/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.relocator;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.Keep;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppServices;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.jar.CfApplicationWriter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.signature.GenericSignatureRewriter;
import com.android.tools.r8.relocator.RelocatorCommand;
import com.android.tools.r8.relocator.SimplePackagesRewritingMapper;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

@Keep
public class Relocator {
    private Relocator() {
    }

    public static void run(RelocatorCommand command) throws CompilationFailedException {
        AndroidApp app = command.getApp();
        InternalOptions options = command.getInternalOptions();
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        ExceptionUtils.withCompilationHandler(command.getReporter(), () -> {
            try {
                Relocator.run(command, executor, app, options);
            }
            finally {
                executor.shutdown();
            }
        });
    }

    public static void run(RelocatorCommand command, ExecutorService executor) throws CompilationFailedException {
        AndroidApp app = command.getApp();
        InternalOptions options = command.getInternalOptions();
        ExceptionUtils.withCompilationHandler(command.getReporter(), () -> Relocator.run(command, executor, app, options));
    }

    private static void run(RelocatorCommand command, ExecutorService executor, AndroidApp inputApp, InternalOptions options) throws IOException {
        Timing timing = Timing.create("Relocator", options);
        try {
            LazyLoadedDexApplication app = new ApplicationReader(inputApp, options, timing).read(executor);
            AppInfo appInfo = AppInfo.createInitialAppInfo(app);
            AppView<AppInfo> appView = AppView.createForRelocator(appInfo);
            appView.setAppServices(AppServices.builder(appView).build());
            SimplePackagesRewritingMapper packageRemapper = new SimplePackagesRewritingMapper(appView);
            NamingLens namingLens = packageRemapper.compute(command.getMapping());
            new GenericSignatureRewriter(appView, namingLens).run(appInfo.classes(), executor);
            new CfApplicationWriter(appView, new Marker(Marker.Tool.Relocator), namingLens).write(command.getConsumer());
            options.printWarnings();
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.unwrapExecutionException(e);
        }
        finally {
            options.signalFinishedToConsumers();
            if (options.printTimes) {
                timing.report();
            }
        }
    }
}

