/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.relocator;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.Version;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.relocator.Relocator;
import com.android.tools.r8.relocator.RelocatorCommand;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.StringUtils;

public class RelocatorCommandLine {
    public static void main(String[] args2) {
        if (args2.length == 0) {
            throw new RuntimeException(StringUtils.joinLines("Invalid invocation.", RelocatorCommand.USAGE_MESSAGE));
        }
        ExceptionUtils.withMainProgramHandler(() -> RelocatorCommandLine.run(args2));
    }

    static void run(String[] args2) throws CompilationFailedException {
        RelocatorCommand command = RelocatorCommand.Builder.parse(args2, CommandLineOrigin.INSTANCE).build();
        if (command.isPrintHelp()) {
            System.out.println(RelocatorCommand.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("Relocator " + Version.getVersionString());
            return;
        }
        Relocator.run(command);
    }
}

