/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.relocator;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.references.PackageReference;
import com.android.tools.r8.relocator.RelocatorDiagnostic;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.util.IdentityHashMap;
import java.util.Map;

class SimplePackagesRewritingMapper {
    private final AppView<?> appView;
    private final Map<DexType, DexString> typeMappings = new IdentityHashMap<DexType, DexString>();

    public SimplePackagesRewritingMapper(AppView<?> appView) {
        this.appView = appView;
    }

    public NamingLens compute(Map<PackageReference, PackageReference> mapping) {
        for (DexProgramClass clazz : ((AppInfo)this.appView.appInfo()).classes()) {
            for (DexEncodedMethod method : clazz.methods()) {
                if (method.getCode() == null) continue;
                method.getCode().asCfCode();
            }
        }
        ImmutableMap.Builder<String, String> packingMappings = ImmutableMap.builder();
        for (PackageReference key : mapping.keySet()) {
            String target;
            String source = key.getPackageName();
            if (source.equals(target = mapping.get(key).getPackageName())) continue;
            if (source.isEmpty()) {
                assert (!target.isEmpty());
                target = target + '.';
            }
            String sourceBinary = DescriptorUtils.getBinaryNameFromJavaType(source);
            String targetBinary = DescriptorUtils.getBinaryNameFromJavaType(target);
            packingMappings.put(sourceBinary, targetBinary);
            DexString sourceDescriptor = this.appView.dexItemFactory().createString("L" + sourceBinary);
            DexString targetDescriptor = this.appView.dexItemFactory().createString("L" + targetBinary);
            this.appView.dexItemFactory().forAllTypes(type -> {
                DexString descriptor = type.descriptor;
                if (descriptor.size <= sourceDescriptor.size) {
                    return;
                }
                if (sourceDescriptor.size != 1 && descriptor.content[sourceDescriptor.size] != 47) {
                    return;
                }
                if (!descriptor.startsWith(sourceDescriptor)) {
                    return;
                }
                if (this.typeMappings.containsKey(type)) {
                    this.appView.options().reporter.error(RelocatorDiagnostic.typeRelocateAmbiguous(type));
                    this.appView.options().reporter.failIfPendingErrors();
                }
                DexString relocatedDescriptor = type.descriptor.withNewPrefix(sourceDescriptor, targetDescriptor, this.appView.dexItemFactory());
                this.typeMappings.put((DexType)type, relocatedDescriptor);
            });
        }
        return new RelocatorNamingLens(this.typeMappings, packingMappings.build(), this.appView.dexItemFactory());
    }

    private static class RelocatorNamingLens
    extends NamingLens.NonIdentityNamingLens {
        private final Map<DexType, DexString> typeMappings;
        private final Map<String, String> packageMappings;

        private RelocatorNamingLens(Map<DexType, DexString> typeMappings, Map<String, String> packageMappings, DexItemFactory factory) {
            super(factory);
            this.typeMappings = typeMappings;
            this.packageMappings = packageMappings;
        }

        @Override
        public String lookupPackageName(String packageName) {
            return this.packageMappings.getOrDefault(packageName, packageName);
        }

        @Override
        protected DexString internalLookupClassDescriptor(DexType type) {
            return this.typeMappings.getOrDefault(type, type.descriptor);
        }

        @Override
        public DexString lookupInnerName(InnerClassAttribute attribute, InternalOptions options) {
            return attribute.getInnerName();
        }

        @Override
        public DexString lookupName(DexMethod method) {
            return method.name;
        }

        @Override
        public DexString lookupName(DexField field) {
            return field.name;
        }

        @Override
        public boolean verifyRenamingConsistentWithResolution(DexMethod item) {
            return true;
        }
    }
}

