/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.repackaging;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.repackaging.RepackagingUseRegistry;

public class RepackagingAnnotationTracer {
    private final AppInfoWithClassHierarchy appInfo;
    private final GraphLens graphLens;
    private final RepackagingUseRegistry registry;

    public RepackagingAnnotationTracer(AppView<? extends AppInfoWithClassHierarchy> appView, RepackagingUseRegistry registry) {
        this.appInfo = appView.appInfo();
        this.graphLens = appView.graphLens();
        this.registry = registry;
    }

    private void traceAnnotation(DexAnnotation annotation) {
        this.traceEncodedAnnotation(annotation.annotation);
    }

    private void traceEncodedAnnotation(DexEncodedAnnotation annotation) {
        this.registry.registerTypeReference(annotation.type, this.graphLens);
        annotation.forEachElement(this::traceAnnotationElement);
    }

    private void traceAnnotationElement(DexAnnotationElement element) {
        this.traceDexValue(element.value);
    }

    private void traceDexValue(DexValue value) {
        switch (value.getValueKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NULL: 
            case SHORT: 
            case STRING: {
                break;
            }
            case ANNOTATION: {
                this.traceEncodedAnnotation(value.asDexValueAnnotation().getValue());
                break;
            }
            case ARRAY: {
                value.asDexValueArray().forEachElement(this::traceDexValue);
                break;
            }
            case ENUM: {
                this.registry.registerFieldAccess((DexField)value.asDexValueEnum().getValue());
                break;
            }
            case FIELD: {
                this.registry.registerFieldAccess((DexField)value.asDexValueField().getValue());
                break;
            }
            case METHOD: {
                this.registry.registerMethodReference((DexMethod)value.asDexValueMethod().getValue());
                break;
            }
            case METHOD_HANDLE: {
                DexMethodHandle handle = (DexMethodHandle)value.asDexValueMethodHandle().getValue();
                if (handle.isFieldHandle()) {
                    this.registry.registerFieldAccess(handle.asField());
                    break;
                }
                assert (handle.isMethodHandle());
                this.registry.registerMethodReference(handle.asMethod());
                break;
            }
            case METHOD_TYPE: {
                ((DexProto)value.asDexValueMethodType().getValue()).forEachType(type -> this.registry.registerTypeReference((DexType)type, this.graphLens));
                break;
            }
            case TYPE: {
                this.registry.registerTypeReference((DexType)value.asDexValueType().getValue(), this.graphLens);
                break;
            }
            default: {
                throw new Unreachable();
            }
        }
    }

    public void trace(DexAnnotationSet annotations) {
        annotations.forEach(this::traceAnnotation);
    }

    public void trace(ParameterAnnotationsList annotations) {
        annotations.forEachAnnotation(this::traceAnnotation);
    }
}

