/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.repackaging;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.ProgramPackage;
import com.android.tools.r8.repackaging.RepackagingAnnotationTracer;
import com.android.tools.r8.repackaging.RepackagingUseRegistry;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.WorkList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class RepackagingConstraintGraph {
    private final AppView<AppInfoWithLiveness> appView;
    private final ProgramPackage pkg;
    private final Map<DexDefinition, Node> nodes = new IdentityHashMap<DexDefinition, Node>();
    private final Set<Node> pinnedNodes = Sets.newIdentityHashSet();
    private final Node libraryBoundaryNode;

    public RepackagingConstraintGraph(AppView<AppInfoWithLiveness> appView, ProgramPackage pkg) {
        this.appView = appView;
        this.pkg = pkg;
        this.libraryBoundaryNode = this.createNode(appView.definitionFor(appView.dexItemFactory().objectType));
        this.pinnedNodes.add(this.libraryBoundaryNode);
    }

    private Node createNode(DexDefinition definition) {
        Node node = new Node(definition);
        this.nodes.put(definition, node);
        return node;
    }

    private void registerReferencesFromClass(DexProgramClass clazz) {
        RepackagingUseRegistry registry = new RepackagingUseRegistry(this.appView, this, clazz, this.libraryBoundaryNode);
        registry.registerTypeReference(clazz.getSuperType(), this.appView.graphLens());
        clazz.interfaces.forEach((Consumer<? super DexType>)((Consumer<DexType>)type -> registry.registerTypeReference((DexType)type, this.appView.graphLens())));
        new RepackagingAnnotationTracer(this.appView, registry).trace(clazz.annotations());
        if (clazz.isInANest()) {
            if (clazz.isNestHost()) {
                clazz.forEachNestMember(type -> registry.registerTypeReference((DexType)type, this.appView.graphLens()));
            } else {
                assert (clazz.isNestMember());
                registry.registerTypeReference(clazz.getNestHost(), this.appView.graphLens());
            }
        }
        clazz.getInnerClasses().forEach(innerClassAttribute -> registry.registerInnerClassAttribute(clazz, (InnerClassAttribute)innerClassAttribute));
        registry.registerEnclosingMethodAttribute(clazz.getEnclosingMethodAttribute());
        registry.registerNestHostAttribute(clazz.getNestHostClassAttribute());
        registry.registerNestMemberClassAttributes(clazz.getNestMembersClassAttributes());
    }

    private void registerReferencesFromField(ProgramField field) {
        RepackagingUseRegistry registry = new RepackagingUseRegistry(this.appView, this, field, this.libraryBoundaryNode);
        registry.registerTypeReference(((DexField)field.getReference()).getType(), this.appView.graphLens());
        new RepackagingAnnotationTracer(this.appView, registry).trace(((DexEncodedField)field.getDefinition()).annotations());
    }

    private void registerReferencesFromMethod(ProgramMethod method) {
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        RepackagingUseRegistry registry = new RepackagingUseRegistry(this.appView, this, method, this.libraryBoundaryNode);
        definition.getProto().forEachType(type -> registry.registerTypeReference((DexType)type, this.appView.graphLens()));
        DexClass superClass = this.appView.definitionFor(method.getHolder().getSuperType(), method.getHolder());
        if (superClass != null) {
            registry.registerMemberAccess(this.appView.appInfo().resolveMethodOn(superClass, (DexMethod)method.getReference()));
        }
        RepackagingAnnotationTracer annotationTracer = new RepackagingAnnotationTracer(this.appView, registry);
        annotationTracer.trace(definition.annotations());
        annotationTracer.trace(definition.getParameterAnnotations());
        if (definition.hasCode()) {
            definition.getCode().registerCodeReferences(method, registry);
        }
    }

    public boolean initializeGraph() {
        boolean hasPinnedItem = false;
        for (DexProgramClass clazz : this.pkg) {
            boolean isPinned = !this.appView.appInfo().isRepackagingAllowed(clazz, this.appView);
            Node classNode = this.createNode(clazz);
            if (isPinned) {
                this.pinnedNodes.add(classNode);
            }
            for (DexEncodedMember<?, ?> member : clazz.members()) {
                Node memberNode = this.createNode(member);
                classNode.addNeighbor(memberNode);
            }
            hasPinnedItem |= isPinned;
        }
        return !hasPinnedItem;
    }

    Node getNode(DexDefinition definition) {
        if (definition.isNotProgramDefinition(this.appView)) {
            String packageDescriptor = definition.getContextType().getPackageDescriptor();
            if (packageDescriptor.equals(this.pkg.getPackageDescriptor())) {
                return this.libraryBoundaryNode;
            }
            return null;
        }
        return this.nodes.get(definition);
    }

    public void populateConstraints(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(this.pkg::forEachMethod, this::registerReferencesFromMethod, executorService);
        this.pkg.forEachClass(this::registerReferencesFromClass);
        this.pkg.forEachField(this::registerReferencesFromField);
    }

    public Collection<DexProgramClass> computeClassesToRepackage() {
        WorkList<Node> worklist = WorkList.newIdentityWorkList(this.pinnedNodes);
        while (worklist.hasNext()) {
            Node pinnedNode = worklist.next();
            for (Node neighbor : pinnedNode.getNeighbors()) {
                worklist.addIfNotSeen(neighbor);
            }
        }
        Set<Node> pinnedNodes = worklist.getSeenSet();
        ArrayList<DexProgramClass> classesToRepackage = new ArrayList<DexProgramClass>();
        for (DexProgramClass clazz : this.pkg) {
            if (pinnedNodes.contains(this.getNode(clazz))) continue;
            classesToRepackage.add(clazz);
        }
        return classesToRepackage;
    }

    static class Node {
        private final DexDefinition definitionForDebugging;
        private final Set<Node> neighbors = Sets.newConcurrentHashSet();

        Node(DexDefinition definitionForDebugging) {
            this.definitionForDebugging = definitionForDebugging;
        }

        public void addNeighbor(Node neighbor) {
            this.neighbors.add(neighbor);
            neighbor.neighbors.add(this);
        }

        public Set<Node> getNeighbors() {
            return this.neighbors;
        }

        public String toString() {
            return "Node(" + this.definitionForDebugging.getReference().toSourceString() + ")";
        }
    }
}

