/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.repackaging;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.NestedGraphLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.collections.BidirectionalOneToOneHashMap;
import com.android.tools.r8.utils.collections.BidirectionalOneToOneMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalOneToOneMap;
import java.util.Map;

public class RepackagingLens
extends NestedGraphLens {
    private final BiMap<DexType, DexType> newTypes;
    private final Map<String, String> packageRenamings;

    private RepackagingLens(AppView<AppInfoWithLiveness> appView, BidirectionalOneToOneMap<DexField, DexField> newFieldSignatures, BidirectionalOneToOneMap<DexMethod, DexMethod> newMethodSignatures, BiMap<DexType, DexType> newTypes, Map<String, String> packageRenamings) {
        super(appView, newFieldSignatures, newMethodSignatures, newTypes);
        this.newTypes = newTypes;
        this.packageRenamings = packageRenamings;
    }

    private boolean isSimpleTypeRenamingOrEqual(DexType from, DexType to) {
        return from == to || this.newTypes.get(from) == to;
    }

    private boolean isSimpleTypeRenamingOrEqual(DexMember<?, ?> from, DexMember<?, ?> to) {
        if (!this.isSimpleTypeRenamingOrEqual(from.getHolderType(), to.getHolderType())) {
            return false;
        }
        return IterableUtils.testPairs(this::isSimpleTypeRenamingOrEqual, from.getReferencedBaseTypes(this.dexItemFactory()), to.getReferencedBaseTypes(this.dexItemFactory()));
    }

    @Override
    public String lookupPackageName(String pkg) {
        return this.packageRenamings.getOrDefault(this.getPrevious().lookupPackageName(pkg), pkg);
    }

    @Override
    public DexType getOriginalType(DexType type) {
        DexType previous = this.newTypes.inverse().getOrDefault(type, type);
        return this.getPrevious().getOriginalType(previous);
    }

    @Override
    public <T extends DexReference> boolean isSimpleRenaming(T from, T to) {
        if (from == to) {
            assert (false) : "The from and to references should not be equal";
            return false;
        }
        if (super.isSimpleRenaming(from, to)) {
            return true;
        }
        return DexReference.applyPair(from, to, this::isSimpleTypeRenamingOrEqual, this::isSimpleTypeRenamingOrEqual, this::isSimpleTypeRenamingOrEqual);
    }

    public static class Builder {
        protected final BiMap<DexType, DexType> newTypes = HashBiMap.create();
        protected final MutableBidirectionalOneToOneMap<DexField, DexField> newFieldSignatures = new BidirectionalOneToOneHashMap<DexField, DexField>();
        protected final MutableBidirectionalOneToOneMap<DexMethod, DexMethod> newMethodSignatures = new BidirectionalOneToOneHashMap<DexMethod, DexMethod>();

        public void recordMove(DexField from, DexField to) {
            this.newFieldSignatures.put(from, to);
        }

        public void recordMove(DexMethod from, DexMethod to) {
            this.newMethodSignatures.put(from, to);
        }

        public void recordMove(DexType from, DexType to) {
            this.newTypes.put(from, to);
        }

        public RepackagingLens build(AppView<AppInfoWithLiveness> appView, Map<String, String> packageRenamings) {
            assert (!this.newTypes.isEmpty());
            return new RepackagingLens(appView, this.newFieldSignatures, this.newMethodSignatures, this.newTypes, packageRenamings);
        }
    }
}

