/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.repackaging;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.graph.AccessFlags;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.MemberResolutionResult;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.NestHostClassAttribute;
import com.android.tools.r8.graph.NestMemberClassAttribute;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.SuccessfulMemberResolutionResult;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.repackaging.RepackagingConstraintGraph;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class RepackagingUseRegistry
extends UseRegistry<ProgramDefinition> {
    private final AppInfoWithLiveness appInfo;
    private final InternalOptions options;
    private final GraphLens graphLens;
    private final RepackagingConstraintGraph constraintGraph;
    private final InitClassLens initClassLens;
    private final RepackagingConstraintGraph.Node node;
    private final RepackagingConstraintGraph.Node missingTypeNode;
    private final GraphLens codeLens;
    private final ProgramMethod methodContext;

    public RepackagingUseRegistry(AppView<AppInfoWithLiveness> appView, RepackagingConstraintGraph constraintGraph, ProgramDefinition context, RepackagingConstraintGraph.Node missingTypeNode) {
        super(appView, context);
        Code code;
        this.appInfo = appView.appInfo();
        this.options = appView.options();
        this.constraintGraph = constraintGraph;
        this.initClassLens = appView.initClassLens();
        this.graphLens = appView.graphLens();
        this.node = constraintGraph.getNode(context.getDefinition());
        this.missingTypeNode = missingTypeNode;
        GraphLens codeLens = appView.graphLens();
        if (context.isMethod() && (code = ((DexEncodedMethod)context.asMethod().getDefinition()).getCode()) != null) {
            codeLens = code.getCodeLens(appView);
        }
        this.codeLens = codeLens;
        this.methodContext = context.isMethod() ? context.asMethod() : null;
    }

    private boolean isOnlyAccessibleFromSamePackage(DexClass referencedClass) {
        ClassAccessFlags accessFlags = referencedClass.getAccessFlags();
        if (accessFlags.isPackagePrivate()) {
            return true;
        }
        return accessFlags.isProtected() && !this.appInfo.isSubtype(((ProgramDefinition)this.getContext()).getContextType(), referencedClass.getType());
    }

    private boolean isOnlyAccessibleFromSamePackage(SuccessfulMemberResolutionResult<?, ?> resolutionResult, boolean isInvoke) {
        AccessFlags<?> accessFlags = resolutionResult.getResolutionPair().getAccessFlags();
        if (accessFlags.isPackagePrivate()) {
            return true;
        }
        if (accessFlags.isProtected()) {
            if (!this.appInfo.isSubtype(((ProgramDefinition)this.getContext()).getContextType(), resolutionResult.getResolvedHolder().getType())) {
                return true;
            }
            if (isInvoke && this.options.isGeneratingClassFiles() && !this.appInfo.isSubtype(resolutionResult.getInitialResolutionHolder().getType(), ((ProgramDefinition)this.getContext()).getContextType())) {
                return true;
            }
        }
        return false;
    }

    private void registerMemberAccessForInvoke(MemberResolutionResult<?, ?> resolutionResult) {
        this.registerMemberAccess(resolutionResult, true);
    }

    private void registerMemberAccess(MemberResolutionResult<?, ?> resolutionResult, boolean isInvoke) {
        RepackagingConstraintGraph.Node resolvedMemberNode;
        if (!resolutionResult.isSuccessfulMemberResolutionResult()) {
            if (resolutionResult.isFieldResolutionResult()) {
                assert (resolutionResult.asFieldResolutionResult().isFailedResolution());
                return;
            }
            MethodResolutionResult methodResult = resolutionResult.asMethodResolutionResult();
            if (methodResult.isClassNotFoundResult() || methodResult.isArrayCloneMethodResult() || methodResult.isNoSuchMethodErrorResult(((ProgramDefinition)this.getContext()).getContextClass(), this.appInfo)) {
                return;
            }
            this.node.addNeighbor(this.missingTypeNode);
            return;
        }
        SuccessfulMemberResolutionResult<?, ?> successfulResolutionResult = resolutionResult.asSuccessfulMemberResolutionResult();
        DexClass initialResolutionHolder = successfulResolutionResult.getInitialResolutionHolder();
        this.registerClassTypeAccess(initialResolutionHolder);
        DexClassAndMember<?, ?> resolutionPair = successfulResolutionResult.getResolutionPair();
        if (resolutionPair != null && (resolvedMemberNode = this.constraintGraph.getNode(resolutionPair.getDefinition())) != null && this.isOnlyAccessibleFromSamePackage(successfulResolutionResult, isInvoke)) {
            this.node.addNeighbor(resolvedMemberNode);
        }
    }

    private void registerTypeAccess(DexType type) {
        this.registerTypeAccess(type, this::registerClassTypeAccess);
    }

    private void registerTypeAccess(DexType type, Consumer<DexClass> consumer) {
        if (type.isArrayType()) {
            this.registerTypeAccess(type.toBaseType(this.appInfo.dexItemFactory()), consumer);
            return;
        }
        if (type.isPrimitiveType() || type.isVoidType()) {
            return;
        }
        assert (type.isClassType());
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz != null) {
            consumer.accept(clazz);
        }
    }

    private void registerClassTypeAccess(DexClass clazz) {
        this.registerClassTypeAccess(clazz, this::isOnlyAccessibleFromSamePackage);
    }

    private void registerClassTypeAccess(DexClass clazz, Predicate<DexClass> predicate) {
        RepackagingConstraintGraph.Node classNode = this.constraintGraph.getNode(clazz);
        if (classNode != null && predicate.test(clazz)) {
            this.node.addNeighbor(classNode);
        }
    }

    public void registerFieldAccess(DexField field) {
        this.registerMemberAccess(this.appInfo.resolveField(this.graphLens.lookupField(field)), false);
    }

    public ProgramMethod registerMethodReference(DexMethod method) {
        MethodResolutionResult resolutionResult = this.appInfo.unsafeResolveMethodDueToDexFormat(method);
        this.registerMemberAccess(resolutionResult, false);
        return resolutionResult.isSingleResolution() ? resolutionResult.asSingleResolution().getResolvedProgramMethod() : null;
    }

    public void registerMemberAccess(MemberResolutionResult<?, ?> resolutionResult) {
        this.registerMemberAccess(resolutionResult, false);
    }

    @Override
    public void registerInitClass(DexType type) {
        this.registerMemberAccess(this.appInfo.resolveField(this.initClassLens.getInitClassField(this.graphLens.lookupClassType(type))), false);
    }

    @Override
    public void registerInvokeVirtual(DexMethod invokedMethod) {
        this.registerMemberAccessForInvoke(this.appInfo.resolveMethod((DexMethod)this.graphLens.lookupInvokeVirtual(invokedMethod, this.methodContext, this.codeLens).getReference(), false));
    }

    @Override
    public void registerInvokeDirect(DexMethod invokedMethod) {
        this.registerMemberAccessForInvoke(this.appInfo.unsafeResolveMethodDueToDexFormat((DexMethod)this.graphLens.lookupInvokeDirect(invokedMethod, this.methodContext, this.codeLens).getReference()));
    }

    @Override
    public void registerInvokeStatic(DexMethod invokedMethod) {
        this.registerMemberAccessForInvoke(this.appInfo.unsafeResolveMethodDueToDexFormat((DexMethod)this.graphLens.lookupInvokeStatic(invokedMethod, this.methodContext, this.codeLens).getReference()));
    }

    @Override
    public void registerInvokeInterface(DexMethod invokedMethod) {
        this.registerMemberAccessForInvoke(this.appInfo.resolveMethod((DexMethod)this.graphLens.lookupInvokeInterface(invokedMethod, this.methodContext, this.codeLens).getReference(), true));
    }

    @Override
    public void registerInvokeSuper(DexMethod invokedMethod) {
        this.registerMemberAccessForInvoke(this.appInfo.unsafeResolveMethodDueToDexFormat((DexMethod)this.graphLens.lookupInvokeSuper(invokedMethod, this.methodContext, this.codeLens).getReference()));
    }

    @Override
    public void registerInstanceFieldRead(DexField field) {
        this.registerFieldAccess(field);
    }

    @Override
    public void registerInstanceFieldWrite(DexField field) {
        this.registerFieldAccess(field);
    }

    @Override
    public void registerNewInstance(DexType type) {
        this.registerTypeAccess(this.graphLens.lookupClassType(type));
    }

    @Override
    public void registerStaticFieldRead(DexField field) {
        this.registerFieldAccess(field);
    }

    @Override
    public void registerStaticFieldWrite(DexField field) {
        this.registerFieldAccess(field);
    }

    @Override
    public void registerTypeReference(DexType type) {
        this.registerTypeReference(type, this.codeLens);
    }

    public void registerTypeReference(DexType type, GraphLens applied) {
        this.registerTypeAccess(this.graphLens.lookupType(type, applied));
    }

    @Override
    public void registerInstanceOf(DexType type) {
        this.registerTypeAccess(this.graphLens.lookupType(type));
    }

    public void registerEnclosingMethodAttribute(EnclosingMethodAttribute enclosingMethodAttribute) {
        ProgramMethod method;
        if (enclosingMethodAttribute == null) {
            return;
        }
        if (enclosingMethodAttribute.getEnclosingClass() != null) {
            this.registerTypeAccess(enclosingMethodAttribute.getEnclosingClass(), clazz -> this.registerClassTypeAccess((DexClass)clazz, (Predicate<DexClass>)Predicates.alwaysTrue()));
        }
        if (enclosingMethodAttribute.getEnclosingMethod() != null && (method = this.registerMethodReference(enclosingMethodAttribute.getEnclosingMethod())) != null) {
            this.registerClassTypeAccess(method.getHolder(), Predicates.alwaysTrue());
        }
    }

    public void registerInnerClassAttribute(DexProgramClass outer, InnerClassAttribute innerClassAttribute) {
        innerClassAttribute.forEachType(type -> this.registerTypeAccess((DexType)type, clazz -> this.registerClassTypeAccess((DexClass)clazz, (Predicate<DexClass>)Predicates.alwaysTrue())));
    }

    public void registerNestHostAttribute(NestHostClassAttribute nestHostClassAttribute) {
        if (nestHostClassAttribute == null) {
            return;
        }
        this.registerTypeAccess(nestHostClassAttribute.getNestHost(), clazz -> this.registerClassTypeAccess((DexClass)clazz, (Predicate<DexClass>)Predicates.alwaysTrue()));
    }

    public void registerNestMemberClassAttributes(List<NestMemberClassAttribute> memberClassAttributes) {
        if (memberClassAttributes == null) {
            return;
        }
        memberClassAttributes.forEach(nestMember -> this.registerTypeAccess(nestMember.getNestMember(), clazz -> this.registerClassTypeAccess((DexClass)clazz, (Predicate<DexClass>)Predicates.alwaysTrue())));
    }
}

