/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.retrace.ProguardMapProducer;

@Keep
public class RetraceOptions {
    private final boolean isVerbose;
    private final boolean verifyMappingFileHash;
    private final String regularExpression;
    private final DiagnosticsHandler diagnosticsHandler;
    private final ProguardMapProducer proguardMapProducer;

    private RetraceOptions(String regularExpression, DiagnosticsHandler diagnosticsHandler, ProguardMapProducer proguardMapProducer, boolean isVerbose, boolean verifyMappingFileHash) {
        this.regularExpression = regularExpression;
        this.diagnosticsHandler = diagnosticsHandler;
        this.proguardMapProducer = proguardMapProducer;
        this.isVerbose = isVerbose;
        this.verifyMappingFileHash = verifyMappingFileHash;
        assert (diagnosticsHandler != null);
        assert (proguardMapProducer != null);
    }

    public static Builder builder() {
        return RetraceOptions.builder(new DiagnosticsHandler(){});
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    public static String defaultRegularExpression() {
        return "(?:.*?\\bat\\s+%c\\.%m\\s*\\(%S\\)\\s*(?:~\\[.*\\])?)|(?:(?:(?:%c|.*)?[:\"]\\s+)?%c(?::.*)?)";
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public boolean isVerifyMappingFileHash() {
        return this.verifyMappingFileHash;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public DiagnosticsHandler getDiagnosticsHandler() {
        return this.diagnosticsHandler;
    }

    public ProguardMapProducer getProguardMapProducer() {
        return this.proguardMapProducer;
    }

    @Keep
    public static class Builder {
        private boolean isVerbose;
        private boolean verifyMappingFileHash;
        private final DiagnosticsHandler diagnosticsHandler;
        private ProguardMapProducer proguardMapProducer;
        private String regularExpression = RetraceOptions.defaultRegularExpression();

        Builder(DiagnosticsHandler diagnosticsHandler) {
            this.diagnosticsHandler = diagnosticsHandler;
        }

        public Builder setVerbose(boolean verbose) {
            this.isVerbose = verbose;
            return this;
        }

        public Builder setVerifyMappingFileHash(boolean verifyMappingFileHash) {
            this.verifyMappingFileHash = verifyMappingFileHash;
            return this;
        }

        public Builder setProguardMapProducer(ProguardMapProducer producer) {
            this.proguardMapProducer = producer;
            return this;
        }

        public Builder setRegularExpression(String regularExpression) {
            this.regularExpression = regularExpression;
            return this;
        }

        public RetraceOptions build() {
            if (this.diagnosticsHandler == null) {
                throw new RuntimeException("DiagnosticsHandler not specified");
            }
            if (this.proguardMapProducer == null) {
                throw new RuntimeException("ProguardMapSupplier not specified");
            }
            if (this.regularExpression == null) {
                throw new RuntimeException("Regular expression not specified");
            }
            return new RetraceOptions(this.regularExpression, this.diagnosticsHandler, this.proguardMapProducer, this.isVerbose, this.verifyMappingFileHash);
        }
    }
}

