/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.retrace.InvalidMappingFileException;
import com.android.tools.r8.retrace.ProguardMapProducer;
import com.android.tools.r8.retrace.ProguardMappingProvider;
import com.android.tools.r8.retrace.RetraceClassResult;
import com.android.tools.r8.retrace.RetraceFieldResult;
import com.android.tools.r8.retrace.RetraceFrameResult;
import com.android.tools.r8.retrace.RetraceMethodResult;
import com.android.tools.r8.retrace.RetraceStackTraceContext;
import com.android.tools.r8.retrace.RetraceThrownExceptionResult;
import com.android.tools.r8.retrace.RetraceTypeResult;
import com.android.tools.r8.retrace.RetracerBuilder;
import com.android.tools.r8.retrace.internal.RetracerImpl;
import java.util.OptionalInt;

@Keep
public interface Retracer {
    public static Retracer createDefault(ProguardMapProducer proguardMapProducer, DiagnosticsHandler diagnosticsHandler) {
        try {
            ProguardMappingProvider mappingProvider = (ProguardMappingProvider)((ProguardMappingProvider.Builder)ProguardMappingProvider.builder().setProguardMapProducer(proguardMapProducer).setDiagnosticsHandler(diagnosticsHandler)).build();
            return Retracer.builder().setMappingProvider(mappingProvider).setDiagnosticsHandler(diagnosticsHandler).build();
        }
        catch (Exception e) {
            throw new InvalidMappingFileException(e);
        }
    }

    public static RetracerBuilder builder() {
        return RetracerImpl.builder();
    }

    public RetraceClassResult retraceClass(ClassReference var1);

    public RetraceMethodResult retraceMethod(MethodReference var1);

    public RetraceFrameResult retraceFrame(RetraceStackTraceContext var1, OptionalInt var2, ClassReference var3, String var4);

    public RetraceFrameResult retraceFrame(RetraceStackTraceContext var1, OptionalInt var2, MethodReference var3);

    public RetraceFieldResult retraceField(FieldReference var1);

    public RetraceTypeResult retraceType(TypeReference var1);

    public RetraceThrownExceptionResult retraceThrownException(ClassReference var1);
}

