/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.retrace.Retrace;
import com.android.tools.r8.retrace.RetraceOptions;
import com.android.tools.r8.retrace.Retracer;
import com.android.tools.r8.retrace.StackTraceElementProxyRetracer;
import com.android.tools.r8.retrace.StackTraceLineParser;
import com.android.tools.r8.retrace.internal.RetraceUtils;
import com.android.tools.r8.retrace.internal.StackTraceElementStringProxy;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

@Keep
public class StringRetrace
extends Retrace<String, StackTraceElementStringProxy> {
    StringRetrace(StackTraceLineParser<String, StackTraceElementStringProxy> stackTraceLineParser, StackTraceElementProxyRetracer<String, StackTraceElementStringProxy> proxyRetracer, DiagnosticsHandler diagnosticsHandler, boolean isVerbose) {
        super(stackTraceLineParser, proxyRetracer, diagnosticsHandler, isVerbose);
    }

    public static StringRetrace create(RetraceOptions command) {
        return StringRetrace.create(Retracer.createDefault(command.getProguardMapProducer(), command.getDiagnosticsHandler()), command.getDiagnosticsHandler(), command.getRegularExpression(), command.isVerbose());
    }

    public static StringRetrace create(Retracer retracer, DiagnosticsHandler diagnosticsHandler, String regularExpression, boolean isVerbose) {
        return new StringRetrace(StackTraceLineParser.createRegularExpressionParser(regularExpression), StackTraceElementProxyRetracer.createDefault(retracer), diagnosticsHandler, isVerbose);
    }

    private void joinAmbiguousLines(List<List<String>> retracedResult, Consumer<String> joinedConsumer) {
        if (retracedResult.isEmpty()) {
            return;
        }
        HashSet reportedFrames = new HashSet();
        ListUtils.forEachWithIndex(retracedResult, (potentialResults, index) -> {
            assert (!potentialResults.isEmpty());
            if (reportedFrames.add((String)potentialResults.get(0))) {
                boolean isAmbiguous = potentialResults != retracedResult.get(0);
                potentialResults.forEach(retracedString -> {
                    if (isAmbiguous) {
                        int firstCharIndex = RetraceUtils.firstNonWhiteSpaceCharacterFromIndex(retracedString, 0);
                        joinedConsumer.accept(retracedString.substring(0, firstCharIndex) + "<OR> " + retracedString.substring(firstCharIndex));
                    } else {
                        joinedConsumer.accept((String)retracedString);
                    }
                });
            }
        });
    }

    public List<String> retrace(List<String> stackTrace) {
        ArrayList<String> retracedStrings = new ArrayList<String>();
        List<List<List<String>>> lists = this.retraceStackTrace(stackTrace);
        for (List<List<String>> newLines : lists) {
            ListUtils.forEachWithIndex(newLines, (inlineFrames, ambiguousIndex) -> {
                for (int i = 0; i < inlineFrames.size(); ++i) {
                    String stackTraceLine = (String)inlineFrames.get(i);
                    if (i == 0 && ambiguousIndex > 0) {
                        int indexToInsertOr = stackTraceLine.indexOf("at ");
                        if (indexToInsertOr < 0) {
                            indexToInsertOr = Math.max(StringUtils.firstNonWhitespaceCharacter(stackTraceLine), 0);
                        }
                        retracedStrings.add(stackTraceLine.substring(0, indexToInsertOr) + "<OR> " + stackTraceLine.substring(indexToInsertOr));
                        continue;
                    }
                    retracedStrings.add(stackTraceLine);
                }
            });
        }
        return retracedStrings;
    }

    public List<String> retrace(String stackTraceLine) {
        ArrayList<String> result = new ArrayList<String>();
        this.joinAmbiguousLines(this.retraceFrame(stackTraceLine), result::add);
        return result;
    }
}

