/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.retrace.internal.Definition;
import java.util.Objects;

abstract class FieldDefinition
implements Definition {
    FieldDefinition() {
    }

    static FieldDefinition create(ClassReference obfuscatedReference, String fieldName) {
        return new BaseFieldDefinition(obfuscatedReference, fieldName);
    }

    public static FieldDefinition create(FieldReference field) {
        return new FullFieldDefinition(field);
    }

    abstract FieldDefinition substituteHolder(ClassReference var1);

    static class FullFieldDefinition
    extends FieldDefinition {
        private final FieldReference fieldReference;

        private FullFieldDefinition(FieldReference fieldReference) {
            this.fieldReference = fieldReference;
        }

        @Override
        public String getName() {
            return this.fieldReference.getFieldName();
        }

        @Override
        public ClassReference getHolderClass() {
            return this.fieldReference.getHolderClass();
        }

        @Override
        FieldDefinition substituteHolder(ClassReference newHolder) {
            return FullFieldDefinition.create(Reference.field(newHolder, this.fieldReference.getFieldName(), this.fieldReference.getFieldType()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FullFieldDefinition that = (FullFieldDefinition)o;
            return this.fieldReference.equals(that.fieldReference);
        }

        public int hashCode() {
            return this.fieldReference.hashCode();
        }
    }

    static class BaseFieldDefinition
    extends FieldDefinition {
        private final ClassReference classReference;
        private final String name;

        private BaseFieldDefinition(ClassReference classReference, String name) {
            this.classReference = classReference;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ClassReference getHolderClass() {
            return this.classReference;
        }

        @Override
        FieldDefinition substituteHolder(ClassReference newHolder) {
            return FieldDefinition.create(newHolder, this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseFieldDefinition that = (BaseFieldDefinition)o;
            return this.classReference.equals(that.classReference) && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.classReference, this.name);
        }
    }
}

