/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.retrace.RetraceFieldElement;
import com.android.tools.r8.retrace.RetraceFieldResult;
import com.android.tools.r8.retrace.RetracedSourceFile;
import com.android.tools.r8.retrace.Retracer;
import com.android.tools.r8.retrace.internal.FieldDefinition;
import com.android.tools.r8.retrace.internal.RetraceClassResultImpl;
import com.android.tools.r8.retrace.internal.RetracedClassReferenceImpl;
import com.android.tools.r8.retrace.internal.RetracedFieldReferenceImpl;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.Pair;
import java.util.List;
import java.util.stream.Stream;

public class RetraceFieldResultImpl
implements RetraceFieldResult {
    private final RetraceClassResultImpl classResult;
    private final List<Pair<RetraceClassResultImpl.RetraceClassElementImpl, List<MemberNaming>>> memberNamings;
    private final FieldDefinition fieldDefinition;
    private final Retracer retracer;

    RetraceFieldResultImpl(RetraceClassResultImpl classResult, List<Pair<RetraceClassResultImpl.RetraceClassElementImpl, List<MemberNaming>>> memberNamings, FieldDefinition fieldDefinition, Retracer retracer) {
        this.classResult = classResult;
        this.memberNamings = memberNamings;
        this.fieldDefinition = fieldDefinition;
        this.retracer = retracer;
        assert (classResult != null);
        assert (!memberNamings.isEmpty());
    }

    @Override
    public Stream<RetraceFieldElement> stream() {
        return this.memberNamings.stream().flatMap((? super T mappedNamePair) -> {
            RetraceClassResultImpl.RetraceClassElementImpl classElement = (RetraceClassResultImpl.RetraceClassElementImpl)mappedNamePair.getFirst();
            List memberNamings = (List)mappedNamePair.getSecond();
            if (memberNamings == null) {
                return Stream.of(new ElementImpl(this, classElement, RetracedFieldReferenceImpl.create(this.fieldDefinition.substituteHolder(classElement.getRetracedClass().getClassReference()))));
            }
            return memberNamings.stream().map(memberNaming -> {
                MemberNaming.FieldSignature fieldSignature = memberNaming.getOriginalSignature().asFieldSignature();
                RetracedClassReferenceImpl holder = fieldSignature.isQualified() ? RetracedClassReferenceImpl.create(Reference.classFromDescriptor(DescriptorUtils.javaTypeToDescriptor(fieldSignature.toHolderFromQualified()))) : classElement.getRetracedClass();
                return new ElementImpl(this, classElement, RetracedFieldReferenceImpl.create(Reference.field(holder.getClassReference(), fieldSignature.isQualified() ? fieldSignature.toUnqualifiedName() : fieldSignature.name, Reference.typeFromTypeName(fieldSignature.type))));
            });
        });
    }

    @Override
    public boolean isAmbiguous() {
        if (this.memberNamings.size() > 1) {
            return true;
        }
        List<MemberNaming> mappings = this.memberNamings.get(0).getSecond();
        if (mappings == null) {
            return false;
        }
        return mappings.size() > 1;
    }

    @Override
    public boolean isEmpty() {
        return this.memberNamings == null || this.memberNamings.isEmpty();
    }

    public static class ElementImpl
    implements RetraceFieldElement {
        private final RetracedFieldReferenceImpl fieldReference;
        private final RetraceFieldResultImpl retraceFieldResult;
        private final RetraceClassResultImpl.RetraceClassElementImpl classElement;

        private ElementImpl(RetraceFieldResultImpl retraceFieldResult, RetraceClassResultImpl.RetraceClassElementImpl classElement, RetracedFieldReferenceImpl fieldReference) {
            this.classElement = classElement;
            this.fieldReference = fieldReference;
            this.retraceFieldResult = retraceFieldResult;
        }

        @Override
        public boolean isCompilerSynthesized() {
            throw new Unimplemented("b/172014416");
        }

        @Override
        public boolean isUnknown() {
            return this.fieldReference.isUnknown();
        }

        @Override
        public RetracedFieldReferenceImpl getField() {
            return this.fieldReference;
        }

        @Override
        public RetraceFieldResult getParentResult() {
            return this.retraceFieldResult;
        }

        @Override
        public RetraceClassResultImpl.RetraceClassElementImpl getClassElement() {
            return this.classElement;
        }

        @Override
        public RetracedSourceFile getSourceFile() {
            return this.classElement.getSourceFile();
        }
    }
}

