/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.naming.ClassNamingForNameMapper;
import com.android.tools.r8.naming.Range;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.retrace.RetraceFrameElement;
import com.android.tools.r8.retrace.RetraceFrameResult;
import com.android.tools.r8.retrace.RetraceInvalidRewriteFrameDiagnostics;
import com.android.tools.r8.retrace.RetraceStackTraceContext;
import com.android.tools.r8.retrace.RetracedClassMemberReference;
import com.android.tools.r8.retrace.RetracedSingleFrame;
import com.android.tools.r8.retrace.RetracedSourceFile;
import com.android.tools.r8.retrace.internal.MethodDefinition;
import com.android.tools.r8.retrace.internal.RetraceClassResultImpl;
import com.android.tools.r8.retrace.internal.RetraceStackTraceContextImpl;
import com.android.tools.r8.retrace.internal.RetraceStackTraceCurrentEvaluationInformation;
import com.android.tools.r8.retrace.internal.RetraceUtils;
import com.android.tools.r8.retrace.internal.RetracedMethodReferenceImpl;
import com.android.tools.r8.retrace.internal.RetracedSingleFrameImpl;
import com.android.tools.r8.retrace.internal.RetracerImpl;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.OptionalUtils;
import com.android.tools.r8.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Stream;

class RetraceFrameResultImpl
implements RetraceFrameResult {
    private final RetraceClassResultImpl classResult;
    private final MethodDefinition methodDefinition;
    private final OptionalInt obfuscatedPosition;
    private final List<Pair<RetraceClassResultImpl.RetraceClassElementImpl, List<ClassNamingForNameMapper.MappedRange>>> mappedRanges;
    private final RetracerImpl retracer;
    private final RetraceStackTraceContextImpl context;
    private OptionalBool isAmbiguousCache = OptionalBool.UNKNOWN;

    public RetraceFrameResultImpl(RetraceClassResultImpl classResult, List<Pair<RetraceClassResultImpl.RetraceClassElementImpl, List<ClassNamingForNameMapper.MappedRange>>> mappedRanges, MethodDefinition methodDefinition, OptionalInt obfuscatedPosition, RetracerImpl retracer, RetraceStackTraceContextImpl context) {
        this.classResult = classResult;
        this.methodDefinition = methodDefinition;
        this.obfuscatedPosition = obfuscatedPosition;
        this.mappedRanges = mappedRanges;
        this.retracer = retracer;
        this.context = context;
    }

    private boolean isMappedRangeAmbiguous(ClassNamingForNameMapper.MappedRange mappedRange) {
        if (mappedRange.originalRange == null || mappedRange.originalRange.span() == 1) {
            return false;
        }
        return mappedRange.minifiedRange == null || mappedRange.minifiedRange.span() != mappedRange.originalRange.span();
    }

    private void separateAmbiguousOriginalPositions(RetraceClassResultImpl.RetraceClassElementImpl classElement, List<ClassNamingForNameMapper.MappedRange> frames, List<ElementImpl> allAmbiguousElements) {
        if (!this.isAmbiguous() || !this.isMappedRangeAmbiguous(frames.get(0))) {
            allAmbiguousElements.add(this.elementFromMappedRanges(ListUtils.map(frames, x$0 -> MappedRangeForFrame.create(x$0)), classElement));
            return;
        }
        assert (frames.size() > 0);
        assert (frames.get((int)0).originalRange != null && frames.get((int)0).originalRange.to > frames.get((int)0).originalRange.from);
        ArrayList newFrames = new ArrayList();
        ListUtils.forEachWithIndex(frames, (frame, index) -> {
            if (index == 0) {
                for (int i = frame.originalRange.from; i <= frame.originalRange.to; ++i) {
                    ArrayList<MappedRangeForFrame> ambiguousFrames2 = new ArrayList<MappedRangeForFrame>();
                    ambiguousFrames2.add(MappedRangeForFrame.create(frame, OptionalInt.of(i)));
                    newFrames.add(ambiguousFrames2);
                }
            } else {
                newFrames.forEach((? super T ambiguousFrames) -> ambiguousFrames.add(MappedRangeForFrame.create(frame)));
            }
        });
        newFrames.forEach((? super T ambiguousFrames) -> allAmbiguousElements.add(this.elementFromMappedRanges((List<MappedRangeForFrame>)ambiguousFrames, classElement)));
    }

    private ElementImpl elementFromMappedRanges(List<MappedRangeForFrame> mappedRangesForElement, RetraceClassResultImpl.RetraceClassElementImpl classElement) {
        MappedRangeForFrame topFrame = mappedRangesForElement.get(0);
        MethodReference methodReference = RetraceUtils.methodReferenceFromMappedRange(topFrame.mappedRange, classElement.getRetracedClass().getClassReference());
        return new ElementImpl(this, classElement, this.getRetracedMethod(methodReference, topFrame, this.obfuscatedPosition), mappedRangesForElement, this.obfuscatedPosition, this.retracer);
    }

    private RetracedMethodReferenceImpl getRetracedMethod(MethodReference methodReference, MappedRangeForFrame mappedRangeForFrame, OptionalInt obfuscatedPosition) {
        ClassNamingForNameMapper.MappedRange mappedRange = mappedRangeForFrame.mappedRange;
        OptionalInt originalPosition = mappedRangeForFrame.position;
        if (!(this.isAmbiguous() || mappedRange.minifiedRange != null && obfuscatedPosition.orElse(-1) != -1)) {
            int originalLineNumber = mappedRange.getFirstLineNumberOfOriginalRange();
            if (originalLineNumber > 0) {
                return RetracedMethodReferenceImpl.create(methodReference, OptionalUtils.orElse(originalPosition, originalLineNumber));
            }
            return RetracedMethodReferenceImpl.create(methodReference, originalPosition);
        }
        if (!obfuscatedPosition.isPresent() || mappedRange.minifiedRange == null || !mappedRange.minifiedRange.contains(obfuscatedPosition.getAsInt())) {
            return RetracedMethodReferenceImpl.create(methodReference, originalPosition);
        }
        return RetracedMethodReferenceImpl.create(methodReference, OptionalUtils.orElseGet(originalPosition, () -> mappedRange.getOriginalLineNumber(obfuscatedPosition.getAsInt())));
    }

    @Override
    public boolean isAmbiguous() {
        if (this.isAmbiguousCache.isUnknown()) {
            if (this.mappedRanges.size() > 1) {
                this.isAmbiguousCache = OptionalBool.TRUE;
                return true;
            }
            List<ClassNamingForNameMapper.MappedRange> methodRanges = this.mappedRanges.get(0).getSecond();
            if (methodRanges != null && !methodRanges.isEmpty()) {
                ClassNamingForNameMapper.MappedRange initialRange = methodRanges.get(0);
                for (ClassNamingForNameMapper.MappedRange mappedRange : methodRanges) {
                    if (this.isMappedRangeAmbiguous(mappedRange)) {
                        this.isAmbiguousCache = OptionalBool.TRUE;
                        return true;
                    }
                    if (mappedRange == initialRange || mappedRange.minifiedRange != null && mappedRange.minifiedRange.equals(initialRange.minifiedRange)) continue;
                    this.isAmbiguousCache = OptionalBool.TRUE;
                    return true;
                }
            }
            this.isAmbiguousCache = OptionalBool.FALSE;
        }
        assert (!this.isAmbiguousCache.isUnknown());
        return this.isAmbiguousCache.isTrue();
    }

    @Override
    public Stream<RetraceFrameElement> stream() {
        return this.mappedRanges.stream().flatMap((? super T mappedRangePair) -> {
            RetraceClassResultImpl.RetraceClassElementImpl classElement = (RetraceClassResultImpl.RetraceClassElementImpl)mappedRangePair.getFirst();
            List mappedRanges = (List)mappedRangePair.getSecond();
            if (mappedRanges == null || mappedRanges.isEmpty()) {
                return Stream.of(new ElementImpl(this, classElement, RetracedMethodReferenceImpl.create(this.methodDefinition.substituteHolder(classElement.getRetracedClass().getClassReference())), ImmutableList.of(), this.obfuscatedPosition, this.retracer));
            }
            ArrayList<ElementImpl> ambiguousFrames = new ArrayList<ElementImpl>();
            Range minifiedRange = ((ClassNamingForNameMapper.MappedRange)mappedRanges.get((int)0)).minifiedRange;
            ArrayList<ClassNamingForNameMapper.MappedRange> mappedRangesForElement = Lists.newArrayList((ClassNamingForNameMapper.MappedRange)mappedRanges.get(0));
            for (int i = 1; i < mappedRanges.size(); ++i) {
                ClassNamingForNameMapper.MappedRange mappedRange = (ClassNamingForNameMapper.MappedRange)mappedRanges.get(i);
                if (minifiedRange == null || !minifiedRange.equals(mappedRange.minifiedRange)) {
                    this.separateAmbiguousOriginalPositions(classElement, mappedRangesForElement, ambiguousFrames);
                    mappedRangesForElement = new ArrayList();
                    minifiedRange = mappedRange.minifiedRange;
                }
                mappedRangesForElement.add(mappedRange);
            }
            this.separateAmbiguousOriginalPositions(classElement, mappedRangesForElement, ambiguousFrames);
            return ambiguousFrames.stream();
        });
    }

    @Override
    public boolean isEmpty() {
        return !this.mappedRanges.isEmpty();
    }

    private static class MappedRangeForFrame {
        private final ClassNamingForNameMapper.MappedRange mappedRange;
        private final OptionalInt position;

        private MappedRangeForFrame(ClassNamingForNameMapper.MappedRange mappedRange, OptionalInt position) {
            this.mappedRange = mappedRange;
            this.position = position;
        }

        private ClassNamingForNameMapper.MappedRange getMappedRange() {
            return this.mappedRange;
        }

        private static MappedRangeForFrame create(ClassNamingForNameMapper.MappedRange mappedRange) {
            return MappedRangeForFrame.create(mappedRange, mappedRange.originalRange == null || mappedRange.originalRange.span() != 1 ? OptionalInt.empty() : OptionalInt.of(mappedRange.originalRange.from));
        }

        private static MappedRangeForFrame create(ClassNamingForNameMapper.MappedRange mappedRange, OptionalInt position) {
            return new MappedRangeForFrame(mappedRange, position);
        }
    }

    public static class ElementImpl
    implements RetraceFrameElement {
        private final RetracedMethodReferenceImpl methodReference;
        private final RetraceFrameResultImpl retraceFrameResult;
        private final RetraceClassResultImpl.RetraceClassElementImpl classElement;
        private final List<MappedRangeForFrame> mappedRanges;
        private final OptionalInt obfuscatedPosition;
        private final RetracerImpl retracer;

        ElementImpl(RetraceFrameResultImpl retraceFrameResult, RetraceClassResultImpl.RetraceClassElementImpl classElement, RetracedMethodReferenceImpl methodReference, List<MappedRangeForFrame> mappedRanges, OptionalInt obfuscatedPosition, RetracerImpl retracer) {
            this.methodReference = methodReference;
            this.retraceFrameResult = retraceFrameResult;
            this.classElement = classElement;
            this.mappedRanges = mappedRanges;
            this.obfuscatedPosition = obfuscatedPosition;
            this.retracer = retracer;
        }

        private boolean isOuterMostFrameCompilerSynthesized() {
            if (this.mappedRanges == null || this.mappedRanges.isEmpty()) {
                return false;
            }
            return ListUtils.last(this.mappedRanges).mappedRange.isCompilerSynthesized();
        }

        private RetracedMethodReferenceImpl getMethodReferenceFromMappedRange(MappedRangeForFrame mappedRangeForFrame) {
            MethodReference methodReference = RetraceUtils.methodReferenceFromMappedRange(mappedRangeForFrame.getMappedRange(), this.classElement.getRetracedClass().getClassReference());
            return this.retraceFrameResult.getRetracedMethod(methodReference, mappedRangeForFrame, this.obfuscatedPosition);
        }

        @Override
        public boolean isCompilerSynthesized() {
            return this.getOuterFrames().isEmpty() && this.isOuterMostFrameCompilerSynthesized();
        }

        @Override
        public RetraceFrameResult getParentResult() {
            return this.retraceFrameResult;
        }

        @Override
        public boolean isUnknown() {
            return this.methodReference.isUnknown();
        }

        @Override
        public RetracedMethodReferenceImpl getTopFrame() {
            return this.methodReference;
        }

        @Override
        public RetraceClassResultImpl.RetraceClassElementImpl getClassElement() {
            return this.classElement;
        }

        @Override
        public void forEach(Consumer<RetracedSingleFrame> consumer) {
            if (this.mappedRanges == null || this.mappedRanges.isEmpty()) {
                consumer.accept(RetracedSingleFrameImpl.create(this, this.getTopFrame(), 0));
                return;
            }
            int counter = 0;
            consumer.accept(RetracedSingleFrameImpl.create(this, this.getTopFrame(), counter++));
            for (RetracedMethodReferenceImpl outerFrame : this.getOuterFrames()) {
                consumer.accept(RetracedSingleFrameImpl.create(this, outerFrame, counter++));
            }
        }

        @Override
        public Stream<RetracedSingleFrame> stream() {
            Stream.Builder builder = Stream.builder();
            this.forEach(builder::add);
            return builder.build();
        }

        @Override
        public void forEachRewritten(Consumer<RetracedSingleFrame> consumer) {
            int totalNumberOfFrames;
            RetraceStackTraceContextImpl contextImpl = this.retraceFrameResult.context;
            RetraceStackTraceCurrentEvaluationInformation currentFrameInformation = contextImpl == null ? RetraceStackTraceCurrentEvaluationInformation.empty() : contextImpl.computeRewriteFrameInformation(ListUtils.map(this.mappedRanges, rec$ -> ((MappedRangeForFrame)rec$).getMappedRange()));
            int index = 0;
            int numberOfFramesToRemove = currentFrameInformation.getRemoveInnerFramesCount();
            int n = totalNumberOfFrames = this.mappedRanges == null || this.mappedRanges.isEmpty() ? 1 : this.mappedRanges.size();
            if (numberOfFramesToRemove > totalNumberOfFrames) {
                DiagnosticsHandler diagnosticsHandler = this.retracer.getDiagnosticsHandler();
                diagnosticsHandler.warning(RetraceInvalidRewriteFrameDiagnostics.create(numberOfFramesToRemove, this.getTopFrame().asKnown().toString()));
                numberOfFramesToRemove = 0;
            }
            RetracedMethodReferenceImpl prev = this.getTopFrame();
            List<RetracedMethodReferenceImpl> outerFrames = this.getOuterFrames();
            for (RetracedMethodReferenceImpl next : outerFrames) {
                if (numberOfFramesToRemove-- <= 0) {
                    consumer.accept(RetracedSingleFrameImpl.create(this, prev, index++));
                }
                prev = next;
            }
            if (numberOfFramesToRemove <= 0 && !this.isOuterMostFrameCompilerSynthesized()) {
                consumer.accept(RetracedSingleFrameImpl.create(this, prev, index));
            }
        }

        @Override
        public Stream<RetracedSingleFrame> streamRewritten(RetraceStackTraceContext context) {
            Stream.Builder builder = Stream.builder();
            this.forEachRewritten(builder::add);
            return builder.build();
        }

        @Override
        public RetracedSourceFile getSourceFile(RetracedClassMemberReference frame) {
            return RetraceUtils.getSourceFileOrLookup(frame.getHolderClass(), this.classElement, this.retraceFrameResult.retracer);
        }

        public List<RetracedMethodReferenceImpl> getOuterFrames() {
            if (this.mappedRanges == null) {
                return Collections.emptyList();
            }
            ArrayList<RetracedMethodReferenceImpl> outerFrames = new ArrayList<RetracedMethodReferenceImpl>();
            for (int i = 1; i < this.mappedRanges.size(); ++i) {
                outerFrames.add(this.getMethodReferenceFromMappedRange(this.mappedRanges.get(i)));
            }
            return outerFrames;
        }

        @Override
        public RetraceStackTraceContext getRetraceStackTraceContext() {
            if (this.mappedRanges == null || this.mappedRanges.isEmpty() || !this.obfuscatedPosition.isPresent() || !ListUtils.last(this.mappedRanges).getMappedRange().isOutlineFrame()) {
                return RetraceStackTraceContext.empty();
            }
            return RetraceStackTraceContextImpl.builder().setRewritePosition(this.obfuscatedPosition).build();
        }
    }
}

