/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.naming.ClassNamingForNameMapper;
import com.android.tools.r8.naming.mappinginformation.OutlineCallsiteMappingInformation;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.retrace.RetraceMethodElement;
import com.android.tools.r8.retrace.RetraceMethodResult;
import com.android.tools.r8.retrace.RetraceStackTraceContext;
import com.android.tools.r8.retrace.RetracedMethodReference;
import com.android.tools.r8.retrace.RetracedSourceFile;
import com.android.tools.r8.retrace.internal.MethodDefinition;
import com.android.tools.r8.retrace.internal.RetraceClassResultImpl;
import com.android.tools.r8.retrace.internal.RetraceFrameResultImpl;
import com.android.tools.r8.retrace.internal.RetraceStackTraceContextImpl;
import com.android.tools.r8.retrace.internal.RetraceUtils;
import com.android.tools.r8.retrace.internal.RetracedMethodReferenceImpl;
import com.android.tools.r8.retrace.internal.RetracerImpl;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Stream;

public class RetraceMethodResultImpl
implements RetraceMethodResult {
    private final MethodDefinition methodDefinition;
    private final RetraceClassResultImpl classResult;
    private final List<Pair<RetraceClassResultImpl.RetraceClassElementImpl, List<ClassNamingForNameMapper.MappedRange>>> mappedRanges;
    private final RetracerImpl retracer;

    RetraceMethodResultImpl(RetraceClassResultImpl classResult, List<Pair<RetraceClassResultImpl.RetraceClassElementImpl, List<ClassNamingForNameMapper.MappedRange>>> mappedRanges, MethodDefinition methodDefinition, RetracerImpl retracer) {
        this.classResult = classResult;
        this.mappedRanges = mappedRanges;
        this.methodDefinition = methodDefinition;
        this.retracer = retracer;
        assert (classResult != null);
        assert (!mappedRanges.isEmpty());
    }

    @Override
    public boolean isAmbiguous() {
        if (this.mappedRanges.size() > 1) {
            return true;
        }
        List<ClassNamingForNameMapper.MappedRange> methodRanges = this.mappedRanges.get(0).getSecond();
        if (methodRanges == null || methodRanges.isEmpty()) {
            return false;
        }
        ClassNamingForNameMapper.MappedRange lastRange = methodRanges.get(0);
        for (ClassNamingForNameMapper.MappedRange mappedRange : methodRanges) {
            if (mappedRange == lastRange || mappedRange.minifiedRange != null && mappedRange.minifiedRange.equals(lastRange.minifiedRange)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.mappedRanges == null || this.mappedRanges.isEmpty();
    }

    @Override
    public RetraceFrameResultImpl narrowByPosition(RetraceStackTraceContext context, OptionalInt position) {
        ArrayList<Pair<RetraceClassResultImpl.RetraceClassElementImpl, List<ClassNamingForNameMapper.MappedRange>>> narrowedRanges = new ArrayList<Pair<RetraceClassResultImpl.RetraceClassElementImpl, List<ClassNamingForNameMapper.MappedRange>>>();
        RetraceStackTraceContextImpl stackTraceContext = null;
        if (context instanceof RetraceStackTraceContextImpl) {
            stackTraceContext = (RetraceStackTraceContextImpl)context;
        }
        for (Pair<RetraceClassResultImpl.RetraceClassElementImpl, List<ClassNamingForNameMapper.MappedRange>> mappedRange : this.mappedRanges) {
            List<OutlineCallsiteMappingInformation> outlineCallsiteInformation;
            boolean hasPosition;
            if (mappedRange.getSecond() == null) {
                narrowedRanges.add(new Pair<RetraceClassResultImpl.RetraceClassElementImpl, Object>(mappedRange.getFirst(), null));
                continue;
            }
            ClassNamingForNameMapper.MappedRangesOfName mappedRangesOfElement = new ClassNamingForNameMapper.MappedRangesOfName(mappedRange.getSecond());
            List<ClassNamingForNameMapper.MappedRange> mappedRangesForPosition = null;
            boolean bl = hasPosition = position.isPresent() && position.getAsInt() >= 0;
            if (hasPosition) {
                mappedRangesForPosition = mappedRangesOfElement.allRangesForLine(position.getAsInt(), false);
            }
            if (mappedRangesForPosition == null || mappedRangesForPosition.isEmpty()) {
                List<ClassNamingForNameMapper.MappedRange> list = mappedRangesForPosition = hasPosition ? ListUtils.filter(mappedRangesOfElement.getMappedRanges(), range -> range.minifiedRange == null) : mappedRangesOfElement.getMappedRanges();
            }
            if (mappedRangesForPosition == null || mappedRangesForPosition.isEmpty()) continue;
            if (stackTraceContext != null && stackTraceContext.hasRewritePosition() && !(outlineCallsiteInformation = ListUtils.last(mappedRangesForPosition).getOutlineCallsiteInformation()).isEmpty()) {
                assert (outlineCallsiteInformation.size() == 1) : "There can only be one outline entry for a line";
                return this.narrowByPosition(stackTraceContext.buildFromThis().clearRewritePosition().build(), OptionalInt.of(outlineCallsiteInformation.get(0).rewritePosition(stackTraceContext.getRewritePosition())));
            }
            narrowedRanges.add(new Pair<RetraceClassResultImpl.RetraceClassElementImpl, List<ClassNamingForNameMapper.MappedRange>>(mappedRange.getFirst(), mappedRangesForPosition));
        }
        return new RetraceFrameResultImpl(this.classResult, narrowedRanges, this.methodDefinition, position, this.retracer, (RetraceStackTraceContextImpl)context);
    }

    @Override
    public Stream<RetraceMethodElement> stream() {
        return this.mappedRanges.stream().flatMap((? super T mappedRangePair) -> {
            RetraceClassResultImpl.RetraceClassElementImpl classElement = (RetraceClassResultImpl.RetraceClassElementImpl)mappedRangePair.getFirst();
            List mappedRanges = (List)mappedRangePair.getSecond();
            if (mappedRanges == null || mappedRanges.isEmpty()) {
                return Stream.of(new ElementImpl(this, classElement, RetracedMethodReferenceImpl.create(this.methodDefinition.substituteHolder(classElement.getRetracedClass().getClassReference()))));
            }
            ArrayList<ElementImpl> results = new ArrayList<ElementImpl>();
            HashSet<MethodReference> seenMethodReferences = new HashSet<MethodReference>();
            for (ClassNamingForNameMapper.MappedRange mappedRange : mappedRanges) {
                MethodReference methodReference = RetraceUtils.methodReferenceFromMappedRange(mappedRange, classElement.getRetracedClass().getClassReference());
                if (!seenMethodReferences.add(methodReference)) continue;
                results.add(new ElementImpl(this, classElement, RetracedMethodReferenceImpl.create(methodReference)));
            }
            return results.stream();
        });
    }

    public static class ElementImpl
    implements RetraceMethodElement {
        private final RetracedMethodReferenceImpl methodReference;
        private final RetraceMethodResultImpl retraceMethodResult;
        private final RetraceClassResultImpl.RetraceClassElementImpl classElement;

        private ElementImpl(RetraceMethodResultImpl retraceMethodResult, RetraceClassResultImpl.RetraceClassElementImpl classElement, RetracedMethodReferenceImpl methodReference) {
            this.classElement = classElement;
            this.retraceMethodResult = retraceMethodResult;
            this.methodReference = methodReference;
        }

        @Override
        public boolean isCompilerSynthesized() {
            throw new Unimplemented("b/172014416");
        }

        @Override
        public boolean isUnknown() {
            return this.methodReference.isUnknown();
        }

        @Override
        public RetracedMethodReference getRetracedMethod() {
            return this.methodReference;
        }

        @Override
        public RetraceMethodResult getParentResult() {
            return this.retraceMethodResult;
        }

        @Override
        public RetraceClassResultImpl.RetraceClassElementImpl getClassElement() {
            return this.classElement;
        }

        @Override
        public RetracedSourceFile getSourceFile() {
            return RetraceUtils.getSourceFileOrLookup(this.methodReference.getHolderClass(), this.classElement, this.retraceMethodResult.retracer);
        }
    }
}

