/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.naming.ClassNamingForNameMapper;
import com.android.tools.r8.naming.mappinginformation.RewriteFrameMappingInformation;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.retrace.RetraceStackTraceContext;
import com.android.tools.r8.retrace.internal.RetraceStackTraceCurrentEvaluationInformation;
import java.util.List;
import java.util.OptionalInt;

public class RetraceStackTraceContextImpl
implements RetraceStackTraceContext {
    private final ClassReference thrownException;
    private final OptionalInt rewritePosition;

    private RetraceStackTraceContextImpl(ClassReference thrownException, OptionalInt rewritePosition) {
        this.thrownException = thrownException;
        this.rewritePosition = rewritePosition;
    }

    private boolean evaluateConditions(List<RewriteFrameMappingInformation.Condition> conditions) {
        for (RewriteFrameMappingInformation.Condition condition : conditions) {
            if (condition.evaluate(this)) continue;
            return false;
        }
        return true;
    }

    public static Builder builder() {
        return Builder.create();
    }

    public ClassReference getThrownException() {
        return this.thrownException;
    }

    RetraceStackTraceCurrentEvaluationInformation computeRewriteFrameInformation(List<ClassNamingForNameMapper.MappedRange> mappedRanges) {
        if (mappedRanges == null || mappedRanges.isEmpty()) {
            return RetraceStackTraceCurrentEvaluationInformation.empty();
        }
        RetraceStackTraceCurrentEvaluationInformation.Builder builder = RetraceStackTraceCurrentEvaluationInformation.builder();
        for (ClassNamingForNameMapper.MappedRange mappedRange : mappedRanges) {
            for (RewriteFrameMappingInformation rewriteInformation : mappedRange.getRewriteFrameMappingInformation()) {
                if (!this.evaluateConditions(rewriteInformation.getConditions())) continue;
                for (RewriteFrameMappingInformation.RewriteAction action : rewriteInformation.getActions()) {
                    action.evaluate(builder);
                }
            }
        }
        return builder.build();
    }

    public boolean hasRewritePosition() {
        return this.rewritePosition.isPresent();
    }

    public int getRewritePosition() {
        return this.rewritePosition.getAsInt();
    }

    public Builder buildFromThis() {
        return RetraceStackTraceContextImpl.builder().setThrownException(this.thrownException).setRewritePosition(this.rewritePosition);
    }

    public static class Builder {
        private ClassReference thrownException;
        private OptionalInt rewritePosition = OptionalInt.empty();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder setThrownException(ClassReference thrownException) {
            this.thrownException = thrownException;
            return this;
        }

        public Builder setRewritePosition(OptionalInt rewritePosition) {
            this.rewritePosition = rewritePosition;
            return this;
        }

        public Builder clearRewritePosition() {
            this.rewritePosition = OptionalInt.empty();
            return this;
        }

        public RetraceStackTraceContextImpl build() {
            return new RetraceStackTraceContextImpl(this.thrownException, this.rewritePosition);
        }
    }
}

