/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.naming.ClassNamingForNameMapper;
import com.android.tools.r8.naming.mappinginformation.MappingInformation;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.retrace.RetraceStackTraceContext;
import com.android.tools.r8.retrace.RetraceThrownExceptionElement;
import com.android.tools.r8.retrace.RetraceThrownExceptionResult;
import com.android.tools.r8.retrace.RetracedSourceFile;
import com.android.tools.r8.retrace.internal.RetraceStackTraceContextImpl;
import com.android.tools.r8.retrace.internal.RetracedClassReferenceImpl;
import com.android.tools.r8.retrace.internal.RetracedSourceFileImpl;
import java.util.stream.Stream;

public class RetraceThrownExceptionResultImpl
implements RetraceThrownExceptionResult {
    private final RetraceStackTraceContextImpl context;
    private final ClassReference obfuscatedReference;
    private final ClassNamingForNameMapper mapper;

    RetraceThrownExceptionResultImpl(RetraceStackTraceContextImpl context, ClassReference obfuscatedReference, ClassNamingForNameMapper mapper) {
        this.context = context;
        this.obfuscatedReference = obfuscatedReference;
        this.mapper = mapper;
    }

    private RetraceThrownExceptionElement createElement() {
        return new RetraceThrownExceptionElementImpl(this, RetracedClassReferenceImpl.create(this.mapper == null ? this.obfuscatedReference : Reference.classFromTypeName(this.mapper.originalName)), this.mapper, this.obfuscatedReference);
    }

    @Override
    public Stream<RetraceThrownExceptionElement> stream() {
        return Stream.of(this.createElement());
    }

    @Override
    public boolean isEmpty() {
        return this.obfuscatedReference == null;
    }

    public static class RetraceThrownExceptionElementImpl
    implements RetraceThrownExceptionElement {
        private final RetraceThrownExceptionResultImpl thrownExceptionResult;
        private final RetracedClassReferenceImpl classReference;
        private final ClassNamingForNameMapper mapper;
        private final ClassReference thrownException;

        private RetraceThrownExceptionElementImpl(RetraceThrownExceptionResultImpl thrownExceptionResult, RetracedClassReferenceImpl classReference, ClassNamingForNameMapper mapper, ClassReference thrownException) {
            this.thrownExceptionResult = thrownExceptionResult;
            this.classReference = classReference;
            this.mapper = mapper;
            this.thrownException = thrownException;
        }

        @Override
        public RetracedClassReferenceImpl getRetracedClass() {
            return this.classReference;
        }

        @Override
        public RetraceThrownExceptionResult getParentResult() {
            return this.thrownExceptionResult;
        }

        @Override
        public RetracedSourceFile getSourceFile() {
            String sourceFile = null;
            if (this.mapper != null) {
                for (MappingInformation info : this.mapper.getAdditionalMappingInfo()) {
                    if (!info.isFileNameInformation()) continue;
                    sourceFile = info.asFileNameInformation().getFileName();
                    break;
                }
            }
            return new RetracedSourceFileImpl(this.getRetracedClass().getClassReference(), sourceFile);
        }

        @Override
        public boolean isCompilerSynthesized() {
            return false;
        }

        @Override
        public RetraceStackTraceContext getContext() {
            return RetraceStackTraceContextImpl.builder().setThrownException(this.thrownException).build();
        }
    }
}

