/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.retrace.RetraceTypeResult;
import com.android.tools.r8.retrace.RetracedTypeReference;
import com.android.tools.r8.retrace.Retracer;
import com.android.tools.r8.retrace.internal.RetracedTypeReferenceImpl;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class RetraceTypeResultImpl
implements RetraceTypeResult {
    private final TypeReference obfuscatedType;
    private final Retracer retracer;

    private RetraceTypeResultImpl(TypeReference obfuscatedType, Retracer retracer) {
        this.obfuscatedType = obfuscatedType;
        this.retracer = retracer;
    }

    static RetraceTypeResultImpl create(TypeReference obfuscatedType, Retracer retracer) {
        return new RetraceTypeResultImpl(obfuscatedType, retracer);
    }

    @Override
    public Stream<RetraceTypeResult.Element> stream() {
        if (this.obfuscatedType == null || this.obfuscatedType.isPrimitive()) {
            return Stream.of(new ElementImpl(RetracedTypeReferenceImpl.create(this.obfuscatedType)));
        }
        if (this.obfuscatedType.isArray()) {
            int dimensions = this.obfuscatedType.asArray().getDimensions();
            return this.retracer.retraceType(this.obfuscatedType.asArray().getBaseType()).stream().map(baseElement -> new ElementImpl(RetracedTypeReferenceImpl.create(baseElement.getType().toArray(dimensions))));
        }
        return this.retracer.retraceClass(this.obfuscatedType.asClass()).stream().map(classElement -> new ElementImpl(classElement.getRetracedClass().getRetracedType()));
    }

    @Override
    public boolean isAmbiguous() {
        return false;
    }

    @Override
    public RetraceTypeResultImpl forEach(Consumer<RetraceTypeResult.Element> resultConsumer) {
        this.stream().forEach(resultConsumer);
        return this;
    }

    public static class ElementImpl
    implements RetraceTypeResult.Element {
        private final RetracedTypeReference retracedType;

        public ElementImpl(RetracedTypeReference retracedType) {
            this.retracedType = retracedType;
        }

        @Override
        public RetracedTypeReference getType() {
            return this.retracedType;
        }
    }
}

