/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.retrace.RetracedFieldReference;
import com.android.tools.r8.retrace.internal.FieldDefinition;
import com.android.tools.r8.retrace.internal.RetracedClassReferenceImpl;
import java.util.Objects;

public abstract class RetracedFieldReferenceImpl
implements RetracedFieldReference {
    private RetracedFieldReferenceImpl() {
    }

    static RetracedFieldReferenceImpl create(FieldReference fieldReference) {
        return new KnownRetracedFieldReferenceImpl(fieldReference);
    }

    static RetracedFieldReferenceImpl create(FieldDefinition fieldDefinition) {
        return new UnknownRetracedFieldReferenceImpl(fieldDefinition);
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public final boolean isKnown() {
        return !this.isUnknown();
    }

    @Override
    public KnownRetracedFieldReferenceImpl asKnown() {
        return null;
    }

    public static final class UnknownRetracedFieldReferenceImpl
    extends RetracedFieldReferenceImpl {
        private final FieldDefinition fieldDefinition;

        private UnknownRetracedFieldReferenceImpl(FieldDefinition fieldDefinition) {
            this.fieldDefinition = fieldDefinition;
        }

        @Override
        public RetracedClassReferenceImpl getHolderClass() {
            return RetracedClassReferenceImpl.create(this.fieldDefinition.getHolderClass());
        }

        @Override
        public String getFieldName() {
            return this.fieldDefinition.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnknownRetracedFieldReferenceImpl that = (UnknownRetracedFieldReferenceImpl)o;
            return this.fieldDefinition.equals(that.fieldDefinition);
        }

        public int hashCode() {
            return Objects.hash(this.fieldDefinition);
        }
    }

    public static final class KnownRetracedFieldReferenceImpl
    extends RetracedFieldReferenceImpl
    implements RetracedFieldReference.KnownRetracedFieldReference {
        private final FieldReference fieldReference;

        private KnownRetracedFieldReferenceImpl(FieldReference fieldReference) {
            this.fieldReference = fieldReference;
        }

        @Override
        public boolean isUnknown() {
            return false;
        }

        @Override
        public KnownRetracedFieldReferenceImpl asKnown() {
            return this;
        }

        @Override
        public RetracedClassReferenceImpl getHolderClass() {
            return RetracedClassReferenceImpl.create(this.fieldReference.getHolderClass());
        }

        @Override
        public String getFieldName() {
            return this.fieldReference.getFieldName();
        }

        @Override
        public TypeReference getFieldType() {
            return this.fieldReference.getFieldType();
        }

        @Override
        public FieldReference getFieldReference() {
            return this.fieldReference;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KnownRetracedFieldReferenceImpl that = (KnownRetracedFieldReferenceImpl)o;
            return this.fieldReference.equals(that.fieldReference);
        }

        public int hashCode() {
            return Objects.hash(this.fieldReference);
        }
    }
}

