/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.references.Reference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.retrace.RetraceClassResult;
import com.android.tools.r8.retrace.RetraceFieldElement;
import com.android.tools.r8.retrace.RetraceFieldResult;
import com.android.tools.r8.retrace.RetraceFrameElement;
import com.android.tools.r8.retrace.RetraceFrameResult;
import com.android.tools.r8.retrace.RetraceStackTraceContext;
import com.android.tools.r8.retrace.RetraceStackTraceElementProxy;
import com.android.tools.r8.retrace.RetraceStackTraceElementProxyResult;
import com.android.tools.r8.retrace.RetraceThrownExceptionElement;
import com.android.tools.r8.retrace.RetraceTypeResult;
import com.android.tools.r8.retrace.RetracedClassReference;
import com.android.tools.r8.retrace.RetracedFieldReference;
import com.android.tools.r8.retrace.RetracedMethodReference;
import com.android.tools.r8.retrace.RetracedSingleFrame;
import com.android.tools.r8.retrace.RetracedSourceFile;
import com.android.tools.r8.retrace.RetracedTypeReference;
import com.android.tools.r8.retrace.Retracer;
import com.android.tools.r8.retrace.StackTraceElementProxy;
import com.android.tools.r8.retrace.StackTraceElementProxyRetracer;
import com.android.tools.r8.retrace.internal.RetraceStackTraceElementProxyResultImpl;
import com.android.tools.r8.retrace.internal.RetraceUtils;
import com.android.tools.r8.retrace.internal.RetracedTypeReferenceImpl;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StackTraceElementProxyRetracerImpl<T, ST extends StackTraceElementProxy<T, ST>>
implements StackTraceElementProxyRetracer<T, ST> {
    private final Retracer retracer;

    public StackTraceElementProxyRetracerImpl(Retracer retracer) {
        this.retracer = retracer;
    }

    private RetraceStackTraceElementProxyResultImpl<T, ST> retraceClassOrType(RetraceStackTraceElementProxyResultImpl<T, ST> currentResult, RetraceClassResult classResult) {
        return currentResult.builder().setResultStream(currentResult.stream().flatMap(proxy -> classResult.lookupThrownException(proxy.getContext()).stream().map(thrownExceptionElement -> this.buildProxyForRewrittenThrownExceptionElement(classResult, (RetraceStackTraceElementProxyImpl<T, ST>)proxy, (RetraceThrownExceptionElement)thrownExceptionElement)))).build();
    }

    private RetraceStackTraceElementProxyImpl<T, ST> buildProxyForRewrittenThrownExceptionElement(RetraceClassResult classResult, RetraceStackTraceElementProxyImpl<T, ST> proxy, RetraceThrownExceptionElement thrownExceptionElement) {
        return ((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)proxy.builder()).setRetracedClass(thrownExceptionElement.getRetracedClass())).joinAmbiguous(classResult.isAmbiguous())).setTopFrame(true)).setContext(thrownExceptionElement.getContext())).apply(this.setSourceFileOnProxy(thrownExceptionElement::getSourceFile, thrownExceptionElement.getRetracedClass(), classResult))).build();
    }

    private RetraceStackTraceElementProxyResultImpl<T, ST> retraceMethod(RetraceStackTraceElementProxyResultImpl<T, ST> currentResult, ST element, RetraceClassResult classResult, RetraceStackTraceContext context) {
        Box<RetraceStackTraceContext> resultingContext = new Box<RetraceStackTraceContext>(RetraceStackTraceContext.empty());
        RetraceStackTraceElementProxyResultImpl.Builder<T, ST> resultBuilder = currentResult.builder().setResultContext(resultingContext::get);
        return resultBuilder.setResultStream(currentResult.stream().flatMap(proxy -> {
            RetraceFrameResult frameResult = classResult.lookupFrame(context, element.hasLineNumber() ? OptionalInt.of(element.getLineNumber()) : OptionalInt.empty(), element.getMethodName());
            if (!frameResult.isEmpty()) {
                return classResult.stream().map(classElement -> ((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)proxy.builder().setTopFrame(true)).joinAmbiguous(classResult.isAmbiguous())).setRetracedClass(classElement.getRetracedClass())).applyIf(element.hasLineNumber(), b -> ((RetraceStackTraceElementProxyImpl.Builder)b).setLineNumber(element.getLineNumber()))).apply(this.setSourceFileOnProxy(classElement::getSourceFile, classElement.getRetracedClass(), classResult))).build());
            }
            return frameResult.stream().flatMap(frameElement -> {
                resultingContext.set(frameElement.getRetraceStackTraceContext());
                return frameElement.streamRewritten(context).map(singleFrame -> this.buildProxyForRewrittenFrameElement(element, classResult, (RetraceStackTraceElementProxyImpl<T, ST>)proxy, frameResult, (RetraceFrameElement)frameElement, (RetracedSingleFrame)singleFrame));
            });
        })).build();
    }

    private RetraceStackTraceElementProxyImpl<T, ST> buildProxyForRewrittenFrameElement(ST element, RetraceClassResult classResult, RetraceStackTraceElementProxyImpl<T, ST> proxy, RetraceFrameResult frameResult, RetraceFrameElement frameElement, RetracedSingleFrame singleFrame) {
        boolean isTopFrame = singleFrame.getIndex() == 0;
        RetracedMethodReference method = singleFrame.getMethodReference();
        return ((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)proxy.builder()).setRetracedClass(method.getHolderClass())).setRetracedMethod(method)).joinAmbiguous(frameResult.isAmbiguous())).setTopFrame(isTopFrame)).setContext(frameElement.getRetraceStackTraceContext())).applyIf(((StackTraceElementProxy)element).hasLineNumber(), builder -> ((RetraceStackTraceElementProxyImpl.Builder)builder).setLineNumber(method.getOriginalPositionOrDefault(element.getLineNumber())))).apply(this.setSourceFileOnProxy(() -> frameElement.getSourceFile(method), method.getHolderClass(), classResult))).build();
    }

    private RetraceStackTraceElementProxyResultImpl<T, ST> retraceField(RetraceStackTraceElementProxyResultImpl<T, ST> currentResult, ST element, RetraceClassResult classResult) {
        return currentResult.builder().setResultStream(currentResult.stream().flatMap(proxy -> {
            RetraceFieldResult retraceFieldResult = classResult.lookupField(element.getFieldName());
            return retraceFieldResult.stream().map(fieldElement -> this.buildProxyForRewrittenFieldElement(classResult, (RetraceStackTraceElementProxyImpl<T, ST>)proxy, retraceFieldResult, (RetraceFieldElement)fieldElement));
        })).build();
    }

    private RetraceStackTraceElementProxyImpl<T, ST> buildProxyForRewrittenFieldElement(RetraceClassResult classResult, RetraceStackTraceElementProxyImpl<T, ST> proxy, RetraceFieldResult retraceFieldResult, RetraceFieldElement fieldElement) {
        return ((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)proxy.builder()).setRetracedClass(fieldElement.getField().getHolderClass())).setRetracedField(fieldElement.getField())).joinAmbiguous(retraceFieldResult.isAmbiguous())).setTopFrame(true)).apply(this.setSourceFileOnProxy(fieldElement::getSourceFile, fieldElement.getField().getHolderClass(), classResult))).build();
    }

    private Consumer<RetraceStackTraceElementProxyImpl.Builder<T, ST>> setSourceFileOnProxy(Supplier<RetracedSourceFile> sourceFile, RetracedClassReference classReference, RetraceClassResult classResult) {
        return proxy -> {
            StackTraceElementProxy original = ((RetraceStackTraceElementProxyImpl.Builder)proxy).originalElement;
            if (!original.hasSourceFile()) {
                return;
            }
            RetracedSourceFile retracedSourceFile = (RetracedSourceFile)sourceFile.get();
            ((RetraceStackTraceElementProxyImpl.Builder)proxy).setSourceFile(retracedSourceFile.hasRetraceResult() ? retracedSourceFile.getSourceFile() : RetraceUtils.inferSourceFile(classReference.getTypeName(), original.getSourceFile(), classResult.isEmpty()));
        };
    }

    private RetraceStackTraceElementProxyResultImpl<T, ST> retraceFieldOrReturnType(RetraceStackTraceElementProxyResultImpl<T, ST> currentResult, ST element) {
        if (!((StackTraceElementProxy)element).hasFieldOrReturnType()) {
            return currentResult;
        }
        RetraceStackTraceElementProxyResultImpl.Builder<T, ST> resultBuilder = currentResult.builder();
        String elementOrReturnType = ((StackTraceElementProxy)element).getFieldOrReturnType();
        if (elementOrReturnType.equals("void")) {
            return resultBuilder.setResultStream(currentResult.stream().map(proxy -> this.buildProxyForRewrittenReturnType((RetraceStackTraceElementProxyImpl<T, ST>)proxy, RetracedTypeReferenceImpl.createVoid(), proxy.isAmbiguous()))).build();
        }
        TypeReference typeReference = Reference.typeFromTypeName(elementOrReturnType);
        RetraceTypeResult retraceTypeResult = this.retracer.retraceType(typeReference);
        List retracedElements = retraceTypeResult.stream().collect(Collectors.toList());
        return resultBuilder.setResultStream(currentResult.stream().flatMap(proxy -> retracedElements.stream().map(retracedResult -> this.buildProxyForRewrittenReturnType((RetraceStackTraceElementProxyImpl<T, ST>)proxy, retracedResult.getType(), retraceTypeResult.isAmbiguous())))).build();
    }

    private RetraceStackTraceElementProxyImpl<T, ST> buildProxyForRewrittenReturnType(RetraceStackTraceElementProxyImpl<T, ST> proxy, RetracedTypeReference type, boolean isAmbiguous) {
        return ((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)proxy.builder()).setRetracedFieldOrReturnType(type)).joinAmbiguous(isAmbiguous)).build();
    }

    private RetraceStackTraceElementProxyResultImpl<T, ST> retracedMethodArguments(RetraceStackTraceElementProxyResultImpl<T, ST> currentResult, ST element) {
        if (!((StackTraceElementProxy)element).hasMethodArguments()) {
            return currentResult;
        }
        List retracedResults = Arrays.stream(((StackTraceElementProxy)element).getMethodArguments().split(",")).map(typeName -> this.retracer.retraceType(Reference.typeFromTypeName(typeName))).collect(Collectors.toList());
        ArrayList initial = new ArrayList();
        initial.add(new ArrayList());
        List allRetracedArguments = ListUtils.fold(retracedResults, initial, (acc, retracedTypeResult) -> {
            ArrayList newResult = new ArrayList();
            retracedTypeResult.forEach(retracedElement -> acc.forEach(oldResult -> {
                ArrayList<RetracedTypeReference> newList = new ArrayList<RetracedTypeReference>((Collection<RetracedTypeReference>)oldResult);
                newList.add(retracedElement.getType());
                newResult.add(newList);
            }));
            return newResult;
        });
        boolean isAmbiguous = allRetracedArguments.size() > 1;
        return currentResult.builder().setResultStream(currentResult.stream().flatMap(proxy -> allRetracedArguments.stream().map(retracedArguments -> ((RetraceStackTraceElementProxyImpl.Builder)((RetraceStackTraceElementProxyImpl.Builder)proxy.builder().setRetracedMethodArguments(retracedArguments)).joinAmbiguous(isAmbiguous)).build()))).build();
    }

    @Override
    public RetraceStackTraceElementProxyResult<T, ST> retrace(ST element, RetraceStackTraceContext context) {
        RetraceStackTraceElementProxyResultImpl currentResult = RetraceStackTraceElementProxyResultImpl.Builder.create().setResultStream(Stream.of(RetraceStackTraceElementProxyImpl.create(element, context))).setResultContext(RetraceStackTraceContext::empty).build();
        if (!(((StackTraceElementProxy)element).hasClassName() || ((StackTraceElementProxy)element).hasFieldOrReturnType() || ((StackTraceElementProxy)element).hasMethodArguments())) {
            return currentResult;
        }
        currentResult = this.retraceFieldOrReturnType(currentResult, element);
        currentResult = this.retracedMethodArguments(currentResult, element);
        if (((StackTraceElementProxy)element).hasClassName()) {
            RetraceClassResult classResult = this.retracer.retraceClass(((StackTraceElementProxy)element).getClassReference());
            currentResult = ((StackTraceElementProxy)element).hasMethodName() ? this.retraceMethod(currentResult, element, classResult, context) : (((StackTraceElementProxy)element).hasFieldName() ? this.retraceField(currentResult, element, classResult) : this.retraceClassOrType(currentResult, classResult));
        }
        return currentResult;
    }

    static class RetraceStackTraceElementProxyImpl<T, ST extends StackTraceElementProxy<T, ST>>
    implements RetraceStackTraceElementProxy<T, ST> {
        private final ST originalItem;
        private final RetracedClassReference retracedClass;
        private final RetracedMethodReference retracedMethod;
        private final RetracedFieldReference retracedField;
        private final RetracedTypeReference fieldOrReturnType;
        private final List<RetracedTypeReference> methodArguments;
        private final String sourceFile;
        private final int lineNumber;
        private final boolean isAmbiguous;
        private final boolean isTopFrame;
        private final RetraceStackTraceContext context;

        private RetraceStackTraceElementProxyImpl(ST originalItem, RetracedClassReference retracedClass, RetracedMethodReference retracedMethod, RetracedFieldReference retracedField, RetracedTypeReference fieldOrReturnType, List<RetracedTypeReference> methodArguments, String sourceFile, int lineNumber, boolean isAmbiguous, boolean isTopFrame, RetraceStackTraceContext context) {
            assert (originalItem != null);
            this.originalItem = originalItem;
            this.retracedClass = retracedClass;
            this.retracedMethod = retracedMethod;
            this.retracedField = retracedField;
            this.fieldOrReturnType = fieldOrReturnType;
            this.methodArguments = methodArguments;
            this.sourceFile = sourceFile;
            this.lineNumber = lineNumber;
            this.isAmbiguous = isAmbiguous;
            this.isTopFrame = isTopFrame;
            this.context = context;
        }

        private static <T, ST extends StackTraceElementProxy<T, ST>> RetraceStackTraceElementProxyImpl<T, ST> create(ST originalItem, RetraceStackTraceContext context) {
            return new RetraceStackTraceElementProxyImpl<T, ST>(originalItem, null, null, null, null, null, null, -1, false, false, context);
        }

        /* synthetic */ RetraceStackTraceElementProxyImpl(StackTraceElementProxy x0, RetracedClassReference x1, RetracedMethodReference x2, RetracedFieldReference x3, RetracedTypeReference x4, List x5, String x6, int x7, boolean x8, boolean x9, RetraceStackTraceContext x10, 1 x11) {
            this(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10);
        }

        @Override
        public boolean isAmbiguous() {
            return this.isAmbiguous;
        }

        @Override
        public boolean isTopFrame() {
            return this.isTopFrame;
        }

        @Override
        public boolean hasRetracedClass() {
            return this.retracedClass != null;
        }

        @Override
        public boolean hasRetracedMethod() {
            return this.retracedMethod != null;
        }

        @Override
        public boolean hasRetracedField() {
            return this.retracedField != null;
        }

        @Override
        public boolean hasSourceFile() {
            return this.sourceFile != null;
        }

        @Override
        public boolean hasLineNumber() {
            return this.lineNumber != -1;
        }

        @Override
        public boolean hasRetracedFieldOrReturnType() {
            return this.fieldOrReturnType != null;
        }

        @Override
        public boolean hasRetracedMethodArguments() {
            return this.methodArguments != null;
        }

        @Override
        public ST getOriginalItem() {
            return this.originalItem;
        }

        @Override
        public RetracedClassReference getRetracedClass() {
            return this.retracedClass;
        }

        @Override
        public RetracedMethodReference getRetracedMethod() {
            return this.retracedMethod;
        }

        @Override
        public RetracedFieldReference getRetracedField() {
            return this.retracedField;
        }

        @Override
        public RetracedTypeReference getRetracedFieldOrReturnType() {
            return this.fieldOrReturnType;
        }

        @Override
        public List<RetracedTypeReference> getRetracedMethodArguments() {
            return this.methodArguments;
        }

        @Override
        public String getSourceFile() {
            return this.sourceFile;
        }

        Builder<T, ST> builder() {
            Builder builder = new Builder((StackTraceElementProxy)this.originalItem, null);
            builder.classContext = this.retracedClass;
            builder.methodContext = this.retracedMethod;
            builder.retracedField = this.retracedField;
            builder.fieldOrReturnType = this.fieldOrReturnType;
            builder.methodArguments = this.methodArguments;
            builder.sourceFile = this.sourceFile;
            builder.lineNumber = this.lineNumber;
            builder.isAmbiguous = this.isAmbiguous;
            builder.isTopFrame = this.isTopFrame;
            builder.context = this.context;
            return builder;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public RetraceStackTraceContext getContext() {
            return this.context;
        }

        @Override
        public int compareTo(RetraceStackTraceElementProxy<T, ST> other) {
            if (this == other) {
                return 0;
            }
            int classCompare = Boolean.compare(this.hasRetracedClass(), other.hasRetracedClass());
            if (classCompare != 0) {
                return classCompare;
            }
            if (this.hasRetracedClass() && (classCompare = this.getRetracedClass().getTypeName().compareTo(other.getRetracedClass().getTypeName())) != 0) {
                return classCompare;
            }
            int methodCompare = Boolean.compare(this.hasRetracedMethod(), other.hasRetracedMethod());
            if (methodCompare != 0) {
                return methodCompare;
            }
            if (this.hasRetracedMethod() && (methodCompare = this.getRetracedMethod().compareTo(other.getRetracedMethod())) != 0) {
                return methodCompare;
            }
            int sourceFileCompare = Boolean.compare(this.hasSourceFile(), other.hasSourceFile());
            if (sourceFileCompare != 0) {
                return sourceFileCompare;
            }
            if (this.hasSourceFile() && (sourceFileCompare = this.getSourceFile().compareTo(other.getSourceFile())) != 0) {
                return sourceFileCompare;
            }
            int lineNumberCompare = Boolean.compare(this.hasLineNumber(), other.hasLineNumber());
            if (lineNumberCompare != 0) {
                return lineNumberCompare;
            }
            if (this.hasLineNumber()) {
                return Integer.compare(this.lineNumber, other.getLineNumber());
            }
            return 0;
        }

        private static class Builder<T, ST extends StackTraceElementProxy<T, ST>> {
            private final ST originalElement;
            private RetracedClassReference classContext;
            private RetracedMethodReference methodContext;
            private RetracedFieldReference retracedField;
            private RetracedTypeReference fieldOrReturnType;
            private List<RetracedTypeReference> methodArguments;
            private String sourceFile;
            private int lineNumber = -1;
            private boolean isAmbiguous;
            private boolean isTopFrame;
            private RetraceStackTraceContext context;

            private Builder(ST originalElement) {
                this.originalElement = originalElement;
            }

            private Builder<T, ST> setRetracedClass(RetracedClassReference retracedClass) {
                this.classContext = retracedClass;
                return this;
            }

            private Builder<T, ST> setRetracedMethod(RetracedMethodReference methodElement) {
                this.methodContext = methodElement;
                return this;
            }

            private Builder<T, ST> setRetracedField(RetracedFieldReference retracedField) {
                this.retracedField = retracedField;
                return this;
            }

            private Builder<T, ST> setRetracedFieldOrReturnType(RetracedTypeReference retracedType) {
                this.fieldOrReturnType = retracedType;
                return this;
            }

            private Builder<T, ST> setRetracedMethodArguments(List<RetracedTypeReference> arguments) {
                this.methodArguments = arguments;
                return this;
            }

            private Builder<T, ST> setSourceFile(String sourceFile) {
                this.sourceFile = sourceFile;
                return this;
            }

            private Builder<T, ST> setLineNumber(int lineNumber) {
                this.lineNumber = lineNumber;
                return this;
            }

            private Builder<T, ST> joinAmbiguous(boolean ambiguous) {
                this.isAmbiguous = ambiguous || this.isAmbiguous;
                return this;
            }

            private Builder<T, ST> setTopFrame(boolean topFrame) {
                this.isTopFrame = topFrame;
                return this;
            }

            private Builder<T, ST> setContext(RetraceStackTraceContext context) {
                this.context = context;
                return this;
            }

            private Builder<T, ST> apply(Consumer<Builder<T, ST>> consumer) {
                consumer.accept(this);
                return this;
            }

            private Builder<T, ST> applyIf(boolean condition, Consumer<Builder<T, ST>> consumer) {
                if (condition) {
                    consumer.accept(this);
                }
                return this;
            }

            private RetraceStackTraceElementProxyImpl<T, ST> build() {
                RetracedClassReference retracedClass = this.classContext;
                if (this.methodContext != null) {
                    retracedClass = this.methodContext.getHolderClass();
                }
                return new RetraceStackTraceElementProxyImpl((StackTraceElementProxy)this.originalElement, retracedClass, this.methodContext, this.retracedField, this.fieldOrReturnType, this.methodArguments, this.sourceFile, this.lineNumber, this.isAmbiguous, this.isTopFrame, this.context, null);
            }

            /* synthetic */ Builder(StackTraceElementProxy x0, 1 x1) {
                this(x0);
            }
        }
    }
}

