/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.retrace.RetraceStackTraceElementProxy;
import com.android.tools.r8.retrace.RetracedClassReference;
import com.android.tools.r8.retrace.RetracedFieldReference;
import com.android.tools.r8.retrace.RetracedTypeReference;
import com.android.tools.r8.retrace.StackTraceElementProxy;
import com.android.tools.r8.retrace.internal.RetraceUtils;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.TriFunction;
import java.util.ArrayList;
import java.util.List;

public final class StackTraceElementStringProxy
extends StackTraceElementProxy<String, StackTraceElementStringProxy> {
    private final String line;
    private final List<StringIndex> orderedIndices;
    private final ClassStringIndex className;
    private final StringIndex methodName;
    private final StringIndex sourceFile;
    private final StringIndex lineNumber;
    private final StringIndex fieldName;
    private final StringIndex fieldOrReturnType;
    private final StringIndex methodArguments;

    private StackTraceElementStringProxy(String line, List<StringIndex> orderedIndices, ClassStringIndex className, StringIndex methodName, StringIndex sourceFile, StringIndex lineNumber, StringIndex fieldName, StringIndex fieldOrReturnType, StringIndex methodArguments) {
        this.line = line;
        this.orderedIndices = orderedIndices;
        this.className = className;
        this.methodName = methodName;
        this.sourceFile = sourceFile;
        this.lineNumber = lineNumber;
        this.fieldName = fieldName;
        this.fieldOrReturnType = fieldOrReturnType;
        this.methodArguments = methodArguments;
    }

    static StackTraceElementStringProxyBuilder builder(String line) {
        return new StackTraceElementStringProxyBuilder(line);
    }

    private String getEntryInLine(StringIndex index) {
        assert (index != StringIndex.noIndex());
        return this.line.substring(index.startIndex, index.endIndex);
    }

    @Override
    public boolean hasClassName() {
        return this.className.hasIndex();
    }

    @Override
    public boolean hasMethodName() {
        return this.methodName.hasIndex();
    }

    @Override
    public boolean hasSourceFile() {
        return this.sourceFile.hasIndex();
    }

    @Override
    public boolean hasLineNumber() {
        return this.lineNumber.hasIndex();
    }

    @Override
    public boolean hasFieldName() {
        return this.fieldName.hasIndex();
    }

    @Override
    public boolean hasFieldOrReturnType() {
        return this.fieldOrReturnType.hasIndex();
    }

    @Override
    public boolean hasMethodArguments() {
        return this.methodArguments.hasIndex();
    }

    @Override
    public ClassReference getClassReference() {
        return this.hasClassName() ? this.className.getReference(this.line) : null;
    }

    @Override
    public String getMethodName() {
        return this.hasMethodName() ? this.getEntryInLine(this.methodName) : null;
    }

    @Override
    public String getSourceFile() {
        return this.hasSourceFile() ? this.getEntryInLine(this.sourceFile) : null;
    }

    @Override
    public int getLineNumber() {
        if (!this.hasLineNumber()) {
            return -1;
        }
        try {
            String lineNumberString = this.getEntryInLine(this.lineNumber);
            if (lineNumberString.isEmpty()) {
                return -1;
            }
            return Integer.parseInt(lineNumberString);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    @Override
    public String getFieldName() {
        return this.hasFieldName() ? this.getEntryInLine(this.fieldName) : null;
    }

    @Override
    public String getFieldOrReturnType() {
        return this.hasFieldOrReturnType() ? this.getEntryInLine(this.fieldOrReturnType) : null;
    }

    @Override
    public String getMethodArguments() {
        return this.hasMethodArguments() ? this.getEntryInLine(this.methodArguments) : null;
    }

    @Override
    public String toRetracedItem(RetraceStackTraceElementProxy<String, StackTraceElementStringProxy> retracedProxy, boolean verbose) {
        StringBuilder sb = new StringBuilder();
        int lastSeenIndex = 0;
        for (StringIndex index : this.orderedIndices) {
            sb.append(this.line, lastSeenIndex, index.startIndex);
            sb.append((String)index.retracedString.apply(retracedProxy, this, verbose));
            lastSeenIndex = index.endIndex;
        }
        sb.append(this.line, lastSeenIndex, this.line.length());
        return sb.toString();
    }

    public String lineNumberAsString() {
        return this.getEntryInLine(this.lineNumber);
    }

    static final class ClassStringIndex
    extends StringIndex {
        static final ClassStringIndex NO_INDEX = new ClassStringIndex(-1, -1, null, ClassNameType.TYPENAME);
        private final ClassNameType classNameType;

        private ClassStringIndex(int startIndex, int endIndex, TriFunction<RetraceStackTraceElementProxy<String, ?>, StackTraceElementStringProxy, Boolean, String> retracedString, ClassNameType classNameType) {
            super(startIndex, endIndex, retracedString);
            this.classNameType = classNameType;
        }

        ClassReference getReference(String line) {
            String className = line.substring(this.startIndex, this.endIndex);
            return this.classNameType == ClassNameType.BINARY ? Reference.classFromBinaryName(className) : Reference.classFromTypeName(className);
        }
    }

    static class StringIndex {
        protected final int startIndex;
        protected final int endIndex;
        private final TriFunction<RetraceStackTraceElementProxy<String, ?>, StackTraceElementStringProxy, Boolean, String> retracedString;

        static ClassStringIndex noIndex() {
            return ClassStringIndex.NO_INDEX;
        }

        private StringIndex(int startIndex, int endIndex, TriFunction<RetraceStackTraceElementProxy<String, ?>, StackTraceElementStringProxy, Boolean, String> retracedString) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.retracedString = retracedString;
        }

        boolean hasIndex() {
            return this != ClassStringIndex.NO_INDEX;
        }
    }

    public static class StackTraceElementStringProxyBuilder {
        private final String line;
        private final List<StringIndex> orderedIndices = new ArrayList<StringIndex>();
        private ClassStringIndex className = StringIndex.noIndex();
        private StringIndex methodName = StringIndex.noIndex();
        private StringIndex sourceFile = StringIndex.noIndex();
        private StringIndex lineNumber = StringIndex.noIndex();
        private StringIndex fieldName = StringIndex.noIndex();
        private StringIndex fieldOrReturnType = StringIndex.noIndex();
        private StringIndex methodArguments = StringIndex.noIndex();
        private int lastSeenStartIndex = -1;

        private StackTraceElementStringProxyBuilder(String line) {
            this.line = line;
        }

        private void ensureLineIndexIncreases(int newStartIndex) {
            if (this.lastSeenStartIndex >= newStartIndex) {
                throw new RuntimeException("Parsing has to be incremental in the order of characters.");
            }
            this.lastSeenStartIndex = newStartIndex;
        }

        public StackTraceElementStringProxyBuilder registerClassName(int startIndex, int endIndex, ClassNameType classNameType) {
            this.ensureLineIndexIncreases(startIndex);
            this.className = new ClassStringIndex(startIndex, endIndex, (retraced, original, verbose) -> {
                assert (retraced.hasRetracedClass());
                RetracedClassReference retracedClass = retraced.getRetracedClass();
                return classNameType == ClassNameType.BINARY ? retracedClass.getBinaryName() : retracedClass.getTypeName();
            }, classNameType);
            this.orderedIndices.add(this.className);
            return this;
        }

        public StackTraceElementStringProxyBuilder registerMethodName(int startIndex, int endIndex) {
            this.methodName = new StringIndex(startIndex, endIndex, (retraced, original, verbose) -> {
                if (!retraced.hasRetracedMethod()) {
                    return original.getMethodName();
                }
                return RetraceUtils.methodDescriptionFromRetraceMethod(retraced.getRetracedMethod(), false, verbose);
            });
            this.orderedIndices.add(this.methodName);
            return this;
        }

        public StackTraceElementStringProxyBuilder registerSourceFile(int startIndex, int endIndex) {
            this.sourceFile = new StringIndex(startIndex, endIndex, (retraced, original, verbose) -> retraced.hasSourceFile() ? retraced.getSourceFile() : original.getSourceFile());
            this.orderedIndices.add(this.sourceFile);
            return this;
        }

        public StackTraceElementStringProxyBuilder registerLineNumber(int startIndex, int endIndex, boolean insertSeparatorForRetraced) {
            this.lineNumber = new StringIndex(startIndex, endIndex, (retraced, original, verbose) -> {
                boolean printLineNumber;
                boolean bl = printLineNumber = retraced.hasLineNumber() && (original.hasLineNumber() && original.getLineNumber() > -1 || !retraced.isAmbiguous() || verbose != false);
                return printLineNumber ? (insertSeparatorForRetraced ? ":" : "") + retraced.getLineNumber() : original.lineNumberAsString();
            });
            this.orderedIndices.add(this.lineNumber);
            return this;
        }

        public StackTraceElementStringProxyBuilder registerFieldName(int startIndex, int endIndex) {
            this.fieldName = new StringIndex(startIndex, endIndex, (retraced, original, verbose) -> {
                if (!retraced.hasRetracedField()) {
                    return original.getFieldName();
                }
                RetracedFieldReference retracedField = retraced.getRetracedField();
                if (!verbose.booleanValue() || retracedField.isUnknown()) {
                    return retracedField.getFieldName();
                }
                return retracedField.asKnown().getFieldType().getTypeName() + " " + retracedField.getFieldName();
            });
            this.orderedIndices.add(this.fieldName);
            return this;
        }

        public StackTraceElementStringProxyBuilder registerFieldOrReturnType(int startIndex, int endIndex) {
            this.fieldOrReturnType = new StringIndex(startIndex, endIndex, (retraced, original, verbose) -> {
                if (!retraced.hasRetracedFieldOrReturnType()) {
                    return original.getFieldOrReturnType();
                }
                return retraced.getRetracedFieldOrReturnType().isVoid() ? "void" : retraced.getRetracedFieldOrReturnType().getTypeName();
            });
            this.orderedIndices.add(this.fieldOrReturnType);
            return this;
        }

        public StackTraceElementStringProxyBuilder registerMethodArguments(int startIndex, int endIndex) {
            this.methodArguments = new StringIndex(startIndex, endIndex, (retraced, original, verbose) -> {
                if (!retraced.hasRetracedMethodArguments()) {
                    return original.getMethodArguments();
                }
                return StringUtils.join(",", retraced.getRetracedMethodArguments(), RetracedTypeReference::getTypeName);
            });
            this.orderedIndices.add(this.methodArguments);
            return this;
        }

        public StackTraceElementStringProxy build() {
            return new StackTraceElementStringProxy(this.line, this.orderedIndices, this.className, this.methodName, this.sourceFile, this.lineNumber, this.fieldName, this.fieldOrReturnType, this.methodArguments);
        }
    }

    public static enum ClassNameType {
        BINARY,
        TYPENAME;

    }
}

