/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.ScopedDexMethodSet;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.ListUtils;
import java.util.List;

public class AbstractMethodRemover {
    private final AppView<AppInfoWithLiveness> appView;
    private final SubtypingInfo subtypingInfo;
    private ScopedDexMethodSet scope = new ScopedDexMethodSet();

    public AbstractMethodRemover(AppView<AppInfoWithLiveness> appView, SubtypingInfo subtypingInfo) {
        this.appView = appView;
        this.subtypingInfo = subtypingInfo;
    }

    private void processClass(DexType type) {
        DexEncodedMethod[] newVirtualMethods;
        DexClass holder = this.appView.definitionFor(type);
        this.scope = this.scope.newNestedScope();
        if (holder != null && holder.isProgramClass() && (newVirtualMethods = this.processMethods(IterableUtils.ensureUnmodifiableList(holder.virtualMethods()))) != null) {
            holder.setVirtualMethods(newVirtualMethods);
        }
        this.subtypingInfo.forAllImmediateExtendsSubtypes(type, this::processClass);
        this.scope = this.scope.getParent();
    }

    private DexEncodedMethod[] processMethods(List<DexEncodedMethod> virtualMethods) {
        if (virtualMethods == null) {
            return null;
        }
        List<DexEncodedMethod> filteredMethods = ListUtils.filterOrElse(virtualMethods, this::isNonAbstractPinnedOrWideningVisibility);
        return filteredMethods == virtualMethods ? null : filteredMethods.toArray(DexEncodedMethod.EMPTY_ARRAY);
    }

    private boolean isNonAbstractPinnedOrWideningVisibility(DexEncodedMethod method) {
        if (!method.accessFlags.isAbstract()) {
            return true;
        }
        if (this.scope.addMethodIfMoreVisible(method) != ScopedDexMethodSet.AddMethodIfMoreVisibleResult.NOT_ADDED) {
            return true;
        }
        if (this.appView.appInfo().isPinned(method.getReference())) {
            return true;
        }
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Removing abstract method %s.", method.getReference());
        }
        return false;
    }

    public void run() {
        assert (this.scope.getParent() == null);
        this.processClass(this.appView.dexItemFactory().objectType);
    }
}

