/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.utils.ArrayUtils;

public class AnnotationFixer {
    private final GraphLens lens;

    public AnnotationFixer(GraphLens lens) {
        this.lens = lens;
    }

    private void processMethod(DexEncodedMethod method) {
        method.rewriteAllAnnotations((annotation, isParameterAnnotation) -> this.rewriteAnnotation((DexAnnotation)annotation));
    }

    private void processField(DexEncodedField field) {
        field.setAnnotations(field.annotations().rewrite(this::rewriteAnnotation));
    }

    private DexAnnotation rewriteAnnotation(DexAnnotation original) {
        return original.rewrite(this::rewriteEncodedAnnotation);
    }

    private DexEncodedAnnotation rewriteEncodedAnnotation(DexEncodedAnnotation original) {
        DexEncodedAnnotation rewritten = original.rewrite(this.lens::lookupType, this::rewriteAnnotationElement);
        assert (rewritten != null);
        return rewritten;
    }

    private DexAnnotationElement rewriteAnnotationElement(DexAnnotationElement original) {
        DexValue rewrittenValue = this.rewriteComplexValue(original.value);
        if (rewrittenValue != original.value) {
            return new DexAnnotationElement(original.name, rewrittenValue);
        }
        return original;
    }

    private DexValue rewriteComplexValue(DexValue value) {
        if (value.isDexValueArray()) {
            DexValue[] originalValues = value.asDexValueArray().getValues();
            DexValue[] rewrittenValues = ArrayUtils.map(originalValues, this::rewriteComplexValue, DexValue.EMPTY_ARRAY);
            if (rewrittenValues != originalValues) {
                return new DexValue.DexValueArray(rewrittenValues);
            }
        } else if (value.isDexValueAnnotation()) {
            DexValue.DexValueAnnotation original = value.asDexValueAnnotation();
            DexEncodedAnnotation rewritten = this.rewriteEncodedAnnotation(original.getValue());
            if (original.value == rewritten) {
                return value;
            }
            return new DexValue.DexValueAnnotation(rewritten);
        }
        return this.rewriteNestedValue(value);
    }

    private DexValue rewriteNestedValue(DexValue value) {
        if (value.isDexItemBasedValueString()) {
            DexValue.DexItemBasedValueString valueString = value.asDexItemBasedValueString();
            DexReference original = (DexReference)valueString.value;
            DexReference rewritten = this.lens.lookupReference(original);
            if (original != rewritten) {
                return new DexValue.DexItemBasedValueString(rewritten, valueString.getNameComputationInfo());
            }
        } else if (value.isDexValueEnum()) {
            DexField original = (DexField)value.asDexValueEnum().value;
            DexField rewritten = this.lens.lookupField(original);
            if (original != rewritten) {
                return new DexValue.DexValueEnum(rewritten);
            }
        } else {
            if (value.isDexValueField()) {
                throw new Unreachable("Unexpected field in annotation");
            }
            if (value.isDexValueMethod()) {
                throw new Unreachable("Unexpected method in annotation");
            }
            if (value.isDexValueMethodHandle()) {
                throw new Unreachable("Unexpected method handle in annotation");
            }
            if (value.isDexValueMethodType()) {
                throw new Unreachable("Unexpected method type in annotation");
            }
            if (!value.isDexValueString()) {
                if (value.isDexValueType()) {
                    DexType originalType = (DexType)value.asDexValueType().value;
                    DexType rewrittenType = this.lens.lookupType(originalType);
                    if (rewrittenType != originalType) {
                        return new DexValue.DexValueType(rewrittenType);
                    }
                } else assert (!value.isNestedDexValue());
            }
        }
        return value;
    }

    public void run(Iterable<DexProgramClass> classes) {
        for (DexProgramClass clazz : classes) {
            clazz.setAnnotations(clazz.annotations().rewrite(this::rewriteAnnotation));
            clazz.forEachMethod(this::processMethod);
            clazz.forEachField(this::processField);
        }
    }
}

