/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMember;
import com.android.tools.r8.kotlin.KotlinMemberLevelInfo;
import com.android.tools.r8.kotlin.KotlinPropertyInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.KeepClassInfo;
import com.android.tools.r8.shaking.KeepInfo;
import com.android.tools.r8.shaking.KeepMemberInfo;
import com.android.tools.r8.shaking.ProguardKeepAttributes;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class AnnotationRemover {
    private final AppView<AppInfoWithLiveness> appView;
    private final Enqueuer.Mode mode;
    private final InternalOptions options;
    private final Set<DexAnnotation> annotationsToRetain;
    private final ProguardKeepAttributes keep;
    private final Set<DexType> removedClasses;

    private AnnotationRemover(AppView<AppInfoWithLiveness> appView, Set<DexAnnotation> annotationsToRetain, Enqueuer.Mode mode, Set<DexType> removedClasses) {
        this.appView = appView;
        this.mode = mode;
        this.options = appView.options();
        this.annotationsToRetain = annotationsToRetain;
        this.keep = appView.options().getProguardConfiguration().getKeepAttributes();
        this.removedClasses = removedClasses;
    }

    public static Builder builder(Enqueuer.Mode mode) {
        return new Builder(mode);
    }

    private boolean filterAnnotations(ProgramDefinition holder, DexAnnotation annotation, DexAnnotation.AnnotatedKind kind) {
        return this.annotationsToRetain.contains(annotation) || AnnotationRemover.shouldKeepAnnotation(this.appView, holder, annotation, this.isAnnotationTypeLive(annotation), kind);
    }

    public static boolean shouldKeepAnnotation(AppView<?> appView, ProgramDefinition holder, DexAnnotation annotation, boolean isAnnotationTypeLive, DexAnnotation.AnnotatedKind kind) {
        if (!appView.options().isShrinking()) {
            return true;
        }
        InternalOptions options = appView.options();
        ProguardKeepAttributes config = options.getProguardConfiguration() != null ? options.getProguardConfiguration().getKeepAttributes() : ProguardKeepAttributes.fromPatterns(ImmutableList.of());
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        switch (annotation.visibility) {
            case 2: {
                if (kind.isParameter()) {
                    return false;
                }
                assert (!DexAnnotation.isInnerClassAnnotation(annotation, dexItemFactory));
                assert (!DexAnnotation.isMemberClassesAnnotation(annotation, dexItemFactory));
                assert (!DexAnnotation.isEnclosingMethodAnnotation(annotation, dexItemFactory));
                assert (!DexAnnotation.isEnclosingClassAnnotation(annotation, dexItemFactory));
                assert (options.passthroughDexCode || !DexAnnotation.isSignatureAnnotation(annotation, dexItemFactory));
                if (config.exceptions && DexAnnotation.isThrowingAnnotation(annotation, dexItemFactory)) {
                    return true;
                }
                if (DexAnnotation.isSourceDebugExtension(annotation, dexItemFactory)) {
                    assert (holder.isProgramClass());
                    appView.setSourceDebugExtensionForType(holder.asProgramClass(), annotation.annotation.elements[0].value.asDexValueString());
                    return config.sourceDebugExtension;
                }
                if (config.methodParameters && DexAnnotation.isParameterNameAnnotation(annotation, dexItemFactory)) {
                    return true;
                }
                return DexAnnotation.isAnnotationDefaultAnnotation(annotation, dexItemFactory);
            }
            case 1: {
                if (holder.isProgramClass() && holder.asProgramClass().isAnnotation() && DexAnnotation.isJavaLangRetentionAnnotation(annotation, dexItemFactory)) {
                    return true;
                }
                if (kind.isParameter() ? !options.isKeepRuntimeVisibleParameterAnnotationsEnabled() : !options.isKeepRuntimeVisibleAnnotationsEnabled()) {
                    return false;
                }
                return isAnnotationTypeLive;
            }
            case 0: {
                if (annotation.getAnnotationType().getDescriptor().startsWith(options.itemFactory.dalvikAnnotationOptimizationPrefix)) {
                    return true;
                }
                if (kind.isParameter() ? !options.isKeepRuntimeInvisibleParameterAnnotationsEnabled() : !options.isKeepRuntimeInvisibleAnnotationsEnabled()) {
                    return false;
                }
                return isAnnotationTypeLive;
            }
        }
        throw new Unreachable("Unexpected annotation visibility.");
    }

    private boolean isAnnotationTypeLive(DexAnnotation annotation) {
        return AnnotationRemover.isAnnotationTypeLive(annotation, this.appView);
    }

    private static boolean isAnnotationTypeLive(DexAnnotation annotation, AppView<AppInfoWithLiveness> appView) {
        DexType annotationType = annotation.annotation.type.toBaseType(appView.dexItemFactory());
        return appView.appInfo().isNonProgramTypeOrLiveProgramType(annotationType);
    }

    private void run(DexProgramClass clazz) {
        KeepClassInfo keepInfo = this.appView.getKeepInfo().getClassInfo(clazz);
        this.removeAnnotations(clazz, keepInfo);
        this.stripAttributes(clazz, keepInfo);
        Set pinnedKotlinProperties = Sets.newIdentityHashSet();
        clazz.forEachProgramMember(member -> this.processMember((ProgramMember<?, ?>)member, clazz, pinnedKotlinProperties));
        clazz.forEachProgramMember(member -> {
            KotlinMemberLevelInfo kotlinInfo = member.getKotlinInfo();
            if (kotlinInfo.isProperty() && !pinnedKotlinProperties.contains(kotlinInfo.asProperty())) {
                member.clearKotlinInfo();
            }
        });
    }

    private boolean verifyNoKeptKotlinMembersForClassesWithNoKotlinInfo() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            if (!clazz.getKotlinInfo().isNoKotlinInformation()) continue;
            clazz.forEachProgramMember(member -> {
                assert (member.getKotlinInfo().isNoKotlinInformation()) : "Should have pruned kotlin info";
            });
        }
        return true;
    }

    private void processMember(ProgramMember<?, ?> member, DexProgramClass clazz, Set<KotlinPropertyInfo> pinnedKotlinProperties) {
        KeepMemberInfo<?, ?> memberInfo = this.appView.getKeepInfo().getMemberInfo(member);
        this.removeAnnotations(member, memberInfo);
        if (memberInfo.isSignatureRemovalAllowed(this.options)) {
            member.clearGenericSignature();
        }
        if (!member.getKotlinInfo().isProperty() && memberInfo.isKotlinMetadataRemovalAllowed(clazz, this.options)) {
            member.clearKotlinInfo();
        }
        if (member.getKotlinInfo().isProperty() && !memberInfo.isKotlinMetadataRemovalAllowed(clazz, this.options)) {
            pinnedKotlinProperties.add(member.getKotlinInfo().asProperty());
        }
    }

    private DexAnnotation rewriteAnnotation(ProgramDefinition holder, DexAnnotation original, DexAnnotation.AnnotatedKind kind) {
        if (this.filterAnnotations(holder, original, kind)) {
            return original.rewrite(this::rewriteEncodedAnnotation);
        }
        return null;
    }

    private DexEncodedAnnotation rewriteEncodedAnnotation(DexEncodedAnnotation original) {
        GraphLens graphLens = this.appView.graphLens();
        DexType annotationType = original.type.toBaseType(this.appView.dexItemFactory());
        if (this.removedClasses.contains(annotationType)) {
            return null;
        }
        DexType rewrittenType = graphLens.lookupType(annotationType);
        DexEncodedAnnotation rewrite = original.rewrite(graphLens::lookupType, element -> this.rewriteAnnotationElement(rewrittenType, (DexAnnotationElement)element));
        assert (rewrite != null);
        DexClass annotationClass = this.appView.appInfo().definitionFor(rewrittenType);
        assert (annotationClass == null || this.appView.appInfo().isNonProgramTypeOrLiveProgramType(rewrittenType));
        return rewrite;
    }

    private DexAnnotationElement rewriteAnnotationElement(DexType annotationType, DexAnnotationElement original) {
        DexClass definition = this.appView.definitionFor(annotationType);
        if (definition == null) {
            return original;
        }
        assert (definition.isInterface());
        boolean liveGetter = definition.getMethodCollection().hasVirtualMethods(method -> ((DexMethod)method.getReference()).name == original.name);
        return liveGetter ? original : null;
    }

    private void removeAnnotations(ProgramDefinition definition, KeepInfo<?, ?> keepInfo) {
        boolean isAnnotation;
        assert (this.mode.isInitialTreeShaking() || this.annotationsToRetain.isEmpty());
        boolean bl = isAnnotation = definition.isProgramClass() && definition.asProgramClass().isAnnotation();
        if (keepInfo.isAnnotationRemovalAllowed(this.options)) {
            if (isAnnotation) {
                definition.rewriteAllAnnotations((annotation, isParameterAnnotation) -> this.shouldRetainAnnotationOnAnnotationClass((DexAnnotation)annotation) ? annotation : null);
            } else if (this.mode.isInitialTreeShaking()) {
                definition.rewriteAllAnnotations((annotation, isParameterAnnotation) -> this.annotationsToRetain.contains(annotation) ? annotation : null);
            } else {
                definition.clearAllAnnotations();
            }
        } else {
            definition.rewriteAllAnnotations((annotation, kind) -> this.rewriteAnnotation(definition, (DexAnnotation)annotation, (DexAnnotation.AnnotatedKind)((Object)kind)));
        }
    }

    private boolean shouldRetainAnnotationOnAnnotationClass(DexAnnotation annotation) {
        if (DexAnnotation.isAnnotationDefaultAnnotation(annotation, this.appView.dexItemFactory())) {
            return this.shouldRetainAnnotationDefaultAnnotationOnAnnotationClass(annotation);
        }
        if (DexAnnotation.isJavaLangRetentionAnnotation(annotation, this.appView.dexItemFactory())) {
            return this.shouldRetainRetentionAnnotationOnAnnotationClass(annotation);
        }
        return this.annotationsToRetain.contains(annotation);
    }

    private boolean shouldRetainAnnotationDefaultAnnotationOnAnnotationClass(DexAnnotation annotation) {
        return true;
    }

    private boolean shouldRetainRetentionAnnotationOnAnnotationClass(DexAnnotation annotation) {
        if (annotation.annotation.getNumberOfElements() != 1) {
            return true;
        }
        DexAnnotationElement element = annotation.annotation.getElement(0);
        if (element.name != this.appView.dexItemFactory().valueString) {
            return true;
        }
        DexValue value = element.getValue();
        return !value.isDexValueEnum() || value.asDexValueEnum().getValue() != this.appView.dexItemFactory().javaLangAnnotationRetentionPolicyMembers.CLASS;
    }

    private void stripAttributes(DexProgramClass clazz, KeepClassInfo keepInfo) {
        clazz.removeEnclosingMethodAttribute(enclosingMethodAttribute -> keepInfo.isEnclosingMethodAttributeRemovalAllowed(this.options, (EnclosingMethodAttribute)enclosingMethodAttribute, this.appView));
        clazz.removeInnerClasses(attribute -> this.canRemoveInnerClassAttribute(clazz, (InnerClassAttribute)attribute, clazz.getEnclosingMethodAttribute()));
        if (clazz.getClassSignature().isValid() && keepInfo.isSignatureRemovalAllowed(this.options)) {
            clazz.clearClassSignature();
        }
    }

    private boolean canRemoveInnerClassAttribute(DexProgramClass clazz, InnerClassAttribute innerClassAttribute, EnclosingMethodAttribute enclosingAttributeMethod) {
        if (innerClassAttribute.getOuter() == null && (clazz.isLocalClass() || clazz.isAnonymousClass())) {
            assert (innerClassAttribute.getInner() != null);
            return this.appView.getKeepInfo().getClassInfo(innerClassAttribute.getInner(), this.appView).isInnerClassesAttributeRemovalAllowed(this.options, enclosingAttributeMethod);
        }
        if (innerClassAttribute.getOuter() == null) {
            assert (!clazz.isLocalClass() && !clazz.isAnonymousClass());
            return this.appView.getKeepInfo().getClassInfo(innerClassAttribute.getInner(), this.appView).isInnerClassesAttributeRemovalAllowed(this.options);
        }
        if (innerClassAttribute.getInner() == null) {
            assert (innerClassAttribute.getOuter() != null);
            return this.appView.getKeepInfo().getClassInfo(innerClassAttribute.getOuter(), this.appView).isInnerClassesAttributeRemovalAllowed(this.options);
        }
        assert (innerClassAttribute.getOuter() != null && innerClassAttribute.getInner() != null);
        return this.appView.getKeepInfo().getClassInfo(innerClassAttribute.getInner(), this.appView).isInnerClassesAttributeRemovalAllowed(this.options) || this.appView.getKeepInfo().getClassInfo(innerClassAttribute.getOuter(), this.appView).isInnerClassesAttributeRemovalAllowed(this.options);
    }

    public static void clearAnnotations(AppView<?> appView) {
        for (DexProgramClass clazz : ((AppInfo)appView.appInfo()).classes()) {
            clazz.clearAnnotations();
            clazz.members().forEach(DexDefinition::clearAnnotations);
        }
    }

    public AnnotationRemover ensureValid() {
        this.keep.ensureValid(this.appView.options().forceProguardCompatibility);
        return this;
    }

    public void run(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(this.appView.appInfo().classes(), this::run, executorService);
        assert (this.verifyNoKeptKotlinMembersForClassesWithNoKotlinInfo());
    }

    public static class Builder {
        private final Set<DexAnnotation> annotationsToRetain = Sets.newIdentityHashSet();
        private final Enqueuer.Mode mode;

        Builder(Enqueuer.Mode mode) {
            this.mode = mode;
        }

        public boolean isRetainedForFinalTreeShaking(DexAnnotation annotation) {
            return this.annotationsToRetain.contains(annotation);
        }

        public void retainAnnotation(DexAnnotation annotation) {
            this.annotationsToRetain.add(annotation);
        }

        public AnnotationRemover build(AppView<AppInfoWithLiveness> appView, Set<DexType> removedClasses) {
            return new AnnotationRemover(appView, this.annotationsToRetain, this.mode, removedClasses);
        }
    }
}

