/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.code.CfOrDexInstruction;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.desugar.records.RecordRewriterHelper;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.ListIterator;

public class DefaultEnqueuerUseRegistry
extends UseRegistry<ProgramMethod> {
    protected final AppView<? extends AppInfoWithClassHierarchy> appView;
    protected final Enqueuer enqueuer;
    private final AndroidApiLevelCompute apiLevelCompute;
    private ComputedApiLevel maxApiReferenceLevel;

    public DefaultEnqueuerUseRegistry(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context, Enqueuer enqueuer, AndroidApiLevelCompute apiLevelCompute) {
        super(appView, context);
        this.appView = appView;
        this.enqueuer = enqueuer;
        this.apiLevelCompute = apiLevelCompute;
        this.maxApiReferenceLevel = appView.computedMinApiLevel();
    }

    private void registerInstanceFieldReadFromRecordMethodHandle(DexField field) {
        this.setMaxApiReferenceLevel(field);
        this.enqueuer.traceInstanceFieldReadFromRecordMethodHandle(field, (ProgramMethod)this.getContext());
    }

    private void registerRecordCallSiteBootstrapArgs(DexCallSite callSite) {
        this.registerCallSiteBootstrapArgs(callSite, 0, 2);
        for (int i = 2; i < callSite.getBootstrapArgs().size(); ++i) {
            DexField field = ((DexMethodHandle)callSite.getBootstrapArgs().get((int)i).asDexValueMethodHandle().value).asField();
            DexEncodedField encodedField = this.appView.appInfo().resolveField(field, (ProgramMethod)this.getContext()).getResolvedField();
            if (encodedField.getOptimizationInfo().isDead()) continue;
            this.registerInstanceFieldReadFromRecordMethodHandle(field);
        }
    }

    private void setMaxApiReferenceLevel(DexReference reference) {
        this.maxApiReferenceLevel = this.maxApiReferenceLevel.max(this.apiLevelCompute.computeApiLevelForLibraryReference(reference, this.apiLevelCompute.getPlatformApiLevelOrUnknown(this.appView)));
    }

    public DexProgramClass getContextHolder() {
        return ((ProgramMethod)this.getContext()).getHolder();
    }

    public DexEncodedMethod getContextMethod() {
        return (DexEncodedMethod)((ProgramMethod)this.getContext()).getDefinition();
    }

    @Override
    public void registerInitClass(DexType clazz) {
        this.enqueuer.traceInitClass(clazz, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerRecordFieldValues(DexField[] fields) {
        super.registerRecordFieldValues(fields);
        this.enqueuer.traceRecordFieldValues(fields, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerInvokeVirtual(DexMethod invokedMethod) {
        this.setMaxApiReferenceLevel(invokedMethod);
        this.enqueuer.traceInvokeVirtual(invokedMethod, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerInvokeDirect(DexMethod invokedMethod) {
        this.setMaxApiReferenceLevel(invokedMethod);
        this.enqueuer.traceInvokeDirect(invokedMethod, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerInvokeStatic(DexMethod invokedMethod) {
        this.setMaxApiReferenceLevel(invokedMethod);
        this.enqueuer.traceInvokeStatic(invokedMethod, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerInvokeInterface(DexMethod invokedMethod) {
        this.setMaxApiReferenceLevel(invokedMethod);
        this.enqueuer.traceInvokeInterface(invokedMethod, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerInvokeSuper(DexMethod invokedMethod) {
        this.setMaxApiReferenceLevel(invokedMethod);
        this.enqueuer.traceInvokeSuper(invokedMethod, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerInstanceFieldRead(DexField field) {
        this.setMaxApiReferenceLevel(field);
        this.enqueuer.traceInstanceFieldRead(field, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerInstanceFieldReadFromMethodHandle(DexField field) {
        this.setMaxApiReferenceLevel(field);
        this.enqueuer.traceInstanceFieldReadFromMethodHandle(field, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerInstanceFieldWrite(DexField field) {
        this.setMaxApiReferenceLevel(field);
        this.enqueuer.traceInstanceFieldWrite(field, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerInstanceFieldWriteFromMethodHandle(DexField field) {
        this.setMaxApiReferenceLevel(field);
        this.enqueuer.traceInstanceFieldWriteFromMethodHandle(field, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerNewInstance(DexType type) {
        this.setMaxApiReferenceLevel(type);
        this.enqueuer.traceNewInstance(type, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerStaticFieldRead(DexField field) {
        this.setMaxApiReferenceLevel(field);
        this.enqueuer.traceStaticFieldRead(field, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerStaticFieldReadFromMethodHandle(DexField field) {
        this.setMaxApiReferenceLevel(field);
        this.enqueuer.traceStaticFieldReadFromMethodHandle(field, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerStaticFieldWrite(DexField field) {
        this.setMaxApiReferenceLevel(field);
        this.enqueuer.traceStaticFieldWrite(field, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerStaticFieldWriteFromMethodHandle(DexField field) {
        this.setMaxApiReferenceLevel(field);
        this.enqueuer.traceStaticFieldWriteFromMethodHandle(field, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerConstClass(DexType type, ListIterator<? extends CfOrDexInstruction> iterator2, boolean ignoreCompatRules) {
        this.enqueuer.traceConstClass(type, (ProgramMethod)this.getContext(), iterator2, ignoreCompatRules);
    }

    @Override
    public void registerCheckCast(DexType type, boolean ignoreCompatRules) {
        this.enqueuer.traceCheckCast(type, (ProgramMethod)this.getContext(), ignoreCompatRules);
    }

    @Override
    public void registerSafeCheckCast(DexType type) {
        this.enqueuer.traceSafeCheckCast(type, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerTypeReference(DexType type) {
        this.enqueuer.traceTypeReference(type, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerInstanceOf(DexType type) {
        this.enqueuer.traceInstanceOf(type, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerExceptionGuard(DexType guard) {
        this.setMaxApiReferenceLevel(guard);
        this.enqueuer.traceExceptionGuard(guard, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerMethodHandle(DexMethodHandle methodHandle, UseRegistry.MethodHandleUse use) {
        super.registerMethodHandle(methodHandle, use);
        this.enqueuer.traceMethodHandle(methodHandle, use, (ProgramMethod)this.getContext());
    }

    @Override
    public void registerCallSite(DexCallSite callSite) {
        super.registerCallSiteExceptBootstrapArgs(callSite);
        if (RecordRewriterHelper.isInvokeDynamicOnRecord(callSite, this.appView, (ProgramMethod)this.getContext()) && this.appView.options().testing.enableRecordModeling) {
            this.registerRecordCallSiteBootstrapArgs(callSite);
        } else {
            super.registerCallSiteBootstrapArgs(callSite, 0, callSite.bootstrapArgs.size());
        }
        this.enqueuer.traceCallSite(callSite, (ProgramMethod)this.getContext());
    }

    public ComputedApiLevel getMaxApiReferenceLevel() {
        return this.maxApiReferenceLevel;
    }
}

