/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.code.CfOrDexInstruction;
import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.InterfaceDesugarMissingTypeDiagnostic;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassDefinition;
import com.android.tools.r8.graph.ClasspathOrLibraryClass;
import com.android.tools.r8.graph.ClasspathOrLibraryDefinition;
import com.android.tools.r8.graph.Definition;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.FieldAccessInfoCollectionImpl;
import com.android.tools.r8.graph.FieldAccessInfoImpl;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.GenericSignatureEnqueuerAnalysis;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.InvalidCode;
import com.android.tools.r8.graph.LookupLambdaTarget;
import com.android.tools.r8.graph.LookupResult;
import com.android.tools.r8.graph.LookupTarget;
import com.android.tools.r8.graph.MethodAccessInfoCollection;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.NestMemberClassAttribute;
import com.android.tools.r8.graph.ObjectAllocationInfoCollectionImpl;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramDerivedContext;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.graph.analysis.ApiModelAnalysis;
import com.android.tools.r8.graph.analysis.EnqueuerAnalysis;
import com.android.tools.r8.graph.analysis.EnqueuerCheckCastAnalysis;
import com.android.tools.r8.graph.analysis.EnqueuerExceptionGuardAnalysis;
import com.android.tools.r8.graph.analysis.EnqueuerFieldAccessAnalysis;
import com.android.tools.r8.graph.analysis.EnqueuerInstanceOfAnalysis;
import com.android.tools.r8.graph.analysis.EnqueuerInvokeAnalysis;
import com.android.tools.r8.graph.analysis.GetArrayOfMissingTypeVerifyErrorWorkaround;
import com.android.tools.r8.graph.analysis.InvokeVirtualToInterfaceVerifyErrorWorkaround;
import com.android.tools.r8.ir.analysis.proto.ProtoEnqueuerUseRegistry;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoEnqueuerExtension;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.ConstantValueUtils;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.LambdaClass;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.ir.desugar.ProgramAdditions;
import com.android.tools.r8.ir.desugar.constantdynamic.ConstantDynamicClass;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryAPIConverter;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodProcessorFacade;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodRewriter;
import com.android.tools.r8.ir.desugar.itf.InterfaceProcessor;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import com.android.tools.r8.kotlin.KotlinMetadataEnqueuerExtension;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.naming.IdentifierNameStringUtils;
import com.android.tools.r8.naming.identifiernamestring.IdentifierNameStringLookupResult;
import com.android.tools.r8.naming.identifiernamestring.IdentifierNameStringTypeLookupResult;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.shaking.AnnotationMatchResult;
import com.android.tools.r8.shaking.AnnotationRemover;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.DefaultEnqueuerUseRegistry;
import com.android.tools.r8.shaking.DelayedRootSetActionItem;
import com.android.tools.r8.shaking.DependentMinimumKeepInfoCollection;
import com.android.tools.r8.shaking.EnqueuerDeferredTracing;
import com.android.tools.r8.shaking.EnqueuerEvent;
import com.android.tools.r8.shaking.EnqueuerResult;
import com.android.tools.r8.shaking.EnqueuerUseRegistryFactory;
import com.android.tools.r8.shaking.EnqueuerWorklist;
import com.android.tools.r8.shaking.GlobalKeepInfoConfiguration;
import com.android.tools.r8.shaking.GraphReporter;
import com.android.tools.r8.shaking.IfRuleClassPartEquivalence;
import com.android.tools.r8.shaking.IfRuleEvaluator;
import com.android.tools.r8.shaking.InstantiatedObject;
import com.android.tools.r8.shaking.InstantiationReason;
import com.android.tools.r8.shaking.KeepClassInfo;
import com.android.tools.r8.shaking.KeepFieldInfo;
import com.android.tools.r8.shaking.KeepInfoCollection;
import com.android.tools.r8.shaking.KeepMethodInfo;
import com.android.tools.r8.shaking.KeepReason;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.shaking.MainDexListBuilder;
import com.android.tools.r8.shaking.MinimumKeepInfoCollection;
import com.android.tools.r8.shaking.MissingClasses;
import com.android.tools.r8.shaking.ProguardCompatibilityActions;
import com.android.tools.r8.shaking.ProguardIfRule;
import com.android.tools.r8.shaking.ProguardKeepRuleBase;
import com.android.tools.r8.shaking.RootSetUtils;
import com.android.tools.r8.shaking.ScopedDexMethodSet;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.IteratorUtils;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.Visibility;
import com.android.tools.r8.utils.WorkList;
import com.android.tools.r8.utils.collections.DexMethodSignatureSet;
import com.android.tools.r8.utils.collections.ProgramFieldSet;
import com.android.tools.r8.utils.collections.ProgramMethodMap;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Enqueuer {
    private final boolean forceProguardCompatibility;
    private final Mode mode;
    private final Set<EnqueuerAnalysis> analyses = new LinkedHashSet<EnqueuerAnalysis>();
    private final Set<EnqueuerFieldAccessAnalysis> fieldAccessAnalyses = new LinkedHashSet<EnqueuerFieldAccessAnalysis>();
    private final Set<EnqueuerInvokeAnalysis> invokeAnalyses = new LinkedHashSet<EnqueuerInvokeAnalysis>();
    private final Set<EnqueuerInstanceOfAnalysis> instanceOfAnalyses = new LinkedHashSet<EnqueuerInstanceOfAnalysis>();
    private final Set<EnqueuerExceptionGuardAnalysis> exceptionGuardAnalyses = new LinkedHashSet<EnqueuerExceptionGuardAnalysis>();
    private final Set<EnqueuerCheckCastAnalysis> checkCastAnalyses = new LinkedHashSet<EnqueuerCheckCastAnalysis>();
    private AppInfoWithClassHierarchy appInfo;
    private final AppView<AppInfoWithClassHierarchy> appView;
    private final EnqueuerDeferredTracing deferredTracing;
    private final ExecutorService executorService;
    private SubtypingInfo subtypingInfo;
    private final InternalOptions options;
    private RootSetUtils.RootSet rootSet;
    private final EnqueuerUseRegistryFactory useRegistryFactory;
    private AnnotationRemover.Builder annotationRemoverBuilder;
    private final EnqueuerDefinitionSupplier enqueuerDefinitionSupplier = new EnqueuerDefinitionSupplier(this);
    private final FieldAccessInfoCollectionImpl fieldAccessInfoCollection = new FieldAccessInfoCollectionImpl();
    private final MethodAccessInfoCollection.IdentityBuilder methodAccessInfoCollection = MethodAccessInfoCollection.identityBuilder();
    private final ObjectAllocationInfoCollectionImpl.Builder objectAllocationInfoCollection;
    private final Map<DexCallSite, ProgramMethodSet> callSites = new IdentityHashMap<DexCallSite, ProgramMethodSet>();
    private final Set<DexMember<?, ?>> identifierNameStrings = Sets.newIdentityHashSet();
    private final Map<DexEncodedMethod, ProgramMethodSet> superInvokeDependencies = Maps.newIdentityHashMap();
    private final Map<DexProgramClass, ProgramFieldSet> reachableInstanceFields = Maps.newIdentityHashMap();
    private final Map<DexProgramClass, ProgramMethod> synthesizingContexts = new IdentityHashMap<DexProgramClass, ProgramMethod>();
    private final SetWithReportedReason<DexProgramClass> liveTypes = new SetWithReportedReason();
    private final Set<DexProgramClass> interfacesTransitionedToInstantiated = Sets.newIdentityHashSet();
    private final SetWithReportedReason<DexProgramClass> initializedClasses = new SetWithReportedReason();
    private final SetWithReportedReason<DexProgramClass> directlyInitializedInterfaces = new SetWithReportedReason();
    private final SetWithReportedReason<DexProgramClass> indirectlyInitializedInterfaces = new SetWithReportedReason();
    private final Set<ClasspathOrLibraryClass> liveNonProgramTypes = Sets.newIdentityHashSet();
    private final Set<ClasspathOrLibraryClass> referencedNonProgramTypes = Sets.newIdentityHashSet();
    private final Set<DexProgramClass> deadProtoTypeCandidates = Sets.newIdentityHashSet();
    private final MissingClasses.Builder missingClassesBuilder;
    private Set<DexType> initialDeadProtoTypes = Sets.newIdentityHashSet();
    private Set<DexType> initialPrunedTypes;
    private final Set<DexType> noClassMerging = Sets.newIdentityHashSet();
    private final Map<DexProgramClass, Set<DexProgramClass>> unusedInterfaceTypes = new IdentityHashMap<DexProgramClass, Set<DexProgramClass>>();
    private final LiveMethodsSet targetedMethods;
    private final Set<DexMethod> failedMethodResolutionTargets;
    private final Set<DexField> failedFieldResolutionTargets;
    private final Set<DexMethod> bootstrapMethods = Sets.newIdentityHashSet();
    private final Set<DexMethod> virtualMethodsTargetedByInvokeDirect = Sets.newIdentityHashSet();
    private final LiveMethodsSet liveMethods;
    private final LiveFieldsSet liveFields;
    private EnqueuerWorklist workList;
    private final ProguardCompatibilityActions.Builder proguardCompatibilityActionsBuilder;
    private final ProgramMethodSet pendingReflectiveUses = ProgramMethodSet.createLinked();
    private final Map<DexProgramClass, Map<ResolutionSearchKey, ProgramMethodSet>> reachableVirtualTargets = new IdentityHashMap<DexProgramClass, Map<ResolutionSearchKey, ProgramMethodSet>>();
    private final KeepInfoCollection.MutableKeepInfoCollection keepInfo = new KeepInfoCollection.MutableKeepInfoCollection();
    private final DependentMinimumKeepInfoCollection dependentMinimumKeepInfo = new DependentMinimumKeepInfoCollection();
    private final Set<DexType> lockCandidates = Sets.newIdentityHashSet();
    private final Map<DexType, Visibility> initClassReferences = new IdentityHashMap<DexType, Visibility>();
    private final Set<DexMethod> recordFieldValuesReferences = Sets.newIdentityHashSet();
    private final Map<DexType, Map<DexAnnotation, List<ProgramDefinition>>> deferredAnnotations = new IdentityHashMap<DexType, Map<DexAnnotation, List<ProgramDefinition>>>();
    private final Map<DexType, Map<DexAnnotation, List<ProgramDefinition>>> deferredParameterAnnotations = new IdentityHashMap<DexType, Map<DexAnnotation, List<ProgramDefinition>>>();
    private Map<Equivalence.Wrapper<ProguardIfRule>, Set<ProguardIfRule>> activeIfRules;
    private final Map<DexType, ScopedDexMethodSet> scopedMethodsForLiveTypes = new IdentityHashMap<DexType, ScopedDexMethodSet>();
    private final GraphReporter graphReporter;
    private final CfInstructionDesugaringCollection desugaring;
    private final ProgramMethodSet pendingCodeDesugaring = ProgramMethodSet.create();
    private final ProgramMethodSet pendingMethodMove = ProgramMethodSet.create();
    private final ProgramMethodMap<ProgramMethod> pendingMethodMoveInverse = ProgramMethodMap.createConcurrent();
    private final InterfaceProcessor interfaceProcessor;
    private final Map<DexMethod, ProgramMethod> syntheticInterfaceMethodBridges = new LinkedHashMap<DexMethod, ProgramMethod>();

    Enqueuer(AppView<? extends AppInfoWithClassHierarchy> appView, ExecutorService executorService, SubtypingInfo subtypingInfo, GraphConsumer keptGraphConsumer, Mode mode) {
        assert (appView.appServices() != null);
        InternalOptions options = appView.options();
        this.appInfo = appView.appInfo();
        this.appView = appView.withClassHierarchy();
        this.deferredTracing = new EnqueuerDeferredTracing();
        this.executorService = executorService;
        this.subtypingInfo = subtypingInfo;
        this.forceProguardCompatibility = options.forceProguardCompatibility;
        this.graphReporter = new GraphReporter(appView, keptGraphConsumer);
        this.missingClassesBuilder = appView.appInfo().getMissingClasses().builder();
        this.mode = mode;
        this.options = options;
        this.useRegistryFactory = this.createUseRegistryFactory();
        this.workList = EnqueuerWorklist.createWorklist(this);
        ProguardCompatibilityActions.Builder builder = this.proguardCompatibilityActionsBuilder = mode.isInitialTreeShaking() && options.forceProguardCompatibility ? ProguardCompatibilityActions.builder() : null;
        if (mode.isTreeShaking()) {
            GetArrayOfMissingTypeVerifyErrorWorkaround.register(appView, this);
            InvokeVirtualToInterfaceVerifyErrorWorkaround.register(appView, this);
            if (options.protoShrinking().enableGeneratedMessageLiteShrinking) {
                this.registerAnalysis(new ProtoEnqueuerExtension(appView));
            }
            appView.withGeneratedMessageLiteBuilderShrinker(shrinker -> this.registerAnalysis(shrinker.createEnqueuerAnalysis()));
        }
        this.targetedMethods = new LiveMethodsSet(this.graphReporter::registerMethod);
        this.failedMethodResolutionTargets = SetUtils.newIdentityHashSet(2);
        this.failedFieldResolutionTargets = SetUtils.newIdentityHashSet(0);
        this.liveMethods = new LiveMethodsSet(this.graphReporter::registerMethod);
        this.liveFields = new LiveFieldsSet(this.graphReporter::registerField);
        if (mode.isInitialTreeShaking()) {
            this.desugaring = CfInstructionDesugaringCollection.create(appView, appView.apiLevelCompute());
            this.interfaceProcessor = new InterfaceProcessor(appView);
        } else {
            this.desugaring = CfInstructionDesugaringCollection.empty();
            this.interfaceProcessor = null;
        }
        this.objectAllocationInfoCollection = ObjectAllocationInfoCollectionImpl.builder(mode.isInitialTreeShaking(), this.graphReporter);
    }

    private AppInfoWithClassHierarchy appInfo() {
        return this.appView.appInfo();
    }

    private EnqueuerUseRegistryFactory createUseRegistryFactory() {
        if (this.mode.isFinalTreeShaking()) {
            return this.appView.withGeneratedMessageLiteShrinker(ignore -> ProtoEnqueuerUseRegistry.getFactory(), DefaultEnqueuerUseRegistry::new);
        }
        return DefaultEnqueuerUseRegistry::new;
    }

    private void recordCompilerSynthesizedTypeReference(DexType type) {
        DexClass clazz = this.appInfo().definitionFor(type);
        if (clazz == null) {
            this.ignoreMissingClass(type);
        } else if (clazz.isNotProgramClass()) {
            this.addLiveNonProgramType(clazz.asClasspathOrLibraryClass(), true, this::ignoreMissingClasspathOrLibraryClass);
        }
    }

    private void recordTypeReference(DexType type, ProgramDefinition context) {
        this.recordTypeReference(type, context, this::recordNonProgramClass, this::reportMissingClass);
    }

    private void recordTypeReference(DexType type, ProgramDerivedContext context) {
        this.recordTypeReference(type, context, this::recordNonProgramClass, this::reportMissingClass);
    }

    private void recordTypeReference(DexType type, ProgramDerivedContext context, BiConsumer<DexClass, ProgramDerivedContext> foundClassConsumer, BiConsumer<DexType, ProgramDerivedContext> missingClassConsumer) {
        if (type == null) {
            return;
        }
        if (type.isArrayType()) {
            type = type.toBaseType(this.appView.dexItemFactory());
        }
        if (!type.isClassType()) {
            return;
        }
        this.definitionFor(type, context, foundClassConsumer, missingClassConsumer);
    }

    private void recordMethodReference(DexMethod method, ProgramDerivedContext context) {
        this.recordMethodReference(method, context, this::recordNonProgramClass, this::reportMissingClass);
    }

    private void recordMethodReference(DexMethod method, ProgramDerivedContext context, BiConsumer<DexClass, ProgramDerivedContext> foundClassConsumer, BiConsumer<DexType, ProgramDerivedContext> missingClassConsumer) {
        this.recordTypeReference(method.holder, context, foundClassConsumer, missingClassConsumer);
        this.recordTypeReference(method.proto.returnType, context, foundClassConsumer, missingClassConsumer);
        for (DexType type : method.proto.parameters.values) {
            this.recordTypeReference(type, context, foundClassConsumer, missingClassConsumer);
        }
    }

    private void recordFieldReference(DexField field, ProgramDerivedContext context) {
        this.recordTypeReference(field.getHolderType(), context);
        this.recordTypeReference(field.getType(), context);
    }

    private DexClass definitionFor(DexType type, ProgramDerivedContext context, BiConsumer<DexClass, ProgramDerivedContext> foundClassConsumer, BiConsumer<DexType, ProgramDerivedContext> missingClassConsumer) {
        return this.internalDefinitionFor(type, context, foundClassConsumer, missingClassConsumer);
    }

    private DexClass internalDefinitionFor(DexType type, ProgramDerivedContext context, BiConsumer<DexClass, ProgramDerivedContext> foundClassConsumer, BiConsumer<DexType, ProgramDerivedContext> missingClassConsumer) {
        DexClass clazz = this.appInfo().definitionFor(type);
        if (clazz == null) {
            missingClassConsumer.accept(type, context);
            return null;
        }
        foundClassConsumer.accept(clazz, context);
        return clazz;
    }

    private void addLiveNonProgramType(ClasspathOrLibraryClass clazz, boolean markProgramSuperTypesAsLiveAndVisitMemberReferences, BiConsumer<DexType, ClasspathOrLibraryDefinition> missingClassConsumer) {
        WorkList<ClasspathOrLibraryClass> worklist = WorkList.newIdentityWorkList(clazz, this.liveNonProgramTypes);
        while (worklist.hasNext()) {
            ClasspathOrLibraryClass definition = worklist.next();
            this.processNewLiveNonProgramType(definition, worklist, missingClassConsumer, markProgramSuperTypesAsLiveAndVisitMemberReferences);
        }
    }

    private void processNewLiveNonProgramType(ClasspathOrLibraryClass clazz, WorkList<ClasspathOrLibraryClass> worklist, BiConsumer<DexType, ClasspathOrLibraryDefinition> missingClassConsumer, boolean markProgramSuperTypesAsLiveAndVisitMemberReferences) {
        this.ensureMethodsContinueToWidenAccess(clazz);
        if (markProgramSuperTypesAsLiveAndVisitMemberReferences) {
            if (clazz.isLibraryClass()) {
                this.handleLibraryTypeInheritingFromProgramType(clazz.asLibraryClass());
            }
            clazz.forEachClassField(field -> this.addNonProgramClassToWorklist(field.getType(), field.asClasspathOrLibraryDefinition(), this.referencedNonProgramTypes::add, missingClassConsumer));
            clazz.forEachClassMethod(method -> {
                ClasspathOrLibraryDefinition derivedContext = method.asClasspathOrLibraryDefinition();
                this.addNonProgramClassToWorklist(method.getReturnType(), derivedContext, this.referencedNonProgramTypes::add, missingClassConsumer);
                for (DexType parameter : method.getParameters()) {
                    this.addNonProgramClassToWorklist(parameter, derivedContext, this.referencedNonProgramTypes::add, missingClassConsumer);
                }
            });
        }
        for (DexType supertype : clazz.allImmediateSupertypes()) {
            this.addNonProgramClassToWorklist(supertype, clazz.asClasspathOrLibraryDefinition(), worklist::addIfNotSeen, missingClassConsumer);
        }
    }

    private void addNonProgramClassToWorklist(DexType type, ClasspathOrLibraryDefinition context, Consumer<ClasspathOrLibraryClass> classAdder, BiConsumer<DexType, ClasspathOrLibraryDefinition> missingClassConsumer) {
        if (type.isArrayType()) {
            type = type.toBaseType(this.appView.dexItemFactory());
        }
        if (!type.isClassType()) {
            return;
        }
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz == null) {
            missingClassConsumer.accept(type, context);
        } else if (!clazz.isProgramClass()) {
            classAdder.accept(clazz.asClasspathOrLibraryClass());
        }
    }

    private DexProgramClass getProgramClassOrNull(DexType type, ProgramDefinition context) {
        DexClass clazz = this.definitionFor(type, context);
        return clazz != null && clazz.isProgramClass() ? clazz.asProgramClass() : null;
    }

    private DexProgramClass getProgramHolderOrNull(DexMember<?, ?> member, ProgramDefinition context) {
        return this.getProgramClassOrNull(member.getHolderType(), context);
    }

    private DexClass getClassOrNullFromReflectiveAccess(DexType type, ProgramDefinition context) {
        return this.definitionFor(type, context, this::recordNonProgramClassWithNoMissingReporting, this::ignoreMissingClass);
    }

    private DexProgramClass getProgramClassOrNullFromReflectiveAccess(DexType type, ProgramDefinition context) {
        return DexProgramClass.asProgramClassOrNull(this.getClassOrNullFromReflectiveAccess(type, context));
    }

    private void handleLibraryTypeInheritingFromProgramType(DexLibraryClass clazz) {
        if (clazz.superType != null) {
            this.ensureFromLibraryOrThrow(clazz.superType, clazz);
        }
        for (DexType iface : clazz.interfaces.values) {
            this.ensureFromLibraryOrThrow(iface, clazz);
        }
    }

    private void warnIfClassExtendsInterfaceOrImplementsClass(DexProgramClass clazz) {
        DexClass superClass;
        if (clazz.superType != null && (superClass = this.definitionFor(clazz.superType, (ProgramDefinition)clazz)) != null && superClass.isInterface()) {
            this.options.reporter.warning(new StringDiagnostic("Class " + clazz.toSourceString() + " extends " + superClass.toSourceString() + " which is an interface"));
        }
        for (DexType iface : clazz.interfaces.values) {
            DexClass ifaceClass = this.definitionFor(iface, (ProgramDefinition)clazz);
            if (ifaceClass == null || ifaceClass.isInterface()) continue;
            this.options.reporter.warning(new StringDiagnostic("Class " + clazz.toSourceString() + " implements " + ifaceClass.toSourceString() + " which is not an interface"));
        }
    }

    private void enqueueAllIfNotShrinking() {
        if (this.appView.options().isShrinking()) {
            return;
        }
        KeepClassInfo.Joiner keepClassInfo = (KeepClassInfo.Joiner)KeepClassInfo.newEmptyJoiner().disallowShrinking();
        KeepFieldInfo.Joiner keepFieldInfo = (KeepFieldInfo.Joiner)KeepFieldInfo.newEmptyJoiner().disallowShrinking();
        KeepMethodInfo.Joiner keepMethodInfo = (KeepMethodInfo.Joiner)KeepMethodInfo.newEmptyJoiner().disallowShrinking();
        EnqueuerEvent.UnconditionalKeepInfoEvent preconditionEvent = EnqueuerEvent.UnconditionalKeepInfoEvent.get();
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            if (this.appView.getSyntheticItems().isSyntheticClass(clazz) && !this.appView.getSyntheticItems().isSubjectToKeepRules(clazz)) continue;
            this.enqueueClassDueToNoShrinkingRule(clazz, keepClassInfo, preconditionEvent);
            clazz.forEachProgramField(field -> this.enqueueFieldDueToNoShrinkingRule((ProgramField)field, keepFieldInfo, preconditionEvent));
            clazz.forEachProgramMethod(method -> this.enqueueMethodDueToNoShrinkingRule((ProgramMethod)method, keepMethodInfo, preconditionEvent));
        }
    }

    private void enqueueClassDueToNoShrinkingRule(DexProgramClass clazz, KeepClassInfo.Joiner minimumKeepInfo, EnqueuerEvent preconditionEvent) {
        assert (minimumKeepInfo.verifyShrinkingDisallowedWithRule(this.options));
        DexDefinition precondition = preconditionEvent.getDefinition(this.appInfo());
        this.enqueueKeepRuleInstantiatedType(clazz, minimumKeepInfo.getRules(), precondition);
    }

    private void enqueueKeepRuleInstantiatedType(DexProgramClass clazz, Set<ProguardKeepRuleBase> rules, DexDefinition precondition) {
        GraphReporter.KeepReasonWitness witness = this.graphReporter.reportKeepClass(precondition, rules, clazz);
        if (clazz.isAnnotation()) {
            this.workList.enqueueMarkAnnotationInstantiatedAction(clazz, witness);
        } else if (clazz.isInterface()) {
            this.workList.enqueueMarkInterfaceInstantiatedAction(clazz, witness);
        } else {
            this.workList.enqueueMarkInstantiatedAction(clazz, null, InstantiationReason.KEEP_RULE, witness);
            if (clazz.hasDefaultInitializer()) {
                ProgramMethod defaultInitializer = clazz.getProgramDefaultInitializer();
                if (this.forceProguardCompatibility) {
                    this.workList.enqueueMarkMethodKeptAction(defaultInitializer, this.graphReporter.reportCompatKeepDefaultInitializer(defaultInitializer));
                }
                if (clazz.isExternalizable(this.appView)) {
                    this.workList.enqueueMarkMethodLiveAction(defaultInitializer, defaultInitializer, witness);
                    this.applyMinimumKeepInfoWhenLiveOrTargeted(defaultInitializer, (KeepMethodInfo.Joiner)KeepMethodInfo.newEmptyJoiner().disallowOptimization());
                }
            }
        }
    }

    private void enqueueFieldDueToNoShrinkingRule(ProgramField field, KeepFieldInfo.Joiner minimumKeepInfo, EnqueuerEvent preconditionEvent) {
        assert (minimumKeepInfo.verifyShrinkingDisallowedWithRule(this.options));
        DexDefinition precondition = preconditionEvent.getDefinition(this.appInfo());
        this.workList.enqueueMarkFieldKeptAction(field, this.graphReporter.reportKeepField(precondition, minimumKeepInfo.getRules(), (DexEncodedField)field.getDefinition()));
    }

    private void enqueueMethodDueToNoShrinkingRule(ProgramMethod method, KeepMethodInfo.Joiner minimumKeepInfo, EnqueuerEvent preconditionEvent) {
        assert (minimumKeepInfo.verifyShrinkingDisallowedWithRule(this.options));
        DexDefinition precondition = preconditionEvent.getDefinition(this.appInfo());
        this.workList.enqueueMarkMethodKeptAction(method, this.graphReporter.reportKeepMethod(precondition, minimumKeepInfo.getRules(), (DexEncodedMethod)method.getDefinition()));
    }

    private void enqueueFirstNonSerializableClassInitializer(DexProgramClass clazz, KeepReason reason) {
        assert (clazz.isSerializable(this.appView));
        while (clazz.isSerializable(this.appView)) {
            DexProgramClass superClass = this.getProgramClassOrNull(clazz.superType, clazz);
            if (superClass == null) {
                return;
            }
            clazz = superClass;
        }
        if (clazz.hasDefaultInitializer()) {
            this.workList.enqueueMarkMethodLiveAction(clazz.getProgramDefaultInitializer(), clazz, reason);
            this.applyMinimumKeepInfoWhenLiveOrTargeted(clazz.getProgramDefaultInitializer(), (KeepMethodInfo.Joiner)KeepMethodInfo.newEmptyJoiner().disallowOptimization());
        }
    }

    private void compatEnqueueHolderIfDependentNonStaticMember(DexProgramClass holder, Set<ProguardKeepRuleBase> compatRules) {
        if (!this.forceProguardCompatibility || compatRules == null) {
            return;
        }
        this.enqueueKeepRuleInstantiatedType(holder, compatRules, null);
    }

    private boolean registerMethodWithTargetAndContext(BiPredicate<DexMethod, ProgramMethod> registration, DexMethod method, ProgramMethod context) {
        DexType baseHolder = method.holder.toBaseType(this.appView.dexItemFactory());
        if (baseHolder.isClassType()) {
            this.markTypeAsLive(baseHolder, (ProgramDefinition)context);
            return registration.test(method, context);
        }
        return false;
    }

    private boolean registerFieldAccess(DexField field, ProgramMethod context, boolean isRead, boolean isReflective) {
        FieldAccessInfoImpl info = this.fieldAccessInfoCollection.get(field);
        if (info == null) {
            DexEncodedField encodedField = this.resolveField(field, context).getResolvedField();
            if (encodedField == null) {
                this.fieldAccessInfoCollection.extend(field, FieldAccessInfoImpl.MISSING_FIELD_ACCESS_INFO);
                return true;
            }
            info = this.fieldAccessInfoCollection.get((DexField)encodedField.getReference());
            if (info == null) {
                info = new FieldAccessInfoImpl((DexField)encodedField.getReference());
                this.fieldAccessInfoCollection.extend((DexField)encodedField.getReference(), info);
            }
            if (field != encodedField.getReference()) {
                this.fieldAccessInfoCollection.extend(field, info);
            }
        } else if (info == FieldAccessInfoImpl.MISSING_FIELD_ACCESS_INFO) {
            return false;
        }
        if (isReflective) {
            info.setHasReflectiveAccess();
        }
        return isRead ? info.recordRead(field, context) : info.recordWrite(field, context);
    }

    private void disableClosedWorldReasoning(DexMethod reference, ProgramMethod context) {
        MethodResolutionResult.SingleResolutionResult resolutionResult = this.resolveMethod(reference, context, KeepReason.methodHandleReferencedIn(context));
        if (resolutionResult != null && resolutionResult.getResolvedHolder().isProgramClass()) {
            this.applyMinimumKeepInfoWhenLiveOrTargeted(resolutionResult.getResolvedProgramMethod(), KeepMethodInfo.newEmptyJoiner().disallowClosedWorldReasoning());
        }
    }

    private void handleLockCandidate(DexType type, ProgramMethod currentMethod, ListIterator<? extends CfOrDexInstruction> iterator2) {
        DexProgramClass baseClass;
        DexType baseType = type.toBaseType(this.appView.dexItemFactory());
        if (baseType.isClassType() && (baseClass = this.getProgramClassOrNull(baseType, currentMethod)) != null && this.isConstClassMaybeUsedAsLock(currentMethod, iterator2)) {
            this.lockCandidates.add(baseType);
        }
    }

    private boolean isConstClassMaybeUsedAsLock(ProgramMethod currentMethod, ListIterator<? extends CfOrDexInstruction> iterator2) {
        if (iterator2 == null) {
            return true;
        }
        boolean result = true;
        if (((DexEncodedMethod)currentMethod.getDefinition()).getCode().isCfCode()) {
            CfInvoke invoke;
            DexMethod invokedMethod;
            DexItemFactory.ClassMethods classMethods;
            CfInstruction nextInstruction = IteratorUtils.nextUntil(iterator2, instruction -> !instruction.asCfInstruction().isLabel() && !instruction.asCfInstruction().isPosition()).asCfInstruction();
            assert (nextInstruction != null);
            if (nextInstruction.isInvoke() && ((classMethods = this.appView.dexItemFactory().classMethods).isReflectiveNameLookup(invokedMethod = (invoke = nextInstruction.asInvoke()).getMethod()) || invokedMethod == classMethods.desiredAssertionStatus || invokedMethod == classMethods.getClassLoader || invokedMethod == classMethods.getPackage)) {
                result = false;
            }
            iterator2.previous();
        }
        return result;
    }

    private void internalTraceConstClassOrCheckCast(DexType type, ProgramMethod currentMethod, boolean ignoreCompatRules) {
        DexProgramClass baseClass;
        this.traceTypeReference(type, currentMethod);
        if (!this.forceProguardCompatibility || ignoreCompatRules) {
            return;
        }
        DexType baseType = type.toBaseType(this.appView.dexItemFactory());
        if (baseType.isClassType() && (baseClass = this.getProgramClassOrNull(baseType, currentMethod)) != null) {
            this.markClassAsInstantiatedWithCompatRule(baseClass, () -> this.graphReporter.reportCompatInstantiated(baseClass, currentMethod));
        }
    }

    private Visibility computeMinimumRequiredVisibilityForInitClassField(DexType clazz, DexProgramClass context) {
        if (clazz.isSamePackage(context.type)) {
            return Visibility.PACKAGE_PRIVATE;
        }
        if (this.appInfo.isStrictSubtypeOf(context.type, clazz)) {
            return Visibility.PROTECTED;
        }
        return Visibility.PUBLIC;
    }

    private boolean registerDeferredActionForDeadProtoBuilder(DexType type, ProgramMethod currentMethod, Action action) {
        DexProgramClass clazz = this.getProgramClassOrNull(type, currentMethod);
        if (clazz != null) {
            return this.appView.withGeneratedMessageLiteBuilderShrinker(shrinker -> shrinker.deferDeadProtoBuilders(clazz, currentMethod, () -> this.liveTypes.registerDeferredAction(clazz, action)), false);
        }
        return false;
    }

    private void traceInvokeDirect(DexMethod invokedMethod, ProgramMethod context, KeepReason reason) {
        if (!this.registerMethodWithTargetAndContext(this.methodAccessInfoCollection::registerInvokeDirectInContext, invokedMethod, context)) {
            return;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register invokeDirect `%s`.", invokedMethod);
        }
        this.handleInvokeOfDirectTarget(invokedMethod, context, reason);
        this.invokeAnalyses.forEach(analysis -> analysis.traceInvokeDirect(invokedMethod, context));
    }

    private void traceInvokeInterface(DexMethod method, ProgramMethod context, KeepReason keepReason) {
        if (!this.registerMethodWithTargetAndContext(this.methodAccessInfoCollection::registerInvokeInterfaceInContext, method, context)) {
            return;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register invokeInterface `%s`.", method);
        }
        this.markVirtualMethodAsReachable(method, true, context, keepReason);
        this.invokeAnalyses.forEach(analysis -> analysis.traceInvokeInterface(method, context));
    }

    private void traceInvokeStatic(DexMethod invokedMethod, ProgramMethod context, KeepReason reason) {
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        if (dexItemFactory.classMethods.isReflectiveClassLookup(invokedMethod) || dexItemFactory.atomicFieldUpdaterMethods.isFieldUpdater(invokedMethod)) {
            this.identifierNameStrings.add(invokedMethod);
            this.pendingReflectiveUses.add(context);
        }
        if (invokedMethod == dexItemFactory.enumMembers.valueOf) {
            this.pendingReflectiveUses.add(context);
        }
        if (dexItemFactory.serviceLoaderMethods.isLoadMethod(invokedMethod)) {
            this.pendingReflectiveUses.add(context);
        }
        if (invokedMethod == dexItemFactory.proxyMethods.newProxyInstance) {
            this.pendingReflectiveUses.add(context);
        }
        if (!this.registerMethodWithTargetAndContext(this.methodAccessInfoCollection::registerInvokeStaticInContext, invokedMethod, context)) {
            return;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register invokeStatic `%s`.", invokedMethod);
        }
        this.handleInvokeOfStaticTarget(invokedMethod, context, reason);
        this.invokeAnalyses.forEach(analysis -> analysis.traceInvokeStatic(invokedMethod, context));
    }

    private void traceInvokeVirtual(DexMethod invokedMethod, ProgramMethod context, KeepReason reason) {
        if (invokedMethod == this.appView.dexItemFactory().classMethods.newInstance || invokedMethod == this.appView.dexItemFactory().constructorMethods.newInstance) {
            this.pendingReflectiveUses.add(context);
        } else if (this.appView.dexItemFactory().classMethods.isReflectiveMemberLookup(invokedMethod)) {
            this.identifierNameStrings.add(invokedMethod);
            this.pendingReflectiveUses.add(context);
        }
        if (!this.registerMethodWithTargetAndContext(this.methodAccessInfoCollection::registerInvokeVirtualInContext, invokedMethod, context)) {
            return;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register invokeVirtual `%s`.", invokedMethod);
        }
        this.markVirtualMethodAsReachable(invokedMethod, false, context, reason);
        this.invokeAnalyses.forEach(analysis -> analysis.traceInvokeVirtual(invokedMethod, context));
    }

    private void traceNewInstance(DexType type, ProgramMethod context, InstantiationReason instantiationReason, KeepReason keepReason) {
        DexProgramClass clazz = this.getProgramClassOrNull(type, context);
        if (clazz != null) {
            if (clazz.isAnnotation() || clazz.isInterface()) {
                this.markTypeAsLive(clazz, this.graphReporter.registerClass(clazz, keepReason));
            } else {
                this.workList.enqueueMarkInstantiatedAction(clazz, context, instantiationReason, keepReason);
            }
        }
    }

    private void traceInstanceFieldRead(DexField fieldReference, ProgramMethod currentMethod, FieldAccessMetadata metadata) {
        if (!this.registerFieldRead(fieldReference, currentMethod)) {
            return;
        }
        FieldResolutionResult resolutionResult = this.resolveField(fieldReference, currentMethod);
        if (this.deferredTracing.deferTracingOfFieldAccess(fieldReference, resolutionResult, currentMethod, FieldAccessKind.INSTANCE_READ, metadata)) {
            return;
        }
        resolutionResult.visitFieldResolutionResults(singleResolutionResult -> {
            this.fieldAccessAnalyses.forEach(analysis -> analysis.traceInstanceFieldRead(fieldReference, (FieldResolutionResult)singleResolutionResult, currentMethod, this.workList));
            ProgramField field = singleResolutionResult.getProgramField();
            if (field == null) {
                return;
            }
            assert (!this.mode.isFinalTreeShaking() || !((DexEncodedField)field.getDefinition()).getOptimizationInfo().isDead()) : "Unexpected reference in `" + currentMethod.toSourceString() + "` to field marked dead: " + ((DexField)field.getReference()).toSourceString();
            if (metadata.isFromMethodHandle()) {
                this.fieldAccessInfoCollection.get((DexField)field.getReference()).setReadFromMethodHandle();
            } else if (metadata.isFromRecordMethodHandle()) {
                this.fieldAccessInfoCollection.get((DexField)field.getReference()).setReadFromRecordInvokeDynamic();
            }
            if (Log.ENABLED) {
                Log.verbose(this.getClass(), "Register Iget `%s`.", fieldReference);
            }
            if (field.getReference() != fieldReference) {
                this.markTypeAsLive(singleResolutionResult.getInitialResolutionHolder(), (ProgramDefinition)currentMethod);
            }
            this.workList.enqueueMarkFieldAsReachableAction(field, currentMethod, KeepReason.fieldReferencedIn(currentMethod));
        }, failedResolution -> {
            this.traceFieldReference(fieldReference, (FieldResolutionResult.FailedOrUnknownFieldResolutionResult)failedResolution, currentMethod);
            this.noClassMerging.add(fieldReference.getHolderType());
        });
    }

    private void traceInstanceFieldWrite(DexField fieldReference, ProgramMethod currentMethod, FieldAccessMetadata metadata) {
        if (!this.registerFieldWrite(fieldReference, currentMethod)) {
            return;
        }
        FieldResolutionResult resolutionResult = this.resolveField(fieldReference, currentMethod);
        if (this.deferredTracing.deferTracingOfFieldAccess(fieldReference, resolutionResult, currentMethod, FieldAccessKind.INSTANCE_WRITE, metadata)) {
            return;
        }
        resolutionResult.visitFieldResolutionResults(singleResolutionResult -> {
            this.fieldAccessAnalyses.forEach(analysis -> analysis.traceInstanceFieldWrite(fieldReference, (FieldResolutionResult)singleResolutionResult, currentMethod, this.workList));
            ProgramField field = singleResolutionResult.getProgramField();
            if (field == null) {
                return;
            }
            assert (!this.mode.isFinalTreeShaking() || !((DexEncodedField)field.getDefinition()).getOptimizationInfo().isDead()) : "Unexpected reference in `" + currentMethod.toSourceString() + "` to field marked dead: " + ((DexField)field.getReference()).toSourceString();
            if (metadata.isFromMethodHandle()) {
                this.fieldAccessInfoCollection.get((DexField)field.getReference()).setWrittenFromMethodHandle();
            }
            if (Log.ENABLED) {
                Log.verbose(this.getClass(), "Register Iput `%s`.", fieldReference);
            }
            if (field.getReference() != fieldReference) {
                this.markTypeAsLive(singleResolutionResult.getInitialResolutionHolder(), (ProgramDefinition)currentMethod);
            }
            KeepReason reason = KeepReason.fieldReferencedIn(currentMethod);
            this.workList.enqueueMarkFieldAsReachableAction(field, currentMethod, reason);
        }, failedResolution -> {
            this.traceFieldReference(fieldReference, (FieldResolutionResult.FailedOrUnknownFieldResolutionResult)failedResolution, currentMethod);
            this.noClassMerging.add(fieldReference.getHolderType());
        });
    }

    private void traceStaticFieldRead(DexField fieldReference, ProgramMethod currentMethod, FieldAccessMetadata metadata) {
        if (!this.registerFieldRead(fieldReference, currentMethod)) {
            return;
        }
        FieldResolutionResult resolutionResult = this.resolveField(fieldReference, currentMethod);
        if (this.deferredTracing.deferTracingOfFieldAccess(fieldReference, resolutionResult, currentMethod, FieldAccessKind.STATIC_READ, metadata)) {
            return;
        }
        resolutionResult.visitFieldResolutionResults(singleResolutionResult -> {
            boolean skipTracing;
            this.fieldAccessAnalyses.forEach(analysis -> analysis.traceStaticFieldRead(fieldReference, (FieldResolutionResult)singleResolutionResult, currentMethod, this.workList));
            ProgramField field = singleResolutionResult.getProgramField();
            if (field == null) {
                return;
            }
            assert (!this.mode.isFinalTreeShaking() || !((DexEncodedField)field.getDefinition()).getOptimizationInfo().isDead()) : "Unexpected reference in `" + currentMethod.toSourceString() + "` to field marked dead: " + ((DexField)field.getReference()).toSourceString();
            if (metadata.isFromMethodHandle()) {
                this.fieldAccessInfoCollection.get((DexField)field.getReference()).setReadFromMethodHandle();
            }
            if (Log.ENABLED) {
                Log.verbose(this.getClass(), "Register Sget `%s`.", fieldReference);
            }
            if (skipTracing = this.appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.isDeadProtoExtensionField(field, this.fieldAccessInfoCollection, this.keepInfo), false).booleanValue()) {
                this.addDeadProtoTypeCandidate(field.getHolder());
                return;
            }
            if (field.getReference() != fieldReference) {
                this.markTypeAsLive(singleResolutionResult.getInitialResolutionHolder(), (ProgramDefinition)currentMethod);
            }
            this.markFieldAsLive(field, currentMethod);
        }, failedResolution -> {
            this.traceFieldReference(fieldReference, (FieldResolutionResult.FailedOrUnknownFieldResolutionResult)failedResolution, currentMethod);
            this.noClassMerging.add(fieldReference.getHolderType());
            this.appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.handleFailedOrUnknownFieldResolution(fieldReference, currentMethod, this.mode));
        });
    }

    private void traceStaticFieldWrite(DexField fieldReference, ProgramMethod currentMethod, FieldAccessMetadata metadata) {
        if (!this.registerFieldWrite(fieldReference, currentMethod)) {
            return;
        }
        FieldResolutionResult resolutionResult = this.resolveField(fieldReference, currentMethod);
        if (this.deferredTracing.deferTracingOfFieldAccess(fieldReference, resolutionResult, currentMethod, FieldAccessKind.STATIC_WRITE, metadata)) {
            return;
        }
        resolutionResult.visitFieldResolutionResults(singleResolutionResult -> {
            boolean skipTracing;
            this.fieldAccessAnalyses.forEach(analysis -> analysis.traceStaticFieldWrite(fieldReference, (FieldResolutionResult)singleResolutionResult, currentMethod, this.workList));
            ProgramField field = singleResolutionResult.getProgramField();
            if (field == null) {
                return;
            }
            assert (!this.mode.isFinalTreeShaking() || !((DexEncodedField)field.getDefinition()).getOptimizationInfo().isDead()) : "Unexpected reference in `" + currentMethod.toSourceString() + "` to field marked dead: " + ((DexField)field.getReference()).toSourceString();
            if (metadata.isFromMethodHandle()) {
                this.fieldAccessInfoCollection.get((DexField)field.getReference()).setWrittenFromMethodHandle();
            }
            if (Log.ENABLED) {
                Log.verbose(this.getClass(), "Register Sput `%s`.", fieldReference);
            }
            if (this.appView.options().protoShrinking().enableGeneratedExtensionRegistryShrinking && (skipTracing = this.appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.isDeadProtoExtensionField(field, this.fieldAccessInfoCollection, this.keepInfo), false).booleanValue())) {
                this.addDeadProtoTypeCandidate(field.getHolder());
                return;
            }
            if (field.getReference() != fieldReference) {
                this.markTypeAsLive(singleResolutionResult.getInitialResolutionHolder(), (ProgramDefinition)currentMethod);
            }
            this.markFieldAsLive(field, currentMethod);
        }, failedResolution -> {
            this.traceFieldReference(fieldReference, (FieldResolutionResult.FailedOrUnknownFieldResolutionResult)failedResolution, currentMethod);
            this.noClassMerging.add(fieldReference.getHolderType());
        });
    }

    private DexMethod getInvokeSuperTarget(DexMethod method, ProgramMethod currentMethod) {
        DexClass methodHolderClass = this.appView.definitionFor(method.holder);
        if (methodHolderClass != null && methodHolderClass.isInterface()) {
            return method;
        }
        DexProgramClass holderClass = currentMethod.getHolder();
        if (holderClass.superType == null || holderClass.isInterface()) {
            return method;
        }
        return this.appView.dexItemFactory().createMethod(holderClass.superType, method.proto, method.name);
    }

    private boolean verifyMethodIsTargeted(ProgramMethod method) {
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        assert (!definition.isClassInitializer()) : "Class initializers are never targeted";
        assert (this.targetedMethods.contains(definition));
        return true;
    }

    private boolean verifyTypeIsLive(DexProgramClass clazz) {
        assert (this.liveTypes.contains(clazz));
        return true;
    }

    private void markTypeAsLive(DexType type, ProgramDefinition context) {
        if (type.isArrayType()) {
            this.markTypeAsLive(type.toBaseType(this.appView.dexItemFactory()), context);
            return;
        }
        if (!type.isClassType()) {
            return;
        }
        DexProgramClass clazz = this.getProgramClassOrNull(type, context);
        if (clazz == null) {
            return;
        }
        this.markTypeAsLive(clazz, context);
    }

    private void markTypeAsLive(DexType type, ProgramDefinition context, KeepReason reason) {
        if (type.isArrayType()) {
            this.markTypeAsLive(type.toBaseType(this.appView.dexItemFactory()), context, reason);
            return;
        }
        if (!type.isClassType()) {
            return;
        }
        DexProgramClass clazz = this.getProgramClassOrNull(type, context);
        if (clazz == null) {
            return;
        }
        this.markTypeAsLive(clazz, reason);
    }

    private void markTypeAsLive(DexClass clazz, ProgramDefinition context) {
        if (clazz.isProgramClass()) {
            DexProgramClass programClass = clazz.asProgramClass();
            this.markTypeAsLive(programClass, this.graphReporter.reportClassReferencedFrom(programClass, context));
        }
    }

    private void markTypeAsLive(DexProgramClass clazz, ProgramDefinition context) {
        this.markTypeAsLive(clazz, this.graphReporter.reportClassReferencedFrom(clazz, context));
    }

    private void markTypeAsLive(DexProgramClass clazz, KeepReason reason) {
        assert (clazz != null);
        this.markTypeAsLive(clazz, this.scopedMethodsForLiveTypes.computeIfAbsent(clazz.getType(), ignore -> new ScopedDexMethodSet()), this.graphReporter.registerClass(clazz, reason));
    }

    private void markTypeAsLive(DexProgramClass clazz, ScopedDexMethodSet seen, GraphReporter.KeepReasonWitness witness) {
        if (!this.liveTypes.add(clazz, witness)) {
            return;
        }
        assert (!this.mode.isFinalMainDexTracing() || !this.options.testing.checkForNotExpandingMainDexTracingResult || this.appView.appInfo().getMainDexInfo().isTracedRoot(clazz, this.appView.getSyntheticItems())) : "Class " + clazz.toSourceString() + " was not a main dex root in the first round";
        assert (!this.appView.unboxedEnums().isUnboxedEnum(clazz));
        BiConsumer<DexType, ProgramDerivedContext> missingClassConsumer = this.options.reportMissingClassesInInnerClassAttributes ? this::reportMissingClass : this::ignoreMissingClass;
        for (InnerClassAttribute innerClassAttribute : clazz.getInnerClasses()) {
            this.recordTypeReference(innerClassAttribute.getInner(), clazz, this::recordNonProgramClass, missingClassConsumer);
            this.recordTypeReference(innerClassAttribute.getOuter(), clazz, this::recordNonProgramClass, missingClassConsumer);
        }
        if (clazz.isNestHost()) {
            for (NestMemberClassAttribute nestMemberClassAttribute : clazz.getNestMembersClassAttributes()) {
                this.recordTypeReference(nestMemberClassAttribute.getNestMember(), clazz);
            }
        } else {
            this.recordTypeReference(clazz.getNestHost(), clazz);
        }
        EnclosingMethodAttribute enclosingMethodAttribute = clazz.getEnclosingMethodAttribute();
        if (enclosingMethodAttribute != null) {
            Object missingClassConsumer2;
            DexMethod enclosingMethod = enclosingMethodAttribute.getEnclosingMethod();
            Object object = missingClassConsumer2 = this.options.reportMissingClassesInEnclosingMethodAttribute ? this::reportMissingClass : this::ignoreMissingClass;
            if (enclosingMethod != null) {
                this.recordMethodReference(enclosingMethod, clazz, this::recordNonProgramClass, (BiConsumer<DexType, ProgramDerivedContext>)missingClassConsumer2);
            } else {
                DexType enclosingClass = enclosingMethodAttribute.getEnclosingClass();
                this.recordTypeReference(enclosingClass, clazz, this::recordNonProgramClass, (BiConsumer<DexType, ProgramDerivedContext>)missingClassConsumer2);
            }
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Type `%s` has become live.", clazz.type);
        }
        KeepReason reason = KeepReason.reachableFromLiveType(clazz.type);
        for (DexType iface : clazz.getInterfaces()) {
            this.markInterfaceTypeAsLiveViaInheritanceClause(iface, clazz);
        }
        if (clazz.superType != null) {
            ScopedDexMethodSet seenForSuper = this.scopedMethodsForLiveTypes.computeIfAbsent(clazz.superType, ignore -> new ScopedDexMethodSet());
            seen.setParent(seenForSuper);
            this.markTypeAsLive(clazz.superType, (ProgramDefinition)clazz);
        }
        this.warnIfClassExtendsInterfaceOrImplementsClass(clazz);
        this.transitionUnusedInterfaceToLive(clazz);
        this.ensureMethodsContinueToWidenAccess(clazz, seen, reason);
        if (clazz.isSerializable(this.appView)) {
            this.enqueueFirstNonSerializableClassInitializer(clazz, reason);
        }
        this.applyMinimumKeepInfo(clazz);
        this.applyMinimumKeepInfoDependentOn(new EnqueuerEvent.LiveClassEnqueuerEvent(clazz));
        this.processAnnotations(clazz);
        if (clazz.isAnnotation()) {
            this.processDeferredAnnotations(clazz, this.deferredAnnotations, DexAnnotation.AnnotatedKind::from);
            this.processDeferredAnnotations(clazz, this.deferredParameterAnnotations, annotatedItem -> DexAnnotation.AnnotatedKind.PARAMETER);
        }
        this.compatEnqueueHolderIfDependentNonStaticMember(clazz, this.rootSet.getDependentKeepClassCompatRule(clazz.getType()));
        this.analyses.forEach(analysis -> analysis.processNewlyLiveClass(clazz, this.workList));
    }

    private void processDeferredAnnotations(DexProgramClass clazz, Map<DexType, Map<DexAnnotation, List<ProgramDefinition>>> deferredAnnotations, Function<ProgramDefinition, DexAnnotation.AnnotatedKind> kindProvider) {
        Map<DexAnnotation, List<ProgramDefinition>> annotations = deferredAnnotations.remove(clazz.getType());
        if (annotations != null) {
            assert (annotations.keySet().stream().allMatch(annotation -> annotation.getAnnotationType() == clazz.getType()));
            annotations.forEach((annotation, annotatedItems) -> annotatedItems.forEach(annotatedItem -> this.processAnnotation((ProgramDefinition)annotatedItem, (DexAnnotation)annotation, (DexAnnotation.AnnotatedKind)((Object)((Object)((Object)kindProvider.apply((ProgramDefinition)annotatedItem)))))));
        }
    }

    private void ensureMethodsContinueToWidenAccess(ClassDefinition clazz) {
        assert (!clazz.isProgramClass());
        ScopedDexMethodSet seen = this.scopedMethodsForLiveTypes.computeIfAbsent(clazz.getType(), ignore -> new ScopedDexMethodSet());
        clazz.getMethodCollection().forEachVirtualMethod(seen::addMethodIfMoreVisible);
    }

    private void ensureMethodsContinueToWidenAccess(DexProgramClass clazz, ScopedDexMethodSet seen, KeepReason reason) {
        clazz.forEachProgramVirtualMethodMatching(definition -> seen.addMethodIfMoreVisible((DexEncodedMethod)definition) == ScopedDexMethodSet.AddMethodIfMoreVisibleResult.ADDED_MORE_VISIBLE && this.appView.appInfo().methodDefinedInInterfaces((DexEncodedMethod)definition, clazz.type), method -> this.markMethodAsTargeted((ProgramMethod)method, reason));
    }

    private void markInterfaceTypeAsLiveViaInheritanceClause(DexType type, DexProgramClass implementer) {
        DexProgramClass clazz = this.getProgramClassOrNull(type, implementer);
        if (clazz == null) {
            return;
        }
        if (!this.appView.options().enableUnusedInterfaceRemoval || this.rootSet.noUnusedInterfaceRemoval.contains(type) || this.mode.isMainDexTracing()) {
            this.markTypeAsLive(clazz, (ProgramDefinition)implementer);
            return;
        }
        if (this.liveTypes.contains(clazz)) {
            this.graphReporter.reportClassReferencedFrom(clazz, implementer);
            return;
        }
        WorkList<DexProgramClass> worklist = WorkList.newIdentityWorkList();
        worklist.addIfNotSeen(clazz);
        while (worklist.hasNext()) {
            Set implementors;
            DexProgramClass current = (DexProgramClass)worklist.next();
            if (this.liveTypes.contains(current) || !(implementors = this.unusedInterfaceTypes.computeIfAbsent(current, ignore -> Sets.newIdentityHashSet())).add(implementer)) continue;
            for (DexType iface : current.getInterfaces()) {
                DexProgramClass definition = this.getProgramClassOrNull(iface, current);
                if (definition == null) continue;
                if (definition.isPublic() || implementer.getType().isSamePackage(definition.getType())) {
                    worklist.addIfNotSeen(definition);
                    continue;
                }
                this.markTypeAsLive(current, (ProgramDefinition)implementer);
            }
        }
    }

    private void enqueueHolderWithDependentInstanceConstructor(ProgramMethod instanceInitializer, Set<ProguardKeepRuleBase> reasons) {
        DexProgramClass holder = instanceInitializer.getHolder();
        this.enqueueKeepRuleInstantiatedType(holder, reasons, instanceInitializer.getDefinition());
    }

    private void processAnnotations(ProgramDefinition annotatedItem) {
        this.processAnnotations(annotatedItem, annotatedItem.getDefinition().annotations(), DexAnnotation.AnnotatedKind.from(annotatedItem));
    }

    private void processAnnotations(ProgramDefinition annotatedItem, DexAnnotationSet annotations, DexAnnotation.AnnotatedKind kind) {
        this.processAnnotations(annotatedItem, annotations.annotations, kind);
    }

    private void processAnnotations(ProgramDefinition annotatedItem, DexAnnotation[] annotations, DexAnnotation.AnnotatedKind kind) {
        for (DexAnnotation annotation : annotations) {
            this.processAnnotation(annotatedItem, annotation, kind);
        }
    }

    private boolean shouldKeepAnnotation(ProgramDefinition annotatedItem, DexAnnotation annotation, DexAnnotation.AnnotatedKind annotatedKind, boolean isLive) {
        if (this.annotationRemoverBuilder != null && this.annotationRemoverBuilder.isRetainedForFinalTreeShaking(annotation)) {
            assert (this.mode.isInitialTreeShaking());
            return true;
        }
        return AnnotationRemover.shouldKeepAnnotation(this.appView, annotatedItem, annotation, isLive, annotatedKind);
    }

    private FieldResolutionResult resolveField(DexField field, ProgramDefinition context) {
        FieldResolutionResult fieldResolutionResult = this.appInfo.resolveField(field);
        fieldResolutionResult.visitFieldResolutionResults(resolutionResult -> this.recordFieldReference(field, resolutionResult.getResolutionPair().asProgramDerivedContext(context)), failedResolution -> {
            this.failedFieldResolutionTargets.add(field);
            this.recordFieldReference(field, context);
        });
        return fieldResolutionResult;
    }

    private MethodResolutionResult.SingleResolutionResult resolveMethod(DexMethod method, ProgramDefinition context, KeepReason reason) {
        MethodResolutionResult resolutionResult = this.appInfo.unsafeResolveMethodDueToDexFormat(method);
        if (resolutionResult.isFailedResolution()) {
            this.markFailedMethodResolutionTargets(method, resolutionResult.asFailedResolution(), context, reason);
            this.recordMethodReference(method, context, this::recordFoundClass, this::reportMissingClass);
        } else {
            this.recordMethodReference(method, context);
        }
        return resolutionResult.asSingleResolution();
    }

    private MethodResolutionResult.SingleResolutionResult resolveMethod(DexMethod method, ProgramDefinition context, KeepReason reason, boolean interfaceInvoke) {
        MethodResolutionResult resolutionResult = this.appInfo.resolveMethod(method, interfaceInvoke);
        if (resolutionResult.isSingleResolution()) {
            this.recordMethodReference(method, resolutionResult.getResolutionPair().asProgramDerivedContext(context));
        } else {
            assert (resolutionResult.isFailedResolution());
            this.markFailedMethodResolutionTargets(method, resolutionResult.asFailedResolution(), context, reason);
            this.recordMethodReference(method, context, this::recordFoundClass, this::reportMissingClass);
        }
        return resolutionResult.asSingleResolution();
    }

    private void handleInvokeOfStaticTarget(DexMethod reference, ProgramDefinition context, KeepReason reason) {
        MethodResolutionResult.SingleResolutionResult resolution = this.resolveMethod(reference, context, reason);
        if (resolution == null || resolution.getResolvedHolder().isNotProgramClass()) {
            return;
        }
        DexProgramClass clazz = resolution.getResolvedHolder().asProgramClass();
        DexEncodedMethod encodedMethod = resolution.getResolvedMethod();
        ProgramMethod method = new ProgramMethod(clazz, encodedMethod);
        this.markMethodAsTargeted(method, reason);
        if (encodedMethod.isStatic()) {
            this.markDirectAndIndirectClassInitializersAsLive(clazz);
            this.markDirectStaticOrConstructorMethodAsLive(method, reason);
        }
    }

    private void markDirectAndIndirectClassInitializersAsLive(DexProgramClass clazz) {
        if (clazz.isInterface()) {
            this.markInterfaceInitializedDirectly(clazz);
            return;
        }
        WorkList<DexProgramClass> worklist = WorkList.newIdentityWorkList(clazz);
        while (worklist.hasNext()) {
            DexProgramClass current = worklist.next();
            if (current.isInterface() ? !this.markInterfaceInitializedIndirectly(current) : !this.markDirectClassInitializerAsLive(current)) continue;
            for (DexType superType : current.allImmediateSupertypes()) {
                DexProgramClass superClass = this.getProgramClassOrNull(superType, current);
                if (superClass == null) continue;
                worklist.addIfNotSeen(superClass);
            }
        }
    }

    private boolean markDirectClassInitializerAsLive(DexProgramClass clazz) {
        ProgramMethod clinit = clazz.getProgramClassInitializer();
        GraphReporter.KeepReasonWitness witness = this.graphReporter.reportReachableClassInitializer(clazz, clinit);
        if (!this.initializedClasses.add(clazz, witness)) {
            return false;
        }
        if (clinit != null && ((DexEncodedMethod)clinit.getDefinition()).getOptimizationInfo().mayHaveSideEffects()) {
            this.markDirectStaticOrConstructorMethodAsLive(clinit, witness);
        }
        return true;
    }

    private void markInterfaceInitializedDirectly(DexProgramClass clazz) {
        ProgramMethod clinit = clazz.getProgramClassInitializer();
        GraphReporter.KeepReasonWitness witness = this.graphReporter.reportReachableClassInitializer(clazz, clinit);
        if (!this.directlyInitializedInterfaces.add(clazz, witness)) {
            return;
        }
        if (clinit == null || !((DexEncodedMethod)clinit.getDefinition()).getOptimizationInfo().mayHaveSideEffects()) {
            return;
        }
        if (this.indirectlyInitializedInterfaces.contains(clazz) && clazz.getMethodCollection().hasVirtualMethods(DexEncodedMethod::isDefaultMethod)) {
            assert (this.liveMethods.contains(clinit));
            return;
        }
        this.markDirectStaticOrConstructorMethodAsLive(clinit, witness);
    }

    private boolean markInterfaceInitializedIndirectly(DexProgramClass clazz) {
        ProgramMethod clinit = clazz.getProgramClassInitializer();
        GraphReporter.KeepReasonWitness witness = this.graphReporter.reportReachableClassInitializer(clazz, clinit);
        if (!this.indirectlyInitializedInterfaces.add(clazz, witness)) {
            return false;
        }
        if (clinit == null || !((DexEncodedMethod)clinit.getDefinition()).getOptimizationInfo().mayHaveSideEffects() || !clazz.getMethodCollection().hasVirtualMethods(DexEncodedMethod::isDefaultMethod)) {
            return true;
        }
        if (this.directlyInitializedInterfaces.contains(clazz)) {
            assert (this.liveMethods.contains(clinit));
            return true;
        }
        this.markDirectStaticOrConstructorMethodAsLive(clinit, witness);
        return true;
    }

    private void handleInvokeOfDirectTarget(DexMethod reference, ProgramDefinition context, KeepReason reason) {
        DexType holder = reference.holder;
        DexProgramClass clazz = this.getProgramClassOrNull(holder, context);
        if (clazz == null) {
            this.recordMethodReference(reference, context);
            return;
        }
        DexEncodedMethod encodedMethod = clazz.lookupMethod(reference);
        if (encodedMethod == null) {
            this.failedMethodResolutionTargets.add(reference);
            return;
        }
        ProgramMethod method = new ProgramMethod(clazz, encodedMethod);
        this.markMethodAsTargeted(method, reason);
        if (encodedMethod.isStatic()) {
            return;
        }
        this.markDirectStaticOrConstructorMethodAsLive(method, reason);
        if (encodedMethod.isNonPrivateVirtualMethod() && this.virtualMethodsTargetedByInvokeDirect.add((DexMethod)encodedMethod.getReference())) {
            this.workList.enqueueMarkMethodLiveAction(method, context, reason);
        }
    }

    private void ensureFromLibraryOrThrow(DexType type, DexLibraryClass context) {
        if (this.mode.isMainDexTracing()) {
            return;
        }
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appInfo().definitionFor(type));
        if (clazz == null) {
            return;
        }
        if (this.forceProguardCompatibility) {
            KeepReason keepReason = KeepReason.reachableFromLiveType(context.type);
            this.keepClassAndAllMembers(clazz, keepReason);
            this.appInfo.forEachSuperType(clazz, (superType, subclass, ignored) -> {
                DexProgramClass superClass = DexProgramClass.asProgramClassOrNull(this.appInfo().definitionFor((DexType)superType));
                if (superClass != null) {
                    this.keepClassAndAllMembers(superClass, keepReason);
                }
            });
        }
        if (this.appView.getDontWarnConfiguration().matches(context)) {
            return;
        }
        if (this.mode.isInitialTreeShaking()) {
            StringDiagnostic message = new StringDiagnostic("Library class " + context.type.toSourceString() + (clazz.isInterface() ? " implements " : " extends ") + "program class " + type.toSourceString());
            if (this.forceProguardCompatibility) {
                this.options.reporter.warning(message);
            } else {
                this.options.reporter.error(message);
            }
        }
    }

    private void shouldNotBeMinified(ProgramDefinition definition) {
        if (this.options.isMinificationEnabled()) {
            this.rootSet.shouldNotBeMinified(definition);
        }
    }

    private void keepClassAndAllMembers(DexProgramClass clazz, KeepReason keepReason) {
        GraphReporter.KeepReasonWitness keepReasonWitness = this.graphReporter.registerClass(clazz, keepReason);
        this.markClassAsInstantiatedWithCompatRule(clazz.asProgramClass(), () -> keepReasonWitness);
        this.keepInfo.keepClass(clazz);
        this.shouldNotBeMinified(clazz);
        clazz.forEachProgramField(field -> {
            this.keepInfo.keepField((ProgramField)field);
            this.shouldNotBeMinified((ProgramDefinition)field);
            this.markFieldAsKept((ProgramField)field, keepReasonWitness);
        });
        clazz.forEachProgramMethod(method -> {
            this.keepInfo.keepMethod((ProgramMethod)method);
            this.shouldNotBeMinified((ProgramDefinition)method);
            this.markMethodAsKept((ProgramMethod)method, keepReasonWitness);
        });
    }

    private void recordFoundClass(DexClass clazz, ProgramDerivedContext context) {
        if (clazz.isProgramClass()) {
            if (context.isProgramContext()) {
                this.markTypeAsLive(clazz, context.getContext().asProgramDefinition());
            }
        } else {
            this.recordNonProgramClass(clazz, context);
        }
    }

    private void recordNonProgramClass(DexClass clazz, ProgramDerivedContext context) {
        if (!clazz.isProgramClass()) {
            this.addLiveNonProgramType(clazz.asClasspathOrLibraryClass(), true, (missingType, derivedContext) -> this.reportMissingClass((DexType)missingType, derivedContext.asProgramDerivedContext(context)));
        }
    }

    private void recordNonProgramClassWithNoMissingReporting(DexClass clazz, ProgramDerivedContext context) {
        if (!clazz.isProgramClass()) {
            this.addLiveNonProgramType(clazz.asClasspathOrLibraryClass(), true, this::ignoreMissingClasspathOrLibraryClass);
        }
    }

    private void ignoreMissingClass(DexType clazz) {
        this.missingClassesBuilder.ignoreNewMissingClass(clazz);
    }

    private void ignoreMissingClass(DexType clazz, ProgramDerivedContext context) {
        this.ignoreMissingClass(clazz);
    }

    private void ignoreMissingClasspathOrLibraryClass(DexType clazz) {
        this.ignoreMissingClass(clazz);
    }

    private void ignoreMissingClasspathOrLibraryClass(DexType clazz, ClasspathOrLibraryDefinition context) {
        this.ignoreMissingClasspathOrLibraryClass(clazz);
    }

    private void reportMissingClass(DexType clazz, ProgramDerivedContext context) {
        assert (!this.mode.isFinalTreeShaking() || this.missingClassesBuilder.wasAlreadyMissing(clazz) || this.appView.dexItemFactory().isPossiblyCompilerSynthesizedType(clazz) || this.initialDeadProtoTypes.contains(clazz) || this.initialPrunedTypes != null && this.initialPrunedTypes.contains(clazz)) : "Unexpected missing class `" + clazz.toSourceString() + "`";
        if (context.isProgramContext() && context.getContext().isMethod() && ((DexEncodedMethod)context.getContext().asMethod().getDefinition()).isD8R8Synthesized() && !this.appView.getSyntheticItems().isSyntheticClass(context.getContext().asProgramDefinition().getContextClass())) {
            this.missingClassesBuilder.ignoreNewMissingClass(clazz);
        } else {
            this.missingClassesBuilder.addNewMissingClass(clazz, context);
        }
    }

    private boolean markInstantiatedClass(DexProgramClass clazz, ProgramMethod context, InstantiationReason instantiationReason, KeepReason keepReason) {
        assert (!clazz.isInterface());
        return this.objectAllocationInfoCollection.recordDirectAllocationSite(clazz, context, instantiationReason, keepReason, this.appInfo);
    }

    private void markLambdaAsInstantiated(LambdaDescriptor descriptor, ProgramMethod context) {
        for (DexType iface : descriptor.interfaces) {
            this.checkLambdaInterface(iface, context);
            this.objectAllocationInfoCollection.recordInstantiatedLambdaInterface(iface, descriptor, this.appInfo);
        }
    }

    private void checkLambdaInterface(DexType itf, ProgramMethod context) {
        DexClass clazz = this.definitionFor(itf, (ProgramDefinition)context);
        if (clazz == null) {
            if (!this.appView.getDontWarnConfiguration().matches(itf)) {
                StringDiagnostic message = new StringDiagnostic("Lambda expression implements missing interface `" + itf.toSourceString() + "`", context.getOrigin());
                this.options.reporter.warning(message);
            }
        } else if (!clazz.isInterface() && !this.appView.getDontWarnConfiguration().matches(itf)) {
            StringDiagnostic message = new StringDiagnostic("Lambda expression expected to implement an interface, but found `" + itf.toSourceString() + "`", context.getOrigin());
            this.options.reporter.warning(message);
        }
    }

    private void transitionMethodsForInstantiatedLambda(LambdaDescriptor lambda) {
        this.transitionMethodsForInstantiatedObject(InstantiatedObject.of(lambda), this.appInfo.dexItemFactory().objectType, lambda.interfaces);
    }

    private void transitionMethodsForInstantiatedClass(DexProgramClass clazz) {
        assert (!clazz.isAnnotation());
        assert (!clazz.isInterface());
        this.transitionMethodsForInstantiatedObject(InstantiatedObject.of(clazz), clazz.type, Collections.emptyList());
    }

    private void transitionMethodsForInstantiatedObject(InstantiatedObject instantiation, DexType type, List<DexType> interfaces) {
        WorkList<DexType> worklist = WorkList.newIdentityWorkList(type);
        worklist.addIfNotSeen(interfaces);
        while (worklist.hasNext()) {
            DexClass clazz = this.appInfo().definitionFor(worklist.next());
            if (clazz == null) continue;
            if (clazz.isProgramClass()) {
                this.markProgramMethodOverridesAsLive(instantiation, clazz.asProgramClass());
            } else {
                this.markLibraryAndClasspathMethodOverridesAsLive(instantiation, clazz);
            }
            if (clazz.superType != null) {
                worklist.addIfNotSeen(clazz.superType);
            }
            worklist.addIfNotSeen(clazz.interfaces);
        }
    }

    private Map<ResolutionSearchKey, ProgramMethodSet> getReachableVirtualTargets(DexProgramClass clazz) {
        return this.reachableVirtualTargets.getOrDefault(clazz, Collections.emptyMap());
    }

    private void markProgramMethodOverridesAsLive(InstantiatedObject instantiation, DexProgramClass currentClass) {
        assert (instantiation.isLambda() || this.appInfo.isSubtype(instantiation.asClass().getType(), currentClass.type));
        this.getReachableVirtualTargets(currentClass).forEach((resolutionSearchKey, contexts) -> {
            MethodResolutionResult.SingleResolutionResult singleResolution = this.appInfo.resolveMethod(((ResolutionSearchKey)resolutionSearchKey).method, ((ResolutionSearchKey)resolutionSearchKey).isInterface).asSingleResolution();
            if (singleResolution == null) {
                assert (false) : "Should not be null";
                return;
            }
            IdentityHashMap<DexProgramClass, List> contextsByClass = new IdentityHashMap<DexProgramClass, List>();
            for (ProgramMethod context : contexts) {
                ((List)contextsByClass.computeIfAbsent(context.getHolder(), MapUtils.ignoreKey(ArrayList::new))).add(context);
            }
            contextsByClass.forEach((contextHolder, contextsInHolder) -> {
                LookupResult lookupResult = singleResolution.lookupVirtualDispatchTargets((DexProgramClass)contextHolder, this.appInfo, (type, subTypeConsumer, lambdaConsumer) -> {
                    assert (this.appInfo.isSubtype(currentClass.type, type));
                    instantiation.apply(subTypeConsumer, lambdaConsumer);
                }, definition -> this.keepInfo.isPinned(definition.getReference(), (DexDefinitionSupplier)this.appInfo, (GlobalKeepInfoConfiguration)this.options));
                lookupResult.forEach(target -> this.markVirtualDispatchTargetAsLive((LookupTarget)target, (ProgramMethod programMethod) -> this.graphReporter.reportReachableMethodAsLive((DexMethod)singleResolution.getResolvedMethod().getReference(), (ProgramMethod)programMethod)));
                lookupResult.forEachFailureDependency(method -> {
                    DexProgramClass clazz = this.getProgramClassOrNull(method.getHolderType(), (ProgramDefinition)contextHolder);
                    if (clazz != null) {
                        this.failedMethodResolutionTargets.add((DexMethod)method.getReference());
                        for (ProgramMethod context : contextsInHolder) {
                            this.markMethodAsTargeted(new ProgramMethod(clazz, (DexEncodedMethod)method), KeepReason.invokedFrom(context));
                        }
                    }
                });
            });
        });
    }

    private void markLibraryAndClasspathMethodOverridesAsLive(InstantiatedObject instantiation, DexClass libraryClass) {
        assert (libraryClass.isNotProgramClass());
        if (this.mode.isMainDexTracing()) {
            return;
        }
        for (DexEncodedMethod method : libraryClass.virtualMethods()) {
            assert (!method.isPrivateMethod());
            this.markLibraryOrClasspathOverrideLive(instantiation, libraryClass, this.appInfo.resolveMethodOn(libraryClass, (DexMethod)method.getReference()));
            if (!instantiation.isClass() || !this.appView.typeRewriter.hasRewrittenTypeInSignature(((DexMethod)method.getReference()).proto, this.appView)) continue;
            DexMethod methodToResolve = DesugaredLibraryAPIConverter.methodWithVivifiedTypeInSignature((DexMethod)method.getReference(), method.getHolderType(), this.appView);
            assert (methodToResolve != method.getReference());
            this.markLibraryOrClasspathOverrideLive(instantiation, libraryClass, this.appInfo.resolveMethodOn((DexClass)instantiation.asClass(), methodToResolve));
        }
    }

    private void markLibraryOrClasspathOverrideLive(InstantiatedObject instantiation, DexClass libraryOrClasspathClass, MethodResolutionResult resolution) {
        LookupTarget lookup = resolution.lookupVirtualDispatchTarget(instantiation, this.appInfo);
        if (lookup == null) {
            return;
        }
        if (!this.shouldMarkLibraryMethodOverrideAsReachable(lookup)) {
            return;
        }
        this.markVirtualDispatchTargetAsLive(lookup, (ProgramMethod method) -> this.graphReporter.reportLibraryMethodAsLive(instantiation, (ProgramMethod)method, libraryOrClasspathClass));
        if (instantiation.isClass()) {
            this.markOverridesAsLibraryMethodOverrides(instantiation.asClass(), (DexMethod)((DexEncodedMethod)lookup.asMethodTarget().getDefinition()).getReference());
        }
    }

    private void markOverridesAsLibraryMethodOverrides(DexProgramClass instantiatedClass, DexMethod libraryMethodOverride) {
        WorkList<DexProgramClass> worklist = WorkList.newIdentityWorkList();
        worklist.addIfNotSeen(instantiatedClass);
        while (worklist.hasNext()) {
            DexProgramClass clazz = (DexProgramClass)worklist.next();
            DexEncodedMethod override = clazz.lookupVirtualMethod(libraryMethodOverride);
            if (override != null) {
                if (override.isLibraryMethodOverride().isTrue()) continue;
                override.setLibraryMethodOverride(OptionalBool.TRUE);
            }
            clazz.forEachImmediateSupertype(superType -> {
                DexProgramClass superclass = this.getProgramClassOrNull((DexType)superType, clazz);
                if (superclass != null) {
                    worklist.addIfNotSeen(superclass);
                }
            });
        }
    }

    private void transitionFieldsForInstantiatedClass(DexProgramClass clazz) {
        do {
            ProgramFieldSet reachableFields;
            if ((reachableFields = this.reachableInstanceFields.get(clazz)) == null) continue;
            KeepReason reason = KeepReason.reachableFromLiveType(clazz.type);
            for (ProgramField field : reachableFields) {
                this.markFieldAsLive(field, clazz, reason);
            }
        } while ((clazz = this.getProgramClassOrNull(clazz.superType, clazz)) != null && !this.objectAllocationInfoCollection.isInstantiatedDirectly(clazz));
    }

    private void transitionDependentItemsForInstantiatedClass(DexProgramClass clazz) {
        assert (!clazz.isAnnotation());
        assert (!clazz.isInterface());
        this.transitionDependentItemsForInstantiatedItem(clazz);
    }

    private void transitionDependentItemsForInstantiatedInterface(DexProgramClass clazz) {
        assert (clazz.isInterface());
        this.transitionDependentItemsForInstantiatedItem(clazz);
    }

    private void transitionDependentItemsForInstantiatedItem(DexProgramClass clazz) {
        WorkList<DexProgramClass> interfacesToTransition = WorkList.newWorkList(this.interfacesTransitionedToInstantiated);
        if (clazz.getAccessFlags().isInterface()) {
            interfacesToTransition.addIfNotSeen(clazz);
        } else {
            do {
                this.applyMinimumKeepInfoDependentOn(new EnqueuerEvent.InstantiatedClassEnqueuerEvent(clazz));
                for (DexType interfaceType : clazz.getInterfaces()) {
                    DexProgramClass interfaceClass = DexProgramClass.asProgramClassOrNull(this.definitionFor(interfaceType, (ProgramDefinition)clazz));
                    if (interfaceClass == null) continue;
                    interfacesToTransition.addIfNotSeen(interfaceClass);
                }
                DexProgramClass dexProgramClass = clazz = clazz.superType != null ? DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(clazz.superType)) : null;
            } while (clazz != null && !this.objectAllocationInfoCollection.isInstantiatedDirectly(clazz));
        }
        while (interfacesToTransition.hasNext()) {
            DexProgramClass interfaceClass = interfacesToTransition.next();
            this.applyMinimumKeepInfoDependentOn(new EnqueuerEvent.InstantiatedClassEnqueuerEvent(interfaceClass));
            for (DexType indirectInterfaceType : interfaceClass.getInterfaces()) {
                DexProgramClass indirectInterfaceClass = DexProgramClass.asProgramClassOrNull(this.definitionFor(indirectInterfaceType, (ProgramDefinition)interfaceClass));
                if (indirectInterfaceClass == null) continue;
                interfacesToTransition.addIfNotSeen(indirectInterfaceClass);
            }
        }
    }

    private void transitionUnusedInterfaceToLive(DexProgramClass clazz) {
        if (clazz.isInterface()) {
            Set<DexProgramClass> implementedBy = this.unusedInterfaceTypes.remove(clazz);
            if (implementedBy != null) {
                for (DexProgramClass implementer : implementedBy) {
                    this.markTypeAsLive(clazz, (ProgramDefinition)implementer);
                }
            }
        } else assert (!this.unusedInterfaceTypes.containsKey(clazz));
    }

    private void markFieldAsLive(ProgramField field, ProgramMethod context) {
        this.markFieldAsLive(field, context, KeepReason.fieldReferencedIn(context));
    }

    private void markFieldAsLive(ProgramField field, ProgramDefinition context, KeepReason reason) {
        if (!this.liveFields.add(field, reason)) {
            return;
        }
        if (field.getAccessFlags().isStatic()) {
            this.traceFieldDefinition(field);
            this.markDirectAndIndirectClassInitializersAsLive(field.getHolder());
        } else if (!this.reachableInstanceFields.getOrDefault(field.getHolder(), ProgramFieldSet.empty()).contains(field)) {
            this.traceFieldDefinition(field);
        }
        this.applyMinimumKeepInfo(field);
        this.analyses.forEach(analysis -> analysis.processNewlyLiveField(field, context, this.workList));
    }

    private void traceFieldDefinition(ProgramField field) {
        this.markTypeAsLive(field.getHolder(), (ProgramDefinition)field);
        this.markTypeAsLive(field.getType(), (ProgramDefinition)field);
        this.processAnnotations(field);
    }

    private void traceFieldReference(DexField field, FieldResolutionResult.FailedOrUnknownFieldResolutionResult resolutionResult, ProgramMethod context) {
        this.markTypeAsLive(field.getHolderType(), (ProgramDefinition)context);
        this.markTypeAsLive(field.getType(), (ProgramDefinition)context);
    }

    private void markDirectStaticOrConstructorMethodAsLive(ProgramMethod method, KeepReason reason) {
        if (this.workList.enqueueMarkMethodLiveAction(method, method, reason)) {
            assert (this.workList.enqueueAssertAction(() -> {
                assert (((DexEncodedMethod)method.getDefinition()).isClassInitializer() || this.verifyMethodIsTargeted(method));
                assert (this.verifyTypeIsLive(method.getHolder()));
            }));
        } else {
            assert (((DexEncodedMethod)method.getDefinition()).isClassInitializer() || this.verifyMethodIsTargeted(method));
            assert (this.workList.enqueueAssertAction(() -> this.verifyTypeIsLive(method.getHolder())));
        }
    }

    private void markVirtualMethodAsLive(ProgramMethod method, KeepReason reason) {
        assert (!((DexEncodedMethod)method.getDefinition()).isAbstract() || reason.isDueToKeepRule() || reason.isDueToReflectiveUse());
        this.workList.enqueueMarkMethodLiveAction(method, method, reason);
    }

    private void markVirtualMethodAsReachable(DexMethod method, boolean interfaceInvoke, ProgramMethod context, KeepReason reason) {
        if (method.holder.isArrayType()) {
            this.markTypeAsLive(method.holder, context, reason);
            return;
        }
        MethodResolutionResult.SingleResolutionResult resolution = this.resolveMethod(method, context, reason, interfaceInvoke);
        if (resolution == null) {
            return;
        }
        DexProgramClass initialResolutionHolder = resolution.getInitialResolutionHolder().asProgramClass();
        if (initialResolutionHolder == null) {
            this.recordMethodReference(method, context);
            return;
        }
        if (resolution.getResolvedHolder().isNotProgramClass()) {
            return;
        }
        DexProgramClass contextHolder = context.getContextClass();
        ResolutionSearchKey resolutionSearchKey = new ResolutionSearchKey(method, interfaceInvoke);
        ProgramMethodSet seenContexts = this.getReachableVirtualTargets(initialResolutionHolder).get(resolutionSearchKey);
        if (seenContexts != null) {
            seenContexts.add(context);
            this.graphReporter.registerMethod(resolution.getResolvedMethod(), reason);
            return;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Marking virtual method `%s` as reachable.", method);
        }
        DexProgramClass resolvedHolder = resolution.getResolvedHolder().asProgramClass();
        DexEncodedMethod resolvedMethod = resolution.getResolvedMethod();
        this.markMethodAsTargeted(new ProgramMethod(resolvedHolder, resolvedMethod), reason);
        if (resolution.isAccessibleForVirtualDispatchFrom(contextHolder, this.appInfo).isFalse()) {
            return;
        }
        ((Map)this.reachableVirtualTargets.computeIfAbsent(initialResolutionHolder, FunctionUtils.ignoreArgument(HashMap::new))).computeIfAbsent(resolutionSearchKey, FunctionUtils.ignoreArgument(ProgramMethodSet::create)).add(context);
        resolution.lookupVirtualDispatchTargets(contextHolder, this.appInfo, (type, subTypeConsumer, lambdaConsumer) -> this.objectAllocationInfoCollection.forEachInstantiatedSubType(type, subTypeConsumer, lambdaConsumer, this.appInfo), definition -> this.keepInfo.isPinned(definition.getReference(), (DexDefinitionSupplier)this.appInfo, (GlobalKeepInfoConfiguration)this.options)).forEach(target -> this.markVirtualDispatchTargetAsLive((LookupTarget)target, (ProgramMethod programMethod) -> this.graphReporter.reportReachableMethodAsLive((DexMethod)resolvedMethod.getReference(), (ProgramMethod)programMethod)));
    }

    private void markVirtualDispatchTargetAsLive(LookupTarget target, Function<ProgramMethod, GraphReporter.KeepReasonWitness> reason) {
        target.accept(method -> this.markVirtualDispatchTargetAsLive((DexClassAndMethod)method, reason), lambda -> this.markVirtualDispatchTargetAsLive((LookupLambdaTarget)lambda, reason));
        this.analyses.forEach(analysis -> analysis.notifyMarkVirtualDispatchTargetAsLive(target, this.workList));
    }

    private void markVirtualDispatchTargetAsLive(DexClassAndMethod target, Function<ProgramMethod, GraphReporter.KeepReasonWitness> reason) {
        ProgramMethod programMethod = target.asProgramMethod();
        if (programMethod != null && !((DexEncodedMethod)programMethod.getDefinition()).isAbstract()) {
            this.markVirtualMethodAsLive(programMethod, reason.apply(programMethod));
        }
    }

    private void markVirtualDispatchTargetAsLive(LookupLambdaTarget target, Function<ProgramMethod, GraphReporter.KeepReasonWitness> reason) {
        ProgramMethod implementationMethod = target.getImplementationMethod().asProgramMethod();
        if (implementationMethod != null) {
            this.workList.enqueueMarkMethodLiveAction(implementationMethod, implementationMethod, reason.apply(implementationMethod));
        }
    }

    private void markFailedMethodResolutionTargets(DexMethod symbolicMethod, MethodResolutionResult.FailedResolutionResult failedResolution, ProgramDefinition context, KeepReason reason) {
        this.failedMethodResolutionTargets.add(symbolicMethod);
        failedResolution.forEachFailureDependency(method -> {
            DexProgramClass clazz = this.getProgramClassOrNull(method.getHolderType(), context);
            if (clazz != null) {
                this.failedMethodResolutionTargets.add((DexMethod)method.getReference());
                this.markMethodAsTargeted(new ProgramMethod(clazz, (DexEncodedMethod)method), reason);
            }
        });
    }

    private DexMethod generatedEnumValuesMethod(DexClass enumClass) {
        DexType arrayOfEnumClass = this.appView.dexItemFactory().createType(this.appView.dexItemFactory().createString("[" + enumClass.type.toDescriptorString()));
        DexProto proto = this.appView.dexItemFactory().createProto(arrayOfEnumClass, new DexType[0]);
        return this.appView.dexItemFactory().createMethod(enumClass.type, proto, this.appView.dexItemFactory().createString("values"));
    }

    private void markEnumValuesAsReachable(DexProgramClass clazz, KeepReason reason) {
        ProgramMethod valuesMethod = clazz.lookupProgramMethod(this.generatedEnumValuesMethod(clazz));
        if (valuesMethod != null) {
            this.workList.enqueueMarkMethodKeptAction(valuesMethod, reason);
            this.keepInfo.joinMethod(valuesMethod, joiner -> {
                KeepMethodInfo.Joiner cfr_ignored_0 = (KeepMethodInfo.Joiner)((KeepMethodInfo.Joiner)((KeepMethodInfo.Joiner)joiner.disallowMinification()).disallowOptimization()).disallowShrinking();
            });
            this.shouldNotBeMinified(valuesMethod);
        }
    }

    private void includeMinimumKeepInfo(RootSetUtils.RootSetBase rootSet) {
        rootSet.getDependentMinimumKeepInfo().forEach(this.appView, this::recordDependentMinimumKeepInfo, this::recordDependentMinimumKeepInfo, this::recordDependentMinimumKeepInfo);
    }

    private void applyMinimumKeepInfo(DexProgramClass clazz) {
        EnqueuerEvent.UnconditionalKeepInfoEvent preconditionEvent = EnqueuerEvent.UnconditionalKeepInfoEvent.get();
        KeepClassInfo.Joiner minimumKeepInfoForClass = this.dependentMinimumKeepInfo.remove((EnqueuerEvent)preconditionEvent, clazz.getType());
        if (minimumKeepInfoForClass != null) {
            this.keepInfo.joinClass(clazz, info -> info.merge(minimumKeepInfoForClass));
            this.enqueueClassIfShrinkingIsDisallowed(clazz, preconditionEvent, minimumKeepInfoForClass);
        }
    }

    private void applyMinimumKeepInfoWhenLive(DexProgramClass clazz, EnqueuerEvent preconditionEvent, KeepClassInfo.Joiner minimumKeepInfo) {
        if (this.liveTypes.contains(clazz)) {
            this.keepInfo.joinClass(clazz, info -> info.merge(minimumKeepInfo));
        } else {
            this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfo().mergeMinimumKeepInfoFor(clazz.getType(), minimumKeepInfo);
        }
        this.enqueueClassIfShrinkingIsDisallowed(clazz, preconditionEvent, minimumKeepInfo);
    }

    private void enqueueClassIfShrinkingIsDisallowed(DexProgramClass clazz, EnqueuerEvent preconditionEvent, KeepClassInfo.Joiner minimumKeepInfo) {
        if ((this.options.isShrinking() || this.mode.isMainDexTracing()) && !minimumKeepInfo.isShrinkingAllowed()) {
            assert (minimumKeepInfo.verifyShrinkingDisallowedWithRule(this.options));
            this.enqueueClassDueToNoShrinkingRule(clazz, minimumKeepInfo, preconditionEvent);
        }
    }

    private void recordDependentMinimumKeepInfo(EnqueuerEvent preconditionEvent, DexProgramClass clazz, KeepClassInfo.Joiner minimumKeepInfo) {
        if (this.isPreconditionForMinimumKeepInfoSatisfied(preconditionEvent)) {
            this.applyMinimumKeepInfoWhenLive(clazz, preconditionEvent, minimumKeepInfo);
        } else {
            this.dependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(preconditionEvent).mergeMinimumKeepInfoFor(clazz.getType(), minimumKeepInfo);
        }
        if (preconditionEvent.isUnconditionalKeepInfoEvent()) {
            this.enqueueClassIfShrinkingIsDisallowed(clazz, preconditionEvent, minimumKeepInfo);
        }
    }

    private void applyMinimumKeepInfo(ProgramField field) {
        EnqueuerEvent.UnconditionalKeepInfoEvent preconditionEvent = EnqueuerEvent.UnconditionalKeepInfoEvent.get();
        KeepFieldInfo.Joiner minimumKeepInfoForField = this.dependentMinimumKeepInfo.remove((EnqueuerEvent)preconditionEvent, (DexField)field.getReference());
        if (minimumKeepInfoForField != null) {
            this.keepInfo.joinField(field, info -> info.merge(minimumKeepInfoForField));
            this.enqueueFieldIfShrinkingIsDisallowed(field, preconditionEvent, minimumKeepInfoForField);
        }
    }

    private void applyMinimumKeepInfoWhenLive(ProgramField field, EnqueuerEvent preconditionEvent, KeepFieldInfo.Joiner minimumKeepInfo) {
        if (this.liveFields.contains(field)) {
            this.keepInfo.joinField(field, info -> info.merge(minimumKeepInfo));
        } else {
            this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfo().mergeMinimumKeepInfoFor(field.getReference(), minimumKeepInfo);
        }
        this.enqueueFieldIfShrinkingIsDisallowed(field, preconditionEvent, minimumKeepInfo);
    }

    private void enqueueFieldIfShrinkingIsDisallowed(ProgramField field, EnqueuerEvent preconditionEvent, KeepFieldInfo.Joiner minimumKeepInfo) {
        if ((this.options.isShrinking() || this.mode.isMainDexTracing()) && !minimumKeepInfo.isShrinkingAllowed()) {
            assert (minimumKeepInfo.verifyShrinkingDisallowedWithRule(this.options));
            this.enqueueFieldDueToNoShrinkingRule(field, minimumKeepInfo, preconditionEvent);
        }
    }

    private void recordDependentMinimumKeepInfo(EnqueuerEvent preconditionEvent, ProgramField field, KeepFieldInfo.Joiner minimumKeepInfo) {
        if (this.isPreconditionForMinimumKeepInfoSatisfied(preconditionEvent)) {
            this.applyMinimumKeepInfoWhenLive(field, preconditionEvent, minimumKeepInfo);
        } else {
            this.dependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(preconditionEvent).mergeMinimumKeepInfoFor(field.getReference(), minimumKeepInfo);
        }
        if (preconditionEvent.isUnconditionalKeepInfoEvent()) {
            this.enqueueFieldIfShrinkingIsDisallowed(field, preconditionEvent, minimumKeepInfo);
        }
    }

    private void applyMinimumKeepInfo(ProgramMethod method) {
        EnqueuerEvent.UnconditionalKeepInfoEvent preconditionEvent = EnqueuerEvent.UnconditionalKeepInfoEvent.get();
        KeepMethodInfo.Joiner minimumKeepInfoForMethod = this.dependentMinimumKeepInfo.remove((EnqueuerEvent)preconditionEvent, (DexMethod)method.getReference());
        if (minimumKeepInfoForMethod != null) {
            this.keepInfo.joinMethod(method, info -> info.merge(minimumKeepInfoForMethod));
            this.enqueueMethodIfShrinkingIsDisallowed(method, preconditionEvent, minimumKeepInfoForMethod);
        }
    }

    private void applyMinimumKeepInfoWhenLiveOrTargeted(ProgramMethod method, KeepMethodInfo.Joiner minimumKeepInfo, EnqueuerEvent preconditionEvent) {
        if (this.liveMethods.contains(method) || this.targetedMethods.contains(method)) {
            this.keepInfo.joinMethod(method, info -> info.merge(minimumKeepInfo));
        } else {
            this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfo().mergeMinimumKeepInfoFor(method.getReference(), minimumKeepInfo);
        }
        this.enqueueMethodIfShrinkingIsDisallowed(method, preconditionEvent, minimumKeepInfo);
    }

    private void enqueueMethodIfShrinkingIsDisallowed(ProgramMethod method, EnqueuerEvent preconditionEvent, KeepMethodInfo.Joiner minimumKeepInfo) {
        if ((this.options.isShrinking() || this.mode.isMainDexTracing()) && !minimumKeepInfo.isShrinkingAllowed()) {
            assert (minimumKeepInfo.verifyShrinkingDisallowedWithRule(this.options));
            this.enqueueMethodDueToNoShrinkingRule(method, minimumKeepInfo, preconditionEvent);
            if (((DexEncodedMethod)method.getDefinition()).isInstanceInitializer()) {
                this.enqueueHolderWithDependentInstanceConstructor(method, minimumKeepInfo.getRules());
            }
        }
    }

    private void recordDependentMinimumKeepInfo(EnqueuerEvent preconditionEvent, ProgramMethod method, KeepMethodInfo.Joiner minimumKeepInfo) {
        if (this.isPreconditionForMinimumKeepInfoSatisfied(preconditionEvent)) {
            this.applyMinimumKeepInfoWhenLiveOrTargeted(method, minimumKeepInfo, preconditionEvent);
        } else {
            this.dependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(preconditionEvent).mergeMinimumKeepInfoFor(method.getReference(), minimumKeepInfo);
        }
        if (preconditionEvent.isUnconditionalKeepInfoEvent()) {
            this.enqueueMethodIfShrinkingIsDisallowed(method, preconditionEvent, minimumKeepInfo);
        }
    }

    private void applyMinimumKeepInfoDependentOn(EnqueuerEvent preconditionEvent) {
        MinimumKeepInfoCollection minimumKeepClassInfoDependentOnPrecondition = this.dependentMinimumKeepInfo.remove(preconditionEvent);
        if (minimumKeepClassInfoDependentOnPrecondition != null) {
            minimumKeepClassInfoDependentOnPrecondition.forEach(this.appView, (clazz, minimumKeepInfoForClass) -> this.applyMinimumKeepInfoWhenLive((DexProgramClass)clazz, preconditionEvent, (KeepClassInfo.Joiner)minimumKeepInfoForClass), (field, minimumKeepInfoForField) -> this.applyMinimumKeepInfoWhenLive((ProgramField)field, preconditionEvent, (KeepFieldInfo.Joiner)minimumKeepInfoForField), (method, minimumKeepInfoForMethod) -> this.applyMinimumKeepInfoWhenLiveOrTargeted((ProgramMethod)method, (KeepMethodInfo.Joiner)minimumKeepInfoForMethod, preconditionEvent));
        }
    }

    private void synthesize() throws ExecutionException {
        if (!this.mode.isInitialTreeShaking()) {
            return;
        }
        SyntheticAdditions additions = new SyntheticAdditions(this.appView.createProcessorContext());
        this.desugar(additions);
        this.synthesizeInterfaceMethodBridges(additions);
        if (additions.isEmpty()) {
            return;
        }
        this.appInfo = this.appInfo.rebuildWithClassHierarchy(app -> app);
        this.appView.setAppInfo(this.appInfo);
        this.subtypingInfo = SubtypingInfo.create(this.appView);
        additions.enqueueWorkItems(this);
    }

    private boolean mustMoveToInterfaceCompanionMethod(ProgramMethod method) {
        return method.getHolder().isInterface() && ((DexEncodedMethod)method.getDefinition()).isNonAbstractNonNativeMethod() && !((DexEncodedMethod)method.getDefinition()).isInitializer();
    }

    private boolean addToPendingDesugaring(ProgramMethod method) {
        if (this.options.isInterfaceMethodDesugaringEnabled()) {
            if (this.mustMoveToInterfaceCompanionMethod(method)) {
                if (!InvalidCode.isInvalidCode(((DexEncodedMethod)method.getDefinition()).getCode())) {
                    this.pendingMethodMove.add(method);
                }
                return true;
            }
            ProgramMethod nonMovedMethod = (ProgramMethod)this.pendingMethodMoveInverse.get(method);
            if (nonMovedMethod != null) {
                assert (InvalidCode.isInvalidCode(((DexEncodedMethod)method.getDefinition()).getCode()));
                assert (!InvalidCode.isInvalidCode(((DexEncodedMethod)nonMovedMethod.getDefinition()).getCode()));
                this.pendingMethodMove.add(nonMovedMethod);
                return true;
            }
        }
        if (this.desugaring.needsDesugaring(method)) {
            this.pendingCodeDesugaring.add(method);
            return true;
        }
        return false;
    }

    private void desugar(SyntheticAdditions additions) throws ExecutionException {
        if (this.pendingCodeDesugaring.isEmpty() && this.pendingMethodMove.isEmpty()) {
            return;
        }
        this.pendingCodeDesugaring.forEach(additions::addMethodWithDesugaredCodeForTracing);
        for (ProgramMethod method2 : this.pendingMethodMove) {
            if (!this.desugaring.needsDesugaring(method2)) continue;
            this.pendingCodeDesugaring.add(method2);
        }
        CfInstructionDesugaringEventConsumer.R8CfInstructionDesugaringEventConsumer eventConsumer = CfInstructionDesugaringEventConsumer.createForR8(this.appView, this::recordLambdaSynthesizingContext, this::recordConstantDynamicSynthesizingContext, this::recordTwrCloseResourceMethodSynthesizingContext, additions, (method, companion) -> {
            if (!this.isMethodLive((ProgramMethod)method)) {
                this.pendingMethodMoveInverse.put(companion, (ProgramMethod)method);
            }
        });
        ProgramAdditions programAdditions = new ProgramAdditions();
        ThreadUtils.processItems(this.pendingCodeDesugaring, method -> this.desugaring.prepare((ProgramMethod)method, programAdditions), this.executorService);
        programAdditions.apply(this.executorService);
        ThreadUtils.processItems(this.pendingCodeDesugaring, method -> this.desugaring.desugar((ProgramMethod)method, additions.getMethodContext((ProgramMethod)method), eventConsumer), this.executorService);
        for (ProgramMethod method3 : this.pendingMethodMove) {
            ProgramMethod companion2 = this.interfaceProcessor.getHelper().ensureMethodOfProgramCompanionClassStub(method3, eventConsumer);
            this.interfaceProcessor.finalizeMoveToCompanionMethod(method3, companion2);
            this.pendingMethodMoveInverse.remove(companion2);
            if (!this.isMethodLive(companion2)) {
                additions.addLiveMethod(companion2);
            }
            additions.addMethodWithDesugaredCodeForTracing(companion2);
        }
        eventConsumer.finalizeDesugaring();
        this.pendingMethodMove.clear();
        this.pendingCodeDesugaring.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordLambdaSynthesizingContext(LambdaClass lambdaClass, ProgramMethod context) {
        Map<DexProgramClass, ProgramMethod> map = this.synthesizingContexts;
        synchronized (map) {
            this.synthesizingContexts.put(lambdaClass.getLambdaProgramClass(), context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordConstantDynamicSynthesizingContext(ConstantDynamicClass constantDynamicClass, ProgramMethod context) {
        Map<DexProgramClass, ProgramMethod> map = this.synthesizingContexts;
        synchronized (map) {
            this.synthesizingContexts.put(constantDynamicClass.getConstantDynamicProgramClass(), context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordTwrCloseResourceMethodSynthesizingContext(ProgramMethod closeMethod, ProgramMethod context) {
        Map<DexProgramClass, ProgramMethod> map = this.synthesizingContexts;
        synchronized (map) {
            this.synthesizingContexts.put(closeMethod.getHolder(), context);
        }
    }

    private void synthesizeInterfaceMethodBridges(SyntheticAdditions additions) {
        for (ProgramMethod bridge : this.syntheticInterfaceMethodBridges.values()) {
            DexProgramClass holder = bridge.getHolder();
            DexEncodedMethod method = (DexEncodedMethod)bridge.getDefinition();
            holder.addVirtualMethod(method);
        }
        this.syntheticInterfaceMethodBridges.clear();
    }

    private void finalizeLibraryMethodOverrideInformation() {
        for (DexProgramClass liveType : this.liveTypes.getItems()) {
            for (DexEncodedMethod method : liveType.virtualMethods()) {
                if (!method.isLibraryMethodOverride().isUnknown()) continue;
                method.setLibraryMethodOverride(OptionalBool.FALSE);
            }
        }
    }

    private boolean verifyKeptGraph() {
        if (this.appView.options().testing.verifyKeptGraphInfo) {
            for (DexProgramClass liveType : this.liveTypes.getItems()) {
                assert (this.graphReporter.verifyRootedPath(liveType));
            }
        }
        return true;
    }

    private EnqueuerResult createEnqueuerResult(AppInfoWithClassHierarchy appInfo) throws ExecutionException {
        this.deadProtoTypeCandidates.removeIf(this::isTypeLive);
        Set<DexType> deadProtoTypes = SetUtils.newIdentityHashSet(this.deadProtoTypeCandidates.size() + this.initialDeadProtoTypes.size());
        this.deadProtoTypeCandidates.forEach(deadProtoType -> deadProtoTypes.add(deadProtoType.type));
        deadProtoTypes.addAll(this.initialDeadProtoTypes);
        this.fieldAccessInfoCollection.removeIf((field, info) -> field != info.getField() || info == FieldAccessInfoImpl.MISSING_FIELD_ACCESS_INFO);
        assert (this.fieldAccessInfoCollection.verifyMappingIsOneToOne());
        assert (this.verifyReferences(appInfo.app()));
        this.rootSet.pruneDeadItems(this.appView, this);
        if (this.mode.isTreeShaking() && this.appView.hasMainDexRootSet()) {
            assert (this.rootSet != this.appView.getMainDexRootSet());
            this.appView.getMainDexRootSet().pruneDeadItems(this.appView, this);
        }
        this.appView.dexItemFactory().forEachPossiblyCompilerSynthesizedType(this::recordCompilerSynthesizedTypeReference);
        Set<DexLibraryClass> libraryClasses = Sets.newIdentityHashSet();
        Set<DexClasspathClass> classpathClasses = Sets.newIdentityHashSet();
        this.referencedNonProgramTypes.forEach(clazz -> this.addLiveNonProgramType((ClasspathOrLibraryClass)clazz, false, this::ignoreMissingClasspathOrLibraryClass));
        for (ClasspathOrLibraryClass clazz2 : this.liveNonProgramTypes) {
            if (clazz2.isLibraryClass()) {
                libraryClasses.add(clazz2.asLibraryClass());
                continue;
            }
            if (clazz2.isClasspathClass()) {
                classpathClasses.add(clazz2.asClasspathClass());
                continue;
            }
            assert (false);
        }
        DirectMappedDexApplication app = appInfo.app().asDirect().builder().replaceLibraryClasses(libraryClasses).replaceClasspathClasses(classpathClasses).build();
        assert (this.verifyReferences(app));
        SyntheticItems.SynthesizingContextOracle lambdaSynthesizingContextOracle = syntheticClass -> {
            ProgramMethod lambdaSynthesisContext = this.synthesizingContexts.get(syntheticClass);
            return lambdaSynthesisContext != null ? ImmutableSet.of(lambdaSynthesisContext.getReference()) : ImmutableSet.of(syntheticClass.getType());
        };
        this.amendKeepInfoWithCompanionMethods();
        this.deferredTracing.rewriteApplication(this.executorService);
        AppInfoWithLiveness appInfoWithLiveness = new AppInfoWithLiveness(appInfo.getSyntheticItems().commit(app), appInfo.getClassToFeatureSplitMap(), appInfo.getMainDexInfo(), deadProtoTypes, this.mode.isInitialTreeShaking() ? this.missingClassesBuilder.reportMissingClasses(this.appView, lambdaSynthesizingContextOracle) : this.missingClassesBuilder.assertNoMissingClasses(this.appView), SetUtils.mapIdentityHashSet(this.liveTypes.getItems(), DexClass::getType), Enqueuer.toDescriptorSet(this.targetedMethods.getItems()), this.failedMethodResolutionTargets, this.failedFieldResolutionTargets, this.bootstrapMethods, this.virtualMethodsTargetedByInvokeDirect, Enqueuer.toDescriptorSet(this.liveMethods.getItems()), this.fieldAccessInfoCollection, this.methodAccessInfoCollection.build(), this.objectAllocationInfoCollection.build(appInfo), this.callSites, this.keepInfo, this.rootSet.mayHaveSideEffects, this.rootSet.noSideEffects, this.rootSet.assumedValues, this.amendWithCompanionMethods(this.rootSet.alwaysInline), this.amendWithCompanionMethods(this.rootSet.neverInlineDueToSingleCaller), this.amendWithCompanionMethods(this.rootSet.whyAreYouNotInlining), this.amendWithCompanionMethods(this.rootSet.reprocess), this.amendWithCompanionMethods(this.rootSet.neverReprocess), this.rootSet.alwaysClassInline, this.rootSet.neverClassInline, this.noClassMerging, this.rootSet.noVerticalClassMerging, this.rootSet.noHorizontalClassMerging, this.rootSet.neverPropagateValue, Enqueuer.joinIdentifierNameStrings(this.rootSet.identifierNameStrings, this.identifierNameStrings), Collections.emptySet(), Collections.emptyMap(), this.lockCandidates, this.initClassReferences, this.recordFieldValuesReferences);
        appInfo.markObsolete();
        if (this.options.testing.enqueuerInspector != null) {
            this.options.testing.enqueuerInspector.accept(appInfoWithLiveness, this.mode);
        }
        return new EnqueuerResult(appInfoWithLiveness);
    }

    private void forEachCompanionMethod(BiConsumer<DexMethod, DexMethod> consumer) {
        if (this.interfaceProcessor != null) {
            this.interfaceProcessor.forEachMethodToMove(consumer);
        }
    }

    private void amendKeepInfoWithCompanionMethods() {
        this.forEachCompanionMethod((methodReference, companionReference) -> {
            ProgramMethod companion = this.appView.definitionFor((DexMethod)companionReference).asProgramMethod();
            KeepMethodInfo.Joiner minimumKeepInfoForCompanion = this.keepInfo.getMethodInfo((DexMethod)methodReference, this.appInfo).joiner();
            KeepMethodInfo.Joiner extraMinimumKeepInfoForCompanion = this.dependentMinimumKeepInfo.getUnconditionalMinimumKeepInfoOrDefault(MinimumKeepInfoCollection.empty()).getOrDefault((DexReference)methodReference, KeepMethodInfo.newEmptyJoiner()).asMethodJoiner();
            this.keepInfo.evaluateMethodRule(companion, minimumKeepInfoForCompanion.merge(extraMinimumKeepInfoForCompanion));
        });
    }

    private Set<DexMethod> amendWithCompanionMethods(Set<DexMethod> methods) {
        if (methods.isEmpty() || this.interfaceProcessor == null) {
            return methods;
        }
        Set companionMethods = Sets.newIdentityHashSet();
        this.interfaceProcessor.forEachMethodToMove((method, companion) -> {
            if (methods.contains(method)) {
                companionMethods.add(companion);
            }
        });
        methods.addAll(companionMethods);
        return methods;
    }

    private boolean verifyReferences(DexApplication app) {
        WorkList<DexClass> worklist = WorkList.newIdentityWorkList();
        for (DexProgramClass clazz : this.liveTypes.getItems()) {
            worklist.addIfNotSeen(clazz);
        }
        while (worklist.hasNext()) {
            DexClass clazz = (DexClass)worklist.next();
            assert (this.verifyReferencedType(clazz, worklist, app));
        }
        return true;
    }

    private boolean verifyReferencedType(DexType type, WorkList<DexClass> worklist, DexApplication app) {
        if (type.isArrayType()) {
            type = type.toBaseType(this.appView.dexItemFactory());
        }
        if (!type.isClassType()) {
            return true;
        }
        DexClass clazz = app.definitionFor(type);
        if (clazz == null) {
            assert (this.missingClassesBuilder.contains(type)) : "Expected type to be in missing types': " + type;
        } else {
            assert (!this.missingClassesBuilder.contains(type)) : "Type with definition also in missing types: " + type;
            assert (clazz.isProgramClass() || this.liveNonProgramTypes.contains(clazz)) : "Expected type to be in live non-program types: " + clazz;
            worklist.addIfNotSeen(clazz);
        }
        return true;
    }

    private boolean verifyReferencedType(DexClass clazz, WorkList<DexClass> worklist, DexApplication app) {
        for (DexType supertype : clazz.allImmediateSupertypes()) {
            assert (this.verifyReferencedType(supertype, worklist, app));
        }
        assert (clazz.isProgramClass() || this.liveNonProgramTypes.contains(clazz)) : "Expected type to be in live non-program types: " + clazz;
        if (clazz.isProgramClass()) {
            for (DexEncodedField field : clazz.fields()) {
                if (this.isFieldReferenced(field)) assert (this.verifyReferencedType(((DexField)field.getReference()).type, worklist, app));
            }
            for (DexEncodedMethod method : clazz.methods()) {
                if (this.isMethodTargeted(method)) assert (this.verifyReferencedMethod(method, worklist, app));
            }
        }
        return true;
    }

    private boolean verifyReferencedMethod(DexEncodedMethod method, WorkList<DexClass> worklist, DexApplication app) {
        assert (this.verifyReferencedType(((DexMethod)method.getReference()).proto.returnType, worklist, app));
        for (DexType param : ((DexMethod)method.getReference()).proto.parameters.values) {
            assert (this.verifyReferencedType(param, worklist, app));
        }
        return true;
    }

    private static <D extends DexEncodedMember<D, R>, R extends DexMember<D, R>> Set<R> toDescriptorSet(Set<D> set) {
        Set<DexReference> result = Sets.newIdentityHashSet();
        for (DexEncodedMember item : set) {
            result.add(item.getReference());
        }
        return result;
    }

    private static Object2BooleanMap<DexMember<?, ?>> joinIdentifierNameStrings(Set<DexMember<?, ?>> explicit, Set<DexMember<?, ?>> implicit) {
        Object2BooleanArrayMap result = new Object2BooleanArrayMap();
        for (DexMember<?, ?> e : explicit) {
            result.putIfAbsent(e, true);
        }
        for (DexMember<?, ?> i : implicit) {
            result.putIfAbsent(i, false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trace(ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Grow the tree.");
        try {
            while (true) {
                long numberOfLiveItems = this.getNumberOfLiveItems();
                while (!this.workList.isEmpty()) {
                    EnqueuerWorklist.EnqueuerAction action = this.workList.poll();
                    action.run(this);
                }
                long numberOfLiveItemsAfterProcessing = this.getNumberOfLiveItems();
                if (numberOfLiveItemsAfterProcessing > numberOfLiveItems) {
                    if (this.activeIfRules == null) {
                        this.activeIfRules = new HashMap<Equivalence.Wrapper<ProguardIfRule>, Set<ProguardIfRule>>();
                        IfRuleClassPartEquivalence equivalence = new IfRuleClassPartEquivalence();
                        for (ProguardIfRule ifRule : this.rootSet.ifRules) {
                            Equivalence.Wrapper<ProguardIfRule> wrap = equivalence.wrap(ifRule);
                            this.activeIfRules.computeIfAbsent(wrap, ignore -> new LinkedHashSet()).add(ifRule);
                        }
                    }
                    RootSetUtils.ConsequentRootSetBuilder consequentSetBuilder = RootSetUtils.ConsequentRootSet.builder(this.appView, this.subtypingInfo, this);
                    IfRuleEvaluator ifRuleEvaluator = new IfRuleEvaluator(this.appView, this.subtypingInfo, this, executorService, this.activeIfRules, consequentSetBuilder);
                    this.addConsequentRootSet(ifRuleEvaluator.run());
                    assert (this.getNumberOfLiveItems() == numberOfLiveItemsAfterProcessing);
                    if (!this.workList.isEmpty()) continue;
                }
                if (!this.pendingReflectiveUses.isEmpty()) {
                    this.pendingReflectiveUses.forEach(this::handleReflectiveBehavior);
                    this.pendingReflectiveUses.clear();
                }
                if (!this.workList.isEmpty()) continue;
                if (this.deferredTracing.enqueueWorklistActions(this.workList)) {
                    assert (!this.workList.isEmpty());
                    continue;
                }
                this.analyses.forEach(analysis -> analysis.notifyFixpoint(this, this.workList, timing));
                if (!this.workList.isEmpty()) continue;
                for (DelayedRootSetActionItem delayedRootSetActionItem : this.rootSet.delayedRootSetActionItems) {
                    if (!delayedRootSetActionItem.isInterfaceMethodSyntheticBridgeAction()) continue;
                    this.identifySyntheticInterfaceMethodBridges(delayedRootSetActionItem.asInterfaceMethodSyntheticBridgeAction());
                }
                this.synthesize();
                RootSetUtils.ConsequentRootSet consequentRootSet = this.computeDelayedInterfaceMethodSyntheticBridges();
                this.addConsequentRootSet(consequentRootSet);
                this.rootSet.getDependentMinimumKeepInfo().merge(consequentRootSet.getDependentMinimumKeepInfo());
                this.rootSet.delayedRootSetActionItems.clear();
                if (this.workList.isEmpty()) break;
            }
            if (this.mode.isInitialTreeShaking()) {
                this.postProcessingDesugaring();
            }
            if (Log.ENABLED) {
                Set allLive = Sets.newIdentityHashSet();
                Sets.SetView reachableNotLive = Sets.difference(allLive, this.liveMethods.getItems());
                Log.debug(this.getClass(), "%s methods are reachable but not live", reachableNotLive.size());
                Log.info(this.getClass(), "Only reachable: %s", reachableNotLive);
                Sets.SetView<DexEncodedMethod> targetedButNotLive = Sets.difference(this.targetedMethods.getItems(), this.liveMethods.getItems());
                Log.debug(this.getClass(), "%s methods are targeted but not live", targetedButNotLive.size());
                Log.info(this.getClass(), "Targeted but not live: %s", targetedButNotLive);
            }
        }
        finally {
            timing.end();
        }
    }

    private void postProcessingDesugaring() throws ExecutionException {
        SyntheticAdditions syntheticAdditions = new SyntheticAdditions(this.appView.createProcessorContext());
        assert (this.workList.isEmpty());
        CfPostProcessingDesugaringEventConsumer.R8PostProcessingDesugaringEventConsumer eventConsumer = CfPostProcessingDesugaringEventConsumer.createForR8(syntheticAdditions, this.desugaring, (context, missing) -> this.missingClassesBuilder.addNewMissingClassWithDesugarDiagnostic((DexType)missing, (ProgramDerivedContext)context, new InterfaceDesugarMissingTypeDiagnostic(context.getOrigin(), Position.UNKNOWN, missing.asClassReference(), context.getType().asClassReference(), null)));
        InterfaceMethodProcessorFacade interfaceDesugaring = this.desugaring.getInterfaceMethodPostProcessingDesugaringR8(InterfaceMethodRewriter.Flavor.ExcludeDexResources, this.liveMethods::contains, this.interfaceProcessor);
        CfPostProcessingDesugaringCollection.create(this.appView, interfaceDesugaring).postProcessingDesugaring(((SetWithReportedReason)this.liveTypes).items, this.liveMethods::contains, eventConsumer, this.executorService);
        if (syntheticAdditions.isEmpty()) {
            return;
        }
        this.appInfo = this.appInfo.rebuildWithClassHierarchy(app -> app);
        this.appView.setAppInfo(this.appInfo);
        this.subtypingInfo = SubtypingInfo.create(this.appView);
        syntheticAdditions.enqueueWorkItems(this);
        this.workList = this.workList.nonPushable();
        while (!this.workList.isEmpty()) {
            EnqueuerWorklist.EnqueuerAction action = this.workList.poll();
            action.run(this);
        }
    }

    private long getNumberOfLiveItems() {
        long result = this.liveTypes.getItems().size();
        result += (long)this.liveMethods.items.size();
        return result += (long)this.liveFields.fields.size();
    }

    private void addConsequentRootSet(RootSetUtils.ConsequentRootSet consequentRootSet) {
        this.rootSet.addConsequentRootSet(consequentRootSet);
        this.includeMinimumKeepInfo(consequentRootSet);
        consequentRootSet.pendingMethodMoveInverse.forEach(this.pendingMethodMoveInverse::put);
        if (this.forceProguardCompatibility) {
            consequentRootSet.dependentKeepClassCompatRule.forEach((precondition, compatRules) -> {
                assert (precondition.isDexType());
                DexProgramClass preconditionHolder = DexProgramClass.asProgramClassOrNull(this.appInfo().definitionFor(precondition.asDexType()));
                this.compatEnqueueHolderIfDependentNonStaticMember(preconditionHolder, (Set<ProguardKeepRuleBase>)compatRules);
            });
        }
    }

    private RootSetUtils.ConsequentRootSet computeDelayedInterfaceMethodSyntheticBridges() {
        RootSetUtils.RootSetBuilder builder = RootSetUtils.RootSet.builder(this.appView, this.subtypingInfo);
        for (DelayedRootSetActionItem delayedRootSetActionItem : this.rootSet.delayedRootSetActionItems) {
            if (!delayedRootSetActionItem.isInterfaceMethodSyntheticBridgeAction()) continue;
            this.handleInterfaceMethodSyntheticBridgeAction(delayedRootSetActionItem.asInterfaceMethodSyntheticBridgeAction(), builder);
        }
        return builder.buildConsequentRootSet();
    }

    private void identifySyntheticInterfaceMethodBridges(DelayedRootSetActionItem.InterfaceMethodSyntheticBridgeAction action) {
        ProgramMethod methodToKeep = action.getMethodToKeep();
        ProgramMethod singleTarget = action.getSingleTarget();
        if (this.rootSet.isShrinkingDisallowedUnconditionally(singleTarget, this.options)) {
            return;
        }
        if (methodToKeep != singleTarget && !this.syntheticInterfaceMethodBridges.containsKey(((DexEncodedMethod)methodToKeep.getDefinition()).getReference())) {
            this.syntheticInterfaceMethodBridges.put((DexMethod)((DexEncodedMethod)methodToKeep.getDefinition()).getReference(), methodToKeep);
        }
    }

    private void handleInterfaceMethodSyntheticBridgeAction(DelayedRootSetActionItem.InterfaceMethodSyntheticBridgeAction action, RootSetUtils.RootSetBuilder builder) {
        ProgramMethod methodToKeep = action.getMethodToKeep();
        ProgramMethod singleTarget = action.getSingleTarget();
        DexEncodedMethod singleTargetMethod = (DexEncodedMethod)singleTarget.getDefinition();
        if (this.rootSet.isShrinkingDisallowedUnconditionally(singleTarget, this.options)) {
            return;
        }
        if (singleTargetMethod.isLibraryMethodOverride().isTrue()) {
            ((DexEncodedMethod)methodToKeep.getDefinition()).setLibraryMethodOverride(OptionalBool.TRUE);
        }
        action.getAction().accept(builder);
    }

    private boolean shouldMarkLibraryMethodOverrideAsReachable(LookupTarget override) {
        if (override.isLambdaTarget()) {
            return true;
        }
        ProgramMethod programMethod = override.asMethodTarget().asProgramMethod();
        if (programMethod == null) {
            return false;
        }
        DexProgramClass clazz = programMethod.getHolder();
        DexEncodedMethod method = (DexEncodedMethod)programMethod.getDefinition();
        assert (method.isVirtualMethod());
        if (method.isAbstract() || method.isPrivateMethod()) {
            return false;
        }
        if (this.appView.isClassEscapingIntoLibrary(clazz.type)) {
            return true;
        }
        Set<DexProgramClass> immediateSubtypes = this.getImmediateSubtypesInInstantiatedHierarchy(clazz);
        if (immediateSubtypes.isEmpty()) {
            return false;
        }
        ArrayDeque<DexProgramClass> worklist = new ArrayDeque<DexProgramClass>(immediateSubtypes);
        Set<DexProgramClass> visited = SetUtils.newIdentityHashSet(immediateSubtypes);
        while (!worklist.isEmpty()) {
            DexProgramClass current = (DexProgramClass)worklist.removeFirst();
            assert (visited.contains(current));
            if (current.lookupVirtualMethod((DexMethod)method.getReference()) != null) continue;
            if (this.appView.isClassEscapingIntoLibrary(current.type)) {
                return true;
            }
            for (DexProgramClass subtype : this.getImmediateSubtypesInInstantiatedHierarchy(current)) {
                if (!visited.add(subtype)) continue;
                worklist.add(subtype);
            }
        }
        return false;
    }

    private Set<DexProgramClass> getImmediateSubtypesInInstantiatedHierarchy(DexProgramClass clazz) {
        Set<DexClass> subtypes = this.objectAllocationInfoCollection.getImmediateSubtypesInInstantiatedHierarchy(clazz.type);
        if (subtypes == null) {
            return Collections.emptySet();
        }
        Set<DexProgramClass> programClasses = SetUtils.newIdentityHashSet(subtypes.size());
        for (DexClass subtype : subtypes) {
            if (!subtype.isProgramClass()) continue;
            programClasses.add(subtype.asProgramClass());
        }
        return programClasses;
    }

    private void markMethodAsTargeted(ProgramMethod method, KeepReason reason) {
        if (!this.addTargetedMethod(method, reason)) {
            return;
        }
        if (!this.liveMethods.contains(method)) {
            this.traceMethodDefinitionExcludingCode(method);
        }
        if (this.forceProguardCompatibility && !method.getAccessFlags().isAbstract() && method.getHolder().isInterface()) {
            this.markMethodAsLiveWithCompatRule(method);
        }
        this.analyses.forEach(analysis -> analysis.notifyMarkMethodAsTargeted(method, this.workList));
    }

    private void traceNonDesugaredCode(ProgramMethod method) {
        if (this.getMode().isInitialTreeShaking() && this.addToPendingDesugaring(method)) {
            return;
        }
        this.traceCode(method);
    }

    private void markReferencedTypesAsLive(ProgramMethod method) {
        this.markTypeAsLive(method.getHolder(), (ProgramDefinition)method);
        this.markParameterAndReturnTypesAsLive(method);
    }

    private void markParameterAndReturnTypesAsLive(ProgramMethod method) {
        for (DexType parameterType : ((DexEncodedMethod)method.getDefinition()).getParameters()) {
            this.markTypeAsLive(parameterType, (ProgramDefinition)method);
        }
        this.markTypeAsLive(((DexEncodedMethod)method.getDefinition()).returnType(), (ProgramDefinition)method);
    }

    private void markClassAsInstantiatedWithReason(DexProgramClass clazz, KeepReason reason) {
        this.workList.enqueueMarkInstantiatedAction(clazz, null, InstantiationReason.REFLECTION, reason);
        if (clazz.hasDefaultInitializer()) {
            ProgramMethod defaultInitializer = clazz.getProgramDefaultInitializer();
            this.workList.enqueueMarkReachableDirectAction((DexMethod)defaultInitializer.getReference(), defaultInitializer, reason);
        }
    }

    private void markClassAsInstantiatedWithCompatRule(DexProgramClass clazz, Supplier<KeepReason> reasonSupplier) {
        assert (this.forceProguardCompatibility);
        if (!this.addCompatInstantiatedClass(clazz)) {
            return;
        }
        GraphReporter.KeepReasonWitness witness = this.graphReporter.registerClass(clazz, reasonSupplier.get());
        if (clazz.isAnnotation()) {
            this.markTypeAsLive(clazz, witness);
        } else if (clazz.isInterface()) {
            this.markInterfaceAsInstantiated(clazz, witness);
        } else {
            this.workList.enqueueMarkInstantiatedAction(clazz, null, InstantiationReason.KEEP_RULE, witness);
            if (clazz.hasDefaultInitializer()) {
                ProgramMethod defaultInitializer = clazz.getProgramDefaultInitializer();
                this.workList.enqueueMarkReachableDirectAction((DexMethod)defaultInitializer.getReference(), defaultInitializer, this.graphReporter.reportCompatKeepDefaultInitializer(defaultInitializer));
            }
        }
    }

    private boolean addCompatInstantiatedClass(DexProgramClass clazz) {
        assert (this.forceProguardCompatibility);
        if (this.mode.isInitialTreeShaking()) {
            this.proguardCompatibilityActionsBuilder.addCompatInstantiatedType(clazz);
            return true;
        }
        assert (this.proguardCompatibilityActionsBuilder == null);
        return this.appView.hasProguardCompatibilityActions() && this.appView.getProguardCompatibilityActions().isCompatInstantiated(clazz);
    }

    private void markMethodAsLiveWithCompatRule(ProgramMethod method) {
        this.workList.enqueueMarkMethodLiveAction(method, method, this.graphReporter.reportCompatKeepMethod(method));
    }

    private void handleReflectiveBehavior(ProgramMethod method) {
        IRCode code = method.buildIR(this.appView);
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            Instruction instruction = (Instruction)iterator2.next();
            this.handleReflectiveBehavior(method, instruction);
        }
    }

    private void handleReflectiveBehavior(ProgramMethod method, Instruction instruction) {
        if (!instruction.isInvokeMethod()) {
            return;
        }
        InvokeMethod invoke = instruction.asInvokeMethod();
        DexMethod invokedMethod = invoke.getInvokedMethod();
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        if (invokedMethod == dexItemFactory.classMethods.newInstance) {
            this.handleJavaLangClassNewInstance(method, invoke);
            return;
        }
        if (invokedMethod == dexItemFactory.constructorMethods.newInstance) {
            this.handleJavaLangReflectConstructorNewInstance(method, invoke);
            return;
        }
        if (invokedMethod == dexItemFactory.enumMembers.valueOf) {
            this.handleJavaLangEnumValueOf(method, invoke);
            return;
        }
        if (invokedMethod == dexItemFactory.proxyMethods.newProxyInstance) {
            this.handleJavaLangReflectProxyNewProxyInstance(method, invoke);
            return;
        }
        if (dexItemFactory.serviceLoaderMethods.isLoadMethod(invokedMethod)) {
            this.handleServiceLoaderInvocation(method, invoke);
            return;
        }
        if (!IdentifierNameStringUtils.isReflectionMethod(dexItemFactory, invokedMethod)) {
            return;
        }
        IdentifierNameStringLookupResult<?> identifierLookupResult = IdentifierNameStringUtils.identifyIdentifier(invoke, this.appView, method);
        if (identifierLookupResult == null) {
            return;
        }
        Object referencedItem = identifierLookupResult.getReference();
        if (((DexReference)referencedItem).isDexType()) {
            assert (identifierLookupResult.isTypeResult());
            IdentifierNameStringTypeLookupResult identifierTypeLookupResult = identifierLookupResult.asTypeResult();
            DexProgramClass clazz = this.getProgramClassOrNullFromReflectiveAccess(((DexReference)referencedItem).asDexType(), method);
            if (clazz == null) {
                return;
            }
            this.markTypeAsLive(clazz, KeepReason.reflectiveUseIn(method));
            if (clazz.canBeInstantiatedByNewInstance() && identifierTypeLookupResult.isTypeCompatInstantiatedFromUse(this.options)) {
                this.markClassAsInstantiatedWithCompatRule(clazz, () -> KeepReason.reflectiveUseIn(method));
            } else if (identifierTypeLookupResult.isTypeInitializedFromUse()) {
                this.markDirectAndIndirectClassInitializersAsLive(clazz);
            }
            if (this.keepInfo.getClassInfo(clazz).isShrinkingAllowed(this.options)) {
                this.keepInfo.joinClass(clazz, joiner -> {
                    KeepClassInfo.Joiner cfr_ignored_0 = (KeepClassInfo.Joiner)((KeepClassInfo.Joiner)joiner.disallowOptimization()).disallowShrinking();
                });
            }
        } else if (((DexReference)referencedItem).isDexField()) {
            boolean keepClass;
            DexField field = ((DexReference)referencedItem).asDexField();
            DexProgramClass clazz = this.getProgramClassOrNullFromReflectiveAccess(field.holder, method);
            if (clazz == null) {
                return;
            }
            DexEncodedField encodedField = clazz.lookupField(field);
            if (encodedField == null) {
                return;
            }
            boolean bl = keepClass = !encodedField.isStatic() && dexItemFactory.atomicFieldUpdaterMethods.isFieldUpdater(invokedMethod);
            if (keepClass) {
                this.workList.enqueueMarkInstantiatedAction(clazz, null, InstantiationReason.REFLECTION, KeepReason.reflectiveUseIn(method));
            }
            if (this.keepInfo.getFieldInfo(encodedField, clazz).isShrinkingAllowed(this.options)) {
                ProgramField programField = new ProgramField(clazz, encodedField);
                this.keepInfo.joinField(programField, joiner -> {
                    KeepFieldInfo.Joiner cfr_ignored_0 = (KeepFieldInfo.Joiner)((KeepFieldInfo.Joiner)joiner.disallowOptimization()).disallowShrinking();
                });
                this.markFieldAsKept(programField, KeepReason.reflectiveUseIn(method));
            }
        } else {
            assert (((DexReference)referencedItem).isDexMethod());
            DexMethod targetedMethodReference = ((DexReference)referencedItem).asDexMethod();
            DexProgramClass clazz = this.getProgramClassOrNullFromReflectiveAccess(targetedMethodReference.holder, method);
            if (clazz == null) {
                return;
            }
            ProgramMethod targetedMethod = clazz.lookupProgramMethod(targetedMethodReference);
            if (targetedMethod == null) {
                return;
            }
            KeepReason reason = KeepReason.reflectiveUseIn(method);
            if (((DexEncodedMethod)targetedMethod.getDefinition()).belongsToDirectPool()) {
                this.markMethodAsTargeted(targetedMethod, reason);
                this.markDirectStaticOrConstructorMethodAsLive(targetedMethod, reason);
            } else {
                this.markVirtualMethodAsLive(targetedMethod, reason);
            }
            this.applyMinimumKeepInfoWhenLiveOrTargeted(targetedMethod, (KeepMethodInfo.Joiner)KeepMethodInfo.newEmptyJoiner().disallowOptimization());
        }
    }

    private void handleJavaLangClassNewInstance(ProgramMethod method, InvokeMethod invoke) {
        if (!invoke.isInvokeVirtual()) {
            assert (false);
            return;
        }
        DexType instantiatedType = ConstantValueUtils.getDexTypeRepresentedByValue(invoke.asInvokeVirtual().getReceiver(), this.appView);
        if (instantiatedType == null || !instantiatedType.isClassType()) {
            return;
        }
        DexProgramClass clazz = this.getProgramClassOrNullFromReflectiveAccess(instantiatedType, method);
        if (clazz == null) {
            return;
        }
        ProgramMethod defaultInitializer = clazz.getProgramDefaultInitializer();
        if (defaultInitializer != null) {
            KeepReason reason = KeepReason.reflectiveUseIn(method);
            this.markClassAsInstantiatedWithReason(clazz, reason);
            this.markMethodAsTargeted(defaultInitializer, reason);
            this.markDirectStaticOrConstructorMethodAsLive(defaultInitializer, reason);
            this.applyMinimumKeepInfoWhenLiveOrTargeted(defaultInitializer, (KeepMethodInfo.Joiner)KeepMethodInfo.newEmptyJoiner().disallowOptimization());
        }
    }

    private void handleJavaLangReflectConstructorNewInstance(ProgramMethod method, InvokeMethod invoke) {
        if (!invoke.isInvokeVirtual()) {
            assert (false);
            return;
        }
        Value constructorValue = invoke.asInvokeVirtual().getReceiver().getAliasedValue();
        if (constructorValue.isPhi() || !constructorValue.definition.isInvokeVirtual()) {
            return;
        }
        InvokeVirtual constructorDefinition = constructorValue.definition.asInvokeVirtual();
        DexMethod invokedMethod = constructorDefinition.getInvokedMethod();
        if (invokedMethod != this.appView.dexItemFactory().classMethods.getConstructor && invokedMethod != this.appView.dexItemFactory().classMethods.getDeclaredConstructor) {
            return;
        }
        DexType instantiatedType = ConstantValueUtils.getDexTypeRepresentedByValue(constructorDefinition.getReceiver(), this.appView);
        if (instantiatedType == null || !instantiatedType.isClassType()) {
            return;
        }
        DexProgramClass clazz = this.getProgramClassOrNullFromReflectiveAccess(instantiatedType, method);
        if (clazz == null) {
            return;
        }
        Value parametersValue = constructorDefinition.inValues().get(1);
        if (parametersValue.isPhi() || !parametersValue.definition.isNewArrayEmpty()) {
            return;
        }
        Value parametersSizeValue = parametersValue.definition.asNewArrayEmpty().size();
        if (parametersSizeValue.isPhi() || !parametersSizeValue.definition.isConstNumber()) {
            return;
        }
        ProgramMethod initializer = null;
        int parametersSize = parametersSizeValue.definition.asConstNumber().getIntValue();
        if (parametersSize == 0) {
            initializer = clazz.getProgramDefaultInitializer();
        } else {
            DexType[] parameterTypes = new DexType[parametersSize];
            int missingIndices = parametersSize;
            for (Instruction user : parametersValue.uniqueUsers()) {
                if (!user.isArrayPut()) continue;
                ArrayPut arrayPutInstruction = user.asArrayPut();
                if (arrayPutInstruction.array() != parametersValue) {
                    return;
                }
                Value indexValue = arrayPutInstruction.index();
                if (indexValue.isPhi() || !indexValue.definition.isConstNumber()) {
                    return;
                }
                int index = indexValue.definition.asConstNumber().getIntValue();
                if (index >= parametersSize) {
                    return;
                }
                DexType type = ConstantValueUtils.getDexTypeRepresentedByValue(arrayPutInstruction.value(), this.appView);
                if (type == null) {
                    return;
                }
                if (parameterTypes[index] == type) continue;
                if (parameterTypes[index] != null) {
                    return;
                }
                parameterTypes[index] = type;
                --missingIndices;
            }
            if (missingIndices == 0) {
                initializer = clazz.getProgramInitializer(parameterTypes);
            }
        }
        if (initializer != null) {
            KeepReason reason = KeepReason.reflectiveUseIn(method);
            this.markClassAsInstantiatedWithReason(clazz, reason);
            this.markMethodAsTargeted(initializer, reason);
            this.markDirectStaticOrConstructorMethodAsLive(initializer, reason);
            this.applyMinimumKeepInfoWhenLiveOrTargeted(initializer, (KeepMethodInfo.Joiner)KeepMethodInfo.newEmptyJoiner().disallowOptimization());
        }
    }

    private void handleJavaLangReflectProxyNewProxyInstance(ProgramMethod method, InvokeMethod invoke) {
        if (!invoke.isInvokeStatic()) {
            assert (false);
            return;
        }
        Value interfacesValue = invoke.arguments().get(1);
        if (interfacesValue.isPhi() || !interfacesValue.definition.isNewArrayEmpty()) {
            return;
        }
        WorkList<DexProgramClass> worklist = WorkList.newIdentityWorkList();
        for (Instruction user : interfacesValue.uniqueUsers()) {
            DexProgramClass clazz;
            ArrayPut arrayPut;
            DexType type;
            if (!user.isArrayPut() || (type = ConstantValueUtils.getDexTypeRepresentedByValue((arrayPut = user.asArrayPut()).value(), this.appView)) == null || !type.isClassType() || (clazz = this.getProgramClassOrNullFromReflectiveAccess(type, method)) == null || !clazz.isInterface()) continue;
            KeepReason reason = KeepReason.reflectiveUseIn(method);
            this.markInterfaceAsInstantiated(clazz, this.graphReporter.registerClass(clazz, reason));
            worklist.addIfNotSeen(clazz);
        }
        while (worklist.hasNext()) {
            DexProgramClass clazz = (DexProgramClass)worklist.next();
            assert (clazz.isInterface());
            this.keepInfo.joinClass(clazz, joiner -> {
                KeepClassInfo.Joiner cfr_ignored_0 = (KeepClassInfo.Joiner)((KeepClassInfo.Joiner)joiner.disallowOptimization()).disallowShrinking();
            });
            if (this.mode.isInitialTreeShaking()) {
                KeepReason reason = KeepReason.reflectiveUseIn(method);
                clazz.forEachProgramVirtualMethod(virtualMethod -> {
                    this.keepInfo.joinMethod((ProgramMethod)virtualMethod, joiner -> {
                        KeepMethodInfo.Joiner cfr_ignored_0 = (KeepMethodInfo.Joiner)((KeepMethodInfo.Joiner)joiner.disallowOptimization()).disallowShrinking();
                    });
                    this.markVirtualMethodAsReachable((DexMethod)virtualMethod.getReference(), true, method, reason);
                });
            }
            for (DexType implementedType : clazz.getInterfaces()) {
                DexProgramClass implementedClass = DexProgramClass.asProgramClassOrNull(this.definitionFor(implementedType, (ProgramDefinition)clazz));
                if (implementedClass == null || !implementedClass.isInterface()) continue;
                worklist.addIfNotSeen(implementedClass);
            }
        }
    }

    private void handleJavaLangEnumValueOf(ProgramMethod method, InvokeMethod invoke) {
        DexType type;
        DexProgramClass clazz;
        if (invoke.inValues().get(0).isConstClass() && (clazz = this.getProgramClassOrNull(type = invoke.inValues().get((int)0).definition.asConstClass().getValue(), method)) != null && clazz.isEnum()) {
            this.markEnumValuesAsReachable(clazz, KeepReason.invokedFrom(method));
        }
    }

    private void handleServiceLoaderInvocation(ProgramMethod method, InvokeMethod invoke) {
        if (invoke.inValues().size() == 0) {
            return;
        }
        Value argument = invoke.inValues().get(0).getAliasedValue();
        if (!argument.isPhi() && argument.definition.isConstClass()) {
            DexType serviceType = argument.definition.asConstClass().getValue();
            if (!this.appView.appServices().allServiceTypes().contains(serviceType)) {
                if (Log.ENABLED) {
                    this.options.reporter.warning(new StringDiagnostic("The type `" + serviceType.toSourceString() + "` is being passed to the method `" + invoke.getInvokedMethod().toSourceString() + "`, but was not found in `META-INF/services/`.", method.getOrigin()));
                }
                return;
            }
            this.handleServiceInstantiation(serviceType, method, KeepReason.reflectiveUseIn(method));
        } else {
            KeepReason reason = KeepReason.reflectiveUseIn(method);
            for (DexType serviceType : this.appView.appServices().allServiceTypes()) {
                this.handleServiceInstantiation(serviceType, method, reason);
            }
        }
    }

    private void handleServiceInstantiation(DexType serviceType, ProgramMethod context, KeepReason reason) {
        List<DexType> serviceImplementationTypes = this.appView.appServices().serviceImplementationsFor(serviceType);
        DexMethodSignatureSet serviceMethods = this.getServiceMethods(serviceType, context);
        for (DexType serviceImplementationType : serviceImplementationTypes) {
            DexProgramClass serviceImplementationClass;
            if (!serviceImplementationType.isClassType() || (serviceImplementationClass = this.getProgramClassOrNull(serviceImplementationType, context)) == null) continue;
            this.markClassAsInstantiatedWithReason(serviceImplementationClass, reason);
            ProgramMethod defaultInitializer = serviceImplementationClass.getProgramDefaultInitializer();
            if (defaultInitializer != null) {
                this.applyMinimumKeepInfoWhenLiveOrTargeted(defaultInitializer, (KeepMethodInfo.Joiner)KeepMethodInfo.newEmptyJoiner().disallowOptimization());
            }
            for (DexMethodSignature serviceMethod : serviceMethods) {
                ProgramMethod serviceImplementationMethod = DexEncodedMethod.asProgramMethodOrNull(serviceImplementationClass.getMethodCollection().getMethod(serviceMethod), serviceImplementationClass);
                if (serviceImplementationMethod == null) continue;
                this.applyMinimumKeepInfoWhenLiveOrTargeted(serviceImplementationMethod, (KeepMethodInfo.Joiner)KeepMethodInfo.newEmptyJoiner().disallowOptimization());
            }
        }
    }

    private DexMethodSignatureSet getServiceMethods(DexType serviceType, ProgramMethod context) {
        DexMethodSignatureSet serviceMethods = DexMethodSignatureSet.create();
        WorkList<DexType> serviceTypes = WorkList.newIdentityWorkList(serviceType);
        while (serviceTypes.hasNext()) {
            DexType current = serviceTypes.next();
            DexClass clazz = this.getClassOrNullFromReflectiveAccess(current, context);
            if (clazz == null) continue;
            clazz.forEachClassMethodMatching(DexEncodedMethod::belongsToVirtualPool, serviceMethods::add);
            serviceTypes.addIfNotSeen(clazz.getInterfaces());
        }
        return serviceMethods;
    }

    public Mode getMode() {
        return this.mode;
    }

    public GraphReporter getGraphReporter() {
        return this.graphReporter;
    }

    public EnqueuerUseRegistryFactory getUseRegistryFactory() {
        return this.useRegistryFactory;
    }

    public Enqueuer registerAnalysis(EnqueuerAnalysis analysis) {
        this.analyses.add(analysis);
        return this;
    }

    public Enqueuer registerFieldAccessAnalysis(EnqueuerFieldAccessAnalysis analysis) {
        this.fieldAccessAnalyses.add(analysis);
        return this;
    }

    public Enqueuer registerInvokeAnalysis(EnqueuerInvokeAnalysis analysis) {
        this.invokeAnalyses.add(analysis);
        return this;
    }

    public Enqueuer registerInstanceOfAnalysis(EnqueuerInstanceOfAnalysis analysis) {
        this.instanceOfAnalyses.add(analysis);
        return this;
    }

    public Enqueuer registerCheckCastAnalysis(EnqueuerCheckCastAnalysis analysis) {
        this.checkCastAnalyses.add(analysis);
        return this;
    }

    public Enqueuer registerExceptionGuardAnalysis(EnqueuerExceptionGuardAnalysis analysis) {
        this.exceptionGuardAnalyses.add(analysis);
        return this;
    }

    public void setAnnotationRemoverBuilder(AnnotationRemover.Builder annotationRemoverBuilder) {
        this.annotationRemoverBuilder = annotationRemoverBuilder;
    }

    public void setInitialDeadProtoTypes(Set<DexType> initialDeadProtoTypes) {
        assert (this.mode.isFinalTreeShaking());
        this.initialDeadProtoTypes = initialDeadProtoTypes;
    }

    public void setInitialPrunedTypes(Set<DexType> initialPrunedTypes) {
        assert (this.mode.isFinalTreeShaking());
        this.initialPrunedTypes = initialPrunedTypes;
    }

    public void addDeadProtoTypeCandidate(DexType type) {
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(type));
        if (clazz != null) {
            this.addDeadProtoTypeCandidate(clazz);
        }
    }

    public void addDeadProtoTypeCandidate(DexProgramClass clazz) {
        this.deadProtoTypeCandidates.add(clazz);
    }

    public boolean addLiveMethod(ProgramMethod method, KeepReason reason) {
        return this.liveMethods.add(method, reason);
    }

    public boolean addTargetedMethod(ProgramMethod method, KeepReason reason) {
        return this.targetedMethods.add(method, reason);
    }

    public DexEncodedMethod definitionFor(DexMethod method, ProgramDefinition context) {
        DexClass clazz = this.definitionFor(method.holder, context);
        if (clazz == null) {
            return null;
        }
        return clazz.lookupMethod(method);
    }

    public DexClass definitionFor(DexType type, ProgramDefinition context) {
        return this.definitionFor(type, context, this::recordNonProgramClass, this::reportMissingClass);
    }

    public KeepInfoCollection.MutableKeepInfoCollection getKeepInfo() {
        return this.keepInfo;
    }

    public KeepClassInfo getKeepInfo(DexProgramClass clazz) {
        return this.keepInfo.getClassInfo(clazz);
    }

    public boolean registerFieldRead(DexField field, ProgramMethod context) {
        return this.registerFieldAccess(field, context, true, false);
    }

    public boolean registerReflectiveFieldRead(DexField field, ProgramMethod context) {
        return this.registerFieldAccess(field, context, true, true);
    }

    public boolean registerFieldWrite(DexField field, ProgramMethod context) {
        return this.registerFieldAccess(field, context, false, false);
    }

    public boolean registerReflectiveFieldWrite(DexField field, ProgramMethod context) {
        return this.registerFieldAccess(field, context, false, true);
    }

    public boolean registerReflectiveFieldAccess(DexField field, ProgramMethod context) {
        boolean changed = this.registerFieldAccess(field, context, true, true);
        return changed |= this.registerFieldAccess(field, context, false, true);
    }

    void traceCallSite(DexCallSite callSite, ProgramMethod context) {
        LambdaDescriptor descriptor;
        DexProgramClass bootstrapClass;
        if ((this.options.isGeneratingClassFiles() || !LambdaDescriptor.isLambdaMetafactoryMethod(callSite, this.appInfo())) && (bootstrapClass = this.getProgramHolderOrNull(callSite.bootstrapMethod.asMethod(), context)) != null) {
            this.bootstrapMethods.add(callSite.bootstrapMethod.asMethod());
        }
        if ((descriptor = LambdaDescriptor.tryInfer(callSite, this.appInfo(), context)) == null) {
            for (DexValue bootstrapArgument : callSite.getBootstrapArgs()) {
                DexMethodHandle method;
                if (!bootstrapArgument.isDexValueMethodHandle() || !(method = (DexMethodHandle)bootstrapArgument.asDexValueMethodHandle().getValue()).isMethodHandle()) continue;
                this.disableClosedWorldReasoning(method.asMethod(), context);
            }
            return;
        }
        assert (this.options.desugarState.isOff());
        this.markLambdaAsInstantiated(descriptor, context);
        this.transitionMethodsForInstantiatedLambda(descriptor);
        this.callSites.computeIfAbsent(callSite, ignore -> ProgramMethodSet.create()).add(context);
        descriptor.captures.forEach((Consumer<? super DexType>)((Consumer<DexType>)type -> this.markTypeAsLive((DexType)type, (ProgramDefinition)context)));
        DexMethodHandle implHandle = descriptor.implHandle;
        assert (implHandle != null);
        DexMethod method = implHandle.asMethod();
        switch (implHandle.type) {
            case INVOKE_STATIC: {
                this.traceInvokeStaticFromLambda(method, context);
                break;
            }
            case INVOKE_INTERFACE: {
                this.traceInvokeInterfaceFromLambda(method, context);
                break;
            }
            case INVOKE_INSTANCE: {
                this.traceInvokeVirtualFromLambda(method, context);
                break;
            }
            case INVOKE_DIRECT: {
                this.traceInvokeDirectFromLambda(method, context);
                break;
            }
            case INVOKE_CONSTRUCTOR: {
                this.traceNewInstanceFromLambda(method.holder, context);
                break;
            }
            default: {
                throw new Unreachable();
            }
        }
        this.disableClosedWorldReasoning(method, context);
    }

    void traceCheckCast(DexType type, ProgramMethod currentMethod, boolean ignoreCompatRules) {
        this.checkCastAnalyses.forEach(analysis -> analysis.traceCheckCast(type, currentMethod));
        this.internalTraceConstClassOrCheckCast(type, currentMethod, ignoreCompatRules);
    }

    void traceSafeCheckCast(DexType type, ProgramMethod currentMethod) {
        this.checkCastAnalyses.forEach(analysis -> analysis.traceSafeCheckCast(type, currentMethod));
        this.internalTraceConstClassOrCheckCast(type, currentMethod, true);
    }

    void traceConstClass(DexType type, ProgramMethod currentMethod, ListIterator<? extends CfOrDexInstruction> iterator2, boolean ignoreCompatRules) {
        this.handleLockCandidate(type, currentMethod, iterator2);
        this.internalTraceConstClassOrCheckCast(type, currentMethod, ignoreCompatRules);
    }

    void traceRecordFieldValues(DexField[] fields, ProgramMethod currentMethod) {
        if (this.mode.isFinalTreeShaking()) {
            this.recordFieldValuesReferences.add((DexMethod)currentMethod.getReference());
        }
    }

    void traceInitClass(DexType type, ProgramMethod currentMethod) {
        assert (type.isClassType());
        Visibility oldMinimumRequiredVisibility = this.initClassReferences.get(type);
        if (oldMinimumRequiredVisibility == null) {
            DexProgramClass clazz = this.getProgramClassOrNull(type, currentMethod);
            if (clazz == null) {
                assert (false);
                return;
            }
            this.initClassReferences.put(type, this.computeMinimumRequiredVisibilityForInitClassField(type, currentMethod.getHolder()));
            this.markTypeAsLive(type, (ProgramDefinition)currentMethod);
            this.markDirectAndIndirectClassInitializersAsLive(clazz);
            return;
        }
        if (oldMinimumRequiredVisibility.isPublic()) {
            return;
        }
        Visibility minimumRequiredVisibilityForCurrentMethod = this.computeMinimumRequiredVisibilityForInitClassField(type, currentMethod.getHolder());
        assert (!minimumRequiredVisibilityForCurrentMethod.isPrivate());
        if (minimumRequiredVisibilityForCurrentMethod.isPublic()) {
            this.initClassReferences.put(type, minimumRequiredVisibilityForCurrentMethod);
            return;
        }
        if (oldMinimumRequiredVisibility.isProtected()) {
            return;
        }
        if (minimumRequiredVisibilityForCurrentMethod.isProtected()) {
            this.initClassReferences.put(type, minimumRequiredVisibilityForCurrentMethod);
            return;
        }
        assert (oldMinimumRequiredVisibility.isPackagePrivate());
        assert (minimumRequiredVisibilityForCurrentMethod.isPackagePrivate());
    }

    void traceMethodHandle(DexMethodHandle methodHandle, UseRegistry.MethodHandleUse use, ProgramMethod currentMethod) {
        DexType type;
        DexProgramClass clazz;
        if (methodHandle.isMethodHandle() && use != UseRegistry.MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY && (clazz = this.getProgramClassOrNull(type = methodHandle.asMethod().holder, currentMethod)) != null) {
            KeepReason reason = KeepReason.methodHandleReferencedIn(currentMethod);
            if (clazz.isAnnotation()) {
                this.markTypeAsLive(clazz, this.graphReporter.registerClass(clazz, reason));
            } else if (clazz.isInterface()) {
                this.markInterfaceAsInstantiated(clazz, this.graphReporter.registerInterface(clazz, reason));
            } else {
                this.workList.enqueueMarkInstantiatedAction(clazz, null, InstantiationReason.REFERENCED_IN_METHOD_HANDLE, reason);
            }
        }
    }

    void traceTypeReference(DexType type, ProgramMethod currentMethod) {
        this.markTypeAsLive(type, (ProgramDefinition)currentMethod);
    }

    void traceInstanceOf(DexType type, ProgramMethod currentMethod) {
        this.instanceOfAnalyses.forEach(analysis -> analysis.traceInstanceOf(type, currentMethod));
        this.traceTypeReference(type, currentMethod);
    }

    void traceExceptionGuard(DexType guard, ProgramMethod currentMethod) {
        this.exceptionGuardAnalyses.forEach(analysis -> analysis.traceExceptionGuard(guard, currentMethod));
        this.traceTypeReference(guard, currentMethod);
    }

    void traceInvokeDirect(DexMethod invokedMethod, ProgramMethod context) {
        boolean skipTracing = this.registerDeferredActionForDeadProtoBuilder(invokedMethod.holder, context, () -> this.workList.enqueueTraceInvokeDirectAction(invokedMethod, context));
        if (skipTracing) {
            this.addDeadProtoTypeCandidate(invokedMethod.holder);
            return;
        }
        this.traceInvokeDirect(invokedMethod, context, KeepReason.invokedFrom(context));
    }

    void traceInvokeDirectFromLambda(DexMethod invokedMethod, ProgramMethod context) {
        this.traceInvokeDirect(invokedMethod, context, KeepReason.invokedFromLambdaCreatedIn(context));
    }

    void traceInvokeInterface(DexMethod invokedMethod, ProgramMethod context) {
        this.traceInvokeInterface(invokedMethod, context, KeepReason.invokedFrom(context));
    }

    void traceInvokeInterfaceFromLambda(DexMethod invokedMethod, ProgramMethod context) {
        this.traceInvokeInterface(invokedMethod, context, KeepReason.invokedFromLambdaCreatedIn(context));
    }

    void traceInvokeStatic(DexMethod invokedMethod, ProgramMethod context) {
        this.traceInvokeStatic(invokedMethod, context, KeepReason.invokedFrom(context));
    }

    void traceInvokeStaticFromLambda(DexMethod invokedMethod, ProgramMethod context) {
        this.traceInvokeStatic(invokedMethod, context, KeepReason.invokedFromLambdaCreatedIn(context));
    }

    void traceInvokeSuper(DexMethod invokedMethod, ProgramMethod context) {
        DexMethod actualTarget = this.getInvokeSuperTarget(invokedMethod, context);
        if (!this.registerMethodWithTargetAndContext(this.methodAccessInfoCollection::registerInvokeSuperInContext, invokedMethod, context)) {
            return;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register invokeSuper `%s`.", actualTarget);
        }
        this.workList.enqueueMarkReachableSuperAction(invokedMethod, context);
        this.invokeAnalyses.forEach(analysis -> analysis.traceInvokeSuper(invokedMethod, context));
    }

    void traceInvokeVirtual(DexMethod invokedMethod, ProgramMethod context) {
        this.traceInvokeVirtual(invokedMethod, context, KeepReason.invokedFrom(context));
    }

    void traceInvokeVirtualFromLambda(DexMethod invokedMethod, ProgramMethod context) {
        this.traceInvokeVirtual(invokedMethod, context, KeepReason.invokedFromLambdaCreatedIn(context));
    }

    void traceNewInstance(DexType type, ProgramMethod context) {
        boolean skipTracing = this.registerDeferredActionForDeadProtoBuilder(type, context, () -> this.workList.enqueueTraceNewInstanceAction(type, context));
        if (skipTracing) {
            this.addDeadProtoTypeCandidate(type);
            return;
        }
        this.traceNewInstance(type, context, InstantiationReason.NEW_INSTANCE_INSTRUCTION, KeepReason.instantiatedIn(context));
    }

    void traceNewInstanceFromLambda(DexType type, ProgramMethod context) {
        this.traceNewInstance(type, context, InstantiationReason.LAMBDA, KeepReason.invokedFromLambdaCreatedIn(context));
    }

    void traceInstanceFieldRead(DexField field, ProgramMethod currentMethod) {
        this.traceInstanceFieldRead(field, currentMethod, FieldAccessMetadata.DEFAULT);
    }

    void traceInstanceFieldReadFromMethodHandle(DexField field, ProgramMethod currentMethod) {
        this.traceInstanceFieldRead(field, currentMethod, FieldAccessMetadata.FROM_METHOD_HANDLE);
    }

    void traceInstanceFieldReadFromRecordMethodHandle(DexField field, ProgramMethod currentMethod) {
        this.traceInstanceFieldRead(field, currentMethod, FieldAccessMetadata.FROM_RECORD_METHOD_HANDLE);
    }

    void traceInstanceFieldWrite(DexField field, ProgramMethod currentMethod) {
        this.traceInstanceFieldWrite(field, currentMethod, FieldAccessMetadata.DEFAULT);
    }

    void traceInstanceFieldWriteFromMethodHandle(DexField field, ProgramMethod currentMethod) {
        this.traceInstanceFieldWrite(field, currentMethod, FieldAccessMetadata.FROM_METHOD_HANDLE);
    }

    void traceStaticFieldRead(DexField field, ProgramMethod currentMethod) {
        this.traceStaticFieldRead(field, currentMethod, FieldAccessMetadata.DEFAULT);
    }

    void traceStaticFieldReadFromMethodHandle(DexField field, ProgramMethod currentMethod) {
        this.traceStaticFieldRead(field, currentMethod, FieldAccessMetadata.FROM_METHOD_HANDLE);
    }

    void traceStaticFieldWrite(DexField field, ProgramMethod currentMethod) {
        this.traceStaticFieldWrite(field, currentMethod, FieldAccessMetadata.DEFAULT);
    }

    void traceStaticFieldWriteFromMethodHandle(DexField field, ProgramMethod currentMethod) {
        this.traceStaticFieldWrite(field, currentMethod, FieldAccessMetadata.FROM_METHOD_HANDLE);
    }

    void processAnnotation(ProgramDefinition annotatedItem, DexAnnotation annotation, DexAnnotation.AnnotatedKind kind) {
        boolean isLive;
        DexType type = annotation.getAnnotationType();
        DexClass clazz = this.definitionFor(type, annotatedItem);
        boolean annotationTypeIsLibraryClass = clazz == null || clazz.isNotProgramClass();
        boolean bl = isLive = annotationTypeIsLibraryClass || this.liveTypes.contains(clazz.asProgramClass());
        if (!this.shouldKeepAnnotation(annotatedItem, annotation, kind, isLive)) {
            if (!annotationTypeIsLibraryClass) {
                Map<DexType, Map<DexAnnotation, List<ProgramDefinition>>> deferredAnnotations = kind.isParameter() ? this.deferredParameterAnnotations : this.deferredAnnotations;
                Map deferredAnnotationsForAnnotationType = deferredAnnotations.computeIfAbsent(type, ignore -> new IdentityHashMap());
                deferredAnnotationsForAnnotationType.computeIfAbsent(annotation, ignore -> new ArrayList()).add(annotatedItem);
            }
            return;
        }
        this.graphReporter.registerAnnotation(annotation, annotatedItem);
        AnnotationReferenceMarker referenceMarker = new AnnotationReferenceMarker(annotation, annotatedItem);
        annotation.annotation.collectIndexedItems(referenceMarker);
    }

    void markNonStaticDirectMethodAsReachable(DexMethod method, ProgramDefinition context, KeepReason reason) {
        this.handleInvokeOfDirectTarget(method, context, reason);
    }

    void processNewlyInstantiatedClass(DexProgramClass clazz, ProgramMethod context, InstantiationReason instantiationReason, KeepReason keepReason) {
        assert (!clazz.isAnnotation());
        assert (!clazz.isInterface());
        this.analyses.forEach(analysis -> analysis.processNewlyInstantiatedClass(clazz.asProgramClass(), context, this.workList));
        if (!this.markInstantiatedClass(clazz, context, instantiationReason, keepReason)) {
            return;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Class `%s` is instantiated, processing...", clazz);
        }
        this.markTypeAsLive(clazz, this.graphReporter.registerClass(clazz, keepReason));
        this.markDirectAndIndirectClassInitializersAsLive(clazz);
        this.transitionMethodsForInstantiatedClass(clazz);
        this.transitionFieldsForInstantiatedClass(clazz);
        this.transitionDependentItemsForInstantiatedClass(clazz);
    }

    void markAnnotationAsInstantiated(DexProgramClass clazz, GraphReporter.KeepReasonWitness witness) {
        assert (clazz.isAnnotation());
        if (!this.objectAllocationInfoCollection.recordInstantiatedAnnotation(clazz, this.appInfo)) {
            return;
        }
        this.markTypeAsLive(clazz, witness);
        this.transitionDependentItemsForInstantiatedInterface(clazz);
    }

    void markInterfaceAsInstantiated(DexProgramClass clazz, GraphReporter.KeepReasonWitness witness) {
        assert (!clazz.isAnnotation());
        assert (clazz.isInterface());
        if (!this.objectAllocationInfoCollection.recordInstantiatedInterface(clazz, this.appInfo)) {
            return;
        }
        this.markTypeAsLive(clazz, witness);
        this.transitionDependentItemsForInstantiatedInterface(clazz);
    }

    void markFieldAsReachable(ProgramField field, ProgramDefinition context, KeepReason reason) {
        if (((DexEncodedField)field.getDefinition()).isStatic() || this.objectAllocationInfoCollection.isInstantiatedDirectlyOrHasInstantiatedSubtype(field.getHolder())) {
            this.markFieldAsLive(field, context, reason);
        }
        if (this.liveFields.contains(field) || !this.reachableInstanceFields.computeIfAbsent(field.getHolder(), ignore -> ProgramFieldSet.create()).add(field)) {
            this.graphReporter.registerField((DexEncodedField)field.getDefinition(), reason);
            return;
        }
        this.traceFieldDefinition(field);
        this.analyses.forEach(analysis -> analysis.notifyMarkFieldAsReachable(field, this.workList));
    }

    public boolean isFieldReferenced(DexEncodedField field) {
        FieldAccessInfoImpl info = this.fieldAccessInfoCollection.get((DexField)field.getReference());
        return info != null;
    }

    public boolean isFieldReferenced(ProgramField field) {
        return this.isFieldReferenced((DexEncodedField)field.getDefinition());
    }

    public boolean isFieldLive(ProgramField field) {
        return this.liveFields.contains(field);
    }

    public boolean isFieldLive(DexEncodedField field) {
        return this.liveFields.contains(field);
    }

    public boolean isFieldRead(ProgramField field) {
        FieldAccessInfoImpl info = this.fieldAccessInfoCollection.get((DexField)field.getReference());
        return info != null && info.isRead();
    }

    public boolean isFieldWrittenInMethodSatisfying(ProgramField field, Predicate<ProgramMethod> predicate) {
        FieldAccessInfoImpl info = this.fieldAccessInfoCollection.get((DexField)field.getReference());
        return info != null && info.isWrittenInMethodSatisfying(predicate);
    }

    public boolean isFieldWrittenOutsideDefaultConstructor(ProgramField field) {
        FieldAccessInfoImpl info = this.fieldAccessInfoCollection.get((DexField)field.getReference());
        if (info == null) {
            return false;
        }
        DexEncodedMethod defaultInitializer = field.getHolder().getDefaultInitializer();
        return defaultInitializer != null ? info.isWrittenOutside(defaultInitializer) : info.isWritten();
    }

    public boolean isPreconditionForMinimumKeepInfoSatisfied(EnqueuerEvent preconditionEvent) {
        if (preconditionEvent == null || preconditionEvent.isUnconditionalKeepInfoEvent()) {
            return true;
        }
        if (preconditionEvent.isClassEvent()) {
            EnqueuerEvent.ClassEnqueuerEvent classEvent = preconditionEvent.asClassEvent();
            DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(classEvent.getType()));
            if (clazz == null) {
                return false;
            }
            if (preconditionEvent.isLiveClassEvent()) {
                return this.liveTypes.contains(clazz);
            }
            if (preconditionEvent.isInstantiatedClassEvent()) {
                return this.objectAllocationInfoCollection.isInstantiatedDirectlyOrHasInstantiatedSubtype(clazz);
            }
        }
        assert (false);
        return false;
    }

    public boolean isMemberLive(DexEncodedMember<?, ?> member) {
        assert (member != null);
        return member.isDexEncodedField() ? this.liveFields.contains(member.asDexEncodedField()) : this.liveMethods.contains(member.asDexEncodedMethod());
    }

    public boolean isMethodLive(DexEncodedMethod method) {
        return this.liveMethods.contains(method);
    }

    public boolean isMethodLive(ProgramMethod method) {
        return this.isMethodLive((DexEncodedMethod)method.getDefinition());
    }

    public boolean isMethodTargeted(DexEncodedMethod method) {
        return this.targetedMethods.contains(method);
    }

    public boolean isMethodTargeted(ProgramMethod method) {
        return this.isMethodTargeted((DexEncodedMethod)method.getDefinition());
    }

    public boolean isTypeLive(DexClass clazz) {
        return clazz.isProgramClass() ? this.isTypeLive(clazz.asProgramClass()) : this.isNonProgramTypeLive(clazz);
    }

    public boolean isTypeLive(DexProgramClass clazz) {
        return this.liveTypes.contains(clazz);
    }

    public boolean isNonProgramTypeLive(DexClass clazz) {
        assert (!clazz.isProgramClass());
        return this.liveNonProgramTypes.contains(clazz);
    }

    public boolean isReachable(Definition definition) {
        assert (definition != null);
        if (definition.isClass()) {
            return this.isTypeLive(definition.asClass());
        }
        assert (definition.isMember());
        if (definition.getContextClass().isProgramClass()) {
            if (definition.isField()) {
                ProgramField field = definition.asProgramField();
                return this.isFieldLive(field) || this.isFieldReferenced(field);
            }
            assert (definition.isMethod());
            ProgramMethod method = definition.asProgramMethod();
            return this.isMethodLive(method) || this.isMethodTargeted(method);
        }
        return this.isNonProgramTypeLive(definition.getContextClass());
    }

    public void forAllLiveClasses(Consumer<DexProgramClass> consumer) {
        this.liveTypes.getItems().forEach(consumer);
    }

    void markSuperMethodAsReachable(DexMethod reference, ProgramMethod from) {
        DexClassAndMethod target;
        KeepReason reason = KeepReason.targetedBySuperFrom(from);
        MethodResolutionResult.SingleResolutionResult resolution = this.resolveMethod(reference, from, reason);
        if (resolution == null) {
            return;
        }
        if (resolution.getResolvedHolder().isProgramClass()) {
            this.markMethodAsTargeted(new ProgramMethod(resolution.getResolvedHolder().asProgramClass(), resolution.getResolvedMethod()), reason);
        }
        if ((target = resolution.lookupInvokeSuperTarget(from.getHolder(), this.appInfo)) == null) {
            this.failedMethodResolutionTargets.add((DexMethod)resolution.getResolvedMethod().getReference());
            this.analyses.forEach(analyses -> analyses.notifyFailedMethodResolutionTarget(resolution.getResolvedMethod(), this.workList));
            return;
        }
        DexProgramClass clazz = target.getHolder().asProgramClass();
        if (clazz == null) {
            return;
        }
        ProgramMethod method = target.asProgramMethod();
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Adding super constraint from `%s` to `%s`", from, target.getReference());
        }
        if (this.superInvokeDependencies.computeIfAbsent((DexEncodedMethod)from.getDefinition(), ignore -> ProgramMethodSet.create()).add(method) && this.liveMethods.contains(from)) {
            this.markMethodAsTargeted(method, KeepReason.invokedViaSuperFrom(from));
            if (!target.getAccessFlags().isAbstract()) {
                this.markVirtualMethodAsLive(method, KeepReason.invokedViaSuperFrom(from));
            }
        }
    }

    public MainDexInfo traceMainDex(ExecutorService executorService, Timing timing) throws ExecutionException {
        assert (this.analyses.isEmpty());
        assert (this.mode.isMainDexTracing());
        this.rootSet = this.appView.getMainDexRootSet();
        this.includeMinimumKeepInfo(this.rootSet);
        this.trace(executorService, timing);
        this.options.reporter.failIfPendingErrors();
        MainDexInfo.Builder builder = this.appView.appInfo().getMainDexInfo().builder();
        this.liveTypes.getItems().forEach(builder::addRoot);
        if (this.mode.isInitialMainDexTracing()) {
            this.liveMethods.getItems().forEach(method -> builder.addRoot((DexMethod)method.getReference()));
        } else assert (this.appView.appInfo().getMainDexInfo().isTracedMethodRootsCleared() || this.mode.isGenerateMainDexList());
        new MainDexListBuilder(this.appView, builder.getRoots(), builder).run();
        MainDexInfo previousMainDexInfo = this.appInfo.getMainDexInfo();
        return builder.build(previousMainDexInfo);
    }

    public EnqueuerResult traceApplication(RootSetUtils.RootSet rootSet, ExecutorService executorService, Timing timing) throws ExecutionException {
        this.rootSet = rootSet;
        rootSet.pendingMethodMoveInverse.forEach(this.pendingMethodMoveInverse::put);
        if (this.mode.isTreeShaking() && this.appView.options().hasProguardConfiguration() && !this.options.kotlinOptimizationOptions().disableKotlinSpecificOptimizations) {
            this.registerAnalysis(new KotlinMetadataEnqueuerExtension(this.appView, this.enqueuerDefinitionSupplier, this.initialPrunedTypes));
        }
        if (this.appView.options().getProguardConfiguration() != null && this.appView.options().getProguardConfiguration().getKeepAttributes().signature) {
            this.registerAnalysis(new GenericSignatureEnqueuerAnalysis(this.enqueuerDefinitionSupplier));
        }
        this.registerAnalysis(new ApiModelAnalysis(this.appView));
        this.includeMinimumKeepInfo(rootSet);
        if (!this.mode.isInitialTreeShaking() && this.appView.getKeepInfo() != null) {
            EnqueuerEvent.UnconditionalKeepInfoEvent preconditionEvent = EnqueuerEvent.UnconditionalKeepInfoEvent.get();
            this.appView.getKeepInfo().forEachRuleInstance(this.appView, (clazz, minimumKeepInfo) -> this.applyMinimumKeepInfoWhenLive((DexProgramClass)clazz, (EnqueuerEvent)preconditionEvent, (KeepClassInfo.Joiner)minimumKeepInfo), (field, minimumKeepInfo) -> this.applyMinimumKeepInfoWhenLive((ProgramField)field, (EnqueuerEvent)preconditionEvent, (KeepFieldInfo.Joiner)minimumKeepInfo), this::applyMinimumKeepInfoWhenLiveOrTargeted);
        }
        this.enqueueAllIfNotShrinking();
        this.trace(executorService, timing);
        this.options.reporter.failIfPendingErrors();
        this.finalizeLibraryMethodOverrideInformation();
        this.analyses.forEach(analyses -> analyses.done(this));
        assert (this.verifyKeptGraph());
        if (this.mode.isInitialTreeShaking() && this.forceProguardCompatibility) {
            this.appView.setProguardCompatibilityActions(this.proguardCompatibilityActionsBuilder.build());
        } else assert (this.proguardCompatibilityActionsBuilder == null);
        if (this.mode.isWhyAreYouKeeping()) {
            return null;
        }
        return this.createEnqueuerResult(this.appInfo);
    }

    public void applyMinimumKeepInfoWhenLiveOrTargeted(ProgramMethod method, KeepMethodInfo.Joiner minimumKeepInfo) {
        this.applyMinimumKeepInfoWhenLiveOrTargeted(method, minimumKeepInfo, EnqueuerEvent.unconditional());
    }

    void retainAnnotationForFinalTreeShaking(List<AnnotationMatchResult.MatchedAnnotation> matchedAnnotations) {
        assert (this.mode.isInitialTreeShaking());
        if (this.annotationRemoverBuilder != null) {
            for (AnnotationMatchResult.MatchedAnnotation matchedAnnotation : matchedAnnotations) {
                this.annotationRemoverBuilder.retainAnnotation(matchedAnnotation.getAnnotation());
                this.workList.enqueueTraceAnnotationAction(matchedAnnotation.getAnnotatedItem(), matchedAnnotation.getAnnotation(), matchedAnnotation.getAnnotatedKind());
            }
        }
    }

    void markMethodAsKept(ProgramMethod target, KeepReason reason) {
        DexEncodedMethod definition = (DexEncodedMethod)target.getDefinition();
        DexProgramClass holder = target.getHolder();
        DexMethod reference = (DexMethod)target.getReference();
        this.markMethodAsTargeted(target, reason);
        if (definition.isVirtualMethod()) {
            this.markVirtualMethodAsReachable(reference, holder.isInterface(), target, reason);
            if (definition.isNonAbstractVirtualMethod() && this.objectAllocationInfoCollection.isInstantiatedDirectlyOrHasInstantiatedSubtype(holder)) {
                this.markVirtualMethodAsLive(target, reason);
            }
        } else {
            this.markDirectStaticOrConstructorMethodAsLive(target, reason);
        }
    }

    void markFieldAsKept(ProgramField field, KeepReason reason) {
        if (((DexEncodedField)field.getDefinition()).isStatic()) {
            this.markFieldAsLive(field, field, reason);
        } else {
            this.workList.enqueueMarkFieldAsReachableAction(field, field, reason);
        }
    }

    void markMethodAsLive(ProgramMethod method, ProgramDefinition context) {
        assert (this.liveMethods.contains(method));
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        assert (!definition.getOptimizationInfo().forceInline());
        if (definition.isStatic()) {
            this.markDirectAndIndirectClassInitializersAsLive(method.getHolder());
        }
        this.traceNonDesugaredCode(method);
        ProgramMethodSet superCallTargets = this.superInvokeDependencies.get(method.getDefinition());
        if (superCallTargets != null) {
            for (ProgramMethod superCallTarget : superCallTargets) {
                if (Log.ENABLED) {
                    Log.verbose(this.getClass(), "Found super invoke constraint on `%s`.", superCallTarget);
                }
                this.markMethodAsTargeted(superCallTarget, KeepReason.invokedViaSuperFrom(method));
                this.markVirtualMethodAsLive(superCallTarget, KeepReason.invokedViaSuperFrom(method));
            }
        }
        this.analyses.forEach(analysis -> analysis.processNewlyLiveMethod(method, context, this, this.workList));
    }

    void traceMethodDefinitionExcludingCode(ProgramMethod method) {
        this.markReferencedTypesAsLive(method);
        this.processAnnotations(method);
        ((DexEncodedMethod)method.getDefinition()).getParameterAnnotations().forEachAnnotation(annotation -> this.processAnnotation(method, (DexAnnotation)annotation, DexAnnotation.AnnotatedKind.PARAMETER));
        this.applyMinimumKeepInfo(method);
    }

    void traceCode(ProgramMethod method) {
        DefaultEnqueuerUseRegistry registry = this.useRegistryFactory.create(this.appView, method, this, this.appView.apiLevelCompute());
        method.registerCodeReferences(registry);
        this.analyses.forEach(analysis -> analysis.processTracedCode(method, registry, this.workList));
    }

    public static class ResolutionSearchKey {
        private final DexMethod method;
        private final boolean isInterface;

        private ResolutionSearchKey(DexMethod method, boolean isInterface) {
            this.method = method;
            this.isInterface = isInterface;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolutionSearchKey that = (ResolutionSearchKey)o;
            return this.method == that.method && this.isInterface == that.isInterface;
        }

        public int hashCode() {
            return Objects.hash(this.method, this.isInterface);
        }
    }

    public static class EnqueuerDefinitionSupplier {
        private final Enqueuer enqueuer;

        EnqueuerDefinitionSupplier(Enqueuer enqueuer) {
            this.enqueuer = enqueuer;
        }

        public DexClass definitionFor(DexType type, ProgramDefinition context) {
            return this.enqueuer.definitionFor(type, context, (x$0, x$1) -> this.enqueuer.recordNonProgramClass(x$0, x$1), (x$0, x$1) -> this.enqueuer.ignoreMissingClass(x$0, x$1));
        }
    }

    private class AnnotationReferenceMarker
    implements IndexedItemCollection {
        private final ProgramDefinition context;
        private final KeepReason reason;

        private AnnotationReferenceMarker(DexAnnotation annotation, ProgramDefinition context) {
            this.context = context;
            this.reason = KeepReason.referencedInAnnotation(annotation, context);
        }

        @Override
        public boolean addClass(DexProgramClass dexProgramClass) {
            return false;
        }

        @Override
        public boolean addField(DexField fieldReference) {
            Enqueuer.this.recordFieldReference(fieldReference, this.context);
            DexProgramClass holder = Enqueuer.this.getProgramHolderOrNull(fieldReference, this.context);
            if (holder == null) {
                return false;
            }
            ProgramField field = holder.lookupProgramField(fieldReference);
            if (field == null) {
                return false;
            }
            if (field.getReference() != fieldReference) {
                return false;
            }
            if (((DexEncodedField)field.getDefinition()).isStatic()) {
                FieldAccessInfoImpl fieldAccessInfo = Enqueuer.this.fieldAccessInfoCollection.contains(fieldReference) ? Enqueuer.this.fieldAccessInfoCollection.get(fieldReference) : Enqueuer.this.fieldAccessInfoCollection.extend(fieldReference, new FieldAccessInfoImpl(fieldReference));
                fieldAccessInfo.setReadFromAnnotation();
                Enqueuer.this.markFieldAsLive(field, this.context, this.reason);
                if (Enqueuer.this.options.isGeneratingClassFiles() && field.getHolder().isEnum()) {
                    Enqueuer.this.markEnumValuesAsReachable(field.getHolder(), this.reason);
                }
            } else {
                Enqueuer.this.workList.enqueueMarkFieldAsReachableAction(field, this.context, this.reason);
            }
            return false;
        }

        @Override
        public boolean addMethod(DexMethod method) {
            Enqueuer.this.recordMethodReference(method, this.context);
            DexProgramClass holder = Enqueuer.this.getProgramHolderOrNull(method, this.context);
            if (holder == null) {
                return false;
            }
            DexEncodedMethod target = holder.lookupDirectMethod(method);
            if (target != null) {
                if (target.getReference() == method) {
                    Enqueuer.this.markDirectStaticOrConstructorMethodAsLive(new ProgramMethod(holder, target), this.reason);
                }
            } else {
                target = holder.lookupVirtualMethod(method);
                if (target != null && target.getReference() == method) {
                    Enqueuer.this.markMethodAsTargeted(new ProgramMethod(holder, target), this.reason);
                }
            }
            return false;
        }

        @Override
        public boolean addString(DexString string) {
            return false;
        }

        @Override
        public boolean addProto(DexProto proto) {
            return false;
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            return false;
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            return false;
        }

        @Override
        public boolean addType(DexType type) {
            Enqueuer.this.markTypeAsLive(type, this.context, this.reason);
            return false;
        }
    }

    private class LiveMethodsSet {
        private final Set<DexEncodedMethod> items = Sets.newIdentityHashSet();
        private final BiConsumer<DexEncodedMethod, KeepReason> register;

        LiveMethodsSet(BiConsumer<DexEncodedMethod, KeepReason> register) {
            this.register = register;
        }

        boolean add(ProgramMethod method, KeepReason reason) {
            DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
            this.register.accept(definition, reason);
            Enqueuer.this.transitionUnusedInterfaceToLive(method.getHolder());
            return this.items.add(definition);
        }

        boolean contains(DexEncodedMethod method) {
            return this.items.contains(method);
        }

        boolean contains(ProgramMethod method) {
            return this.contains((DexEncodedMethod)method.getDefinition());
        }

        Set<DexEncodedMethod> getItems() {
            return Collections.unmodifiableSet(this.items);
        }
    }

    private class LiveFieldsSet {
        private final Set<DexEncodedField> fields = Sets.newIdentityHashSet();
        private final BiConsumer<DexEncodedField, KeepReason> register;

        LiveFieldsSet(BiConsumer<DexEncodedField, KeepReason> register) {
            this.register = register;
        }

        boolean add(ProgramField field, KeepReason reason) {
            DexEncodedField definition = (DexEncodedField)field.getDefinition();
            this.register.accept(definition, reason);
            Enqueuer.this.transitionUnusedInterfaceToLive(field.getHolder());
            return this.fields.add(definition);
        }

        boolean contains(DexEncodedField field) {
            return this.fields.contains(field);
        }

        boolean contains(ProgramField field) {
            return this.contains((DexEncodedField)field.getDefinition());
        }
    }

    private static class SetWithReportedReason<T> {
        private final Set<T> items = Sets.newIdentityHashSet();
        private final Map<T, List<Action>> deferredActions = new IdentityHashMap<T, List<Action>>();

        private SetWithReportedReason() {
        }

        boolean add(T item, GraphReporter.KeepReasonWitness witness) {
            assert (witness != null);
            if (this.items.add(item)) {
                this.deferredActions.getOrDefault(item, Collections.emptyList()).forEach(Action::execute);
                return true;
            }
            return false;
        }

        boolean contains(T item) {
            return this.items.contains(item);
        }

        boolean registerDeferredAction(T item, Action action) {
            if (!this.items.contains(item)) {
                this.deferredActions.computeIfAbsent(item, ignore -> new ArrayList()).add(action);
                return true;
            }
            return false;
        }

        Set<T> getItems() {
            return Collections.unmodifiableSet(this.items);
        }
    }

    public static class SyntheticAdditions {
        private final CompilationContext.ProcessorContext processorContext;
        private Map<DexMethod, CompilationContext.MethodProcessingContext> methodProcessingContexts = new ConcurrentHashMap<DexMethod, CompilationContext.MethodProcessingContext>();
        private final List<ProgramMethod> desugaredMethods = new LinkedList<ProgramMethod>();
        private final Map<DexMethod, ProgramMethod> liveMethods = new ConcurrentHashMap<DexMethod, ProgramMethod>();
        private final ProgramMethodMap<KeepMethodInfo.Joiner> minimumKeepInfo = ProgramMethodMap.createConcurrent();
        private final Map<DexType, DexClasspathClass> syntheticClasspathClasses = new ConcurrentHashMap<DexType, DexClasspathClass>();
        private final Map<DexProgramClass, Set<DexClass>> injectedInterfaces = new ConcurrentHashMap<DexProgramClass, Set<DexClass>>();
        private final List<Pair<ProgramMethod, Consumer<KeepMethodInfo.Joiner>>> liveMethodsWithKeepActions = new ArrayList<Pair<ProgramMethod, Consumer<KeepMethodInfo.Joiner>>>();

        SyntheticAdditions(CompilationContext.ProcessorContext processorContext) {
            this.processorContext = processorContext;
        }

        CompilationContext.MethodProcessingContext getMethodContext(ProgramMethod method) {
            return this.methodProcessingContexts.computeIfAbsent((DexMethod)method.getReference(), k -> this.processorContext.createMethodProcessingContext(method));
        }

        boolean isEmpty() {
            boolean empty;
            boolean bl = empty = this.desugaredMethods.isEmpty() && this.liveMethods.isEmpty() && this.syntheticClasspathClasses.isEmpty() && this.injectedInterfaces.isEmpty();
            assert (!empty || this.liveMethodsWithKeepActions.isEmpty());
            return empty;
        }

        public void addLiveClasspathClass(DexClasspathClass clazz) {
            DexClasspathClass old = this.syntheticClasspathClasses.put(clazz.type, clazz);
            assert (old == null || old == clazz);
        }

        public void addLiveMethod(ProgramMethod method) {
            DexMethod signature = (DexMethod)((DexEncodedMethod)method.getDefinition()).getReference();
            ProgramMethod old = this.liveMethods.put(signature, method);
            assert (old == null);
        }

        public void addMethodWithDesugaredCodeForTracing(ProgramMethod method) {
            this.desugaredMethods.add(method);
        }

        public void injectInterface(DexProgramClass clazz, DexClass newInterface) {
            Set newInterfaces = this.injectedInterfaces.computeIfAbsent(clazz, ignored -> Sets.newConcurrentHashSet());
            newInterfaces.add(newInterface);
        }

        public void addMinimumKeepInfo(ProgramMethod method, Consumer<KeepMethodInfo.Joiner> consumer) {
            consumer.accept(this.minimumKeepInfo.computeIfAbsent(method, MapUtils.ignoreKey(KeepMethodInfo::newEmptyJoiner)));
        }

        void enqueueWorkItems(Enqueuer enqueuer) {
            assert (enqueuer.mode.isInitialTreeShaking());
            GraphReporter.KeepReasonWitness fakeReason = enqueuer.graphReporter.fakeReportShouldNotBeUsed();
            for (ProgramMethod desugaredMethod : this.desugaredMethods) {
                enqueuer.workList.enqueueTraceCodeAction(desugaredMethod);
            }
            this.liveMethodsWithKeepActions.forEach(item -> enqueuer.keepInfo.joinMethod((ProgramMethod)item.getFirst(), (Consumer)item.getSecond()));
            for (ProgramMethod liveMethod : this.liveMethods.values()) {
                assert (!enqueuer.targetedMethods.contains((DexEncodedMethod)liveMethod.getDefinition()));
                enqueuer.markMethodAsTargeted(liveMethod, fakeReason);
                enqueuer.workList.enqueueMarkMethodLiveAction(liveMethod, liveMethod, fakeReason);
            }
            enqueuer.liveNonProgramTypes.addAll(this.syntheticClasspathClasses.values());
            this.injectedInterfaces.forEach((clazz, itfs) -> enqueuer.objectAllocationInfoCollection.injectInterfaces(enqueuer.appInfo(), (DexProgramClass)clazz, (Set<DexClass>)itfs));
            this.minimumKeepInfo.forEach((method, minimumKeepInfoForMethod) -> enqueuer.applyMinimumKeepInfoWhenLiveOrTargeted((ProgramMethod)method, (KeepMethodInfo.Joiner)minimumKeepInfoForMethod));
        }
    }

    static class FieldAccessMetadata {
        private static int FROM_METHOD_HANDLE_MASK = 1;
        private static int FROM_RECORD_METHOD_HANDLE_MASK = 2;
        static FieldAccessMetadata DEFAULT = new FieldAccessMetadata(0);
        static FieldAccessMetadata FROM_METHOD_HANDLE = new FieldAccessMetadata(FROM_METHOD_HANDLE_MASK);
        static FieldAccessMetadata FROM_RECORD_METHOD_HANDLE = new FieldAccessMetadata(FROM_RECORD_METHOD_HANDLE_MASK);
        private final int flags;

        FieldAccessMetadata(int flags) {
            this.flags = flags;
        }

        boolean isFromMethodHandle() {
            return (this.flags & FROM_METHOD_HANDLE_MASK) != 0;
        }

        boolean isFromRecordMethodHandle() {
            return (this.flags & FROM_RECORD_METHOD_HANDLE_MASK) != 0;
        }
    }

    static enum FieldAccessKind {
        INSTANCE_READ,
        INSTANCE_WRITE,
        STATIC_READ,
        STATIC_WRITE;


        boolean isRead() {
            return this == INSTANCE_READ || this == STATIC_READ;
        }

        boolean isStatic() {
            return this == STATIC_READ || this == STATIC_WRITE;
        }

        boolean isWrite() {
            return !this.isRead();
        }
    }

    public static enum Mode {
        INITIAL_TREE_SHAKING,
        FINAL_TREE_SHAKING,
        INITIAL_MAIN_DEX_TRACING,
        FINAL_MAIN_DEX_TRACING,
        GENERATE_MAIN_DEX_LIST,
        WHY_ARE_YOU_KEEPING;


        public boolean isTreeShaking() {
            return this.isInitialTreeShaking() || this.isFinalTreeShaking();
        }

        public boolean isInitialTreeShaking() {
            return this == INITIAL_TREE_SHAKING;
        }

        public boolean isFinalTreeShaking() {
            return this == FINAL_TREE_SHAKING;
        }

        public boolean isInitialMainDexTracing() {
            return this == INITIAL_MAIN_DEX_TRACING;
        }

        public boolean isFinalMainDexTracing() {
            return this == FINAL_MAIN_DEX_TRACING;
        }

        public boolean isGenerateMainDexList() {
            return this == GENERATE_MAIN_DEX_LIST;
        }

        public boolean isMainDexTracing() {
            return this.isInitialMainDexTracing() || this.isFinalMainDexTracing() || this.isGenerateMainDexList();
        }

        public boolean isWhyAreYouKeeping() {
            return this == WHY_ARE_YOU_KEEPING;
        }
    }
}

