/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.GraphReporter;
import com.android.tools.r8.shaking.InstantiationReason;
import com.android.tools.r8.shaking.KeepReason;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class EnqueuerWorklist {
    final Enqueuer enqueuer;
    final Queue<EnqueuerAction> queue;

    public static EnqueuerWorklist createWorklist(Enqueuer enqueuer) {
        return new PushableEnqueuerWorkList(enqueuer);
    }

    private EnqueuerWorklist(Enqueuer enqueuer, Queue<EnqueuerAction> queue) {
        this.enqueuer = enqueuer;
        this.queue = queue;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public EnqueuerAction poll() {
        return this.queue.poll();
    }

    abstract EnqueuerWorklist nonPushable();

    abstract boolean enqueueAssertAction(Action var1);

    abstract void enqueueMarkReachableDirectAction(DexMethod var1, ProgramDefinition var2, KeepReason var3);

    abstract void enqueueMarkReachableSuperAction(DexMethod var1, ProgramMethod var2);

    public abstract void enqueueMarkFieldAsReachableAction(ProgramField var1, ProgramDefinition var2, KeepReason var3);

    public abstract void enqueueMarkInstantiatedAction(DexProgramClass var1, ProgramMethod var2, InstantiationReason var3, KeepReason var4);

    abstract void enqueueMarkAnnotationInstantiatedAction(DexProgramClass var1, GraphReporter.KeepReasonWitness var2);

    abstract void enqueueMarkInterfaceInstantiatedAction(DexProgramClass var1, GraphReporter.KeepReasonWitness var2);

    abstract boolean enqueueMarkMethodLiveAction(ProgramMethod var1, ProgramDefinition var2, KeepReason var3);

    abstract void enqueueMarkMethodKeptAction(ProgramMethod var1, KeepReason var2);

    abstract void enqueueMarkFieldKeptAction(ProgramField var1, GraphReporter.KeepReasonWitness var2);

    abstract void enqueueTraceAnnotationAction(ProgramDefinition var1, DexAnnotation var2, DexAnnotation.AnnotatedKind var3);

    public abstract void enqueueTraceCodeAction(ProgramMethod var1);

    public abstract void enqueueTraceConstClassAction(DexType var1, ProgramMethod var2, boolean var3);

    public abstract void enqueueTraceInvokeDirectAction(DexMethod var1, ProgramMethod var2);

    public abstract void enqueueTraceInvokeStaticAction(DexMethod var1, ProgramMethod var2);

    public abstract void enqueueTraceNewInstanceAction(DexType var1, ProgramMethod var2);

    public abstract void enqueueTraceStaticFieldRead(DexField var1, ProgramMethod var2);

    public static class NonPushableEnqueuerWorklist
    extends EnqueuerWorklist {
        private NonPushableEnqueuerWorklist(PushableEnqueuerWorkList workList) {
            super(workList.enqueuer, workList.queue);
        }

        private Unreachable attemptToEnqueue() {
            throw new Unreachable("Attempt to enqueue an action in a non pushable enqueuer work list.");
        }

        @Override
        EnqueuerWorklist nonPushable() {
            return this;
        }

        @Override
        boolean enqueueAssertAction(Action assertion) {
            assertion.execute();
            return true;
        }

        @Override
        void enqueueMarkReachableDirectAction(DexMethod method, ProgramDefinition context, KeepReason reason) {
            throw this.attemptToEnqueue();
        }

        @Override
        void enqueueMarkReachableSuperAction(DexMethod method, ProgramMethod from) {
            throw this.attemptToEnqueue();
        }

        @Override
        public void enqueueMarkFieldAsReachableAction(ProgramField field, ProgramDefinition context, KeepReason reason) {
            throw this.attemptToEnqueue();
        }

        @Override
        public void enqueueMarkInstantiatedAction(DexProgramClass clazz, ProgramMethod context, InstantiationReason instantiationReason, KeepReason keepReason) {
            throw this.attemptToEnqueue();
        }

        @Override
        void enqueueMarkAnnotationInstantiatedAction(DexProgramClass clazz, GraphReporter.KeepReasonWitness reason) {
            throw this.attemptToEnqueue();
        }

        @Override
        void enqueueMarkInterfaceInstantiatedAction(DexProgramClass clazz, GraphReporter.KeepReasonWitness reason) {
            throw this.attemptToEnqueue();
        }

        @Override
        boolean enqueueMarkMethodLiveAction(ProgramMethod method, ProgramDefinition context, KeepReason reason) {
            if (!this.enqueuer.addLiveMethod(method, reason)) {
                return false;
            }
            throw this.attemptToEnqueue();
        }

        @Override
        void enqueueMarkMethodKeptAction(ProgramMethod method, KeepReason reason) {
            throw this.attemptToEnqueue();
        }

        @Override
        void enqueueMarkFieldKeptAction(ProgramField field, GraphReporter.KeepReasonWitness witness) {
            throw this.attemptToEnqueue();
        }

        @Override
        void enqueueTraceAnnotationAction(ProgramDefinition annotatedItem, DexAnnotation annotation, DexAnnotation.AnnotatedKind annotatedKind) {
            throw this.attemptToEnqueue();
        }

        @Override
        public void enqueueTraceCodeAction(ProgramMethod method) {
            throw this.attemptToEnqueue();
        }

        @Override
        public void enqueueTraceConstClassAction(DexType type, ProgramMethod context, boolean ignoreCompatRules) {
            throw this.attemptToEnqueue();
        }

        @Override
        public void enqueueTraceInvokeDirectAction(DexMethod invokedMethod, ProgramMethod context) {
            throw this.attemptToEnqueue();
        }

        @Override
        public void enqueueTraceInvokeStaticAction(DexMethod invokedMethod, ProgramMethod context) {
            throw this.attemptToEnqueue();
        }

        @Override
        public void enqueueTraceNewInstanceAction(DexType type, ProgramMethod context) {
            throw this.attemptToEnqueue();
        }

        @Override
        public void enqueueTraceStaticFieldRead(DexField field, ProgramMethod context) {
            throw this.attemptToEnqueue();
        }
    }

    static class PushableEnqueuerWorkList
    extends EnqueuerWorklist {
        PushableEnqueuerWorkList(Enqueuer enqueuer) {
            super(enqueuer, new ConcurrentLinkedQueue());
        }

        @Override
        EnqueuerWorklist nonPushable() {
            return new NonPushableEnqueuerWorklist(this);
        }

        @Override
        boolean enqueueAssertAction(Action assertion) {
            if (InternalOptions.assertionsEnabled()) {
                this.queue.add(new AssertAction(assertion));
            }
            return true;
        }

        @Override
        void enqueueMarkReachableDirectAction(DexMethod method, ProgramDefinition context, KeepReason reason) {
            this.queue.add(new MarkReachableDirectAction(method, context, reason));
        }

        @Override
        void enqueueMarkReachableSuperAction(DexMethod method, ProgramMethod from) {
            this.queue.add(new MarkReachableSuperAction(method, from));
        }

        @Override
        public void enqueueMarkFieldAsReachableAction(ProgramField field, ProgramDefinition context, KeepReason reason) {
            this.queue.add(new MarkFieldAsReachableAction(field, context, reason));
        }

        @Override
        public void enqueueMarkInstantiatedAction(DexProgramClass clazz, ProgramMethod context, InstantiationReason instantiationReason, KeepReason keepReason) {
            assert (!clazz.isAnnotation());
            assert (!clazz.isInterface());
            this.queue.add(new MarkInstantiatedAction(clazz, context, instantiationReason, keepReason));
        }

        @Override
        void enqueueMarkAnnotationInstantiatedAction(DexProgramClass clazz, GraphReporter.KeepReasonWitness reason) {
            assert (clazz.isAnnotation());
            assert (clazz.isInterface());
            this.queue.add(new MarkAnnotationInstantiatedAction(clazz, reason));
        }

        @Override
        void enqueueMarkInterfaceInstantiatedAction(DexProgramClass clazz, GraphReporter.KeepReasonWitness reason) {
            assert (!clazz.isAnnotation());
            assert (clazz.isInterface());
            this.queue.add(new MarkInterfaceInstantiatedAction(clazz, reason));
        }

        @Override
        boolean enqueueMarkMethodLiveAction(ProgramMethod method, ProgramDefinition context, KeepReason reason) {
            if (this.enqueuer.addLiveMethod(method, reason)) {
                this.queue.add(new MarkMethodLiveAction(method, context));
                if (!this.enqueuer.isMethodTargeted(method)) {
                    this.queue.add(new TraceMethodDefinitionExcludingCodeAction(method));
                }
                return true;
            }
            return false;
        }

        @Override
        void enqueueMarkMethodKeptAction(ProgramMethod method, KeepReason reason) {
            this.queue.add(new MarkMethodKeptAction(method, reason));
        }

        @Override
        void enqueueMarkFieldKeptAction(ProgramField field, GraphReporter.KeepReasonWitness witness) {
            this.queue.add(new MarkFieldKeptAction(field, witness));
        }

        @Override
        void enqueueTraceAnnotationAction(ProgramDefinition annotatedItem, DexAnnotation annotation, DexAnnotation.AnnotatedKind annotatedKind) {
            this.queue.add(new TraceAnnotationAction(annotatedItem, annotation, annotatedKind));
        }

        @Override
        public void enqueueTraceCodeAction(ProgramMethod method) {
            this.queue.add(new TraceCodeAction(method));
        }

        @Override
        public void enqueueTraceConstClassAction(DexType type, ProgramMethod context, boolean ignoreCompatRules) {
            this.queue.add(new TraceConstClassAction(type, context, ignoreCompatRules));
        }

        @Override
        public void enqueueTraceInvokeDirectAction(DexMethod invokedMethod, ProgramMethod context) {
            this.queue.add(new TraceInvokeDirectAction(invokedMethod, context));
        }

        @Override
        public void enqueueTraceInvokeStaticAction(DexMethod invokedMethod, ProgramMethod context) {
            this.queue.add(new TraceInvokeStaticAction(invokedMethod, context));
        }

        @Override
        public void enqueueTraceNewInstanceAction(DexType type, ProgramMethod context) {
            this.queue.add(new TraceNewInstanceAction(type, context));
        }

        @Override
        public void enqueueTraceStaticFieldRead(DexField field, ProgramMethod context) {
            this.queue.add(new TraceStaticFieldReadAction(field, context));
        }
    }

    static class TraceStaticFieldReadAction
    extends EnqueuerAction {
        private final DexField field;
        private final ProgramMethod context;

        TraceStaticFieldReadAction(DexField field, ProgramMethod context) {
            this.field = field;
            this.context = context;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.traceStaticFieldRead(this.field, this.context);
        }
    }

    static class TraceNewInstanceAction
    extends EnqueuerAction {
        private final DexType type;
        private final ProgramMethod context;

        TraceNewInstanceAction(DexType type, ProgramMethod context) {
            this.type = type;
            this.context = context;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.traceNewInstance(this.type, this.context);
        }
    }

    static class TraceMethodDefinitionExcludingCodeAction
    extends EnqueuerAction {
        private final ProgramMethod method;

        TraceMethodDefinitionExcludingCodeAction(ProgramMethod method) {
            this.method = method;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.traceMethodDefinitionExcludingCode(this.method);
        }
    }

    static class TraceInvokeStaticAction
    extends EnqueuerAction {
        private final DexMethod invokedMethod;
        private final ProgramMethod context;

        TraceInvokeStaticAction(DexMethod invokedMethod, ProgramMethod context) {
            this.invokedMethod = invokedMethod;
            this.context = context;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.traceInvokeStatic(this.invokedMethod, this.context);
        }
    }

    static class TraceInvokeDirectAction
    extends EnqueuerAction {
        private final DexMethod invokedMethod;
        private final ProgramMethod context;

        TraceInvokeDirectAction(DexMethod invokedMethod, ProgramMethod context) {
            this.invokedMethod = invokedMethod;
            this.context = context;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.traceInvokeDirect(this.invokedMethod, this.context);
        }
    }

    static class TraceConstClassAction
    extends EnqueuerAction {
        private final DexType type;
        private final ProgramMethod context;
        private final boolean ignoreCompatRules;

        TraceConstClassAction(DexType type, ProgramMethod context, boolean ignoreCompatRules) {
            this.type = type;
            this.context = context;
            this.ignoreCompatRules = ignoreCompatRules;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.traceConstClass(this.type, this.context, null, this.ignoreCompatRules);
        }
    }

    static class TraceCodeAction
    extends EnqueuerAction {
        private final ProgramMethod method;

        TraceCodeAction(ProgramMethod method) {
            this.method = method;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.traceCode(this.method);
        }
    }

    static class TraceAnnotationAction
    extends EnqueuerAction {
        private final ProgramDefinition annotatedItem;
        private final DexAnnotation annotation;
        private final DexAnnotation.AnnotatedKind annotatedKind;

        TraceAnnotationAction(ProgramDefinition annotatedItem, DexAnnotation annotation, DexAnnotation.AnnotatedKind annotatedKind) {
            this.annotatedItem = annotatedItem;
            this.annotation = annotation;
            this.annotatedKind = annotatedKind;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.processAnnotation(this.annotatedItem, this.annotation, this.annotatedKind);
        }
    }

    static class MarkFieldKeptAction
    extends EnqueuerAction {
        private final ProgramField field;
        private final GraphReporter.KeepReasonWitness witness;

        public MarkFieldKeptAction(ProgramField field, GraphReporter.KeepReasonWitness witness) {
            this.field = field;
            this.witness = witness;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markFieldAsKept(this.field, this.witness);
        }
    }

    static class MarkMethodKeptAction
    extends EnqueuerAction {
        private final ProgramMethod target;
        private final KeepReason reason;

        public MarkMethodKeptAction(ProgramMethod target, KeepReason reason) {
            this.target = target;
            this.reason = reason;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markMethodAsKept(this.target, this.reason);
        }
    }

    static class MarkMethodLiveAction
    extends EnqueuerAction {
        private final ProgramMethod method;
        private final ProgramDefinition context;

        public MarkMethodLiveAction(ProgramMethod method, ProgramDefinition context) {
            this.method = method;
            this.context = context;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markMethodAsLive(this.method, this.context);
        }
    }

    static class MarkInterfaceInstantiatedAction
    extends EnqueuerAction {
        private final DexProgramClass target;
        private final GraphReporter.KeepReasonWitness reason;

        public MarkInterfaceInstantiatedAction(DexProgramClass target, GraphReporter.KeepReasonWitness reason) {
            this.target = target;
            this.reason = reason;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markInterfaceAsInstantiated(this.target, this.reason);
        }
    }

    static class MarkAnnotationInstantiatedAction
    extends EnqueuerAction {
        private final DexProgramClass target;
        private final GraphReporter.KeepReasonWitness reason;

        public MarkAnnotationInstantiatedAction(DexProgramClass target, GraphReporter.KeepReasonWitness reason) {
            this.target = target;
            this.reason = reason;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markAnnotationAsInstantiated(this.target, this.reason);
        }
    }

    static class MarkInstantiatedAction
    extends EnqueuerAction {
        private final DexProgramClass target;
        private final ProgramMethod context;
        private final InstantiationReason instantiationReason;
        private final KeepReason keepReason;

        public MarkInstantiatedAction(DexProgramClass target, ProgramMethod context, InstantiationReason instantiationReason, KeepReason keepReason) {
            this.target = target;
            this.context = context;
            this.instantiationReason = instantiationReason;
            this.keepReason = keepReason;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.processNewlyInstantiatedClass(this.target, this.context, this.instantiationReason, this.keepReason);
        }
    }

    static class MarkFieldAsReachableAction
    extends EnqueuerAction {
        private final ProgramField field;
        private final ProgramDefinition context;
        private final KeepReason reason;

        public MarkFieldAsReachableAction(ProgramField field, ProgramDefinition context, KeepReason reason) {
            this.field = field;
            this.context = context;
            this.reason = reason;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markFieldAsReachable(this.field, this.context, this.reason);
        }
    }

    static class MarkReachableSuperAction
    extends EnqueuerAction {
        private final DexMethod target;
        private final ProgramMethod context;

        public MarkReachableSuperAction(DexMethod target, ProgramMethod context) {
            this.target = target;
            this.context = context;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markSuperMethodAsReachable(this.target, this.context);
        }
    }

    static class MarkReachableDirectAction
    extends EnqueuerAction {
        private final DexMethod target;
        private final ProgramDefinition context;
        private final KeepReason reason;

        MarkReachableDirectAction(DexMethod target, ProgramDefinition context, KeepReason reason) {
            this.target = target;
            this.context = context;
            this.reason = reason;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markNonStaticDirectMethodAsReachable(this.target, this.context, this.reason);
        }
    }

    static class AssertAction
    extends EnqueuerAction {
        private final Action assertion;

        AssertAction(Action assertion) {
            this.assertion = assertion;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            this.assertion.execute();
        }
    }

    public static abstract class EnqueuerAction {
        public abstract void run(Enqueuer var1);
    }
}

