/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.AbstractAccessContexts;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.FieldAccessInfoCollectionImpl;
import com.android.tools.r8.graph.FieldAccessInfoImpl;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.IdentityHashMap;
import java.util.Map;

public class FieldAccessInfoCollectionModifier {
    private final Map<DexField, FieldAccessContexts> newFieldAccessContexts;

    private FieldAccessInfoCollectionModifier(Map<DexField, FieldAccessContexts> newFieldAccessContexts) {
        this.newFieldAccessContexts = newFieldAccessContexts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void modify(AppView<AppInfoWithLiveness> appView) {
        FieldAccessInfoCollectionImpl impl = appView.appInfo().getMutableFieldAccessInfoCollection();
        this.newFieldAccessContexts.forEach((field, accessContexts) -> {
            FieldAccessInfoImpl fieldAccessInfo = new FieldAccessInfoImpl((DexField)field);
            fieldAccessInfo.setReadsWithContexts(((FieldAccessContexts)accessContexts).readsWithContexts);
            fieldAccessInfo.setWritesWithContexts(((FieldAccessContexts)accessContexts).writesWithContexts);
            impl.extend((DexField)field, fieldAccessInfo);
        });
    }

    public static class Builder {
        private final Map<DexField, FieldAccessContexts> newFieldAccessContexts = new IdentityHashMap<DexField, FieldAccessContexts>();

        private FieldAccessContexts getFieldAccessContexts(DexField field) {
            return this.newFieldAccessContexts.computeIfAbsent(field, ignore -> new FieldAccessContexts());
        }

        public void recordFieldReadInContext(DexField field, ProgramMethod context) {
            this.getFieldAccessContexts(field).addReadContext(field, context);
        }

        public Builder recordFieldReadInUnknownContext(DexField field) {
            this.getFieldAccessContexts(field).recordReadInUnknownContext();
            return this;
        }

        public void recordFieldWrittenInContext(DexField field, ProgramMethod context) {
            this.getFieldAccessContexts(field).addWriteContext(field, context);
        }

        public void recordFieldWriteInUnknownContext(DexField field) {
            this.getFieldAccessContexts(field).recordWriteInUnknownContext();
        }

        public FieldAccessInfoCollectionModifier build() {
            return new FieldAccessInfoCollectionModifier(this.newFieldAccessContexts);
        }
    }

    private static class FieldAccessContexts {
        private AbstractAccessContexts readsWithContexts = AbstractAccessContexts.empty();
        private AbstractAccessContexts writesWithContexts = AbstractAccessContexts.empty();

        private FieldAccessContexts() {
        }

        void addReadContext(DexField field, ProgramMethod context) {
            if (this.readsWithContexts.isBottom()) {
                AbstractAccessContexts.ConcreteAccessContexts concreteReadContexts = new AbstractAccessContexts.ConcreteAccessContexts();
                concreteReadContexts.recordAccess(field, context);
                this.readsWithContexts = concreteReadContexts;
            } else if (this.readsWithContexts.isConcrete()) {
                this.readsWithContexts.asConcrete().recordAccess(field, context);
            } else assert (this.readsWithContexts.isTop());
        }

        void recordReadInUnknownContext() {
            this.readsWithContexts = AbstractAccessContexts.unknown();
        }

        void addWriteContext(DexField field, ProgramMethod context) {
            if (this.writesWithContexts.isBottom()) {
                AbstractAccessContexts.ConcreteAccessContexts concreteWriteContexts = new AbstractAccessContexts.ConcreteAccessContexts();
                concreteWriteContexts.recordAccess(field, context);
                this.writesWithContexts = concreteWriteContexts;
            } else if (this.writesWithContexts.isConcrete()) {
                this.writesWithContexts.asConcrete().recordAccess(field, context);
            } else assert (this.writesWithContexts.isTop());
        }

        void recordWriteInUnknownContext() {
            this.writesWithContexts = AbstractAccessContexts.unknown();
        }
    }
}

