/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.experimental.graphinfo.AnnotationGraphNode;
import com.android.tools.r8.experimental.graphinfo.ClassGraphNode;
import com.android.tools.r8.experimental.graphinfo.FieldGraphNode;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.experimental.graphinfo.GraphEdgeInfo;
import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.experimental.graphinfo.KeepRuleGraphNode;
import com.android.tools.r8.experimental.graphinfo.MethodGraphNode;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.itf.InterfaceDesugaringSyntheticHelper;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.shaking.CollectingGraphConsumer;
import com.android.tools.r8.shaking.InstantiatedObject;
import com.android.tools.r8.shaking.KeepReason;
import com.android.tools.r8.shaking.ProguardIfRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleBase;
import com.android.tools.r8.utils.DequeUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphReporter {
    private final AppView<?> appView;
    private final InternalOptions options;
    private final GraphConsumer keptGraphConsumer;
    private final CollectingGraphConsumer verificationGraphConsumer;
    private final Map<DexAnnotation, AnnotationGraphNode> annotationNodes = new IdentityHashMap<DexAnnotation, AnnotationGraphNode>();
    private final Map<DexType, ClassGraphNode> classNodes = new IdentityHashMap<DexType, ClassGraphNode>();
    private final Map<DexMethod, MethodGraphNode> methodNodes = new IdentityHashMap<DexMethod, MethodGraphNode>();
    private final Map<DexField, FieldGraphNode> fieldNodes = new IdentityHashMap<DexField, FieldGraphNode>();
    private final Map<ProguardKeepRuleBase, KeepRuleGraphNode> ruleNodes = new IdentityHashMap<ProguardKeepRuleBase, KeepRuleGraphNode>();
    private final Map<GraphEdgeInfo.EdgeKind, GraphEdgeInfo> reasonInfo = new IdentityHashMap<GraphEdgeInfo.EdgeKind, GraphEdgeInfo>();

    GraphReporter(AppView<?> appView, GraphConsumer keptGraphConsumer) {
        this.appView = appView;
        this.options = appView.options();
        if (appView.options().testing.verifyKeptGraphInfo) {
            this.verificationGraphConsumer = new CollectingGraphConsumer(keptGraphConsumer);
            this.keptGraphConsumer = this.verificationGraphConsumer;
        } else {
            this.verificationGraphConsumer = null;
            this.keptGraphConsumer = keptGraphConsumer;
        }
    }

    private GraphEdgeInfo.EdgeKind reportPrecondition(KeepRuleGraphNode keepRuleGraphNode) {
        if (keepRuleGraphNode.getPreconditions().isEmpty()) {
            return GraphEdgeInfo.EdgeKind.KeepRule;
        }
        for (GraphNode precondition : keepRuleGraphNode.getPreconditions()) {
            this.reportEdge(precondition, keepRuleGraphNode, GraphEdgeInfo.EdgeKind.KeepRulePrecondition);
        }
        return GraphEdgeInfo.EdgeKind.ConditionalKeepRule;
    }

    private KeepReasonWitness reportEdge(GraphNode source, GraphNode target, GraphEdgeInfo.EdgeKind kind) {
        assert (this.keptGraphConsumer != null);
        this.keptGraphConsumer.acceptEdge(source, target, this.getEdgeInfo(kind));
        return KeepReasonWitness.INSTANCE;
    }

    private boolean hasKeptGraphConsumer() {
        return this.keptGraphConsumer != null;
    }

    private boolean skipReporting(KeepReason reason) {
        assert (reason != null);
        if (reason == KeepReasonWitness.INSTANCE) {
            return true;
        }
        assert (this.getSourceNode(reason) != null);
        return !this.hasKeptGraphConsumer();
    }

    private KeepReasonWitness registerEdge(GraphNode target, KeepReason reason) {
        assert (!this.skipReporting(reason));
        GraphNode sourceNode = this.getSourceNode(reason);
        if (!sourceNode.isLibraryNode()) {
            GraphEdgeInfo edgeInfo = this.getEdgeInfo(reason);
            this.keptGraphConsumer.acceptEdge(sourceNode, target, edgeInfo);
        }
        return KeepReasonWitness.INSTANCE;
    }

    private boolean isNonProgramClass(DexType type) {
        DexClass clazz = this.appView.definitionFor(type);
        return clazz == null || clazz.isNotProgramClass();
    }

    private GraphNode getSourceNode(KeepReason reason) {
        return reason.getSourceNode(this);
    }

    private DexClass definitionFor(DexType type) {
        return ((AppInfo)this.appView.appInfo()).definitionForWithoutExistenceAssert(type);
    }

    public KeepReasonWitness fakeReportShouldNotBeUsed() {
        return KeepReasonWitness.INSTANCE;
    }

    public boolean verifyRootedPath(DexProgramClass liveType) {
        assert (this.verificationGraphConsumer != null);
        ClassGraphNode node = this.getClassGraphNode(liveType.type);
        Set<GraphNode> seen = Sets.newIdentityHashSet();
        Deque<ClassGraphNode> targets = DequeUtils.newArrayDeque(node);
        while (!targets.isEmpty()) {
            KeepRuleGraphNode rule;
            GraphNode item = targets.pop();
            if (item instanceof KeepRuleGraphNode && (rule = (KeepRuleGraphNode)item).getPreconditions().isEmpty()) {
                return true;
            }
            if (!seen.add(item)) continue;
            Map<GraphNode, Set<GraphEdgeInfo>> sources = this.verificationGraphConsumer.getSourcesTargeting(item);
            assert (sources != null) : "No sources set for " + item;
            assert (!sources.isEmpty()) : "Empty sources set for " + item;
            targets.addAll(sources.keySet());
        }
        assert (false) : "No rooted path to " + liveType.type;
        return false;
    }

    KeepReasonWitness reportKeepClass(DexDefinition precondition, ProguardKeepRuleBase rule, DexProgramClass clazz) {
        if (this.keptGraphConsumer != null) {
            KeepRuleGraphNode ruleNode = this.getKeepRuleGraphNode(precondition, rule);
            GraphEdgeInfo.EdgeKind edgeKind = this.reportPrecondition(ruleNode);
            return this.reportEdge(ruleNode, this.getClassGraphNode(clazz.type), edgeKind);
        }
        return KeepReasonWitness.INSTANCE;
    }

    KeepReasonWitness reportKeepClass(DexDefinition precondition, Collection<ProguardKeepRuleBase> rules, DexProgramClass clazz) {
        assert (!rules.isEmpty() || !this.options.isShrinking());
        if (this.keptGraphConsumer != null) {
            for (ProguardKeepRuleBase rule : rules) {
                this.reportKeepClass(precondition, rule, clazz);
            }
        }
        return KeepReasonWitness.INSTANCE;
    }

    KeepReasonWitness reportKeepMethod(DexDefinition precondition, ProguardKeepRuleBase rule, DexEncodedMethod method) {
        if (this.keptGraphConsumer != null) {
            KeepRuleGraphNode ruleNode = this.getKeepRuleGraphNode(precondition, rule);
            GraphEdgeInfo.EdgeKind edgeKind = this.reportPrecondition(ruleNode);
            return this.reportEdge(ruleNode, this.getMethodGraphNode((DexMethod)method.getReference()), edgeKind);
        }
        return KeepReasonWitness.INSTANCE;
    }

    KeepReasonWitness reportKeepMethod(DexDefinition precondition, Collection<ProguardKeepRuleBase> rules, DexEncodedMethod method) {
        assert (!rules.isEmpty() || !this.options.isShrinking());
        if (this.keptGraphConsumer != null) {
            for (ProguardKeepRuleBase rule : rules) {
                this.reportKeepMethod(precondition, rule, method);
            }
        }
        return KeepReasonWitness.INSTANCE;
    }

    KeepReasonWitness reportKeepField(DexDefinition precondition, ProguardKeepRuleBase rule, DexEncodedField field) {
        if (this.keptGraphConsumer != null) {
            KeepRuleGraphNode ruleNode = this.getKeepRuleGraphNode(precondition, rule);
            GraphEdgeInfo.EdgeKind edgeKind = this.reportPrecondition(ruleNode);
            return this.reportEdge(ruleNode, this.getFieldGraphNode((DexField)field.getReference()), edgeKind);
        }
        return KeepReasonWitness.INSTANCE;
    }

    KeepReasonWitness reportKeepField(DexDefinition precondition, Collection<ProguardKeepRuleBase> rules, DexEncodedField field) {
        assert (!rules.isEmpty() || !this.options.isShrinking());
        if (this.keptGraphConsumer != null) {
            for (ProguardKeepRuleBase rule : rules) {
                this.reportKeepField(precondition, rule, field);
            }
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportCompatKeepDefaultInitializer(ProgramMethod defaultInitializer) {
        assert (defaultInitializer.getHolder().getDefaultInitializer() == defaultInitializer.getDefinition());
        if (this.keptGraphConsumer != null) {
            this.reportEdge(this.getClassGraphNode(defaultInitializer.getHolderType()), this.getMethodGraphNode((DexMethod)defaultInitializer.getReference()), GraphEdgeInfo.EdgeKind.CompatibilityRule);
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportCompatKeepMethod(ProgramMethod method) {
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportCompatInstantiated(DexProgramClass instantiated, ProgramMethod method) {
        if (this.keptGraphConsumer != null) {
            this.reportEdge(this.getMethodGraphNode((DexMethod)method.getReference()), this.getClassGraphNode(instantiated.type), GraphEdgeInfo.EdgeKind.CompatibilityRule);
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportClassReferencedFrom(DexProgramClass clazz, ProgramDefinition context) {
        if (context.isProgramClass()) {
            return this.reportClassReferencedFrom(clazz, context.asProgramClass());
        }
        if (context.isProgramField()) {
            return this.reportClassReferencedFrom(clazz, context.asProgramField());
        }
        assert (context.isProgramMethod());
        return this.reportClassReferencedFrom(clazz, context.asProgramMethod());
    }

    public KeepReasonWitness reportClassReferencedFrom(DexProgramClass clazz, DexProgramClass implementer) {
        if (this.keptGraphConsumer != null) {
            ClassGraphNode source = this.getClassGraphNode(implementer.type);
            ClassGraphNode target = this.getClassGraphNode(clazz.type);
            return this.reportEdge(source, target, GraphEdgeInfo.EdgeKind.ReferencedFrom);
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportClassReferencedFrom(DexProgramClass clazz, ProgramMethod method) {
        if (this.keptGraphConsumer != null) {
            MethodGraphNode source = this.getMethodGraphNode((DexMethod)method.getReference());
            ClassGraphNode target = this.getClassGraphNode(clazz.type);
            return this.reportEdge(source, target, GraphEdgeInfo.EdgeKind.ReferencedFrom);
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportClassReferencedFrom(DexProgramClass clazz, ProgramField field) {
        if (this.keptGraphConsumer != null) {
            FieldGraphNode source = this.getFieldGraphNode((DexField)field.getReference());
            ClassGraphNode target = this.getClassGraphNode(clazz.type);
            return this.reportEdge(source, target, GraphEdgeInfo.EdgeKind.ReferencedFrom);
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportReachableClassInitializer(DexProgramClass clazz, ProgramMethod initializer) {
        if (initializer != null) {
            assert (((DexEncodedMethod)initializer.getDefinition()).isClassInitializer());
            if (this.keptGraphConsumer != null) {
                ClassGraphNode source = this.getClassGraphNode(clazz.type);
                MethodGraphNode target = this.getMethodGraphNode((DexMethod)initializer.getReference());
                return this.reportEdge(source, target, GraphEdgeInfo.EdgeKind.ReachableFromLiveType);
            }
        } else assert (!clazz.hasClassInitializer());
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportReachableMethodAsLive(DexMethod overriddenMethod, ProgramMethod derivedMethod) {
        if (this.keptGraphConsumer != null && overriddenMethod != ((DexEncodedMethod)derivedMethod.getDefinition()).getReference()) {
            return this.reportEdge(this.getMethodGraphNode(overriddenMethod), this.getMethodGraphNode((DexMethod)((DexEncodedMethod)derivedMethod.getDefinition()).getReference()), GraphEdgeInfo.EdgeKind.OverridingMethod);
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportLibraryMethodAsLive(InstantiatedObject instantiation, ProgramMethod derivedMethod, DexClass libraryOrClasspathClass) {
        if (this.keptGraphConsumer != null && instantiation.isClass()) {
            return this.reportEdge(this.getClassGraphNode(instantiation.asClass().type), this.getMethodGraphNode((DexMethod)((DexEncodedMethod)derivedMethod.getDefinition()).getReference()), GraphEdgeInfo.EdgeKind.IsLibraryMethod);
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportCompanionClass(DexProgramClass iface, DexProgramClass companion) {
        assert (iface.isInterface());
        assert (InterfaceDesugaringSyntheticHelper.isCompanionClassType(companion.type));
        if (this.keptGraphConsumer == null) {
            return KeepReasonWitness.INSTANCE;
        }
        return this.reportEdge(this.getClassGraphNode(iface.type), this.getClassGraphNode(companion.type), GraphEdgeInfo.EdgeKind.CompanionClass);
    }

    public KeepReasonWitness reportCompanionMethod(DexEncodedMethod definition, DexEncodedMethod implementation) {
        assert (InterfaceDesugaringSyntheticHelper.isCompanionClassType(implementation.getHolderType()));
        if (this.keptGraphConsumer == null) {
            return KeepReasonWitness.INSTANCE;
        }
        return this.reportEdge(this.getMethodGraphNode((DexMethod)definition.getReference()), this.getMethodGraphNode((DexMethod)implementation.getReference()), GraphEdgeInfo.EdgeKind.CompanionMethod);
    }

    public KeepReasonWitness registerInterface(DexProgramClass iface, KeepReason reason) {
        assert (iface.isInterface());
        if (this.skipReporting(reason)) {
            return KeepReasonWitness.INSTANCE;
        }
        return this.registerEdge(this.getClassGraphNode(iface.type), reason);
    }

    public KeepReasonWitness registerClass(DexProgramClass clazz, KeepReason reason) {
        if (this.skipReporting(reason)) {
            return KeepReasonWitness.INSTANCE;
        }
        return this.registerEdge(this.getClassGraphNode(clazz.type), reason);
    }

    public KeepReasonWitness registerAnnotation(DexAnnotation annotation, ProgramDefinition annotatedItem) {
        if (this.hasKeptGraphConsumer()) {
            this.registerEdge(this.getAnnotationGraphNode(annotation, annotatedItem), KeepReason.annotatedOn(annotatedItem.getDefinition()));
            this.registerEdge(this.getClassGraphNode(annotation.getAnnotationType()), KeepReason.referencedInAnnotation(annotation, annotatedItem));
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness registerMethod(DexEncodedMethod method, KeepReason reason) {
        if (this.skipReporting(reason)) {
            return KeepReasonWitness.INSTANCE;
        }
        if (reason.edgeKind() == GraphEdgeInfo.EdgeKind.IsLibraryMethod && this.isNonProgramClass(method.getHolderType())) {
            return KeepReasonWitness.INSTANCE;
        }
        return this.registerEdge(this.getMethodGraphNode((DexMethod)method.getReference()), reason);
    }

    public KeepReasonWitness registerField(DexEncodedField field, KeepReason reason) {
        if (this.skipReporting(reason)) {
            return KeepReasonWitness.INSTANCE;
        }
        return this.registerEdge(this.getFieldGraphNode((DexField)field.getReference()), reason);
    }

    public GraphNode getGraphNode(DexReference reference) {
        if (reference.isDexType()) {
            return this.getClassGraphNode(reference.asDexType());
        }
        if (reference.isDexMethod()) {
            return this.getMethodGraphNode(reference.asDexMethod());
        }
        if (reference.isDexField()) {
            return this.getFieldGraphNode(reference.asDexField());
        }
        throw new Unreachable();
    }

    GraphEdgeInfo getEdgeInfo(KeepReason reason) {
        return this.getEdgeInfo(reason.edgeKind());
    }

    GraphEdgeInfo getEdgeInfo(GraphEdgeInfo.EdgeKind kind) {
        return this.reasonInfo.computeIfAbsent(kind, GraphEdgeInfo::new);
    }

    AnnotationGraphNode getAnnotationGraphNode(DexAnnotation annotation, ProgramDefinition annotatedItem) {
        return this.annotationNodes.computeIfAbsent(annotation, key -> {
            GraphNode annotatedNode = annotatedItem.getReference().apply(this::getClassGraphNode, this::getFieldGraphNode, this::getMethodGraphNode);
            ClassGraphNode annotationClassNode = this.getClassGraphNode(annotation.getAnnotationType());
            return new AnnotationGraphNode(annotatedNode, annotationClassNode);
        });
    }

    ClassGraphNode getClassGraphNode(DexType type) {
        return this.classNodes.computeIfAbsent(type, t -> {
            DexClass definition = this.definitionFor((DexType)t);
            return new ClassGraphNode(definition != null && definition.isNotProgramClass(), Reference.classFromDescriptor(t.toDescriptorString()));
        });
    }

    MethodGraphNode getMethodGraphNode(DexMethod context) {
        return this.methodNodes.computeIfAbsent(context, m3 -> {
            DexClass holderDefinition = this.definitionFor(context.holder);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (DexType param : m3.proto.parameters.values) {
                builder.add(Reference.typeFromDescriptor(param.toDescriptorString()));
            }
            return new MethodGraphNode(holderDefinition != null && holderDefinition.isNotProgramClass(), Reference.method(Reference.classFromDescriptor(m3.holder.toDescriptorString()), m3.name.toString(), (List<TypeReference>)((Object)builder.build()), m3.proto.returnType.isVoidType() ? null : Reference.typeFromDescriptor(m3.proto.returnType.toDescriptorString())));
        });
    }

    FieldGraphNode getFieldGraphNode(DexField context) {
        return this.fieldNodes.computeIfAbsent(context, f -> {
            DexClass holderDefinition = this.definitionFor(context.holder);
            return new FieldGraphNode(holderDefinition != null && holderDefinition.isNotProgramClass(), Reference.field(Reference.classFromDescriptor(f.holder.toDescriptorString()), f.name.toString(), Reference.typeFromDescriptor(f.type.toDescriptorString())));
        });
    }

    KeepRuleGraphNode getKeepRuleGraphNode(DexDefinition precondition, ProguardKeepRuleBase rule) {
        if (rule instanceof ProguardKeepRule) {
            Set preconditions = precondition != null ? Collections.singleton(this.getGraphNode(precondition.getReference())) : Collections.emptySet();
            return this.ruleNodes.computeIfAbsent(rule, key -> new KeepRuleGraphNode(rule, preconditions));
        }
        if (rule instanceof ProguardIfRule) {
            ProguardIfRule ifRule = (ProguardIfRule)rule;
            assert (!ifRule.getPreconditions().isEmpty());
            return this.ruleNodes.computeIfAbsent(ifRule, key -> {
                HashSet<GraphNode> preconditions = new HashSet<GraphNode>(ifRule.getPreconditions().size());
                for (DexReference condition : ifRule.getPreconditions()) {
                    preconditions.add(this.getGraphNode(condition));
                }
                return new KeepRuleGraphNode(ifRule, preconditions);
            });
        }
        throw new Unreachable("Unexpected type of keep rule: " + rule);
    }

    public static class KeepReasonWitness
    extends KeepReason {
        private static KeepReasonWitness INSTANCE = new KeepReasonWitness();

        private KeepReasonWitness() {
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            throw new Unreachable();
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            throw new Unreachable();
        }
    }
}

