/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.shaking.ProguardIfRule;
import java.util.Objects;

public class IfRuleClassPartEquivalence
extends Equivalence<ProguardIfRule> {
    @Override
    protected boolean doEquivalent(ProguardIfRule p1, ProguardIfRule p2) {
        if (!p1.getClassAnnotations().equals(p2.getClassAnnotations())) {
            return false;
        }
        if (!p1.getClassAccessFlags().equals(p2.getClassAccessFlags()) || !p1.getNegatedClassAccessFlags().equals(p2.getNegatedClassAccessFlags())) {
            return false;
        }
        if (p1.getClassType() != p2.getClassType() || p1.getClassTypeNegated() != p2.getClassTypeNegated()) {
            return false;
        }
        if (p1.getInheritanceIsExtends() != p2.getInheritanceIsExtends()) {
            return false;
        }
        if (!p1.getInheritanceAnnotations().equals(p2.getInheritanceAnnotations())) {
            return false;
        }
        if (!Objects.equals(p1.getInheritanceClassName(), p2.getInheritanceClassName())) {
            return false;
        }
        return p1.getClassNames().equals(p2.getClassNames());
    }

    @Override
    protected int doHash(ProguardIfRule rule) {
        int result = rule.getClassAnnotations().hashCode();
        result = 3 * result + rule.getClassAccessFlags().hashCode();
        result = 3 * result + rule.getNegatedClassAccessFlags().hashCode();
        result = 3 * result + (rule.getClassTypeNegated() ? 1 : 0);
        result = 3 * result + (rule.getClassType() != null ? rule.getClassType().hashCode() : 0);
        result = 3 * result + rule.getClassNames().hashCode();
        result = 3 * result + rule.getInheritanceAnnotations().hashCode();
        result = 3 * result + (rule.getInheritanceClassName() != null ? rule.getInheritanceClassName().hashCode() : 0);
        result = 3 * result + (rule.getInheritanceIsImplements() ? 1 : 0);
        result = 3 * result + Iterables.size(rule.subsequentRule.getWildcards());
        return result;
    }
}

