/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.shaking.GlobalKeepInfoConfiguration;
import com.android.tools.r8.shaking.KeepInfo;
import com.android.tools.r8.shaking.KeepMemberInfo;

public final class KeepFieldInfo
extends KeepMemberInfo<Builder, KeepFieldInfo> {
    private static final KeepFieldInfo TOP = (KeepFieldInfo)new Builder().makeTop().build();
    private static final KeepFieldInfo BOTTOM = (KeepFieldInfo)new Builder().makeBottom().build();
    private final boolean allowFieldTypeStrengthening;

    public static KeepFieldInfo top() {
        return TOP;
    }

    public static KeepFieldInfo bottom() {
        return BOTTOM;
    }

    public static Joiner newEmptyJoiner() {
        return KeepFieldInfo.bottom().joiner();
    }

    private KeepFieldInfo(Builder builder) {
        super(builder);
        this.allowFieldTypeStrengthening = builder.isFieldTypeStrengtheningAllowed();
    }

    @Override
    Builder builder() {
        return new Builder(this);
    }

    public boolean isFieldTypeStrengtheningAllowed(GlobalKeepInfoConfiguration configuration) {
        return this.internalIsFieldTypeStrengtheningAllowed();
    }

    boolean internalIsFieldTypeStrengtheningAllowed() {
        return this.allowFieldTypeStrengthening;
    }

    public Joiner joiner() {
        assert (!this.isTop());
        return new Joiner(this);
    }

    @Override
    public boolean isTop() {
        return this.equals(KeepFieldInfo.top());
    }

    @Override
    public boolean isBottom() {
        return this.equals(KeepFieldInfo.bottom());
    }

    public static class Joiner
    extends KeepInfo.Joiner<Joiner, Builder, KeepFieldInfo> {
        public Joiner(KeepFieldInfo info) {
            super(info.builder());
        }

        public Joiner disallowFieldTypeStrengthening() {
            ((Builder)this.builder).disallowFieldTypeStrengthening();
            return this.self();
        }

        @Override
        public Joiner asFieldJoiner() {
            return this;
        }

        @Override
        public Joiner merge(Joiner joiner) {
            return super.merge(joiner).applyIf(!((Builder)joiner.builder).isFieldTypeStrengtheningAllowed(), Joiner::disallowFieldTypeStrengthening);
        }

        @Override
        Joiner self() {
            return this;
        }
    }

    public static class Builder
    extends KeepInfo.Builder<Builder, KeepFieldInfo> {
        private boolean allowFieldTypeStrengthening;

        private Builder() {
        }

        private Builder(KeepFieldInfo original) {
            super(original);
            this.allowFieldTypeStrengthening = original.internalIsFieldTypeStrengtheningAllowed();
        }

        @Override
        public Builder makeTop() {
            return ((Builder)super.makeTop()).disallowFieldTypeStrengthening();
        }

        @Override
        public Builder makeBottom() {
            return ((Builder)super.makeBottom()).allowFieldTypeStrengthening();
        }

        public boolean isFieldTypeStrengtheningAllowed() {
            return this.allowFieldTypeStrengthening;
        }

        public Builder setAllowFieldTypeStrengthening(boolean allowFieldTypeStrengthening) {
            this.allowFieldTypeStrengthening = allowFieldTypeStrengthening;
            return this.self();
        }

        public Builder allowFieldTypeStrengthening() {
            return this.setAllowFieldTypeStrengthening(true);
        }

        public Builder disallowFieldTypeStrengthening() {
            return this.setAllowFieldTypeStrengthening(false);
        }

        @Override
        public KeepFieldInfo getTopInfo() {
            return TOP;
        }

        @Override
        public KeepFieldInfo getBottomInfo() {
            return BOTTOM;
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public boolean isEqualTo(KeepFieldInfo other) {
            return this.internalIsEqualTo(other);
        }

        @Override
        boolean internalIsEqualTo(KeepFieldInfo other) {
            return super.internalIsEqualTo(other) && this.isFieldTypeStrengtheningAllowed() == other.internalIsFieldTypeStrengtheningAllowed();
        }

        @Override
        public KeepFieldInfo doBuild() {
            return new KeepFieldInfo(this);
        }
    }
}

