/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.GlobalKeepInfoConfiguration;
import com.android.tools.r8.shaking.KeepClassInfo;
import com.android.tools.r8.shaking.KeepFieldInfo;
import com.android.tools.r8.shaking.KeepMethodInfo;
import com.android.tools.r8.shaking.ProguardKeepRuleBase;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Set;
import java.util.function.Consumer;

public abstract class KeepInfo<B extends Builder<B, K>, K extends KeepInfo<B, K>> {
    private final boolean allowAccessModification;
    private final boolean allowAnnotationRemoval;
    private final boolean allowMinification;
    private final boolean allowOptimization;
    private final boolean allowShrinking;
    private final boolean allowSignatureRemoval;
    private final boolean checkDiscarded;
    private final boolean requireAccessModificationForRepackaging;

    private KeepInfo(boolean allowAccessModification, boolean allowAnnotationRemoval, boolean allowMinification, boolean allowOptimization, boolean allowShrinking, boolean allowSignatureRemoval, boolean checkDiscarded, boolean requireAccessModificationForRepackaging) {
        this.allowAccessModification = allowAccessModification;
        this.allowAnnotationRemoval = allowAnnotationRemoval;
        this.allowMinification = allowMinification;
        this.allowOptimization = allowOptimization;
        this.allowShrinking = allowShrinking;
        this.allowSignatureRemoval = allowSignatureRemoval;
        this.checkDiscarded = checkDiscarded;
        this.requireAccessModificationForRepackaging = requireAccessModificationForRepackaging;
    }

    KeepInfo(B builder) {
        this(((Builder)builder).isAccessModificationAllowed(), ((Builder)builder).isAnnotationRemovalAllowed(), ((Builder)builder).isMinificationAllowed(), ((Builder)builder).isOptimizationAllowed(), ((Builder)builder).isShrinkingAllowed(), ((Builder)builder).isSignatureRemovalAllowed(), ((Builder)builder).isCheckDiscardedEnabled(), ((Builder)builder).isAccessModificationRequiredForRepackaging());
    }

    public static Joiner<?, ?, ?> newEmptyJoinerFor(DexReference reference) {
        return reference.apply(clazz -> KeepClassInfo.newEmptyJoiner(), field -> KeepFieldInfo.newEmptyJoiner(), method -> KeepMethodInfo.newEmptyJoiner());
    }

    abstract B builder();

    public boolean isAnnotationRemovalAllowed(GlobalKeepInfoConfiguration configuration) {
        return configuration.isAnnotationRemovalEnabled() && this.internalIsAnnotationRemovalAllowed();
    }

    boolean internalIsAnnotationRemovalAllowed() {
        return this.allowAnnotationRemoval;
    }

    public boolean isCheckDiscardedEnabled(GlobalKeepInfoConfiguration configuration) {
        return this.internalIsCheckDiscardedEnabled();
    }

    boolean internalIsCheckDiscardedEnabled() {
        return this.checkDiscarded;
    }

    @Deprecated
    public boolean isPinned(GlobalKeepInfoConfiguration configuration) {
        return !this.isOptimizationAllowed(configuration) || !this.isShrinkingAllowed(configuration);
    }

    public boolean isMinificationAllowed(GlobalKeepInfoConfiguration configuration) {
        return configuration.isMinificationEnabled() && this.internalIsMinificationAllowed();
    }

    boolean internalIsMinificationAllowed() {
        return this.allowMinification;
    }

    public boolean isOptimizationAllowed(GlobalKeepInfoConfiguration configuration) {
        return configuration.isOptimizationEnabled() && this.internalIsOptimizationAllowed();
    }

    boolean internalIsOptimizationAllowed() {
        return this.allowOptimization;
    }

    public boolean isShrinkingAllowed(GlobalKeepInfoConfiguration configuration) {
        return configuration.isTreeShakingEnabled() && this.internalIsShrinkingAllowed();
    }

    boolean internalIsShrinkingAllowed() {
        return this.allowShrinking;
    }

    public boolean isSignatureRemovalAllowed(GlobalKeepInfoConfiguration configuration) {
        if (!configuration.isKeepAttributesSignatureEnabled()) {
            return true;
        }
        return !configuration.isForceProguardCompatibilityEnabled() && this.internalIsSignatureRemovalAllowed();
    }

    boolean internalIsSignatureRemovalAllowed() {
        return this.allowSignatureRemoval;
    }

    public abstract boolean isRepackagingAllowed(ProgramDefinition var1, GlobalKeepInfoConfiguration var2);

    boolean internalIsAccessModificationRequiredForRepackaging() {
        return this.requireAccessModificationForRepackaging;
    }

    public boolean isAccessModificationAllowed(GlobalKeepInfoConfiguration configuration) {
        return configuration.isAccessModificationEnabled() && this.internalIsAccessModificationAllowed();
    }

    boolean internalIsAccessModificationAllowed() {
        return this.allowAccessModification;
    }

    public boolean isEnclosingMethodAttributeRemovalAllowed(GlobalKeepInfoConfiguration configuration, EnclosingMethodAttribute enclosingMethodAttribute, AppView<AppInfoWithLiveness> appView) {
        if (!configuration.isKeepEnclosingMethodAttributeEnabled()) {
            return true;
        }
        if (configuration.isForceProguardCompatibilityEnabled()) {
            return false;
        }
        return !this.isPinned(configuration) || !enclosingMethodAttribute.isEnclosingPinned(appView);
    }

    public boolean isInnerClassesAttributeRemovalAllowed(GlobalKeepInfoConfiguration configuration) {
        if (!configuration.isKeepInnerClassesAttributeEnabled()) {
            return true;
        }
        return !configuration.isForceProguardCompatibilityEnabled() && !this.isPinned(configuration);
    }

    public boolean isInnerClassesAttributeRemovalAllowed(GlobalKeepInfoConfiguration configuration, EnclosingMethodAttribute enclosingMethodAttribute) {
        if (!configuration.isKeepInnerClassesAttributeEnabled()) {
            return true;
        }
        if (configuration.isForceProguardCompatibilityEnabled()) {
            return false;
        }
        return enclosingMethodAttribute == null || !this.isPinned(configuration);
    }

    public abstract boolean isTop();

    public abstract boolean isBottom();

    public boolean isLessThanOrEquals(K other) {
        return !(!this.allowAccessModification && ((KeepInfo)other).internalIsAccessModificationAllowed() || !this.allowAnnotationRemoval && ((KeepInfo)other).internalIsAnnotationRemovalAllowed() || !this.allowMinification && ((KeepInfo)other).internalIsMinificationAllowed() || !this.allowOptimization && ((KeepInfo)other).internalIsOptimizationAllowed() || !this.allowShrinking && ((KeepInfo)other).internalIsShrinkingAllowed() || !this.allowSignatureRemoval && ((KeepInfo)other).internalIsSignatureRemovalAllowed() || this.checkDiscarded && !((KeepInfo)other).internalIsCheckDiscardedEnabled());
    }

    public static abstract class Joiner<J extends Joiner<J, B, K>, B extends Builder<B, K>, K extends KeepInfo<B, K>> {
        final B builder;
        final Set<ProguardKeepRuleBase> rules = Sets.newIdentityHashSet();

        Joiner(B builder) {
            this.builder = builder;
        }

        abstract J self();

        public J applyIf(boolean condition, Consumer<J> thenConsumer) {
            if (condition) {
                thenConsumer.accept(this.self());
            }
            return this.self();
        }

        public KeepClassInfo.Joiner asClassJoiner() {
            return null;
        }

        public KeepFieldInfo.Joiner asFieldJoiner() {
            return null;
        }

        public KeepMethodInfo.Joiner asMethodJoiner() {
            return null;
        }

        public Set<ProguardKeepRuleBase> getRules() {
            return this.rules;
        }

        public boolean isBottom() {
            return ((Builder)this.builder).isEqualTo(((Builder)this.builder).getBottomInfo());
        }

        public boolean isCheckDiscardedEnabled() {
            return ((Builder)this.builder).isCheckDiscardedEnabled();
        }

        public boolean isShrinkingAllowed() {
            return ((Builder)this.builder).isShrinkingAllowed();
        }

        public boolean isTop() {
            return ((Builder)this.builder).isEqualTo(((Builder)this.builder).getTopInfo());
        }

        public J top() {
            ((Builder)this.builder).makeTop();
            return this.self();
        }

        public J addRule(ProguardKeepRuleBase rule) {
            this.rules.add(rule);
            return this.self();
        }

        public J disallowAccessModification() {
            ((Builder)this.builder).disallowAccessModification();
            return this.self();
        }

        public J disallowAnnotationRemoval() {
            ((Builder)this.builder).disallowAnnotationRemoval();
            return this.self();
        }

        public J disallowMinification() {
            ((Builder)this.builder).disallowMinification();
            return this.self();
        }

        public J disallowOptimization() {
            ((Builder)this.builder).disallowOptimization();
            return this.self();
        }

        public J disallowShrinking() {
            ((Builder)this.builder).disallowShrinking();
            return this.self();
        }

        public J disallowSignatureRemoval() {
            ((Builder)this.builder).disallowSignatureRemoval();
            return this.self();
        }

        public J setCheckDiscarded() {
            ((Builder)this.builder).setCheckDiscarded();
            return this.self();
        }

        public J requireAccessModificationForRepackaging() {
            ((Builder)this.builder).requireAccessModificationForRepackaging();
            return this.self();
        }

        public J merge(J joiner) {
            B builder = ((Joiner)joiner).builder;
            this.applyIf(!((Builder)builder).isAccessModificationAllowed(), Joiner::disallowAccessModification);
            this.applyIf(!((Builder)builder).isAnnotationRemovalAllowed(), Joiner::disallowAnnotationRemoval);
            this.applyIf(!((Builder)builder).isMinificationAllowed(), Joiner::disallowMinification);
            this.applyIf(!((Builder)builder).isOptimizationAllowed(), Joiner::disallowOptimization);
            this.applyIf(!((Builder)builder).isShrinkingAllowed(), Joiner::disallowShrinking);
            this.applyIf(!((Builder)builder).isSignatureRemovalAllowed(), Joiner::disallowSignatureRemoval);
            this.applyIf(((Builder)builder).isCheckDiscardedEnabled(), Joiner::setCheckDiscarded);
            this.applyIf(((Builder)builder).isAccessModificationRequiredForRepackaging(), Joiner::requireAccessModificationForRepackaging);
            this.rules.addAll(((Joiner)joiner).rules);
            return this.self();
        }

        public J mergeUnsafe(Joiner<?, ?, ?> joiner) {
            return (J)this.merge(joiner);
        }

        public K join() {
            Object joined = ((Builder)this.builder).build();
            Object original = ((Builder)this.builder).original;
            assert (((KeepInfo)original).isLessThanOrEquals(joined));
            return joined;
        }

        public boolean verifyShrinkingDisallowedWithRule(InternalOptions options) {
            assert (!this.isShrinkingAllowed());
            assert (!this.getRules().isEmpty() || !options.isShrinking());
            return true;
        }
    }

    public static abstract class Builder<B extends Builder<B, K>, K extends KeepInfo<B, K>> {
        protected K original;
        private boolean allowAccessModification;
        private boolean allowAnnotationRemoval;
        private boolean allowMinification;
        private boolean allowOptimization;
        private boolean allowShrinking;
        private boolean allowSignatureRemoval;
        private boolean checkDiscarded;
        private boolean requireAccessModificationForRepackaging;

        Builder() {
        }

        Builder(K original) {
            this.original = original;
            this.allowAccessModification = ((KeepInfo)original).internalIsAccessModificationAllowed();
            this.allowAnnotationRemoval = ((KeepInfo)original).internalIsAnnotationRemovalAllowed();
            this.allowMinification = ((KeepInfo)original).internalIsMinificationAllowed();
            this.allowOptimization = ((KeepInfo)original).internalIsOptimizationAllowed();
            this.allowShrinking = ((KeepInfo)original).internalIsShrinkingAllowed();
            this.allowSignatureRemoval = ((KeepInfo)original).internalIsSignatureRemovalAllowed();
            this.checkDiscarded = ((KeepInfo)original).internalIsCheckDiscardedEnabled();
            this.requireAccessModificationForRepackaging = ((KeepInfo)original).internalIsAccessModificationRequiredForRepackaging();
        }

        private B setAllowSignatureRemoval(boolean allowSignatureRemoval) {
            this.allowSignatureRemoval = allowSignatureRemoval;
            return this.self();
        }

        abstract B self();

        abstract K doBuild();

        abstract K getTopInfo();

        abstract K getBottomInfo();

        abstract boolean isEqualTo(K var1);

        B makeTop() {
            this.disallowAccessModification();
            this.disallowAnnotationRemoval();
            this.disallowMinification();
            this.disallowOptimization();
            this.disallowShrinking();
            this.disallowSignatureRemoval();
            this.unsetCheckDiscarded();
            this.requireAccessModificationForRepackaging();
            return this.self();
        }

        B makeBottom() {
            this.allowAccessModification();
            this.allowAnnotationRemoval();
            this.allowMinification();
            this.allowOptimization();
            this.allowShrinking();
            this.allowSignatureRemoval();
            this.unsetCheckDiscarded();
            this.unsetRequireAccessModificationForRepackaging();
            return this.self();
        }

        public K build() {
            if (this.original != null) {
                if (this.internalIsEqualTo(this.original)) {
                    return this.original;
                }
                if (this.internalIsEqualTo(this.getTopInfo())) {
                    return this.getTopInfo();
                }
                if (this.internalIsEqualTo(this.getBottomInfo())) {
                    return this.getBottomInfo();
                }
            }
            return this.doBuild();
        }

        boolean internalIsEqualTo(K other) {
            return this.isAccessModificationAllowed() == ((KeepInfo)other).internalIsAccessModificationAllowed() && this.isAnnotationRemovalAllowed() == ((KeepInfo)other).internalIsAnnotationRemovalAllowed() && this.isMinificationAllowed() == ((KeepInfo)other).internalIsMinificationAllowed() && this.isOptimizationAllowed() == ((KeepInfo)other).internalIsOptimizationAllowed() && this.isShrinkingAllowed() == ((KeepInfo)other).internalIsShrinkingAllowed() && this.isSignatureRemovalAllowed() == ((KeepInfo)other).internalIsSignatureRemovalAllowed() && this.isCheckDiscardedEnabled() == ((KeepInfo)other).internalIsCheckDiscardedEnabled() && this.isAccessModificationRequiredForRepackaging() == ((KeepInfo)other).internalIsAccessModificationRequiredForRepackaging();
        }

        public boolean isAccessModificationRequiredForRepackaging() {
            return this.requireAccessModificationForRepackaging;
        }

        public boolean isAccessModificationAllowed() {
            return this.allowAccessModification;
        }

        public boolean isAnnotationRemovalAllowed() {
            return this.allowAnnotationRemoval;
        }

        public boolean isCheckDiscardedEnabled() {
            return this.checkDiscarded;
        }

        public boolean isMinificationAllowed() {
            return this.allowMinification;
        }

        public boolean isOptimizationAllowed() {
            return this.allowOptimization;
        }

        public boolean isShrinkingAllowed() {
            return this.allowShrinking;
        }

        public boolean isSignatureRemovalAllowed() {
            return this.allowSignatureRemoval;
        }

        public B setAllowMinification(boolean allowMinification) {
            this.allowMinification = allowMinification;
            return this.self();
        }

        public B allowMinification() {
            return this.setAllowMinification(true);
        }

        public B disallowMinification() {
            return this.setAllowMinification(false);
        }

        public B setAllowOptimization(boolean allowOptimization) {
            this.allowOptimization = allowOptimization;
            return this.self();
        }

        public B allowOptimization() {
            return this.setAllowOptimization(true);
        }

        public B disallowOptimization() {
            return this.setAllowOptimization(false);
        }

        public B setAllowShrinking(boolean allowShrinking) {
            this.allowShrinking = allowShrinking;
            return this.self();
        }

        public B allowShrinking() {
            return this.setAllowShrinking(true);
        }

        public B disallowShrinking() {
            return this.setAllowShrinking(false);
        }

        public B setCheckDiscarded(boolean checkDiscarded) {
            this.checkDiscarded = checkDiscarded;
            return this.self();
        }

        public B setCheckDiscarded() {
            return this.setCheckDiscarded(true);
        }

        public B unsetCheckDiscarded() {
            return this.setCheckDiscarded(false);
        }

        public B setRequireAccessModificationForRepackaging(boolean requireAccessModificationForRepackaging) {
            this.requireAccessModificationForRepackaging = requireAccessModificationForRepackaging;
            return this.self();
        }

        public B requireAccessModificationForRepackaging() {
            return this.setRequireAccessModificationForRepackaging(true);
        }

        public B unsetRequireAccessModificationForRepackaging() {
            return this.setRequireAccessModificationForRepackaging(false);
        }

        public B setAllowAccessModification(boolean allowAccessModification) {
            this.allowAccessModification = allowAccessModification;
            return this.self();
        }

        public B allowAccessModification() {
            return this.setAllowAccessModification(true);
        }

        public B disallowAccessModification() {
            return this.setAllowAccessModification(false);
        }

        public B setAllowAnnotationRemoval(boolean allowAnnotationRemoval) {
            this.allowAnnotationRemoval = allowAnnotationRemoval;
            return this.self();
        }

        public B allowAnnotationRemoval() {
            return this.setAllowAnnotationRemoval(true);
        }

        public B disallowAnnotationRemoval() {
            return this.setAllowAnnotationRemoval(false);
        }

        public B allowSignatureRemoval() {
            return this.setAllowSignatureRemoval(true);
        }

        public B disallowSignatureRemoval() {
            return this.setAllowSignatureRemoval(false);
        }
    }
}

