/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.shaking.GlobalKeepInfoConfiguration;
import com.android.tools.r8.shaking.KeepInfo;
import com.android.tools.r8.shaking.KeepMemberInfo;

public final class KeepMethodInfo
extends KeepMemberInfo<Builder, KeepMethodInfo> {
    private static final KeepMethodInfo TOP = (KeepMethodInfo)new Builder().makeTop().build();
    private static final KeepMethodInfo BOTTOM = (KeepMethodInfo)new Builder().makeBottom().build();
    private final boolean allowClassInlining;
    private final boolean allowClosedWorldReasoning;
    private final boolean allowConstantArgumentOptimization;
    private final boolean allowInlining;
    private final boolean allowMethodStaticizing;
    private final boolean allowParameterReordering;
    private final boolean allowParameterTypeStrengthening;
    private final boolean allowReturnTypeStrengthening;
    private final boolean allowUnusedArgumentOptimization;
    private final boolean allowUnusedReturnValueOptimization;

    public static KeepMethodInfo top() {
        return TOP;
    }

    public static KeepMethodInfo bottom() {
        return BOTTOM;
    }

    public static Joiner newEmptyJoiner() {
        return KeepMethodInfo.bottom().joiner();
    }

    private KeepMethodInfo(Builder builder) {
        super(builder);
        this.allowClassInlining = builder.isClassInliningAllowed();
        this.allowClosedWorldReasoning = builder.isClosedWorldReasoningAllowed();
        this.allowConstantArgumentOptimization = builder.isConstantArgumentOptimizationAllowed();
        this.allowInlining = builder.isInliningAllowed();
        this.allowMethodStaticizing = builder.isMethodStaticizingAllowed();
        this.allowParameterReordering = builder.isParameterReorderingAllowed();
        this.allowParameterTypeStrengthening = builder.isParameterTypeStrengtheningAllowed();
        this.allowReturnTypeStrengthening = builder.isReturnTypeStrengtheningAllowed();
        this.allowUnusedArgumentOptimization = builder.isUnusedArgumentOptimizationAllowed();
        this.allowUnusedReturnValueOptimization = builder.isUnusedReturnValueOptimizationAllowed();
    }

    @Override
    Builder builder() {
        return new Builder(this);
    }

    public boolean isArgumentPropagationAllowed(GlobalKeepInfoConfiguration configuration) {
        return this.isParameterRemovalAllowed(configuration);
    }

    public boolean isParameterRemovalAllowed(GlobalKeepInfoConfiguration configuration) {
        return this.isClosedWorldReasoningAllowed(configuration) && this.isOptimizationAllowed(configuration) && this.isShrinkingAllowed(configuration) && !this.isCheckDiscardedEnabled(configuration);
    }

    public boolean isClassInliningAllowed(GlobalKeepInfoConfiguration configuration) {
        return this.isOptimizationAllowed(configuration) && this.internalIsClassInliningAllowed();
    }

    boolean internalIsClassInliningAllowed() {
        return this.allowClassInlining;
    }

    public boolean isClosedWorldReasoningAllowed(GlobalKeepInfoConfiguration configuration) {
        return this.isOptimizationAllowed(configuration) && this.internalIsClosedWorldReasoningAllowed();
    }

    boolean internalIsClosedWorldReasoningAllowed() {
        return this.allowClosedWorldReasoning;
    }

    public boolean isConstantArgumentOptimizationAllowed(GlobalKeepInfoConfiguration configuration) {
        return this.isOptimizationAllowed(configuration) && this.internalIsConstantArgumentOptimizationAllowed();
    }

    boolean internalIsConstantArgumentOptimizationAllowed() {
        return this.allowConstantArgumentOptimization;
    }

    public boolean isInliningAllowed(GlobalKeepInfoConfiguration configuration) {
        return this.isOptimizationAllowed(configuration) && this.internalIsInliningAllowed();
    }

    boolean internalIsInliningAllowed() {
        return this.allowInlining;
    }

    public boolean isMethodStaticizingAllowed(GlobalKeepInfoConfiguration configuration) {
        return this.isClosedWorldReasoningAllowed(configuration) && this.isOptimizationAllowed(configuration) && this.isShrinkingAllowed(configuration) && configuration.isMethodStaticizingEnabled() && this.internalIsMethodStaticizingAllowed();
    }

    boolean internalIsMethodStaticizingAllowed() {
        return this.allowMethodStaticizing;
    }

    public boolean isParameterReorderingAllowed(GlobalKeepInfoConfiguration configuration) {
        return this.isClosedWorldReasoningAllowed(configuration) && this.isOptimizationAllowed(configuration) && this.isShrinkingAllowed(configuration) && this.internalIsParameterReorderingAllowed();
    }

    boolean internalIsParameterReorderingAllowed() {
        return this.allowParameterReordering;
    }

    public boolean isParameterTypeStrengtheningAllowed(GlobalKeepInfoConfiguration configuration) {
        return this.isClosedWorldReasoningAllowed(configuration) && this.isOptimizationAllowed(configuration) && this.isShrinkingAllowed(configuration) && this.internalIsParameterTypeStrengtheningAllowed();
    }

    boolean internalIsParameterTypeStrengtheningAllowed() {
        return this.allowParameterTypeStrengthening;
    }

    public boolean isReturnTypeStrengtheningAllowed(GlobalKeepInfoConfiguration configuration) {
        return this.isClosedWorldReasoningAllowed(configuration) && this.isOptimizationAllowed(configuration) && this.isShrinkingAllowed(configuration) && this.internalIsReturnTypeStrengtheningAllowed();
    }

    boolean internalIsReturnTypeStrengtheningAllowed() {
        return this.allowReturnTypeStrengthening;
    }

    public boolean isUnusedArgumentOptimizationAllowed(GlobalKeepInfoConfiguration configuration) {
        return this.isClosedWorldReasoningAllowed(configuration) && this.isOptimizationAllowed(configuration) && this.isShrinkingAllowed(configuration) && this.internalIsUnusedArgumentOptimizationAllowed();
    }

    boolean internalIsUnusedArgumentOptimizationAllowed() {
        return this.allowUnusedArgumentOptimization;
    }

    public boolean isUnusedReturnValueOptimizationAllowed(GlobalKeepInfoConfiguration configuration) {
        return this.isClosedWorldReasoningAllowed(configuration) && this.isOptimizationAllowed(configuration) && this.isShrinkingAllowed(configuration) && this.internalIsUnusedReturnValueOptimizationAllowed();
    }

    boolean internalIsUnusedReturnValueOptimizationAllowed() {
        return this.allowUnusedReturnValueOptimization;
    }

    public Joiner joiner() {
        assert (!this.isTop());
        return new Joiner(this);
    }

    @Override
    public boolean isTop() {
        return this.equals(KeepMethodInfo.top());
    }

    @Override
    public boolean isBottom() {
        return this.equals(KeepMethodInfo.bottom());
    }

    public static class Joiner
    extends KeepInfo.Joiner<Joiner, Builder, KeepMethodInfo> {
        public Joiner(KeepMethodInfo info) {
            super(info.builder());
        }

        public Joiner disallowClassInlining() {
            ((Builder)this.builder).disallowClassInlining();
            return this.self();
        }

        public Joiner disallowClosedWorldReasoning() {
            ((Builder)this.builder).disallowClosedWorldReasoning();
            return this.self();
        }

        public Joiner disallowConstantArgumentOptimization() {
            ((Builder)this.builder).disallowConstantArgumentOptimization();
            return this.self();
        }

        public Joiner disallowInlining() {
            ((Builder)this.builder).disallowInlining();
            return this.self();
        }

        public Joiner disallowMethodStaticizing() {
            ((Builder)this.builder).disallowMethodStaticizing();
            return this.self();
        }

        public Joiner disallowParameterReordering() {
            ((Builder)this.builder).disallowParameterReordering();
            return this.self();
        }

        public Joiner disallowParameterTypeStrengthening() {
            ((Builder)this.builder).disallowParameterTypeStrengthening();
            return this.self();
        }

        public Joiner disallowReturnTypeStrengthening() {
            ((Builder)this.builder).disallowReturnTypeStrengthening();
            return this.self();
        }

        public Joiner disallowUnusedArgumentOptimization() {
            ((Builder)this.builder).disallowUnusedArgumentOptimization();
            return this.self();
        }

        public Joiner disallowUnusedReturnValueOptimization() {
            ((Builder)this.builder).disallowUnusedReturnValueOptimization();
            return this.self();
        }

        @Override
        public Joiner asMethodJoiner() {
            return this;
        }

        @Override
        public Joiner merge(Joiner joiner) {
            return super.merge(joiner).applyIf(!((Builder)joiner.builder).isClassInliningAllowed(), Joiner::disallowClassInlining).applyIf(!((Builder)joiner.builder).isClosedWorldReasoningAllowed(), Joiner::disallowClosedWorldReasoning).applyIf(!((Builder)joiner.builder).isConstantArgumentOptimizationAllowed(), Joiner::disallowConstantArgumentOptimization).applyIf(!((Builder)joiner.builder).isInliningAllowed(), Joiner::disallowInlining).applyIf(!((Builder)joiner.builder).isMethodStaticizingAllowed(), Joiner::disallowMethodStaticizing).applyIf(!((Builder)joiner.builder).isParameterReorderingAllowed(), Joiner::disallowParameterReordering).applyIf(!((Builder)joiner.builder).isParameterTypeStrengtheningAllowed(), Joiner::disallowParameterTypeStrengthening).applyIf(!((Builder)joiner.builder).isReturnTypeStrengtheningAllowed(), Joiner::disallowReturnTypeStrengthening).applyIf(!((Builder)joiner.builder).isUnusedArgumentOptimizationAllowed(), Joiner::disallowUnusedArgumentOptimization).applyIf(!((Builder)joiner.builder).isUnusedReturnValueOptimizationAllowed(), Joiner::disallowUnusedReturnValueOptimization);
        }

        @Override
        Joiner self() {
            return this;
        }
    }

    public static class Builder
    extends KeepInfo.Builder<Builder, KeepMethodInfo> {
        private boolean allowClassInlining;
        private boolean allowClosedWorldReasoning;
        private boolean allowConstantArgumentOptimization;
        private boolean allowInlining;
        private boolean allowMethodStaticizing;
        private boolean allowParameterReordering;
        private boolean allowParameterTypeStrengthening;
        private boolean allowReturnTypeStrengthening;
        private boolean allowUnusedArgumentOptimization;
        private boolean allowUnusedReturnValueOptimization;

        private Builder() {
        }

        private Builder(KeepMethodInfo original) {
            super(original);
            this.allowClassInlining = original.internalIsClassInliningAllowed();
            this.allowClosedWorldReasoning = original.internalIsClosedWorldReasoningAllowed();
            this.allowConstantArgumentOptimization = original.internalIsConstantArgumentOptimizationAllowed();
            this.allowInlining = original.internalIsInliningAllowed();
            this.allowMethodStaticizing = original.internalIsMethodStaticizingAllowed();
            this.allowParameterReordering = original.internalIsParameterReorderingAllowed();
            this.allowParameterTypeStrengthening = original.internalIsParameterTypeStrengtheningAllowed();
            this.allowReturnTypeStrengthening = original.internalIsReturnTypeStrengtheningAllowed();
            this.allowUnusedArgumentOptimization = original.internalIsUnusedArgumentOptimizationAllowed();
            this.allowUnusedReturnValueOptimization = original.internalIsUnusedReturnValueOptimizationAllowed();
        }

        public boolean isClassInliningAllowed() {
            return this.allowClassInlining;
        }

        public Builder setAllowClassInlining(boolean allowClassInlining) {
            this.allowClassInlining = allowClassInlining;
            return this.self();
        }

        public Builder allowClassInlining() {
            return this.setAllowClassInlining(true);
        }

        public Builder disallowClassInlining() {
            return this.setAllowClassInlining(false);
        }

        public boolean isClosedWorldReasoningAllowed() {
            return this.allowClosedWorldReasoning;
        }

        public Builder setAllowClosedWorldReasoning(boolean allowClosedWorldReasoning) {
            this.allowClosedWorldReasoning = allowClosedWorldReasoning;
            return this.self();
        }

        public Builder allowClosedWorldReasoning() {
            return this.setAllowClosedWorldReasoning(true);
        }

        public Builder disallowClosedWorldReasoning() {
            return this.setAllowClosedWorldReasoning(false);
        }

        public boolean isConstantArgumentOptimizationAllowed() {
            return this.allowConstantArgumentOptimization;
        }

        public Builder setAllowConstantArgumentOptimization(boolean allowConstantArgumentOptimization) {
            this.allowConstantArgumentOptimization = allowConstantArgumentOptimization;
            return this.self();
        }

        public Builder allowConstantArgumentOptimization() {
            return this.setAllowConstantArgumentOptimization(true);
        }

        public Builder disallowConstantArgumentOptimization() {
            return this.setAllowConstantArgumentOptimization(false);
        }

        public boolean isInliningAllowed() {
            return this.allowInlining;
        }

        public Builder setAllowInlining(boolean allowInlining) {
            this.allowInlining = allowInlining;
            return this.self();
        }

        public Builder allowInlining() {
            return this.setAllowInlining(true);
        }

        public Builder disallowInlining() {
            return this.setAllowInlining(false);
        }

        public boolean isMethodStaticizingAllowed() {
            return this.allowMethodStaticizing;
        }

        public Builder setAllowMethodStaticizing(boolean allowMethodStaticizing) {
            this.allowMethodStaticizing = allowMethodStaticizing;
            return this.self();
        }

        public Builder allowMethodStaticizing() {
            return this.setAllowMethodStaticizing(true);
        }

        public Builder disallowMethodStaticizing() {
            return this.setAllowMethodStaticizing(false);
        }

        public boolean isParameterReorderingAllowed() {
            return this.allowParameterReordering;
        }

        public Builder setAllowParameterReordering(boolean allowParameterReordering) {
            this.allowParameterReordering = allowParameterReordering;
            return this.self();
        }

        public Builder allowParameterReordering() {
            return this.setAllowParameterReordering(true);
        }

        public Builder disallowParameterReordering() {
            return this.setAllowParameterReordering(false);
        }

        public boolean isParameterTypeStrengtheningAllowed() {
            return this.allowParameterTypeStrengthening;
        }

        public Builder setAllowParameterTypeStrengthening(boolean allowParameterTypeStrengthening) {
            this.allowParameterTypeStrengthening = allowParameterTypeStrengthening;
            return this.self();
        }

        public Builder allowParameterTypeStrengthening() {
            return this.setAllowParameterTypeStrengthening(true);
        }

        public Builder disallowParameterTypeStrengthening() {
            return this.setAllowParameterTypeStrengthening(false);
        }

        public boolean isReturnTypeStrengtheningAllowed() {
            return this.allowReturnTypeStrengthening;
        }

        public Builder setAllowReturnTypeStrengthening(boolean allowReturnTypeStrengthening) {
            this.allowReturnTypeStrengthening = allowReturnTypeStrengthening;
            return this.self();
        }

        public Builder allowReturnTypeStrengthening() {
            return this.setAllowReturnTypeStrengthening(true);
        }

        public Builder disallowReturnTypeStrengthening() {
            return this.setAllowReturnTypeStrengthening(false);
        }

        public boolean isUnusedArgumentOptimizationAllowed() {
            return this.allowUnusedArgumentOptimization;
        }

        public Builder setAllowUnusedArgumentOptimization(boolean allowUnusedArgumentOptimization) {
            this.allowUnusedArgumentOptimization = allowUnusedArgumentOptimization;
            return this.self();
        }

        public Builder allowUnusedArgumentOptimization() {
            return this.setAllowUnusedArgumentOptimization(true);
        }

        public Builder disallowUnusedArgumentOptimization() {
            return this.setAllowUnusedArgumentOptimization(false);
        }

        public boolean isUnusedReturnValueOptimizationAllowed() {
            return this.allowUnusedReturnValueOptimization;
        }

        public Builder setAllowUnusedReturnValueOptimization(boolean allowUnusedReturnValueOptimization) {
            this.allowUnusedReturnValueOptimization = allowUnusedReturnValueOptimization;
            return this.self();
        }

        public Builder allowUnusedReturnValueOptimization() {
            return this.setAllowUnusedReturnValueOptimization(true);
        }

        public Builder disallowUnusedReturnValueOptimization() {
            return this.setAllowUnusedReturnValueOptimization(false);
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public KeepMethodInfo getTopInfo() {
            return TOP;
        }

        @Override
        public KeepMethodInfo getBottomInfo() {
            return BOTTOM;
        }

        @Override
        public boolean isEqualTo(KeepMethodInfo other) {
            return this.internalIsEqualTo(other);
        }

        @Override
        boolean internalIsEqualTo(KeepMethodInfo other) {
            return super.internalIsEqualTo(other) && this.isClassInliningAllowed() == other.internalIsClassInliningAllowed() && this.isClosedWorldReasoningAllowed() == other.internalIsClosedWorldReasoningAllowed() && this.isConstantArgumentOptimizationAllowed() == other.internalIsConstantArgumentOptimizationAllowed() && this.isInliningAllowed() == other.internalIsInliningAllowed() && this.isMethodStaticizingAllowed() == other.internalIsMethodStaticizingAllowed() && this.isParameterReorderingAllowed() == other.internalIsParameterReorderingAllowed() && this.isParameterTypeStrengtheningAllowed() == other.internalIsParameterTypeStrengtheningAllowed() && this.isReturnTypeStrengtheningAllowed() == other.internalIsReturnTypeStrengtheningAllowed() && this.isUnusedArgumentOptimizationAllowed() == other.internalIsUnusedArgumentOptimizationAllowed() && this.isUnusedReturnValueOptimizationAllowed() == other.internalIsUnusedReturnValueOptimizationAllowed();
        }

        @Override
        public KeepMethodInfo doBuild() {
            return new KeepMethodInfo(this);
        }

        @Override
        public Builder makeTop() {
            return ((Builder)super.makeTop()).disallowClassInlining().disallowClosedWorldReasoning().disallowConstantArgumentOptimization().disallowInlining().disallowMethodStaticizing().disallowParameterReordering().disallowParameterTypeStrengthening().disallowReturnTypeStrengthening().disallowUnusedArgumentOptimization().disallowUnusedReturnValueOptimization();
        }

        @Override
        public Builder makeBottom() {
            return ((Builder)super.makeBottom()).allowClassInlining().allowClosedWorldReasoning().allowConstantArgumentOptimization().allowInlining().allowMethodStaticizing().allowParameterReordering().allowParameterTypeStrengthening().allowReturnTypeStrengthening().allowUnusedArgumentOptimization().allowUnusedReturnValueOptimization();
        }
    }
}

