/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.experimental.graphinfo.GraphEdgeInfo;
import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.shaking.GraphReporter;

public abstract class KeepReason {
    static KeepReason annotatedOn(DexDefinition definition) {
        return new AnnotatedOn(definition);
    }

    static KeepReason instantiatedIn(DexEncodedMethod method) {
        return new InstantiatedIn(method);
    }

    static KeepReason instantiatedIn(ProgramMethod method) {
        return new InstantiatedIn((DexEncodedMethod)method.getDefinition());
    }

    public static KeepReason invokedViaSuperFrom(DexEncodedMethod from) {
        return new InvokedViaSuper(from);
    }

    public static KeepReason invokedViaSuperFrom(ProgramMethod from) {
        return new InvokedViaSuper((DexEncodedMethod)from.getDefinition());
    }

    public static KeepReason reachableFromLiveType(DexType type) {
        return new ReachableFromLiveType(type);
    }

    public static KeepReason invokedFrom(DexProgramClass holder, DexEncodedMethod method) {
        return new InvokedFrom(holder, method);
    }

    public static KeepReason invokedFrom(ProgramMethod context) {
        return KeepReason.invokedFrom(context.getHolder(), (DexEncodedMethod)context.getDefinition());
    }

    public static KeepReason invokedFromLambdaCreatedIn(ProgramMethod method) {
        return new InvokedFromLambdaCreatedIn((DexEncodedMethod)method.getDefinition());
    }

    public static KeepReason fieldReferencedIn(ProgramMethod method) {
        return new ReferencedFrom((DexEncodedMethod)method.getDefinition());
    }

    public static KeepReason referencedInAnnotation(DexAnnotation annotation, ProgramDefinition annotatedItem) {
        return new ReferencedInAnnotation(annotation, annotatedItem);
    }

    public static KeepReason targetedBySuperFrom(ProgramMethod from) {
        return new TargetedBySuper((DexEncodedMethod)from.getDefinition());
    }

    public static KeepReason reflectiveUseIn(ProgramMethod method) {
        return new ReflectiveUseFrom((DexEncodedMethod)method.getDefinition());
    }

    public static KeepReason methodHandleReferencedIn(ProgramMethod method) {
        return new MethodHandleReferencedFrom((DexEncodedMethod)method.getDefinition());
    }

    public abstract GraphEdgeInfo.EdgeKind edgeKind();

    public abstract GraphNode getSourceNode(GraphReporter var1);

    public boolean isDueToKeepRule() {
        return false;
    }

    public boolean isDueToReflectiveUse() {
        return false;
    }

    private static class MethodHandleReferencedFrom
    extends BasedOnOtherMethod {
        private MethodHandleReferencedFrom(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.MethodHandleUseFrom;
        }

        @Override
        String getKind() {
            return "method handle referenced from";
        }
    }

    private static class ReflectiveUseFrom
    extends BasedOnOtherMethod {
        private ReflectiveUseFrom(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public boolean isDueToReflectiveUse() {
            return true;
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.ReflectiveUseFrom;
        }

        @Override
        String getKind() {
            return "reflective use in";
        }
    }

    private static class AnnotatedOn
    extends KeepReason {
        private final DexDefinition holder;

        private AnnotatedOn(DexDefinition holder) {
            this.holder = holder;
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.AnnotatedOn;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            if (this.holder.isDexClass()) {
                return graphReporter.getClassGraphNode(this.holder.asDexClass().type);
            }
            if (this.holder.isDexEncodedField()) {
                return graphReporter.getFieldGraphNode((DexField)this.holder.asDexEncodedField().getReference());
            }
            assert (this.holder.isDexEncodedMethod());
            return graphReporter.getMethodGraphNode((DexMethod)this.holder.asDexEncodedMethod().getReference());
        }
    }

    private static class ReferencedInAnnotation
    extends KeepReason {
        private final DexAnnotation annotation;
        private final ProgramDefinition annotatedItem;

        private ReferencedInAnnotation(DexAnnotation annotation, ProgramDefinition annotatedItem) {
            this.annotation = annotation;
            this.annotatedItem = annotatedItem;
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.ReferencedInAnnotation;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getAnnotationGraphNode(this.annotation, this.annotatedItem);
        }
    }

    private static class ReachableFromLiveType
    extends KeepReason {
        private final DexType type;

        private ReachableFromLiveType(DexType type) {
            this.type = type;
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.ReachableFromLiveType;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getClassGraphNode(this.type);
        }
    }

    private static class ReferencedFrom
    extends BasedOnOtherMethod {
        private ReferencedFrom(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.ReferencedFrom;
        }

        @Override
        String getKind() {
            return "referenced from";
        }
    }

    private static class InvokedFromLambdaCreatedIn
    extends BasedOnOtherMethod {
        private InvokedFromLambdaCreatedIn(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.InvokedFromLambdaCreatedIn;
        }

        @Override
        String getKind() {
            return "invoked from lambda created in";
        }
    }

    private static class InvokedFrom
    extends BasedOnOtherMethod {
        private InvokedFrom(DexProgramClass holder, DexEncodedMethod method) {
            super(method);
            assert (holder.type == method.getHolderType());
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.InvokedFrom;
        }

        @Override
        String getKind() {
            return "invoked from";
        }
    }

    private static class TargetedBySuper
    extends BasedOnOtherMethod {
        private TargetedBySuper(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.TargetedBySuper;
        }

        @Override
        String getKind() {
            return "targeted by super from";
        }
    }

    private static class InvokedViaSuper
    extends BasedOnOtherMethod {
        private InvokedViaSuper(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.InvokedViaSuper;
        }

        @Override
        String getKind() {
            return "invoked via super from";
        }
    }

    public static class InstantiatedIn
    extends BasedOnOtherMethod {
        private InstantiatedIn(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.InstantiatedIn;
        }

        @Override
        String getKind() {
            return "instantiated in";
        }
    }

    private static abstract class BasedOnOtherMethod
    extends KeepReason {
        private final DexEncodedMethod method;

        private BasedOnOtherMethod(DexEncodedMethod method) {
            this.method = method;
        }

        abstract String getKind();

        public DexMethod getMethod() {
            return (DexMethod)this.method.getReference();
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getMethodGraphNode((DexMethod)this.method.getReference());
        }
    }
}

