/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.MainDexDirectReferenceTracer;
import com.android.tools.r8.shaking.MainDexInfo;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class MainDexListBuilder {
    private final Set<DexType> roots;
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final Map<DexType, Boolean> annotationTypeContainEnum;
    private final MainDexInfo.Builder mainDexInfoBuilder;

    public static void checkForAssumedLibraryTypes(AppInfo appInfo) {
        DexClass enumType = appInfo.definitionFor(appInfo.dexItemFactory().enumType);
        if (enumType == null) {
            throw new CompilationError("Tracing for legacy multi dex is not possible without all classpath libraries (java.lang.Enum is missing)");
        }
        DexClass annotationType = appInfo.definitionFor(appInfo.dexItemFactory().annotationType);
        if (annotationType == null) {
            throw new CompilationError("Tracing for legacy multi dex is not possible without all classpath libraries (java.lang.annotation.Annotation is missing)");
        }
    }

    public MainDexListBuilder(AppView<? extends AppInfoWithClassHierarchy> appView, Set<DexType> roots, MainDexInfo.Builder mainDexInfoBuilder) {
        this.appView = appView;
        assert (roots.stream().allMatch(type -> appView.definitionFor((DexType)type).isProgramClass()));
        this.roots = roots;
        this.mainDexInfoBuilder = mainDexInfoBuilder;
        this.annotationTypeContainEnum = new IdentityHashMap<DexType, Boolean>();
    }

    private AppInfoWithClassHierarchy appInfo() {
        return this.appView.appInfo();
    }

    private void traceRuntimeAnnotationsWithEnumForMainDex() {
        for (DexProgramClass clazz : this.appInfo().classes()) {
            if (this.mainDexInfoBuilder.contains(clazz)) continue;
            DexType dexType = clazz.type;
            if (this.isAnnotation(dexType) && this.isAnnotationWithEnum(dexType)) {
                if (!this.isVisibleAnnotation(clazz)) continue;
                this.addAnnotationsWithEnum(clazz);
                continue;
            }
            clazz.forEachAnnotation(annotation -> {
                if (!this.mainDexInfoBuilder.contains(clazz) && annotation.visibility == 1 && this.isAnnotationWithEnum(annotation.annotation.type)) {
                    this.mainDexInfoBuilder.addDependency(clazz);
                }
            });
        }
    }

    private boolean isVisibleAnnotation(DexProgramClass clazz) {
        if (this.retainCompileTimeAnnotation(clazz.type)) {
            return true;
        }
        DexAnnotation retentionAnnotation = clazz.annotations().getFirstMatching(this.appView.dexItemFactory().retentionType);
        if (retentionAnnotation == null) {
            return false;
        }
        return retentionAnnotation.annotation.toString().contains("RUNTIME");
    }

    private boolean retainCompileTimeAnnotation(DexType type) {
        return DexAnnotation.retainCompileTimeAnnotation(type, this.appView.options());
    }

    private boolean isAnnotationWithEnum(DexType dexType) {
        Boolean value = this.annotationTypeContainEnum.get(dexType);
        if (value == null) {
            DexClass clazz = this.appView.definitionFor(dexType);
            if (clazz == null) {
                value = true;
            } else {
                value = false;
                for (DexEncodedMethod method : clazz.virtualMethods()) {
                    DexType valueType;
                    DexProto proto = ((DexMethod)method.getReference()).proto;
                    if (proto.parameters.isEmpty() && (valueType = proto.returnType.toBaseType(this.appView.dexItemFactory())).isClassType()) {
                        assert (!value.booleanValue());
                        DexClass valueTypeClass = this.appInfo().definitionFor(valueType);
                        boolean notLibraryOrTakeBootClasspath = valueTypeClass != null && !valueTypeClass.isLibraryClass() || !this.appView.options().ignoreBootClasspathEnumsForMaindexTracing;
                        value = this.isEnum(valueType) && notLibraryOrTakeBootClasspath || this.isAnnotation(valueType) && this.isAnnotationWithEnum(valueType);
                    }
                    if (!value.booleanValue()) continue;
                    break;
                }
            }
            this.annotationTypeContainEnum.put(dexType, value);
        }
        return value;
    }

    private boolean isEnum(DexType valueType) {
        return valueType.isClassType() && this.appInfo().isSubtype(valueType, this.appView.dexItemFactory().enumType);
    }

    private boolean isAnnotation(DexType valueType) {
        return this.appInfo().isSubtype(valueType, this.appView.dexItemFactory().annotationType);
    }

    private void traceMainDexDirectDependencies() {
        new MainDexDirectReferenceTracer(this.appView, this::addDirectDependency).run(this.roots);
    }

    private void addAnnotationsWithEnum(DexProgramClass clazz) {
        this.addDirectDependency(clazz);
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            DexType valueType;
            DexProto proto = ((DexMethod)method.getReference()).proto;
            if (!proto.parameters.isEmpty() || !this.isEnum(valueType = proto.returnType.toBaseType(this.appView.dexItemFactory()))) continue;
            this.addDirectDependency(valueType);
        }
    }

    private void addDirectDependency(DexType type) {
        if (!(type = type.toBaseType(this.appView.dexItemFactory())).isClassType() || this.mainDexInfoBuilder.contains(type)) {
            return;
        }
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz == null || clazz.isNotProgramClass()) {
            return;
        }
        this.addDirectDependency(clazz.asProgramClass());
    }

    private void addDirectDependency(DexProgramClass dexClass) {
        assert (!this.mainDexInfoBuilder.contains(dexClass));
        this.mainDexInfoBuilder.addDependency(dexClass);
        if (dexClass.superType != null) {
            this.addDirectDependency(dexClass.superType);
        }
        for (DexType interfaze : dexClass.interfaces.values) {
            this.addDirectDependency(interfaze);
        }
    }

    public void run() {
        this.traceMainDexDirectDependencies();
        this.traceRuntimeAnnotationsWithEnumForMainDex();
    }
}

