/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.KeepClassInfo;
import com.android.tools.r8.shaking.KeepFieldInfo;
import com.android.tools.r8.shaking.KeepInfo;
import com.android.tools.r8.shaking.KeepMethodInfo;
import com.android.tools.r8.utils.MapUtils;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class MinimumKeepInfoCollection {
    private static final MinimumKeepInfoCollection EMPTY = new MinimumKeepInfoCollection(Collections.emptyMap());
    private final Map<DexReference, KeepInfo.Joiner<?, ?, ?>> minimumKeepInfo;

    public MinimumKeepInfoCollection() {
        this(new ConcurrentHashMap());
    }

    private MinimumKeepInfoCollection(Map<DexReference, KeepInfo.Joiner<?, ?, ?>> minimumKeepInfo) {
        this.minimumKeepInfo = minimumKeepInfo;
    }

    public static MinimumKeepInfoCollection empty() {
        return EMPTY;
    }

    public void forEach(BiConsumer<DexReference, KeepInfo.Joiner<?, ?, ?>> consumer) {
        this.minimumKeepInfo.forEach(consumer);
    }

    public void forEach(DexDefinitionSupplier definitions, BiConsumer<DexProgramClass, KeepClassInfo.Joiner> classConsumer, BiConsumer<ProgramField, KeepFieldInfo.Joiner> fieldConsumer, BiConsumer<ProgramMethod, KeepMethodInfo.Joiner> methodConsumer) {
        this.minimumKeepInfo.forEach((? super K reference, ? super V joiner) -> {
            DexProgramClass contextClass = DexProgramClass.asProgramClassOrNull(definitions.definitionFor(reference.getContextType()));
            if (contextClass != null) {
                reference.accept(clazz -> classConsumer.accept(contextClass, joiner.asClassJoiner()), fieldReference -> {
                    ProgramField field = contextClass.lookupProgramField((DexField)fieldReference);
                    if (field != null) {
                        fieldConsumer.accept(field, joiner.asFieldJoiner());
                    }
                }, methodReference -> {
                    ProgramMethod method = contextClass.lookupProgramMethod((DexMethod)methodReference);
                    if (method != null) {
                        methodConsumer.accept(method, joiner.asMethodJoiner());
                    }
                });
            }
        });
    }

    public <T extends DexReference> void forEachThatMatches(BiPredicate<DexReference, KeepInfo.Joiner<?, ?, ?>> predicate, BiConsumer<T, KeepInfo.Joiner<?, ?, ?>> consumer) {
        this.minimumKeepInfo.forEach((? super K reference, ? super V minimumKeepInfoForReference) -> {
            if (predicate.test((DexReference)reference, (KeepInfo.Joiner<?, ?, ?>)minimumKeepInfoForReference)) {
                consumer.accept((Object)reference, (KeepInfo.Joiner<?, ?, ?>)minimumKeepInfoForReference);
            }
        });
    }

    public KeepInfo.Joiner<?, ?, ?> getOrDefault(DexReference reference, KeepInfo.Joiner<?, ?, ?> defaultValue) {
        return this.minimumKeepInfo.getOrDefault(reference, defaultValue);
    }

    public KeepInfo.Joiner<?, ?, ?> getOrCreateMinimumKeepInfoFor(DexReference reference) {
        return this.minimumKeepInfo.computeIfAbsent(reference, MapUtils.ignoreKey(() -> KeepInfo.newEmptyJoinerFor(reference)));
    }

    public boolean hasMinimumKeepInfoThatMatches(DexReference reference, Predicate<KeepInfo.Joiner<?, ?, ?>> predicate) {
        KeepInfo.Joiner<?, ?, ?> minimumKeepInfoForReference = this.minimumKeepInfo.get(reference);
        return minimumKeepInfoForReference != null && predicate.test(minimumKeepInfoForReference);
    }

    public boolean isEmpty() {
        return this.minimumKeepInfo.isEmpty();
    }

    public void merge(MinimumKeepInfoCollection otherMinimumKeepInfo) {
        otherMinimumKeepInfo.forEach(this::mergeMinimumKeepInfoFor);
    }

    public void mergeMinimumKeepInfoFor(DexReference reference, KeepInfo.Joiner<?, ?, ?> minimumKeepInfoForReference) {
        this.getOrCreateMinimumKeepInfoFor(reference).mergeUnsafe(minimumKeepInfoForReference);
    }

    public void pruneDeadItems(DexDefinitionSupplier definitions, Enqueuer enqueuer) {
        MapUtils.removeIf(this.minimumKeepInfo, (reference, minimumKeepInfoForReference) -> {
            assert (!minimumKeepInfoForReference.isBottom());
            ProgramDefinition definition = reference.apply(clazz -> DexProgramClass.asProgramClassOrNull(definitions.definitionFor((DexType)clazz)), field -> field.lookupOnProgramClass(DexProgramClass.asProgramClassOrNull(definitions.definitionFor(field.getHolderType()))), method -> method.lookupOnProgramClass(DexProgramClass.asProgramClassOrNull(definitions.definitionFor(method.getHolderType()))));
            return definition == null || !enqueuer.isReachable(definition);
        });
    }

    public void pruneItems(PrunedItems prunedItems) {
        this.minimumKeepInfo.keySet().removeIf(prunedItems::isRemoved);
    }

    public KeepClassInfo.Joiner remove(DexType clazz) {
        return (KeepClassInfo.Joiner)this.minimumKeepInfo.remove(clazz);
    }

    public KeepFieldInfo.Joiner remove(DexField field) {
        return (KeepFieldInfo.Joiner)this.minimumKeepInfo.remove(field);
    }

    public KeepMethodInfo.Joiner remove(DexMethod method) {
        return (KeepMethodInfo.Joiner)this.minimumKeepInfo.remove(method);
    }

    public MinimumKeepInfoCollection rewrittenWithLens(GraphLens graphLens) {
        MinimumKeepInfoCollection rewrittenMinimumKeepInfo = new MinimumKeepInfoCollection();
        this.forEach((reference, minimumKeepInfoForReference) -> {
            DexReference rewrittenReference = reference.apply(type -> {
                DexType rewrittenType = graphLens.lookupType((DexType)type);
                if (rewrittenType.isPrimitiveType()) {
                    assert (type.isClassType());
                    assert (rewrittenType.isIntType());
                    return null;
                }
                return rewrittenType;
            }, graphLens::getRenamedFieldSignature, graphLens::getRenamedMethodSignature);
            if (rewrittenReference != null) {
                rewrittenMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(rewrittenReference).mergeUnsafe((KeepInfo.Joiner<?, ?, ?>)minimumKeepInfoForReference);
            }
        });
        return rewrittenMinimumKeepInfo;
    }
}

