/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.diagnostic.MissingDefinitionsDiagnostic;
import com.android.tools.r8.diagnostic.internal.DefinitionContextUtils;
import com.android.tools.r8.diagnostic.internal.MissingClassInfoImpl;
import com.android.tools.r8.diagnostic.internal.MissingDefinitionsDiagnosticImpl;
import com.android.tools.r8.errors.DesugarDiagnostic;
import com.android.tools.r8.errors.dontwarn.DontWarnConfiguration;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramDerivedContext;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.CustomConversionDescriptor;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.collections.IdentityHashSetFromMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class MissingClasses {
    private final Set<DexType> missingClasses;

    private MissingClasses(Set<DexType> missingClasses) {
        this.missingClasses = missingClasses;
    }

    public static MissingClasses empty() {
        return new MissingClasses(Sets.newIdentityHashSet());
    }

    public Builder builder() {
        return new Builder(this.missingClasses);
    }

    public void forEach(Consumer<DexType> missingClassConsumer) {
        this.missingClasses.forEach(missingClassConsumer);
    }

    public boolean contains(DexType type) {
        return this.missingClasses.contains(type);
    }

    public static class Builder {
        private final Set<DexType> alreadyMissingClasses;
        private final Map<DexType, Set<ProgramDerivedContext>> newMissingClasses = new IdentityHashMap<DexType, Set<ProgramDerivedContext>>();
        private final Set<DexType> newIgnoredMissingClasses = Sets.newIdentityHashSet();

        private Builder(Set<DexType> alreadyMissingClasses) {
            this.alreadyMissingClasses = alreadyMissingClasses;
        }

        private MissingDefinitionsDiagnostic createDiagnostic(Map<DexType, Set<ProgramDerivedContext>> missingClassesToBeReported) {
            MissingDefinitionsDiagnosticImpl.Builder diagnosticBuilder = MissingDefinitionsDiagnosticImpl.builder();
            missingClassesToBeReported.forEach((missingClass, programDerivedContexts) -> {
                MissingClassInfoImpl.Builder missingClassInfoBuilder = MissingClassInfoImpl.builder().setClass(missingClass.asClassReference());
                for (ProgramDerivedContext programDerivedContext : programDerivedContexts) {
                    missingClassInfoBuilder.addReferencedFromContext(DefinitionContextUtils.create(programDerivedContext));
                }
                diagnosticBuilder.addMissingDefinitionInfo(missingClassInfoBuilder.build());
            });
            return diagnosticBuilder.build();
        }

        private void rewriteMissingClassContexts(AppView<?> appView, SyntheticItems.SynthesizingContextOracle synthesizingContextOracle) {
            for (Map.Entry<DexType, Set<ProgramDerivedContext>> entry : this.newMissingClasses.entrySet()) {
                entry.setValue(Builder.rewriteMissingClassContextsForSingleMissingClass(appView, entry.getValue(), synthesizingContextOracle));
            }
        }

        private static Set<ProgramDerivedContext> rewriteMissingClassContextsForSingleMissingClass(AppView<?> appView, Set<ProgramDerivedContext> contexts, SyntheticItems.SynthesizingContextOracle synthesizingContextOracle) {
            if (contexts.isEmpty()) {
                return contexts;
            }
            Set<ProgramDerivedContext> rewrittenContexts = IdentityHashSetFromMap.newProgramDerivedContextSet();
            for (ProgramDerivedContext context : contexts) {
                if (!context.isProgramContext()) {
                    rewrittenContexts.add(context);
                    continue;
                }
                DexProgramClass clazz = context.getContext().asProgramDefinition().getContextClass();
                if (!appView.getSyntheticItems().isSyntheticClass(clazz)) {
                    rewrittenContexts.add(context);
                    continue;
                }
                Set<DexReference> synthesizingContextReferences = appView.getSyntheticItems().getSynthesizingContextReferences(clazz, synthesizingContextOracle);
                assert (synthesizingContextReferences != null);
                assert (!synthesizingContextReferences.isEmpty());
                for (DexReference synthesizingContextReference : synthesizingContextReferences) {
                    if (synthesizingContextReference.isDexMethod()) {
                        DexProgramClass holder = appView.definitionFor(synthesizingContextReference.getContextType()).asProgramClass();
                        ProgramMethod synthesizingContext = holder.lookupProgramMethod(synthesizingContextReference.asDexMethod());
                        assert (synthesizingContext != null);
                        rewrittenContexts.add(synthesizingContext);
                        continue;
                    }
                    if (synthesizingContextReference.isDexType()) {
                        DexProgramClass synthesizingClass = appView.definitionFor(synthesizingContextReference.asDexType()).asProgramClass();
                        rewrittenContexts.add(synthesizingClass);
                        continue;
                    }
                    assert (false) : "Unexpected synthesizing context: " + synthesizingContextReference.toSourceString();
                }
            }
            return rewrittenContexts;
        }

        private Map<DexType, Set<ProgramDerivedContext>> getMissingClassesToBeReported(AppView<?> appView, SyntheticItems.SynthesizingContextOracle synthesizingContextOracle) {
            this.rewriteMissingClassContexts(appView, synthesizingContextOracle);
            Predicate<DexType> allowedMissingClassesPredicate = Builder.getIsAllowedMissingClassesPredicate(appView);
            IdentityHashMap<DexType, Set<ProgramDerivedContext>> missingClassesToBeReported = new IdentityHashMap<DexType, Set<ProgramDerivedContext>>(this.newMissingClasses.size());
            this.newMissingClasses.forEach((missingClass, contexts) -> {
                if (allowedMissingClassesPredicate.test((DexType)missingClass)) {
                    return;
                }
                contexts.removeIf(context -> appView.getDontWarnConfiguration().matches(context.getContext().getContextType()));
                if (!contexts.isEmpty()) {
                    missingClassesToBeReported.put((DexType)missingClass, (Set<ProgramDerivedContext>)contexts);
                }
            });
            return missingClassesToBeReported;
        }

        private static Predicate<DexType> getIsAllowedMissingClassesPredicate(AppView<?> appView) {
            Set<DexType> allowedMissingClasses = Builder.getAllowedMissingClasses(appView);
            Predicate<DexType> compilerSynthesizedAllowingMissingClassPredicate = Builder.getIsCompilerSynthesizedAllowedMissingClassesPredicate(appView);
            DontWarnConfiguration dontWarnConfiguration = appView.getDontWarnConfiguration();
            return type -> allowedMissingClasses.contains(type) || compilerSynthesizedAllowingMissingClassPredicate.test((DexType)type) || dontWarnConfiguration.matches((DexType)type);
        }

        private static Set<DexType> getAllowedMissingClasses(AppView<?> appView) {
            DexItemFactory dexItemFactory = appView.dexItemFactory();
            ImmutableCollection.Builder allowedMissingClasses = ImmutableSet.builder().add(new DexType[]{dexItemFactory.annotationDefault, dexItemFactory.annotationMethodParameters, dexItemFactory.annotationSourceDebugExtension, dexItemFactory.annotationSynthesizedClass, dexItemFactory.annotationThrows, dexItemFactory.serializedLambdaType, dexItemFactory.unsafeType});
            appView.options().machineDesugaredLibrarySpecification.getCustomConversions().forEach((arg_0, arg_1) -> Builder.lambda$getAllowedMissingClasses$7((ImmutableSet.Builder)allowedMissingClasses, appView, arg_0, arg_1));
            return ((ImmutableSet.Builder)allowedMissingClasses).build();
        }

        private static void addWithRewrittenType(ImmutableSet.Builder<DexType> builder, DexType type, AppView<?> appView) {
            builder.add((Object)type);
            DexType rewrittenType = appView.typeRewriter.rewrittenType(type, appView);
            if (rewrittenType != null) {
                builder.add((Object)rewrittenType);
            }
        }

        private static Predicate<DexType> getIsCompilerSynthesizedAllowedMissingClassesPredicate(AppView<?> appView) {
            DexItemFactory dexItemFactory = appView.dexItemFactory();
            DexString vivifiedClassNamePrefix = dexItemFactory.createString("L$-vivified-$/");
            return type -> {
                DexString descriptor = type.getDescriptor();
                return descriptor.startsWith(vivifiedClassNamePrefix);
            };
        }

        private MissingClasses build() {
            return new MissingClasses(SetUtils.newIdentityHashSet(this.alreadyMissingClasses, this.newMissingClasses.keySet(), this.newIgnoredMissingClasses));
        }

        private static /* synthetic */ void lambda$getAllowedMissingClasses$7(ImmutableSet.Builder allowedMissingClasses, AppView appView, DexType type, CustomConversionDescriptor conversions) {
            Builder.addWithRewrittenType(allowedMissingClasses, conversions.getFrom().getHolderType(), appView);
            Builder.addWithRewrittenType(allowedMissingClasses, conversions.getTo().getHolderType(), appView);
        }

        public void addNewMissingClass(DexType type, ProgramDerivedContext context) {
            assert (context != null);
            assert (context.getContext().getContextType() != type);
            if (!this.alreadyMissingClasses.contains(type)) {
                this.newMissingClasses.computeIfAbsent(type, ignore -> IdentityHashSetFromMap.newProgramDerivedContextSet()).add(context);
            }
        }

        public void addNewMissingClassWithDesugarDiagnostic(DexType type, ProgramDerivedContext context, DesugarDiagnostic diagnostic) {
            this.addNewMissingClass(type, context);
        }

        public void legacyAddNewMissingClass(DexType type) {
            if (!this.alreadyMissingClasses.contains(type)) {
                this.newMissingClasses.computeIfAbsent(type, ignore -> IdentityHashSetFromMap.newProgramDerivedContextSet());
            }
        }

        @Deprecated
        public Builder legacyAddNewMissingClasses(Collection<DexType> types) {
            types.forEach(this::legacyAddNewMissingClass);
            return this;
        }

        public void ignoreNewMissingClass(DexType type) {
            this.newIgnoredMissingClasses.add(type);
        }

        public boolean contains(DexType type) {
            return this.alreadyMissingClasses.contains(type) || this.newMissingClasses.containsKey(type) || this.newIgnoredMissingClasses.contains(type);
        }

        Builder removeAlreadyMissingClasses(Iterable<DexType> types) {
            for (DexType type : types) {
                this.alreadyMissingClasses.remove(type);
            }
            return this;
        }

        public MissingClasses assertNoMissingClasses(AppView<?> appView) {
            assert (this.getMissingClassesToBeReported(appView, clazz -> ImmutableSet.of(clazz.getType())).isEmpty());
            return this.build();
        }

        public MissingClasses reportMissingClasses(AppView<?> appView, SyntheticItems.SynthesizingContextOracle synthesizingContextOracle) {
            Map<DexType, Set<ProgramDerivedContext>> missingClassesToBeReported = this.getMissingClassesToBeReported(appView, synthesizingContextOracle);
            if (!missingClassesToBeReported.isEmpty()) {
                MissingDefinitionsDiagnostic diagnostic = this.createDiagnostic(missingClassesToBeReported);
                if (appView.options().ignoreMissingClasses) {
                    appView.reporter().warning(diagnostic);
                } else {
                    throw appView.reporter().fatalError(diagnostic);
                }
            }
            return this.build();
        }

        public boolean wasAlreadyMissing(DexType type) {
            return this.alreadyMissingClasses.contains(type);
        }
    }
}

