/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWildcard;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class ProguardClassNameList {
    public static Builder builder() {
        return new Builder();
    }

    public static ProguardClassNameList emptyList() {
        return new EmptyClassNameList();
    }

    public static ProguardClassNameList singletonList(ProguardTypeMatcher matcher) {
        return new SingleClassNameList(matcher);
    }

    static Iterable<ProguardWildcard> getWildcardsOrEmpty(ProguardClassNameList nameList) {
        return nameList == null ? Collections::emptyIterator : nameList.getWildcards();
    }

    public abstract int size();

    public abstract void writeTo(StringBuilder var1);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.writeTo(builder);
        return builder.toString();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract List<DexType> asSpecificDexTypes();

    public abstract boolean matches(DexType var1);

    protected Iterable<ProguardWildcard> getWildcards() {
        return Collections::emptyIterator;
    }

    public boolean hasWildcards() {
        return this.getWildcards().iterator().hasNext();
    }

    protected ProguardClassNameList materialize(DexItemFactory dexItemFactory) {
        return this;
    }

    public abstract void forEachTypeMatcher(Consumer<ProguardTypeMatcher> var1);

    public final void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer, Predicate<ProguardTypeMatcher> predicate) {
        this.forEachTypeMatcher(matcher -> {
            if (predicate.test((ProguardTypeMatcher)matcher)) {
                consumer.accept((ProguardTypeMatcher)matcher);
            }
        });
    }

    public abstract TraversalContinuation<?> traverseTypeMatchers(Function<ProguardTypeMatcher, TraversalContinuation<?>> var1);

    public final TraversalContinuation<?> traverseTypeMatchers(Function<ProguardTypeMatcher, TraversalContinuation<?>> fn, Predicate<ProguardTypeMatcher> predicate) {
        return this.traverseTypeMatchers(matcher -> {
            if (predicate.test((ProguardTypeMatcher)matcher)) {
                return (TraversalContinuation)fn.apply((ProguardTypeMatcher)matcher);
            }
            return TraversalContinuation.doContinue();
        });
    }

    private static class MixedClassNameList
    extends ProguardClassNameList {
        private final Object2BooleanMap<ProguardTypeMatcher> classNames;

        private MixedClassNameList(Object2BooleanMap<ProguardTypeMatcher> classNames) {
            this.classNames = classNames;
        }

        @Override
        public int size() {
            return this.classNames.size();
        }

        @Override
        public void writeTo(StringBuilder builder) {
            boolean first = true;
            for (Object2BooleanMap.Entry entry : this.classNames.object2BooleanEntrySet()) {
                if (!first) {
                    builder.append(',');
                }
                if (entry.getBooleanValue()) {
                    builder.append('!');
                }
                builder.append(((ProguardTypeMatcher)entry.getKey()).toString());
                first = false;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MixedClassNameList that = (MixedClassNameList)o;
            return Objects.equals(this.classNames, that.classNames);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.classNames);
        }

        @Override
        public List<DexType> asSpecificDexTypes() {
            return null;
        }

        @Override
        public boolean matches(DexType type) {
            boolean lastWasNegated = false;
            for (Object2BooleanMap.Entry entry : this.classNames.object2BooleanEntrySet()) {
                if (((ProguardTypeMatcher)entry.getKey()).matches(type)) {
                    return !entry.getBooleanValue();
                }
                lastWasNegated = entry.getBooleanValue();
            }
            return lastWasNegated;
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return this.classNames.keySet().stream().map(ProguardTypeMatcher::getWildcards).flatMap(it -> StreamSupport.stream(it.spliterator(), false))::iterator;
        }

        @Override
        protected ProguardClassNameList materialize(DexItemFactory dexItemFactory) {
            Builder builder = MixedClassNameList.builder();
            this.classNames.forEach((m3, negated) -> builder.addClassName((boolean)negated, m3.materialize(dexItemFactory)));
            return builder.build();
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            this.classNames.object2BooleanEntrySet().forEach(entry -> consumer.accept((ProguardTypeMatcher)entry.getKey()));
        }

        @Override
        public TraversalContinuation<?> traverseTypeMatchers(Function<ProguardTypeMatcher, TraversalContinuation<?>> fn) {
            for (ProguardTypeMatcher matcher : this.classNames.keySet()) {
                if (!fn.apply(matcher).shouldBreak()) continue;
                return TraversalContinuation.doBreak();
            }
            return TraversalContinuation.doContinue();
        }
    }

    private static class PositiveClassNameList
    extends ProguardClassNameList {
        private final ImmutableList<ProguardTypeMatcher> classNames;

        private PositiveClassNameList(Collection<ProguardTypeMatcher> classNames) {
            this.classNames = ImmutableList.copyOf(classNames);
        }

        @Override
        public int size() {
            return this.classNames.size();
        }

        @Override
        public void writeTo(StringBuilder builder) {
            boolean first = true;
            for (ProguardTypeMatcher className : this.classNames) {
                if (!first) {
                    builder.append(',');
                }
                builder.append(className);
                first = false;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PositiveClassNameList that = (PositiveClassNameList)o;
            return Objects.equals(this.classNames, that.classNames);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.classNames);
        }

        @Override
        public List<DexType> asSpecificDexTypes() {
            if (this.classNames.stream().allMatch(k -> k.getSpecificType() != null)) {
                return this.classNames.stream().map(ProguardTypeMatcher::getSpecificType).collect(Collectors.toList());
            }
            return null;
        }

        @Override
        public boolean matches(DexType type) {
            return this.classNames.stream().anyMatch(name -> name.matches(type));
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return this.classNames.stream().map(ProguardTypeMatcher::getWildcards).flatMap(it -> StreamSupport.stream(it.spliterator(), false))::iterator;
        }

        @Override
        protected PositiveClassNameList materialize(DexItemFactory dexItemFactory) {
            return new PositiveClassNameList(this.classNames.stream().map(className -> className.materialize(dexItemFactory)).collect(Collectors.toList()));
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            this.classNames.forEach(consumer);
        }

        @Override
        public TraversalContinuation<?> traverseTypeMatchers(Function<ProguardTypeMatcher, TraversalContinuation<?>> fn) {
            for (ProguardTypeMatcher matcher : this.classNames) {
                if (!fn.apply(matcher).shouldBreak()) continue;
                return TraversalContinuation.doBreak();
            }
            return TraversalContinuation.doContinue();
        }
    }

    static class SingleClassNameList
    extends ProguardClassNameList {
        final ProguardTypeMatcher className;

        private SingleClassNameList(ProguardTypeMatcher className) {
            this.className = className;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void writeTo(StringBuilder builder) {
            builder.append(this.className.toString());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleClassNameList that = (SingleClassNameList)o;
            return Objects.equals(this.className, that.className);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.className);
        }

        @Override
        public List<DexType> asSpecificDexTypes() {
            DexType specific = this.className.getSpecificType();
            return specific == null ? null : Collections.singletonList(specific);
        }

        @Override
        public boolean matches(DexType type) {
            return this.className.matches(type);
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return this.className.getWildcards();
        }

        @Override
        protected SingleClassNameList materialize(DexItemFactory dexItemFactory) {
            return new SingleClassNameList(this.className.materialize(dexItemFactory));
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            consumer.accept(this.className);
        }

        @Override
        public TraversalContinuation<?> traverseTypeMatchers(Function<ProguardTypeMatcher, TraversalContinuation<?>> fn) {
            return fn.apply(this.className);
        }
    }

    private static class EmptyClassNameList
    extends ProguardClassNameList {
        private EmptyClassNameList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void writeTo(StringBuilder builder) {
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof EmptyClassNameList;
        }

        @Override
        public int hashCode() {
            return 7;
        }

        @Override
        public List<DexType> asSpecificDexTypes() {
            return null;
        }

        @Override
        public boolean matches(DexType type) {
            return false;
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
        }

        @Override
        public TraversalContinuation<?> traverseTypeMatchers(Function<ProguardTypeMatcher, TraversalContinuation<?>> fn) {
            return TraversalContinuation.doContinue();
        }
    }

    public static class Builder {
        private final Object2BooleanMap<ProguardTypeMatcher> matchers = new Object2BooleanArrayMap<ProguardTypeMatcher>();

        private Builder() {
        }

        public Builder addClassName(boolean isNegated, ProguardTypeMatcher className) {
            this.matchers.put(className, isNegated);
            return this;
        }

        ProguardClassNameList build() {
            if (this.matchers.containsValue(true)) {
                return new MixedClassNameList(this.matchers);
            }
            if (this.matchers.size() == 1) {
                return new SingleClassNameList(Iterables.getOnlyElement(this.matchers.keySet()));
            }
            return new PositiveClassNameList(this.matchers.keySet());
        }
    }
}

