/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.position.TextPosition;
import com.android.tools.r8.position.TextRange;
import com.android.tools.r8.shaking.ProguardAccessFlags;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.utils.StringUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class ProguardClassSpecification {
    private final Origin origin;
    private final Position position;
    private final String source;
    private final List<ProguardTypeMatcher> classAnnotations;
    private final ProguardAccessFlags classAccessFlags;
    private final ProguardAccessFlags negatedClassAccessFlags;
    private final boolean classTypeNegated;
    private final ProguardClassType classType;
    private final ProguardClassNameList classNames;
    private final List<ProguardTypeMatcher> inheritanceAnnotations;
    private final ProguardTypeMatcher inheritanceClassName;
    private final boolean inheritanceIsExtends;
    private final List<ProguardMemberRule> memberRules;

    protected ProguardClassSpecification(Origin origin, Position position, String source, List<ProguardTypeMatcher> classAnnotations, ProguardAccessFlags classAccessFlags, ProguardAccessFlags negatedClassAccessFlags, boolean classTypeNegated, ProguardClassType classType, ProguardClassNameList classNames, List<ProguardTypeMatcher> inheritanceAnnotations, ProguardTypeMatcher inheritanceClassName, boolean inheritanceIsExtends, List<ProguardMemberRule> memberRules) {
        assert (origin != null);
        assert (position != null);
        assert (source != null || origin != Origin.unknown());
        this.origin = origin;
        this.position = position;
        this.source = source;
        this.classAnnotations = classAnnotations;
        this.classAccessFlags = classAccessFlags;
        this.negatedClassAccessFlags = negatedClassAccessFlags;
        this.classTypeNegated = classTypeNegated;
        this.classType = classType;
        assert (classType != null);
        this.classNames = classNames;
        this.inheritanceAnnotations = inheritanceAnnotations;
        this.inheritanceClassName = inheritanceClassName;
        this.inheritanceIsExtends = inheritanceIsExtends;
        this.memberRules = memberRules;
    }

    private static void appendAnnotations(List<ProguardTypeMatcher> annotations, StringBuilder builder) {
        if (!annotations.isEmpty()) {
            Iterator<ProguardTypeMatcher> annotationIterator = annotations.iterator();
            builder.append('@').append(annotationIterator.next());
            while (annotationIterator.hasNext()) {
                builder.append(" @").append(annotationIterator.next());
            }
            builder.append(' ');
        }
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getSource() {
        return this.source;
    }

    public List<ProguardMemberRule> getMemberRules() {
        return this.memberRules;
    }

    public boolean getInheritanceIsExtends() {
        return this.inheritanceIsExtends;
    }

    public boolean getInheritanceIsImplements() {
        return !this.inheritanceIsExtends;
    }

    public boolean hasInheritanceClassName() {
        return this.inheritanceClassName != null;
    }

    public ProguardTypeMatcher getInheritanceClassName() {
        return this.inheritanceClassName;
    }

    public List<ProguardTypeMatcher> getInheritanceAnnotations() {
        return this.inheritanceAnnotations;
    }

    public ProguardClassNameList getClassNames() {
        return this.classNames;
    }

    public ProguardClassType getClassType() {
        return this.classType;
    }

    public boolean getClassTypeNegated() {
        return this.classTypeNegated;
    }

    public ProguardAccessFlags getClassAccessFlags() {
        return this.classAccessFlags;
    }

    public ProguardAccessFlags getNegatedClassAccessFlags() {
        return this.negatedClassAccessFlags;
    }

    public List<ProguardTypeMatcher> getClassAnnotations() {
        return this.classAnnotations;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProguardClassSpecification)) {
            return false;
        }
        ProguardClassSpecification that = (ProguardClassSpecification)o;
        if (this.classTypeNegated != that.classTypeNegated) {
            return false;
        }
        if (this.inheritanceIsExtends != that.inheritanceIsExtends) {
            return false;
        }
        if (!Objects.equals(this.classAnnotations, that.classAnnotations)) {
            return false;
        }
        if (!this.classAccessFlags.equals(that.classAccessFlags)) {
            return false;
        }
        if (!this.negatedClassAccessFlags.equals(that.negatedClassAccessFlags)) {
            return false;
        }
        if (this.classType != that.classType) {
            return false;
        }
        if (!this.classNames.equals(that.classNames)) {
            return false;
        }
        if (!Objects.equals(this.inheritanceAnnotations, that.inheritanceAnnotations)) {
            return false;
        }
        if (!Objects.equals(this.inheritanceClassName, that.inheritanceClassName)) {
            return false;
        }
        return this.memberRules.equals(that.memberRules);
    }

    public int hashCode() {
        int result = this.classAnnotations.hashCode();
        result = 3 * result + this.classAccessFlags.hashCode();
        result = 3 * result + this.negatedClassAccessFlags.hashCode();
        result = 3 * result + (this.classTypeNegated ? 1 : 0);
        result = 3 * result + (this.classType != null ? this.classType.hashCode() : 0);
        result = 3 * result + this.classNames.hashCode();
        result = 3 * result + this.inheritanceAnnotations.hashCode();
        result = 3 * result + (this.inheritanceClassName != null ? this.inheritanceClassName.hashCode() : 0);
        result = 3 * result + (this.inheritanceIsExtends ? 1 : 0);
        result = 3 * result + this.memberRules.hashCode();
        return result;
    }

    protected StringBuilder append(StringBuilder builder, boolean includeMemberRules) {
        ProguardClassSpecification.appendAnnotations(this.classAnnotations, builder);
        boolean needsSpaceBeforeClassType = StringUtils.appendNonEmpty(builder, null, this.classAccessFlags, null) | StringUtils.appendNonEmpty(builder, "!", this.negatedClassAccessFlags.toString().replace(" ", " !"), null);
        if (needsSpaceBeforeClassType) {
            builder.append(' ');
        }
        if (this.classTypeNegated) {
            builder.append('!');
        }
        builder.append((Object)this.classType);
        builder.append(' ');
        this.classNames.writeTo(builder);
        if (this.hasInheritanceClassName()) {
            builder.append(' ').append(this.inheritanceIsExtends ? "extends" : "implements").append(' ');
            ProguardClassSpecification.appendAnnotations(this.inheritanceAnnotations, builder);
            builder.append(this.inheritanceClassName);
        }
        if (includeMemberRules && !this.memberRules.isEmpty()) {
            builder.append(" {").append(System.lineSeparator());
            this.memberRules.forEach(memberRule -> {
                builder.append("  ");
                builder.append(memberRule);
                builder.append(";").append(System.lineSeparator());
            });
            builder.append("}");
        }
        return builder;
    }

    public String toShortString() {
        return this.append(new StringBuilder(), false).toString();
    }

    public String toString() {
        return this.append(new StringBuilder(), true).toString();
    }

    public static abstract class Builder<C extends ProguardClassSpecification, B extends Builder<C, B>> {
        protected Origin origin;
        protected Position start;
        protected Position end;
        protected String source;
        private final ImmutableList.Builder<ProguardTypeMatcher> classAnnotations = ImmutableList.builder();
        protected ProguardAccessFlags classAccessFlags = new ProguardAccessFlags();
        protected ProguardAccessFlags negatedClassAccessFlags = new ProguardAccessFlags();
        protected boolean classTypeNegated = false;
        protected ProguardClassType classType = ProguardClassType.UNSPECIFIED;
        protected ProguardClassNameList classNames;
        private final ImmutableList.Builder<ProguardTypeMatcher> inheritanceAnnotations = ImmutableList.builder();
        protected ProguardTypeMatcher inheritanceClassName;
        protected boolean inheritanceIsExtends = false;
        protected List<ProguardMemberRule> memberRules = new LinkedList<ProguardMemberRule>();

        protected Builder() {
            this(Origin.unknown(), Position.UNKNOWN);
        }

        protected Builder(Origin origin, Position start) {
            this.origin = origin;
            this.start = start;
        }

        public abstract C build();

        public abstract B self();

        public B setOrigin(Origin origin) {
            this.origin = origin;
            return this.self();
        }

        public B setStart(Position start) {
            this.start = start;
            return this.self();
        }

        public B setEnd(Position end) {
            this.end = end;
            return this.self();
        }

        public B setSource(String source) {
            this.source = source;
            return this.self();
        }

        public Position getPosition() {
            if (this.start == null) {
                return Position.UNKNOWN;
            }
            if (this.end == null || !(this.start instanceof TextPosition) || !(this.end instanceof TextPosition)) {
                return this.start;
            }
            return new TextRange((TextPosition)this.start, (TextPosition)this.end);
        }

        public List<ProguardMemberRule> getMemberRules() {
            return this.memberRules;
        }

        public B setMemberRules(List<ProguardMemberRule> memberRules) {
            this.memberRules = memberRules;
            return this.self();
        }

        public boolean getInheritanceIsExtends() {
            return this.inheritanceIsExtends;
        }

        public B setInheritanceIsExtends(boolean inheritanceIsExtends) {
            this.inheritanceIsExtends = inheritanceIsExtends;
            return this.self();
        }

        public boolean hasInheritanceClassName() {
            return this.inheritanceClassName != null;
        }

        public ProguardTypeMatcher getInheritanceClassName() {
            return this.inheritanceClassName;
        }

        public B setInheritanceClassName(ProguardTypeMatcher inheritanceClassName) {
            this.inheritanceClassName = inheritanceClassName;
            return this.self();
        }

        public B addInheritanceAnnotations(List<ProguardTypeMatcher> inheritanceAnnotations) {
            assert (inheritanceAnnotations != null);
            this.inheritanceAnnotations.addAll(inheritanceAnnotations);
            return this.self();
        }

        public List<ProguardTypeMatcher> buildInheritanceAnnotations() {
            return this.inheritanceAnnotations.build();
        }

        public ProguardClassNameList getClassNames() {
            return this.classNames;
        }

        public B setClassNames(ProguardClassNameList classNames) {
            this.classNames = classNames;
            return this.self();
        }

        public ProguardClassType getClassType() {
            return this.classType;
        }

        public B setClassType(ProguardClassType classType) {
            this.classType = classType;
            return this.self();
        }

        public boolean getClassTypeNegated() {
            return this.classTypeNegated;
        }

        public B setClassTypeNegated(boolean classTypeNegated) {
            this.classTypeNegated = classTypeNegated;
            return this.self();
        }

        public ProguardAccessFlags getClassAccessFlags() {
            return this.classAccessFlags;
        }

        public B setClassAccessFlags(ProguardAccessFlags flags) {
            this.classAccessFlags = flags;
            return this.self();
        }

        public ProguardAccessFlags getNegatedClassAccessFlags() {
            return this.negatedClassAccessFlags;
        }

        public B setNegatedClassAccessFlags(ProguardAccessFlags flags) {
            this.negatedClassAccessFlags = flags;
            return this.self();
        }

        public B addClassAnnotation(ProguardTypeMatcher classAnnotation) {
            this.classAnnotations.add((Object)classAnnotation);
            return this.self();
        }

        public B addClassAnnotations(List<ProguardTypeMatcher> classAnnotations) {
            assert (classAnnotations != null);
            this.classAnnotations.addAll(classAnnotations);
            return this.self();
        }

        public List<ProguardTypeMatcher> buildClassAnnotations() {
            return this.classAnnotations.build();
        }

        protected void matchAllSpecification() {
            this.setClassNames(ProguardClassNameList.singletonList(ProguardTypeMatcher.defaultAllMatcher()));
            this.setMemberRules(ImmutableList.of(ProguardMemberRule.defaultKeepAllRule()));
        }
    }
}

