/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.PrunedItems;
import java.util.Set;

public class ProguardCompatibilityActions {
    private final Set<DexType> compatInstantiatedTypes;

    private ProguardCompatibilityActions(Set<DexType> compatInstantiatedTypes) {
        this.compatInstantiatedTypes = compatInstantiatedTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isCompatInstantiated(DexProgramClass clazz) {
        return this.compatInstantiatedTypes.contains(clazz.getType());
    }

    public ProguardCompatibilityActions withoutPrunedItems(PrunedItems prunedItems) {
        Builder builder = ProguardCompatibilityActions.builder();
        for (DexType compatInstantiatedType : this.compatInstantiatedTypes) {
            if (prunedItems.isRemoved(compatInstantiatedType)) continue;
            builder.addCompatInstantiatedType(compatInstantiatedType);
        }
        return builder.build();
    }

    public ProguardCompatibilityActions rewrittenWithLens(GraphLens lens) {
        Builder builder = ProguardCompatibilityActions.builder();
        for (DexType compatInstantiatedType : this.compatInstantiatedTypes) {
            builder.addCompatInstantiatedType(lens.lookupType(compatInstantiatedType));
        }
        return builder.build();
    }

    public static class Builder {
        private final Set<DexType> compatInstantiatedTypes = Sets.newIdentityHashSet();

        private void addCompatInstantiatedType(DexType type) {
            this.compatInstantiatedTypes.add(type);
        }

        public void addCompatInstantiatedType(DexProgramClass clazz) {
            this.addCompatInstantiatedType(clazz.getType());
        }

        public ProguardCompatibilityActions build() {
            return new ProguardCompatibilityActions(this.compatInstantiatedTypes);
        }
    }
}

