/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.shaking.ClassInlineRule;
import com.android.tools.r8.shaking.InlineRule;
import com.android.tools.r8.shaking.NoHorizontalClassMergingRule;
import com.android.tools.r8.shaking.ProguardAccessFlags;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleBase;
import com.android.tools.r8.shaking.ProguardKeepRuleModifiers;
import com.android.tools.r8.shaking.ProguardKeepRuleType;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWildcard;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ProguardIfRule
extends ProguardKeepRuleBase {
    private static final Origin NEVER_INLINE_ORIGIN = new Origin(Origin.root()){

        @Override
        public String part() {
            return "<SYNTHETIC_NEVER_INLINE_RULE>";
        }
    };
    private static final Origin NO_HORIZONTAL_CLASS_MERGING_ORIGIN = new Origin(Origin.root()){

        @Override
        public String part() {
            return "<SYNTHETIC_NO_HORIZONTAL_CLASS_MERGING_RULE>";
        }
    };
    private final Set<DexReference> preconditions;
    final ProguardKeepRule subsequentRule;
    private Map<DexField, DexField> inlinableFieldsInPrecondition = new ConcurrentHashMap<DexField, DexField>();

    private ProguardIfRule(Origin origin, Position position, String source, List<ProguardTypeMatcher> classAnnotations, ProguardAccessFlags classAccessFlags, ProguardAccessFlags negatedClassAccessFlags, boolean classTypeNegated, ProguardClassType classType, ProguardClassNameList classNames, List<ProguardTypeMatcher> inheritanceAnnotations, ProguardTypeMatcher inheritanceClassName, boolean inheritanceIsExtends, List<ProguardMemberRule> memberRules, ProguardKeepRule subsequentRule, Set<DexReference> preconditions) {
        super(origin, position, source, classAnnotations, classAccessFlags, negatedClassAccessFlags, classTypeNegated, classType, classNames, inheritanceAnnotations, inheritanceClassName, inheritanceIsExtends, memberRules, ProguardKeepRuleType.CONDITIONAL, ProguardKeepRuleModifiers.builder().build());
        this.subsequentRule = subsequentRule;
        this.preconditions = preconditions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<DexReference> getPreconditions() {
        return this.preconditions;
    }

    public ProguardKeepRule getSubsequentRule() {
        return this.subsequentRule;
    }

    public void addInlinableFieldMatchingPrecondition(DexField field) {
        this.inlinableFieldsInPrecondition.put(field, field);
    }

    public Set<DexField> getAndClearInlinableFieldsMatchingPrecondition() {
        Set<DexField> fields = this.inlinableFieldsInPrecondition.keySet();
        this.inlinableFieldsInPrecondition = null;
        return fields;
    }

    @Override
    protected Iterable<ProguardWildcard> getWildcards() {
        return Iterables.concat(super.getWildcards(), this.subsequentRule.getWildcards());
    }

    @Override
    public boolean isProguardIfRule() {
        return true;
    }

    @Override
    public ProguardIfRule asProguardIfRule() {
        return this;
    }

    protected ProguardIfRule materialize(DexItemFactory dexItemFactory, Set<DexReference> preconditions) {
        return new ProguardIfRule(this.getOrigin(), this.getPosition(), this.getSource(), ProguardTypeMatcher.materializeList(this.getClassAnnotations(), dexItemFactory), this.getClassAccessFlags(), this.getNegatedClassAccessFlags(), this.getClassTypeNegated(), this.getClassType(), this.getClassNames().materialize(dexItemFactory), ProguardTypeMatcher.materializeList(this.getInheritanceAnnotations(), dexItemFactory), this.getInheritanceClassName() == null ? null : this.getInheritanceClassName().materialize(dexItemFactory), this.getInheritanceIsExtends(), this.getMemberRules() == null ? null : this.getMemberRules().stream().map(memberRule -> memberRule.materialize(dexItemFactory)).collect(Collectors.toList()), this.subsequentRule.materialize(dexItemFactory), preconditions);
    }

    protected ClassInlineRule neverClassInlineRuleForCondition(DexItemFactory dexItemFactory) {
        return new ClassInlineRule(NEVER_INLINE_ORIGIN, Position.UNKNOWN, null, ProguardTypeMatcher.materializeList(this.getClassAnnotations(), dexItemFactory), this.getClassAccessFlags(), this.getNegatedClassAccessFlags(), this.getClassTypeNegated(), this.getClassType(), this.getClassNames().materialize(dexItemFactory), ProguardTypeMatcher.materializeList(this.getInheritanceAnnotations(), dexItemFactory), this.getInheritanceClassName() == null ? null : this.getInheritanceClassName().materialize(dexItemFactory), this.getInheritanceIsExtends(), ImmutableList.of(), ClassInlineRule.Type.NEVER);
    }

    protected InlineRule neverInlineRuleForCondition(DexItemFactory dexItemFactory, InlineRule.Type type) {
        if (this.getMemberRules() == null || this.getMemberRules().isEmpty()) {
            return null;
        }
        return new InlineRule(NEVER_INLINE_ORIGIN, Position.UNKNOWN, null, ProguardTypeMatcher.materializeList(this.getClassAnnotations(), dexItemFactory), this.getClassAccessFlags(), this.getNegatedClassAccessFlags(), this.getClassTypeNegated(), this.getClassType(), this.getClassNames().materialize(dexItemFactory), ProguardTypeMatcher.materializeList(this.getInheritanceAnnotations(), dexItemFactory), this.getInheritanceClassName() == null ? null : this.getInheritanceClassName().materialize(dexItemFactory), this.getInheritanceIsExtends(), this.getMemberRules().stream().filter(rule -> rule.getRuleType().includesMethods()).map(memberRule -> memberRule.materialize(dexItemFactory)).collect(Collectors.toList()), type);
    }

    protected NoHorizontalClassMergingRule noHorizontalClassMergingRuleForCondition(DexItemFactory dexItemFactory) {
        List<ProguardMemberRule> memberRules = null;
        if (this.getMemberRules() != null) {
            memberRules = this.getMemberRules().stream().filter(rule -> rule.getRuleType().includesMethods()).map(memberRule -> memberRule.materialize(dexItemFactory)).collect(Collectors.toList());
        }
        return ((NoHorizontalClassMergingRule.Builder)((NoHorizontalClassMergingRule.Builder)((NoHorizontalClassMergingRule.Builder)((NoHorizontalClassMergingRule.Builder)((NoHorizontalClassMergingRule.Builder)((NoHorizontalClassMergingRule.Builder)((NoHorizontalClassMergingRule.Builder)((NoHorizontalClassMergingRule.Builder)((NoHorizontalClassMergingRule.Builder)((NoHorizontalClassMergingRule.Builder)((NoHorizontalClassMergingRule.Builder)NoHorizontalClassMergingRule.builder().setOrigin(NO_HORIZONTAL_CLASS_MERGING_ORIGIN)).addClassAnnotations(ProguardTypeMatcher.materializeList(this.getClassAnnotations(), dexItemFactory))).setClassAccessFlags(this.getClassAccessFlags())).setNegatedClassAccessFlags(this.getNegatedClassAccessFlags())).setClassType(this.getClassType())).setClassTypeNegated(this.getClassTypeNegated())).setClassNames(this.getClassNames().materialize(dexItemFactory))).addInheritanceAnnotations(ProguardTypeMatcher.materializeList(this.getInheritanceAnnotations(), dexItemFactory))).setInheritanceClassName(this.getInheritanceClassName() == null ? null : this.getInheritanceClassName().materialize(dexItemFactory))).setInheritanceIsExtends(this.getInheritanceIsExtends())).setMemberRules(memberRules)).build();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ProguardIfRule)) {
            return false;
        }
        ProguardIfRule other = (ProguardIfRule)o;
        if (!this.subsequentRule.equals(other.subsequentRule)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 3 + this.subsequentRule.hashCode();
    }

    @Override
    String typeString() {
        return "if";
    }

    public static class Builder
    extends ProguardKeepRuleBase.Builder<ProguardIfRule, Builder> {
        ProguardKeepRule subsequentRule = null;

        protected Builder() {
        }

        @Override
        public Builder self() {
            return this;
        }

        public void setSubsequentRule(ProguardKeepRule rule) {
            this.subsequentRule = rule;
        }

        @Override
        public ProguardIfRule build() {
            assert (this.subsequentRule != null) : "Option -if without a subsequent rule.";
            return new ProguardIfRule(this.origin, this.getPosition(), this.source, this.buildClassAnnotations(), this.classAccessFlags, this.negatedClassAccessFlags, this.classTypeNegated, this.classType, this.classNames, this.buildInheritanceAnnotations(), this.inheritanceClassName, this.inheritanceIsExtends, this.memberRules, this.subsequentRule, null);
        }
    }
}

