/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.AnnotationMatchResult;
import com.android.tools.r8.shaking.DexStringCache;
import com.android.tools.r8.shaking.ProguardAccessFlags;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardMemberRuleReturnValue;
import com.android.tools.r8.shaking.ProguardMemberType;
import com.android.tools.r8.shaking.ProguardNameMatcher;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWildcard;
import com.android.tools.r8.shaking.RootSetUtils;
import com.android.tools.r8.utils.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ProguardMemberRule {
    private final List<ProguardTypeMatcher> annotations;
    private final ProguardAccessFlags accessFlags;
    private final ProguardAccessFlags negatedAccessFlags;
    private final ProguardMemberType ruleType;
    private final ProguardTypeMatcher type;
    private final ProguardNameMatcher name;
    private final List<ProguardTypeMatcher> arguments;
    private final ProguardMemberRuleReturnValue returnValue;

    private ProguardMemberRule(List<ProguardTypeMatcher> annotations, ProguardAccessFlags accessFlags, ProguardAccessFlags negatedAccessFlags, ProguardMemberType ruleType, ProguardTypeMatcher type, ProguardNameMatcher name, List<ProguardTypeMatcher> arguments, ProguardMemberRuleReturnValue returnValue) {
        this.annotations = annotations;
        this.accessFlags = accessFlags;
        this.negatedAccessFlags = negatedAccessFlags;
        this.ruleType = ruleType;
        this.type = type;
        this.name = name;
        this.arguments = arguments != null ? Collections.unmodifiableList(arguments) : null;
        this.returnValue = returnValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ProguardMemberRule defaultKeepAllRule() {
        Builder ruleBuilder = new Builder();
        ruleBuilder.setRuleType(ProguardMemberType.ALL);
        return ruleBuilder.build();
    }

    public List<ProguardTypeMatcher> getAnnotations() {
        return this.annotations;
    }

    public ProguardAccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    public ProguardAccessFlags getNegatedAccessFlags() {
        return this.negatedAccessFlags;
    }

    public ProguardMemberType getRuleType() {
        return this.ruleType;
    }

    public ProguardTypeMatcher getType() {
        return this.type;
    }

    public ProguardNameMatcher getName() {
        return this.name;
    }

    public List<ProguardTypeMatcher> getArguments() {
        return this.arguments;
    }

    public boolean hasReturnValue() {
        return this.returnValue != null;
    }

    public ProguardMemberRuleReturnValue getReturnValue() {
        return this.returnValue;
    }

    public ProguardTypeMatcher getTypeMatcher() {
        return this.type;
    }

    public boolean matches(DexClassAndField field, AppView<?> appView, Consumer<AnnotationMatchResult> matchedAnnotationsConsumer, DexStringCache stringCache) {
        DexField originalSignature = appView.graphLens().getOriginalFieldSignature((DexField)field.getReference());
        switch (this.getRuleType()) {
            case ALL: 
            case ALL_FIELDS: {
                if (!this.getAccessFlags().containsAll(field.getAccessFlags()) || !this.getNegatedAccessFlags().containsNone(field.getAccessFlags())) break;
                return RootSetUtils.RootSetBuilder.containsAllAnnotations(this.annotations, field, matchedAnnotationsConsumer);
            }
            case FIELD: {
                String name = stringCache.lookupString(originalSignature.name);
                if (!this.getName().matches(name) || !this.getAccessFlags().containsAll(field.getAccessFlags()) || !this.getNegatedAccessFlags().containsNone(field.getAccessFlags()) || !this.getType().matches(originalSignature.type, appView)) break;
                return RootSetUtils.RootSetBuilder.containsAllAnnotations(this.annotations, field, matchedAnnotationsConsumer);
            }
        }
        return false;
    }

    public boolean matches(DexClassAndMethod method, AppView<?> appView, Consumer<AnnotationMatchResult> matchedAnnotationsConsumer, DexStringCache stringCache) {
        DexMethod originalSignature = appView.graphLens().getOriginalMethodSignature((DexMethod)method.getReference());
        switch (this.getRuleType()) {
            case ALL_METHODS: {
                if (((DexEncodedMethod)method.getDefinition()).isClassInitializer()) break;
            }
            case ALL: {
                if (!this.getAccessFlags().containsAll(method.getAccessFlags()) || !this.getNegatedAccessFlags().containsNone(method.getAccessFlags())) break;
                return RootSetUtils.RootSetBuilder.containsAllAnnotations(this.annotations, method, matchedAnnotationsConsumer);
            }
            case METHOD: {
                if (!this.type.matches(originalSignature.getReturnType(), appView)) break;
            }
            case CLINIT: 
            case INIT: 
            case CONSTRUCTOR: {
                String name = stringCache.lookupString(originalSignature.name);
                if (!this.getName().matches(name) || !this.getAccessFlags().containsAll(method.getAccessFlags()) || !this.getNegatedAccessFlags().containsNone(method.getAccessFlags())) break;
                if (!RootSetUtils.RootSetBuilder.containsAllAnnotations(this.annotations, method, matchedAnnotationsConsumer)) {
                    return false;
                }
                List<ProguardTypeMatcher> arguments = this.getArguments();
                if (arguments.size() == 1 && arguments.get(0).isTripleDotPattern()) {
                    return true;
                }
                DexType[] parameters = originalSignature.getParameters().values;
                if (parameters.length != arguments.size()) break;
                for (int i = 0; i < parameters.length; ++i) {
                    if (arguments.get(i).matches(parameters[i], appView)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isSpecific() {
        switch (this.getRuleType()) {
            case ALL: 
            case ALL_FIELDS: 
            case ALL_METHODS: {
                return false;
            }
        }
        return Iterables.size(this.getWildcards()) == 0;
    }

    Iterable<ProguardWildcard> getWildcards() {
        return Iterables.concat(ProguardTypeMatcher.getWildcardsOrEmpty(this.annotations), ProguardTypeMatcher.getWildcardsOrEmpty(this.type), ProguardNameMatcher.getWildcardsOrEmpty(this.name), this.arguments != null ? this.arguments.stream().map(ProguardTypeMatcher::getWildcards).flatMap(it -> StreamSupport.stream(it.spliterator(), false))::iterator : Collections::emptyIterator);
    }

    ProguardMemberRule materialize(DexItemFactory dexItemFactory) {
        return new ProguardMemberRule(ProguardTypeMatcher.materializeList(this.getAnnotations(), dexItemFactory), this.getAccessFlags(), this.getNegatedAccessFlags(), this.getRuleType(), this.getType() == null ? null : this.getType().materialize(dexItemFactory), this.getName() == null ? null : this.getName().materialize(), this.getArguments() == null ? null : this.getArguments().stream().map(argument -> argument.materialize(dexItemFactory)).collect(Collectors.toList()), this.getReturnValue());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProguardMemberRule)) {
            return false;
        }
        ProguardMemberRule that = (ProguardMemberRule)o;
        if (!this.annotations.equals(that.annotations)) {
            return false;
        }
        if (!this.accessFlags.equals(that.accessFlags)) {
            return false;
        }
        if (!this.negatedAccessFlags.equals(that.negatedAccessFlags)) {
            return false;
        }
        if (this.ruleType != that.ruleType) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return this.arguments != null ? this.arguments.equals(that.arguments) : that.arguments == null;
    }

    public int hashCode() {
        int result = this.annotations.hashCode();
        result = 31 * result + this.accessFlags.hashCode();
        result = 31 * result + this.negatedAccessFlags.hashCode();
        result = 31 * result + (this.ruleType != null ? this.ruleType.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (ProguardTypeMatcher annotation : this.annotations) {
            ProguardKeepRule.appendNonEmpty(result, "@", annotation, " ");
        }
        ProguardKeepRule.appendNonEmpty(result, null, this.accessFlags, " ");
        ProguardKeepRule.appendNonEmpty(result, null, this.negatedAccessFlags.toString().replace(" ", " !"), " ");
        switch (this.getRuleType()) {
            case ALL_FIELDS: {
                result.append("<fields>");
                break;
            }
            case ALL_METHODS: {
                result.append("<methods>");
                break;
            }
            case METHOD: {
                result.append(this.getType());
                result.append(' ');
            }
            case CLINIT: 
            case INIT: 
            case CONSTRUCTOR: {
                result.append(this.getName());
                result.append('(');
                result.append(StringUtils.join(",", this.getArguments()));
                result.append(')');
                break;
            }
            case FIELD: {
                result.append(this.getType());
                result.append(' ');
                result.append(this.getName());
                break;
            }
            case ALL: {
                result.append("*");
                break;
            }
            default: {
                throw new Unreachable("Unknown kind of member rule");
            }
        }
        if (this.hasReturnValue()) {
            result.append(this.returnValue.toString());
        }
        return result.toString();
    }

    public static class Builder {
        private List<ProguardTypeMatcher> annotations = Collections.emptyList();
        private ProguardAccessFlags accessFlags = new ProguardAccessFlags();
        private ProguardAccessFlags negatedAccessFlags = new ProguardAccessFlags();
        private ProguardMemberType ruleType;
        private ProguardTypeMatcher type;
        private ProguardNameMatcher name;
        private List<ProguardTypeMatcher> arguments;
        private ProguardMemberRuleReturnValue returnValue;

        private Builder() {
        }

        public void setAnnotations(List<ProguardTypeMatcher> annotations) {
            assert (annotations != null);
            this.annotations = annotations;
        }

        public ProguardAccessFlags getAccessFlags() {
            return this.accessFlags;
        }

        public Builder setAccessFlags(ProguardAccessFlags flags) {
            this.accessFlags = flags;
            return this;
        }

        public ProguardAccessFlags getNegatedAccessFlags() {
            return this.negatedAccessFlags;
        }

        public void setNegatedAccessFlags(ProguardAccessFlags flags) {
            this.negatedAccessFlags = flags;
        }

        public Builder setRuleType(ProguardMemberType ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        public ProguardTypeMatcher getTypeMatcher() {
            return this.type;
        }

        public Builder setTypeMatcher(ProguardTypeMatcher type) {
            this.type = type;
            return this;
        }

        public Builder setName(ProguardConfigurationParser.IdentifierPatternWithWildcards identifierPatternWithWildcards) {
            this.name = ProguardNameMatcher.create(identifierPatternWithWildcards);
            return this;
        }

        public Builder setArguments(List<ProguardTypeMatcher> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder setReturnValue(ProguardMemberRuleReturnValue value) {
            this.returnValue = value;
            return this;
        }

        public boolean isValid() {
            return this.ruleType != null;
        }

        public ProguardMemberRule build() {
            assert (this.isValid());
            return new ProguardMemberRule(this.annotations, this.accessFlags, this.negatedAccessFlags, this.ruleType, this.type, this.name, this.arguments, this.returnValue);
        }
    }
}

