/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import java.util.List;

public abstract class ProguardPathList {
    public static Builder builder() {
        return new Builder();
    }

    public static ProguardPathList emptyList() {
        return new EmptyPathList();
    }

    abstract boolean matches(String var1);

    private static class EmptyPathList
    extends ProguardPathList {
        private EmptyPathList() {
        }

        @Override
        boolean matches(String path) {
            return true;
        }
    }

    private static class PathList
    extends ProguardPathList {
        private final List<FileNameMatcher> matchers;

        private PathList(List<FileNameMatcher> matchers) {
            this.matchers = matchers;
        }

        @Override
        boolean matches(String path) {
            for (FileNameMatcher matcher : this.matchers) {
                if (!matcher.match(path)) continue;
                return !matcher.negated;
            }
            return false;
        }
    }

    private static class FileNameMatcher {
        public final boolean negated;
        public final String pattern;

        FileNameMatcher(boolean negated, String pattern) {
            this.negated = negated;
            this.pattern = pattern;
        }

        private boolean match(String path) {
            return this.matchImpl(this.pattern, 0, path, 0);
        }

        private boolean matchImpl(String pattern, int patternIndex, String path, int pathIndex) {
            block4: for (int i = patternIndex; i < pattern.length(); ++i) {
                char patternChar = pattern.charAt(i);
                switch (patternChar) {
                    case '*': {
                        boolean includeSeparators = pattern.length() > i + 1 && pattern.charAt(i + 1) == '*';
                        int nextPatternIndex = i + (includeSeparators ? 2 : 1);
                        if (nextPatternIndex == pattern.length()) {
                            return includeSeparators || !this.containsSeparatorsStartingAt(path, pathIndex);
                        }
                        for (int nextPathIndex = pathIndex; nextPathIndex < path.length(); ++nextPathIndex) {
                            if (!includeSeparators && path.charAt(nextPathIndex) == '/') {
                                return this.matchImpl(pattern, nextPatternIndex, path, nextPathIndex);
                            }
                            if (!this.matchImpl(pattern, nextPatternIndex, path, nextPathIndex)) continue;
                            return true;
                        }
                        continue block4;
                    }
                    case '?': {
                        if (pathIndex != path.length() && path.charAt(pathIndex++) != '/') continue block4;
                        return false;
                    }
                    default: {
                        if (pathIndex != path.length() && patternChar == path.charAt(pathIndex++)) continue block4;
                        return false;
                    }
                }
            }
            return pathIndex == path.length();
        }

        private boolean containsSeparatorsStartingAt(String path, int pathIndex) {
            return path.indexOf(47, pathIndex) != -1;
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<FileNameMatcher> matchers = ImmutableList.builder();

        private Builder() {
        }

        public Builder addFileName(String path) {
            return this.addFileName(path, false);
        }

        public Builder addFileName(String path, boolean isNegated) {
            this.matchers.add((Object)new FileNameMatcher(isNegated, path));
            return this;
        }

        public ProguardPathList build() {
            ImmutableCollection matchers = this.matchers.build();
            if (matchers.size() > 0) {
                return new PathList((List)((Object)matchers));
            }
            return ProguardPathList.emptyList();
        }
    }
}

