/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardWildcard;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ProguardTypeMatcher {
    private static final String MATCH_ALL_PATTERN = "***";
    private static final String MATCH_ANY_ARG_SEQUENCE_PATTERN = "...";
    private static final String LEGACY_MATCH_CLASS_PATTERN = "*";
    private static final String MATCH_CLASS_PATTERN = "**";
    private static final String MATCH_BASIC_PATTERN = "%";

    private ProguardTypeMatcher() {
    }

    static Iterable<ProguardWildcard> getWildcardsOrEmpty(ProguardTypeMatcher typeMatcher) {
        return typeMatcher == null ? Collections::emptyIterator : typeMatcher.getWildcards();
    }

    static Iterable<ProguardWildcard> getWildcardsOrEmpty(List<ProguardTypeMatcher> typeMatchers) {
        ArrayList<ProguardWildcard> result = new ArrayList<ProguardWildcard>();
        for (ProguardTypeMatcher typeMatcher : typeMatchers) {
            typeMatcher.getWildcards().forEach(result::add);
        }
        return result;
    }

    public static List<ProguardTypeMatcher> materializeList(List<ProguardTypeMatcher> matchers, DexItemFactory dexItemFactory) {
        if (matchers.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ProguardTypeMatcher matcher : matchers) {
            builder.add(matcher.materialize(dexItemFactory));
        }
        return builder.build();
    }

    public static ProguardTypeMatcher create(ProguardConfigurationParser.IdentifierPatternWithWildcards identifierPatternWithWildcards, ClassOrType kind, DexItemFactory dexItemFactory) {
        if (identifierPatternWithWildcards == null || identifierPatternWithWildcards.pattern == null) {
            return null;
        }
        switch (identifierPatternWithWildcards.pattern) {
            case "***": {
                return MatchAllTypes.MATCH_ALL_TYPES;
            }
            case "...": {
                return MatchAnyArgSequence.MATCH_ANY_ARG_SEQUENCE;
            }
            case "**": {
                return MatchClassTypes.MATCH_CLASS_TYPES;
            }
            case "*": {
                return MatchClassTypes.LEGACY_MATCH_CLASS_TYPES;
            }
            case "%": {
                return MatchBasicTypes.MATCH_BASIC_TYPES;
            }
        }
        if (identifierPatternWithWildcards.wildcards.isEmpty()) {
            return new MatchSpecificType(dexItemFactory.createType(DescriptorUtils.javaTypeToDescriptor(identifierPatternWithWildcards.pattern)));
        }
        return new MatchTypePattern(identifierPatternWithWildcards, kind);
    }

    public static ProguardTypeMatcher create(DexType type) {
        return new MatchSpecificType(type);
    }

    public static ProguardTypeMatcher defaultAllMatcher() {
        return MatchAllTypes.MATCH_ALL_TYPES;
    }

    public MatchSpecificType asSpecificTypeMatcher() {
        return null;
    }

    public abstract boolean matches(DexType var1);

    public final boolean matches(DexType type, AppView<?> appView) {
        if (this.matches(type)) {
            return true;
        }
        if (appView.verticallyMergedClasses() != null) {
            return appView.verticallyMergedClasses().getSourcesFor(type).stream().anyMatch(this::matches);
        }
        return false;
    }

    protected Iterable<ProguardWildcard> getWildcards() {
        return Collections::emptyIterator;
    }

    protected ProguardTypeMatcher materialize(DexItemFactory dexItemFactory) {
        return this;
    }

    public abstract String toString();

    public boolean isTripleDotPattern() {
        return false;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public boolean hasSpecificType() {
        return false;
    }

    public DexType getSpecificType() {
        return null;
    }

    public final boolean matchesSpecificType() {
        return this.getSpecificType() != null;
    }

    private static class MatchTypePattern
    extends ProguardTypeMatcher {
        private final String pattern;
        private final List<ProguardWildcard> wildcards;
        private final ClassOrType kind;

        private MatchTypePattern(ProguardConfigurationParser.IdentifierPatternWithWildcards identifierPatternWithWildcards, ClassOrType kind) {
            this.pattern = identifierPatternWithWildcards.pattern;
            this.wildcards = identifierPatternWithWildcards.wildcards;
            this.kind = kind;
        }

        private static String removeMaterializedBackReferencesFromPattern(String pattern, Int2ReferenceMap<String> materializedBackReferences) {
            int currentIndex;
            StringBuilder builder = new StringBuilder();
            int startIndex = 0;
            for (currentIndex = 0; currentIndex < pattern.length(); ++currentIndex) {
                String captured;
                int backReferenceEndIndex;
                char c = pattern.charAt(currentIndex);
                if (c != '<') continue;
                for (backReferenceEndIndex = currentIndex + 1; backReferenceEndIndex < pattern.length() && pattern.charAt(backReferenceEndIndex) != '>'; ++backReferenceEndIndex) {
                }
                if (backReferenceEndIndex == pattern.length()) break;
                String reference = pattern.substring(currentIndex + 1, backReferenceEndIndex);
                if (reference.isEmpty() || !StringUtils.onlyContainsDigits(reference) || (captured = (String)materializedBackReferences.get(Integer.valueOf(reference))) == null) continue;
                String before = pattern.substring(startIndex, currentIndex);
                builder.append(before);
                builder.append(captured);
                startIndex = backReferenceEndIndex + 1;
                currentIndex = backReferenceEndIndex;
            }
            assert (currentIndex == pattern.length());
            if (startIndex < currentIndex) {
                builder.append(pattern.substring(startIndex));
            }
            return builder.toString();
        }

        private static boolean matchClassOrTypeNameImpl(String pattern, int patternIndex, String name, int nameIndex, List<ProguardWildcard> wildcards, int wildcardIndex, ClassOrType kind) {
            block5: for (int i = patternIndex; i < pattern.length(); ++i) {
                char patternChar = pattern.charAt(i);
                switch (patternChar) {
                    case '*': {
                        ProguardWildcard wildcard = wildcards.get(wildcardIndex);
                        assert (wildcard.isPattern());
                        ProguardWildcard.Pattern wildcardPattern = wildcard.asPattern();
                        boolean includeSeparators = pattern.length() > i + 1 && pattern.charAt(i + 1) == '*';
                        boolean includeAll = includeSeparators && pattern.length() > i + 2 && pattern.charAt(i + 2) == '*';
                        int nextPatternIndex = i + 1;
                        if (includeAll) {
                            nextPatternIndex += 2;
                        } else if (includeSeparators) {
                            ++nextPatternIndex;
                        }
                        if (nextPatternIndex == pattern.length()) {
                            wildcardPattern.setCaptured(name.substring(nameIndex));
                            if (includeAll) {
                                return true;
                            }
                            if (includeSeparators) {
                                return kind == ClassOrType.CLASS || !MatchTypePattern.isArrayType(name);
                            }
                            boolean hasSeparators = MatchTypePattern.containsSeparatorsStartingAt(name, nameIndex);
                            return !hasSeparators && (kind == ClassOrType.CLASS || !MatchTypePattern.isArrayType(name));
                        }
                        for (int nextNameIndex = nameIndex; nextNameIndex < name.length(); ++nextNameIndex) {
                            wildcardPattern.setCaptured(name.substring(nameIndex, nextNameIndex));
                            if (!includeSeparators && name.charAt(nextNameIndex) == '.') {
                                return MatchTypePattern.matchClassOrTypeNameImpl(pattern, nextPatternIndex, name, nextNameIndex, wildcards, wildcardIndex + 1, kind);
                            }
                            if (kind == ClassOrType.TYPE && name.charAt(nextNameIndex) == '[') {
                                return MatchTypePattern.matchClassOrTypeNameImpl(pattern, nextPatternIndex, name, nextNameIndex, wildcards, wildcardIndex + 1, kind);
                            }
                            if (!MatchTypePattern.matchClassOrTypeNameImpl(pattern, nextPatternIndex, name, nextNameIndex, wildcards, wildcardIndex + 1, kind)) continue;
                            return true;
                        }
                        wildcardPattern.setCaptured(name.substring(nameIndex));
                        return MatchTypePattern.matchClassOrTypeNameImpl(pattern, nextPatternIndex, name, name.length(), wildcards, wildcardIndex + 1, kind);
                    }
                    case '?': {
                        ProguardWildcard wildcard = wildcards.get(wildcardIndex);
                        assert (wildcard.isPattern());
                        if (nameIndex == name.length() || name.charAt(nameIndex) == '.') {
                            return false;
                        }
                        ProguardWildcard.Pattern wildcardPattern = wildcard.asPattern();
                        wildcardPattern.setCaptured(name.substring(nameIndex, nameIndex + 1));
                        ++nameIndex;
                        ++wildcardIndex;
                        continue block5;
                    }
                    case '<': {
                        ProguardWildcard wildcard = wildcards.get(wildcardIndex);
                        assert (wildcard.isBackReference());
                        ProguardWildcard.BackReference backReference = wildcard.asBackReference();
                        String captured = backReference.getCaptured();
                        if (captured == null || name.length() < nameIndex + captured.length() || !captured.equals(name.substring(nameIndex, nameIndex + captured.length()))) {
                            return false;
                        }
                        nameIndex += captured.length();
                        ++wildcardIndex;
                        i = pattern.indexOf(">", i);
                        continue block5;
                    }
                    default: {
                        if (nameIndex != name.length() && patternChar == name.charAt(nameIndex++)) continue block5;
                        return false;
                    }
                }
            }
            return nameIndex == name.length();
        }

        private static boolean containsSeparatorsStartingAt(String className, int nameIndex) {
            return className.indexOf(46, nameIndex) != -1;
        }

        private static boolean isArrayType(String type) {
            int length = type.length();
            if (length < 2) {
                return false;
            }
            return type.charAt(length - 1) == ']' && type.charAt(length - 2) == '[';
        }

        @Override
        public boolean matches(DexType type) {
            String typeName = type.toSourceString();
            boolean matched = MatchTypePattern.matchClassOrTypeNameImpl(this.pattern, 0, typeName, 0, this.wildcards, 0, this.kind);
            if (!matched) {
                this.wildcards.forEach(ProguardWildcard::clearCaptured);
            }
            return matched;
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return this.wildcards;
        }

        @Override
        protected ProguardTypeMatcher materialize(DexItemFactory dexItemFactory) {
            Int2ReferenceOpenHashMap<String> materializedBackReferences = new Int2ReferenceOpenHashMap<String>();
            ArrayList<ProguardWildcard> materializedWildcards = new ArrayList<ProguardWildcard>();
            for (ProguardWildcard wildcard : this.wildcards) {
                ProguardWildcard materializedWildcard = wildcard.materialize();
                if (materializedWildcard.isBackReference()) {
                    ProguardWildcard.BackReference materializedBackReference = materializedWildcard.asBackReference();
                    materializedBackReferences.put(materializedBackReference.referenceIndex, materializedBackReference.getCaptured());
                    continue;
                }
                materializedWildcards.add(materializedWildcard);
            }
            if (!materializedBackReferences.isEmpty()) {
                String newPattern = MatchTypePattern.removeMaterializedBackReferencesFromPattern(this.pattern, materializedBackReferences);
                if (!newPattern.contains(ProguardTypeMatcher.LEGACY_MATCH_CLASS_PATTERN)) {
                    String descriptor = DescriptorUtils.javaTypeToDescriptor(newPattern);
                    DexType type = dexItemFactory.createType(descriptor);
                    return new MatchSpecificType(type);
                }
                ProguardConfigurationParser.IdentifierPatternWithWildcards identifierPatternWithMaterializedWildcards = new ProguardConfigurationParser.IdentifierPatternWithWildcards(newPattern, materializedWildcards);
                return new MatchTypePattern(identifierPatternWithMaterializedWildcards, this.kind);
            }
            ProguardConfigurationParser.IdentifierPatternWithWildcards identifierPatternWithMaterializedWildcards = new ProguardConfigurationParser.IdentifierPatternWithWildcards(this.pattern, materializedWildcards);
            return new MatchTypePattern(identifierPatternWithMaterializedWildcards, this.kind);
        }

        @Override
        public String toString() {
            return this.pattern;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof MatchTypePattern) {
                MatchTypePattern that = (MatchTypePattern)o;
                return this.kind.equals((Object)that.kind) && this.pattern.equals(that.pattern);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.pattern.hashCode() * 7 + this.kind.hashCode();
        }
    }

    public static class MatchSpecificType
    extends ProguardTypeMatcher {
        public final DexType type;

        private MatchSpecificType(DexType type) {
            this.type = type;
        }

        @Override
        public MatchSpecificType asSpecificTypeMatcher() {
            return this;
        }

        @Override
        public boolean matches(DexType type) {
            return this.type == type;
        }

        @Override
        public String toString() {
            return this.type.toSourceString();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof MatchSpecificType) {
                return this.type.equals(((MatchSpecificType)o).type);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.type.hashCode();
        }

        @Override
        public boolean hasSpecificType() {
            return true;
        }

        @Override
        public DexType getSpecificType() {
            return this.type;
        }
    }

    private static class MatchBasicTypes
    extends ProguardTypeMatcher {
        private static final ProguardTypeMatcher MATCH_BASIC_TYPES = new MatchBasicTypes();
        private final ProguardWildcard wildcard;

        MatchBasicTypes() {
            this(new ProguardWildcard.Pattern(ProguardTypeMatcher.MATCH_BASIC_PATTERN));
        }

        private MatchBasicTypes(ProguardWildcard wildcard) {
            this.wildcard = wildcard;
        }

        @Override
        public boolean matches(DexType type) {
            if (type.isPrimitiveType()) {
                this.wildcard.setCaptured(type.toSourceString());
                return true;
            }
            return false;
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return ImmutableList.of(this.wildcard);
        }

        @Override
        protected MatchBasicTypes materialize(DexItemFactory dexItemFactory) {
            return new MatchBasicTypes(this.wildcard.materialize());
        }

        @Override
        public String toString() {
            return ProguardTypeMatcher.MATCH_BASIC_PATTERN;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof MatchBasicTypes;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static class MatchClassTypes
    extends ProguardTypeMatcher {
        private static final ProguardTypeMatcher MATCH_CLASS_TYPES = new MatchClassTypes("**");
        private static final ProguardTypeMatcher LEGACY_MATCH_CLASS_TYPES = new MatchClassTypes("*");
        private final String pattern;
        private final ProguardWildcard wildcard;

        private MatchClassTypes(String pattern) {
            this(pattern, new ProguardWildcard.Pattern(pattern));
        }

        private MatchClassTypes(String pattern, ProguardWildcard wildcard) {
            assert (pattern.equals(ProguardTypeMatcher.LEGACY_MATCH_CLASS_PATTERN) || pattern.equals(ProguardTypeMatcher.MATCH_CLASS_PATTERN));
            this.pattern = pattern;
            this.wildcard = wildcard;
        }

        @Override
        public boolean matches(DexType type) {
            if (type.isClassType()) {
                this.wildcard.setCaptured(type.toSourceString());
                return true;
            }
            return false;
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return ImmutableList.of(this.wildcard);
        }

        @Override
        protected MatchClassTypes materialize(DexItemFactory dexItemFactory) {
            return new MatchClassTypes(this.pattern, this.wildcard.materialize());
        }

        @Override
        public String toString() {
            return this.pattern;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof MatchClassTypes && this.pattern.equals(((MatchClassTypes)o).pattern);
        }

        @Override
        public int hashCode() {
            return this.pattern.hashCode();
        }
    }

    private static class MatchAnyArgSequence
    extends ProguardTypeMatcher {
        private static final ProguardTypeMatcher MATCH_ANY_ARG_SEQUENCE = new MatchAnyArgSequence();

        private MatchAnyArgSequence() {
        }

        @Override
        public boolean matches(DexType type) {
            return true;
        }

        @Override
        public String toString() {
            return ProguardTypeMatcher.MATCH_ANY_ARG_SEQUENCE_PATTERN;
        }

        @Override
        public boolean isTripleDotPattern() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof MatchAnyArgSequence;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static class MatchAllTypes
    extends ProguardTypeMatcher {
        private static final ProguardTypeMatcher MATCH_ALL_TYPES = new MatchAllTypes();
        private final ProguardWildcard wildcard;

        MatchAllTypes() {
            this(new ProguardWildcard.Pattern(ProguardTypeMatcher.MATCH_ALL_PATTERN));
        }

        private MatchAllTypes(ProguardWildcard wildcard) {
            this.wildcard = wildcard;
        }

        @Override
        public boolean matches(DexType type) {
            this.wildcard.setCaptured(type.toSourceString());
            return true;
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return ImmutableList.of(this.wildcard);
        }

        @Override
        protected MatchAllTypes materialize(DexItemFactory dexItemFactory) {
            return new MatchAllTypes(this.wildcard.materialize());
        }

        @Override
        public String toString() {
            return ProguardTypeMatcher.MATCH_ALL_PATTERN;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof MatchAllTypes;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    static enum ClassOrType {
        CLASS,
        TYPE;

    }
}

