/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SingleTargetLookupCache {
    private Map<DexType, Map<DexMethod, DexEncodedMethod>> cache = new ConcurrentHashMap<DexType, Map<DexMethod, DexEncodedMethod>>();

    public void addToCache(DexType refinedReceiverType, DexMethod method, DexEncodedMethod target) {
        assert (target != DexEncodedMethod.SENTINEL);
        Map methodCache = this.cache.computeIfAbsent(refinedReceiverType, ignored -> new ConcurrentHashMap());
        DexEncodedMethod dexEncodedMethod = target = target == null ? DexEncodedMethod.SENTINEL : target;
        assert (methodCache.getOrDefault(method, target) == target);
        methodCache.putIfAbsent(method, target);
    }

    public void removeInstantiatedType(DexType instantiatedType, AppInfoWithLiveness appInfo) {
        this.cache.remove(instantiatedType);
        Set seen = Sets.newIdentityHashSet();
        appInfo.forEachInstantiatedSubType(instantiatedType, instance -> appInfo.traverseSuperTypes((DexClass)instance, (superType, subclass, ignore) -> {
            if (seen.add(superType)) {
                this.cache.remove(superType);
                return TraversalContinuation.doContinue();
            }
            return TraversalContinuation.doBreak();
        }), lambda -> {
            assert (false);
        });
    }

    public DexEncodedMethod getCachedItem(DexType receiverType, DexMethod method) {
        Map<DexMethod, DexEncodedMethod> cachedMethods = this.cache.get(receiverType);
        if (cachedMethods == null) {
            return null;
        }
        DexEncodedMethod target = cachedMethods.get(method);
        return target == DexEncodedMethod.SENTINEL ? null : target;
    }

    public boolean hasCachedItem(DexType receiverType, DexMethod method) {
        Map<DexMethod, DexEncodedMethod> cachedMethods = this.cache.get(receiverType);
        if (cachedMethods == null) {
            return false;
        }
        return cachedMethods.containsKey(method);
    }

    public void clear() {
        this.cache = new ConcurrentHashMap<DexType, Map<DexMethod, DexEncodedMethod>>();
    }
}

