/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DefaultInstanceInitializerCode;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.NestMemberClassAttribute;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.optimize.info.MutableFieldOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MutableMethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.DefaultTreePrunerConfiguration;
import com.android.tools.r8.shaking.TreePrunerConfiguration;
import com.android.tools.r8.shaking.UnusedItemsPrinter;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class TreePruner {
    private final AppView<AppInfoWithLiveness> appView;
    private final TreePrunerConfiguration configuration;
    private final UnusedItemsPrinter unusedItemsPrinter;
    private final Set<DexType> prunedTypes = Sets.newIdentityHashSet();
    private final Set<DexMethod> methodsToKeepForConfigurationDebugging = Sets.newIdentityHashSet();

    public TreePruner(AppView<AppInfoWithLiveness> appView) {
        this(appView, DefaultTreePrunerConfiguration.getInstance());
    }

    public TreePruner(AppView<AppInfoWithLiveness> appView, TreePrunerConfiguration configuration) {
        InternalOptions options = appView.options();
        this.appView = appView;
        this.configuration = configuration;
        this.unusedItemsPrinter = options.hasUsageInformationConsumer() ? new UnusedItemsPrinter(s2 -> ExceptionUtils.withConsumeResourceHandler(options.reporter, options.usageInformationConsumer, s2)) : UnusedItemsPrinter.DONT_PRINT;
    }

    private DirectMappedDexApplication.Builder removeUnused(DirectMappedDexApplication application) {
        return (DirectMappedDexApplication.Builder)application.builder().replaceProgramClasses(this.getNewProgramClasses(application.classesWithDeterministicOrder()));
    }

    private List<DexProgramClass> getNewProgramClasses(Collection<DexProgramClass> classes) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        InternalOptions options = this.appView.options();
        ArrayList<DexProgramClass> newClasses = new ArrayList<DexProgramClass>();
        for (DexProgramClass clazz : classes) {
            if (options.configurationDebugging) {
                newClasses.add(clazz);
                this.pruneMembersAndAttributes(clazz);
                continue;
            }
            if (appInfo.isLiveProgramClass(clazz)) {
                newClasses.add(clazz);
                if (!appInfo.getObjectAllocationInfoCollection().isInstantiatedDirectly(clazz) && !options.forceProguardCompatibility) {
                    if (clazz.isFinal()) {
                        clazz.accessFlags.demoteFromFinal();
                    }
                    clazz.accessFlags.setAbstract();
                }
                this.pruneUnusedInterfaces(clazz);
                this.pruneMembersAndAttributes(clazz);
                continue;
            }
            if (Log.ENABLED) {
                Log.debug(this.getClass(), "Removing class: " + clazz, new Object[0]);
            }
            this.prunedTypes.add(clazz.type);
            this.unusedItemsPrinter.registerUnusedClass(clazz);
        }
        this.unusedItemsPrinter.finished();
        return newClasses;
    }

    private void pruneUnusedInterfaces(DexProgramClass clazz) {
        LinkedHashSet<DexType> reachableInterfaces = new LinkedHashSet<DexType>();
        for (DexType type : clazz.getInterfaces()) {
            this.retainReachableInterfacesFrom(type, reachableInterfaces);
        }
        if (!reachableInterfaces.isEmpty()) {
            this.removeInterfacesImplementedDirectlyAndIndirectlyByClassFromSet(clazz.superType, reachableInterfaces);
        }
        clazz.interfaces = reachableInterfaces.isEmpty() ? DexTypeList.empty() : new DexTypeList(reachableInterfaces.toArray(DexType.EMPTY_ARRAY));
    }

    private void removeInterfacesImplementedDirectlyAndIndirectlyByClassFromSet(DexType type, Set<DexType> interfaces) {
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz == null) {
            return;
        }
        for (DexType itf : clazz.interfaces) {
            if (!interfaces.remove(itf) || !interfaces.isEmpty()) continue;
            return;
        }
        if (clazz.superType != null) {
            assert (!interfaces.isEmpty());
            this.removeInterfacesImplementedDirectlyAndIndirectlyByClassFromSet(clazz.superType, interfaces);
        }
    }

    private void retainReachableInterfacesFrom(DexType type, Set<DexType> reachableInterfaces) {
        if (this.isTypeLive(type)) {
            reachableInterfaces.add(type);
        } else {
            DexProgramClass unusedInterface = this.appView.definitionForProgramType(type);
            assert (unusedInterface != null);
            assert (unusedInterface.isInterface());
            for (DexType interfaceType : unusedInterface.interfaces.values) {
                this.retainReachableInterfacesFrom(interfaceType, reachableInterfaces);
            }
        }
    }

    private void pruneMembersAndAttributes(DexProgramClass clazz) {
        DexEncodedField[] reachableStaticFields;
        DexEncodedField[] reachableInstanceFields;
        DexEncodedMethod[] reachableVirtualMethods;
        this.unusedItemsPrinter.visiting(clazz);
        DexEncodedMethod[] reachableDirectMethods = this.reachableMethods(clazz.directMethods(), clazz);
        if (reachableDirectMethods != null) {
            clazz.setDirectMethods(reachableDirectMethods);
        }
        if ((reachableVirtualMethods = this.reachableMethods(clazz.virtualMethods(), clazz)) != null) {
            clazz.setVirtualMethods(reachableVirtualMethods);
        }
        if ((reachableInstanceFields = this.reachableFields(clazz.instanceFields())) != null) {
            clazz.setInstanceFields(reachableInstanceFields);
        }
        if ((reachableStaticFields = this.reachableFields(clazz.staticFields())) != null) {
            clazz.setStaticFields(reachableStaticFields);
        }
        clazz.removeInnerClasses(this::isAttributeReferencingMissingOrPrunedType);
        clazz.removeEnclosingMethodAttribute(this::isAttributeReferencingPrunedItem);
        TreePruner.rewriteNestAttributes(clazz, this::isTypeLive, this.appView::definitionFor);
        this.unusedItemsPrinter.visited();
        assert (this.verifyNoDeadFields(clazz));
    }

    public static void rewriteNestAttributes(DexProgramClass clazz, Predicate<DexType> isLive, Function<DexType, DexClass> definition) {
        if (!clazz.isInANest() || !isLive.test(clazz.type)) {
            return;
        }
        if (clazz.isNestHost()) {
            TreePruner.clearDeadNestMembers(clazz, isLive, definition);
        } else {
            assert (clazz.isNestMember());
            if (!isLive.test(clazz.getNestHost())) {
                TreePruner.claimNestOwnership(clazz, isLive, definition);
            }
        }
    }

    private boolean isTypeMissing(DexType type) {
        return this.appView.appInfo().getMissingClasses().contains(type);
    }

    private boolean isTypeLive(DexType type) {
        return this.appView.appInfo().isNonProgramTypeOrLiveProgramType(type);
    }

    private static void clearDeadNestMembers(DexClass nestHost, Predicate<DexType> isLive, Function<DexType, DexClass> definition) {
        nestHost.getNestMembersClassAttributes().removeIf(nestMemberAttr -> definition.apply(nestMemberAttr.getNestMember()) != null && !isLive.test(nestMemberAttr.getNestMember()));
    }

    private static void claimNestOwnership(DexClass newHost, Predicate<DexType> isLive, Function<DexType, DexClass> definition) {
        DexClass previousHost = definition.apply(newHost.getNestHost());
        if (previousHost == null) {
            return;
        }
        newHost.clearNestHost();
        for (NestMemberClassAttribute attr : previousHost.getNestMembersClassAttributes()) {
            if (attr.getNestMember() == newHost.type || !isLive.test(attr.getNestMember())) continue;
            DexClass nestMember = definition.apply(attr.getNestMember());
            if (nestMember != null) {
                nestMember.setNestHost(newHost.type);
            }
            newHost.getNestMembersClassAttributes().add(new NestMemberClassAttribute(attr.getNestMember()));
        }
    }

    private boolean isAttributeReferencingPrunedItem(EnclosingMethodAttribute attr) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        return attr.getEnclosingClass() != null && !this.isTypeLive(attr.getEnclosingClass()) || attr.getEnclosingMethod() != null && !appInfo.isLiveMethod(attr.getEnclosingMethod());
    }

    private boolean isAttributeReferencingMissingOrPrunedType(InnerClassAttribute attr) {
        if (this.isTypeMissing(attr.getInner()) || !this.isTypeLive(attr.getInner())) {
            return true;
        }
        DexType context = attr.getLiveContext(this.appView);
        return context == null || this.isTypeMissing(context) || !this.isTypeLive(context);
    }

    private <D extends DexEncodedMember<D, R>, R extends DexMember<D, R>> int firstUnreachableIndex(List<D> items, Predicate<D> live) {
        for (int i = 0; i < items.size(); ++i) {
            if (live.test((DexEncodedMember)items.get(i))) continue;
            return i;
        }
        return -1;
    }

    private DexEncodedMethod[] reachableMethods(Iterable<DexEncodedMethod> methods, DexProgramClass clazz) {
        return this.reachableMethods(IterableUtils.ensureUnmodifiableList(methods), clazz);
    }

    private DexEncodedMethod[] reachableMethods(List<DexEncodedMethod> methods, DexProgramClass clazz) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        InternalOptions options = this.appView.options();
        int firstUnreachable = this.firstUnreachableIndex(methods, method -> appInfo.isLiveMethod((DexMethod)method.getReference()));
        if (firstUnreachable == -1) {
            for (DexEncodedMethod method2 : methods) {
                this.canonicalizeCode(method2.asProgramMethod(clazz));
            }
            return null;
        }
        ArrayList<DexEncodedMethod> reachableMethods = new ArrayList<DexEncodedMethod>(methods.size());
        for (int i = 0; i < methods.size(); ++i) {
            DexEncodedMethod method3 = methods.get(i);
            if (appInfo.isLiveMethod((DexMethod)method3.getReference())) {
                this.canonicalizeCode(method3.asProgramMethod(clazz));
                reachableMethods.add(method3);
                continue;
            }
            if (options.configurationDebugging) {
                reachableMethods.add(method3.shouldNotHaveCode() && !method3.hasCode() ? method3 : method3.toMethodThatLogsError(this.appView));
                this.methodsToKeepForConfigurationDebugging.add((DexMethod)method3.getReference());
                continue;
            }
            if (appInfo.isTargetedMethod((DexMethod)method3.getReference())) {
                if (method3.shouldNotHaveCode() && !method3.hasCode()) {
                    reachableMethods.add(method3);
                    continue;
                }
                if (Log.ENABLED) {
                    Log.debug(this.getClass(), "Making method %s abstract.", method3.getReference());
                }
                new ProgramMethod(clazz, method3).convertToAbstractOrThrowNullMethod(this.appView);
                reachableMethods.add(method3);
                continue;
            }
            if (Log.ENABLED) {
                Log.debug(this.getClass(), "Removing method %s.", method3.getReference());
            }
            this.unusedItemsPrinter.registerUnusedMethod(method3);
        }
        return reachableMethods.isEmpty() ? DexEncodedMethod.EMPTY_ARRAY : reachableMethods.toArray(DexEncodedMethod.EMPTY_ARRAY);
    }

    private void canonicalizeCode(ProgramMethod method) {
        if (((DexEncodedMethod)method.getDefinition()).hasCode()) {
            DefaultInstanceInitializerCode.canonicalizeCodeIfPossible(this.appView, method);
        }
    }

    private DexEncodedField[] reachableFields(List<DexEncodedField> fields) {
        int i;
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        Predicate<DexEncodedField> isReachableOrReferencedField = field -> this.configuration.isReachableOrReferencedField(appInfo, (DexEncodedField)field);
        int firstUnreachable = this.firstUnreachableIndex(fields, isReachableOrReferencedField);
        if (firstUnreachable == -1) {
            return null;
        }
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Removing field %s.", fields.get(firstUnreachable));
        }
        this.unusedItemsPrinter.registerUnusedField(fields.get(firstUnreachable));
        ArrayList<DexEncodedField> reachableOrReferencedFields = new ArrayList<DexEncodedField>(fields.size());
        for (i = 0; i < firstUnreachable; ++i) {
            reachableOrReferencedFields.add(fields.get(i));
        }
        for (i = firstUnreachable + 1; i < fields.size(); ++i) {
            DexEncodedField field2 = fields.get(i);
            if (isReachableOrReferencedField.test(field2)) {
                reachableOrReferencedFields.add(field2);
                continue;
            }
            if (Log.ENABLED) {
                Log.debug(this.getClass(), "Removing field %s.", field2.getReference());
            }
            this.unusedItemsPrinter.registerUnusedField(field2);
        }
        return reachableOrReferencedFields.isEmpty() ? DexEncodedField.EMPTY_ARRAY : reachableOrReferencedFields.toArray(DexEncodedField.EMPTY_ARRAY);
    }

    private void fixupOptimizationInfo(DirectMappedDexApplication application, ExecutorService executorService) throws ExecutionException {
        this.appView.dexItemFactory().clearTypeElementsCache();
        OptimizationFeedbackSimple feedback = OptimizationFeedbackSimple.getInstance();
        feedback.fixupOptimizationInfos(application.classes(), executorService, new OptimizationFeedback.OptimizationInfoFixer(){

            @Override
            public void fixup(DexEncodedField field, MutableFieldOptimizationInfo optimizationInfo) {
                optimizationInfo.fixupClassTypeReferences(TreePruner.this.appView, TreePruner.this.appView.graphLens(), TreePruner.this.prunedTypes);
            }

            @Override
            public void fixup(DexEncodedMethod method, MutableMethodOptimizationInfo optimizationInfo) {
                optimizationInfo.fixupClassTypeReferences(TreePruner.this.appView, TreePruner.this.appView.graphLens(), TreePruner.this.prunedTypes);
            }
        });
        assert (this.appView.dexItemFactory().verifyNoCachedTypeElements());
    }

    private boolean verifyNoDeadFields(DexProgramClass clazz) {
        for (DexEncodedField field : clazz.fields()) {
            assert (!field.getOptimizationInfo().isDead() || this.appView.appInfo().isPinned(field)) : "Expected field `" + ((DexField)field.getReference()).toSourceString() + "` to be absent";
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectMappedDexApplication run(ExecutorService executorService) throws ExecutionException {
        DirectMappedDexApplication application = this.appView.appInfo().app().asDirect();
        Timing timing = application.timing;
        timing.begin("Pruning application...");
        try {
            DirectMappedDexApplication.Builder builder = this.removeUnused(application);
            DirectMappedDexApplication newApplication = this.prunedTypes.isEmpty() && !this.appView.options().configurationDebugging ? application : builder.build();
            this.fixupOptimizationInfo(newApplication, executorService);
            DirectMappedDexApplication directMappedDexApplication = newApplication;
            return directMappedDexApplication;
        }
        finally {
            timing.end();
        }
    }

    public Set<DexType> getRemovedClasses() {
        return Collections.unmodifiableSet(this.prunedTypes);
    }

    public Collection<DexMethod> getMethodsToKeepForConfigurationDebugging() {
        return Collections.unmodifiableCollection(this.methodsToKeepForConfigurationDebugging);
    }
}

