/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.synthesis;

import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.synthesis.Rewritable;
import com.android.tools.r8.synthesis.SyntheticClassReference;
import com.android.tools.r8.synthesis.SyntheticDefinition;
import com.android.tools.r8.synthesis.SyntheticMethodDefinition;
import com.android.tools.r8.synthesis.SyntheticMethodReference;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.synthesis.SyntheticProgramClassDefinition;
import com.android.tools.r8.synthesis.SyntheticProgramClassReference;
import com.android.tools.r8.synthesis.SyntheticReference;
import com.android.tools.r8.utils.IterableUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

class CommittedSyntheticsCollection {
    private final SyntheticNaming naming;
    private final ImmutableMap<DexType, List<SyntheticMethodReference>> nonLegacyMethods;
    private final ImmutableMap<DexType, List<SyntheticProgramClassReference>> nonLegacyClasses;
    public final ImmutableSet<DexType> syntheticInputs;

    private static <T> ImmutableMap<DexType, List<T>> merge(Map<DexType, List<T>> newSynthetics, ImmutableMap<DexType, List<T>> oldSynthetics) {
        if (newSynthetics == null) {
            return oldSynthetics;
        }
        oldSynthetics.forEach((type, elements) -> newSynthetics.computeIfAbsent((DexType)type, ignore -> new ArrayList()).addAll(elements));
        return ImmutableMap.copyOf(newSynthetics);
    }

    public CommittedSyntheticsCollection(SyntheticNaming naming, ImmutableMap<DexType, List<SyntheticMethodReference>> nonLegacyMethods, ImmutableMap<DexType, List<SyntheticProgramClassReference>> nonLegacyClasses, ImmutableSet<DexType> syntheticInputs) {
        this.naming = naming;
        this.nonLegacyMethods = nonLegacyMethods;
        this.nonLegacyClasses = nonLegacyClasses;
        this.syntheticInputs = syntheticInputs;
        assert (this.verifySyntheticInputsSubsetOfSynthetics());
    }

    private boolean verifySyntheticInputsSubsetOfSynthetics() {
        ImmutableCollection synthetics = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)this.nonLegacyMethods.keySet())).addAll((Iterable)this.nonLegacyClasses.keySet())).build();
        this.syntheticInputs.forEach(arg_0 -> CommittedSyntheticsCollection.lambda$verifySyntheticInputsSubsetOfSynthetics$2((Set)((Object)synthetics), arg_0));
        return true;
    }

    public static CommittedSyntheticsCollection empty(SyntheticNaming naming) {
        return new CommittedSyntheticsCollection(naming, ImmutableMap.of(), ImmutableMap.of(), ImmutableSet.of());
    }

    private <R extends Rewritable<R>> ImmutableMap<DexType, List<R>> rewriteItems(Map<DexType, List<R>> items, GraphLens.NonIdentityGraphLens lens, ImmutableSet.Builder<DexType> syntheticInputsBuilder) {
        IdentityHashMap<DexType, List> rewrittenItems = new IdentityHashMap<DexType, List>();
        for (Rewritable reference : IterableUtils.flatten(items.values())) {
            Object rewritten = reference.rewrite(lens);
            if (rewritten == null) continue;
            rewrittenItems.computeIfAbsent(rewritten.getHolder(), ignore -> new ArrayList()).add(rewritten);
            if (!this.syntheticInputs.contains(reference.getHolder())) continue;
            syntheticInputsBuilder.add((Object)rewritten.getHolder());
        }
        return ImmutableMap.copyOf(rewrittenItems);
    }

    private static boolean verifyTypesAreInApp(DexApplication app, Collection<DexType> types) {
        for (DexType type : types) {
            assert (app.programDefinitionFor(type) != null) : "Missing synthetic: " + type;
        }
        return true;
    }

    private static /* synthetic */ void lambda$verifySyntheticInputsSubsetOfSynthetics$2(Set synthetics, DexType syntheticInput) {
        assert (synthetics.contains(syntheticInput)) : "Expected " + syntheticInput.toSourceString() + " to be a synthetic";
    }

    SyntheticNaming getNaming() {
        return this.naming;
    }

    Builder builder() {
        return new Builder(this);
    }

    boolean isEmpty() {
        boolean empty;
        boolean bl = empty = this.nonLegacyMethods.isEmpty() && this.nonLegacyClasses.isEmpty();
        assert (!empty || this.syntheticInputs.isEmpty());
        return empty;
    }

    boolean containsType(DexType type) {
        return this.containsNonLegacyType(type);
    }

    boolean containsTypeOfKind(DexType type, SyntheticNaming.SyntheticKind kind) {
        List<SyntheticProgramClassReference> synthetics = this.nonLegacyClasses.get(type);
        if (synthetics == null) {
            List<SyntheticMethodReference> syntheticMethodReferences = this.nonLegacyMethods.get(type);
            if (syntheticMethodReferences == null) {
                return false;
            }
            for (SyntheticMethodReference syntheticMethodReference : syntheticMethodReferences) {
                if (syntheticMethodReference.getKind() != kind) continue;
                return true;
            }
            return false;
        }
        for (SyntheticProgramClassReference synthetic : synthetics) {
            if (synthetic.getKind() != kind) continue;
            return true;
        }
        return false;
    }

    public boolean containsNonLegacyType(DexType type) {
        return this.nonLegacyMethods.containsKey(type) || this.nonLegacyClasses.containsKey(type);
    }

    public boolean containsSyntheticInput(DexType type) {
        return this.syntheticInputs.contains(type);
    }

    public ImmutableMap<DexType, List<SyntheticMethodReference>> getNonLegacyMethods() {
        return this.nonLegacyMethods;
    }

    public ImmutableMap<DexType, List<SyntheticProgramClassReference>> getNonLegacyClasses() {
        return this.nonLegacyClasses;
    }

    public Iterable<SyntheticReference<?, ?, ?>> getNonLegacyItems(DexType type) {
        return Iterables.concat((Iterable)this.nonLegacyClasses.getOrDefault(type, Collections.emptyList()), (Iterable)this.nonLegacyMethods.getOrDefault(type, Collections.emptyList()));
    }

    public void forEachSyntheticInput(Consumer<DexType> fn) {
        this.syntheticInputs.forEach(fn);
    }

    public void forEachNonLegacyItem(Consumer<SyntheticReference<?, ?, ?>> fn) {
        this.nonLegacyMethods.values().forEach(r -> r.forEach(fn));
        this.nonLegacyClasses.values().forEach(r -> r.forEach(fn));
    }

    CommittedSyntheticsCollection pruneItems(PrunedItems prunedItems) {
        Set<DexType> removed = prunedItems.getNoLongerSyntheticItems();
        if (removed.isEmpty()) {
            return this;
        }
        Builder builder = CommittedSyntheticsCollection.empty(this.naming).builder();
        boolean changed = false;
        for (SyntheticReference reference : IterableUtils.flatten(this.nonLegacyMethods.values())) {
            if (removed.contains(((SyntheticMethodReference)reference).getHolder())) {
                changed = true;
                continue;
            }
            builder.addNonLegacyMethod((SyntheticMethodReference)reference);
        }
        for (SyntheticReference reference : IterableUtils.flatten(this.nonLegacyClasses.values())) {
            if (removed.contains(((SyntheticClassReference)reference).getHolder())) {
                changed = true;
                continue;
            }
            builder.addNonLegacyClass((SyntheticProgramClassReference)reference);
        }
        for (DexType syntheticInput : this.syntheticInputs) {
            if (removed.contains(syntheticInput)) {
                changed = true;
                continue;
            }
            builder.addSyntheticInput(syntheticInput);
        }
        return changed ? builder.build() : this;
    }

    CommittedSyntheticsCollection rewriteWithLens(GraphLens.NonIdentityGraphLens lens) {
        ImmutableSet.Builder<DexType> syntheticInputsBuilder = ImmutableSet.builder();
        return new CommittedSyntheticsCollection(this.naming, this.rewriteItems(this.nonLegacyMethods, lens, syntheticInputsBuilder), this.rewriteItems(this.nonLegacyClasses, lens, syntheticInputsBuilder), (ImmutableSet<DexType>)syntheticInputsBuilder.build());
    }

    boolean verifyTypesAreInApp(DexApplication application) {
        assert (CommittedSyntheticsCollection.verifyTypesAreInApp(application, this.nonLegacyMethods.keySet()));
        assert (CommittedSyntheticsCollection.verifyTypesAreInApp(application, this.nonLegacyClasses.keySet()));
        assert (CommittedSyntheticsCollection.verifyTypesAreInApp(application, this.syntheticInputs));
        return true;
    }

    static class Builder {
        private final CommittedSyntheticsCollection parent;
        private Map<DexType, List<SyntheticProgramClassReference>> newNonLegacyClasses = null;
        private Map<DexType, List<SyntheticMethodReference>> newNonLegacyMethods = null;
        private ImmutableSet.Builder<DexType> newSyntheticInputs = null;

        public Builder(CommittedSyntheticsCollection parent) {
            this.parent = parent;
        }

        public Builder addItem(SyntheticDefinition<?, ?, ?> definition) {
            if (definition.isProgramDefinition()) {
                definition.asProgramDefinition().apply(this::addNonLegacyMethod, this::addNonLegacyClass);
            }
            return this;
        }

        public Builder addNonLegacyClass(SyntheticProgramClassDefinition definition) {
            return this.addNonLegacyClass(definition.toReference());
        }

        public Builder addNonLegacyClass(SyntheticProgramClassReference reference) {
            if (this.newNonLegacyClasses == null) {
                this.newNonLegacyClasses = new IdentityHashMap<DexType, List<SyntheticProgramClassReference>>();
            }
            this.newNonLegacyClasses.computeIfAbsent(reference.getHolder(), ignore -> new ArrayList()).add(reference);
            return this;
        }

        public Builder addNonLegacyMethod(SyntheticMethodDefinition definition) {
            return this.addNonLegacyMethod(definition.toReference());
        }

        public Builder addNonLegacyMethod(SyntheticMethodReference reference) {
            if (this.newNonLegacyMethods == null) {
                this.newNonLegacyMethods = new IdentityHashMap<DexType, List<SyntheticMethodReference>>();
            }
            this.newNonLegacyMethods.computeIfAbsent(reference.getHolder(), ignore -> new ArrayList()).add(reference);
            return this;
        }

        public Builder addSyntheticInput(DexType syntheticInput) {
            if (this.newSyntheticInputs == null) {
                this.newSyntheticInputs = ImmutableSet.builder();
            }
            this.newSyntheticInputs.add((Object)syntheticInput);
            return this;
        }

        Builder collectSyntheticInputs() {
            if (this.newSyntheticInputs == null) {
                this.newSyntheticInputs = ImmutableSet.builder();
            }
            if (this.newNonLegacyClasses != null) {
                this.newSyntheticInputs.addAll(this.newNonLegacyClasses.keySet());
            }
            if (this.newNonLegacyMethods != null) {
                this.newSyntheticInputs.addAll(this.newNonLegacyMethods.keySet());
            }
            return this;
        }

        public CommittedSyntheticsCollection build() {
            if (this.newNonLegacyClasses == null && this.newNonLegacyMethods == null) {
                return this.parent;
            }
            ImmutableMap allNonLegacyClasses = CommittedSyntheticsCollection.merge(this.newNonLegacyClasses, this.parent.nonLegacyClasses);
            ImmutableMap allNonLegacyMethods = CommittedSyntheticsCollection.merge(this.newNonLegacyMethods, this.parent.nonLegacyMethods);
            ImmutableCollection allSyntheticInputs = this.newSyntheticInputs == null ? this.parent.syntheticInputs : this.newSyntheticInputs.build();
            return new CommittedSyntheticsCollection(this.parent.naming, allNonLegacyMethods, allNonLegacyClasses, (ImmutableSet<DexType>)allSyntheticInputs);
        }
    }
}

