/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.synthesis;

import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.NestHostClassAttribute;
import com.android.tools.r8.graph.NestMemberClassAttribute;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.synthesis.SynthesizingContext;
import com.android.tools.r8.synthesis.SyntheticMethodBuilder;
import com.android.tools.r8.synthesis.SyntheticNaming;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public abstract class SyntheticClassBuilder<B extends SyntheticClassBuilder<B, C>, C extends DexClass> {
    private final DexItemFactory factory;
    private final DexType type;
    private final SyntheticNaming.SyntheticKind syntheticKind;
    private final Origin origin;
    private boolean isAbstract = false;
    private boolean isFinal = true;
    private boolean isInterface = false;
    private ProgramResource.Kind originKind;
    private DexType superType;
    private DexTypeList interfaces = DexTypeList.empty();
    private DexString sourceFile = null;
    private boolean useSortedMethodBacking = false;
    private List<DexEncodedField> staticFields = new ArrayList<DexEncodedField>();
    private List<DexEncodedField> instanceFields = new ArrayList<DexEncodedField>();
    private List<DexEncodedMethod> directMethods = new ArrayList<DexEncodedMethod>();
    private List<DexEncodedMethod> virtualMethods = new ArrayList<DexEncodedMethod>();
    private List<SyntheticMethodBuilder> methods = new ArrayList<SyntheticMethodBuilder>();
    private GenericSignature.ClassSignature signature = GenericSignature.ClassSignature.noSignature();

    SyntheticClassBuilder(DexType type, SyntheticNaming.SyntheticKind syntheticKind, SynthesizingContext context, DexItemFactory factory) {
        this.factory = factory;
        this.type = type;
        this.syntheticKind = syntheticKind;
        this.origin = context.getInputContextOrigin();
        this.superType = factory.objectType;
    }

    public abstract B self();

    public abstract ClassKind<C> getClassKind();

    public DexItemFactory getFactory() {
        return this.factory;
    }

    public DexType getType() {
        return this.type;
    }

    public SyntheticNaming.SyntheticKind getSyntheticKind() {
        return this.syntheticKind;
    }

    public B setInterfaces(List<DexType> interfaces) {
        this.interfaces = interfaces.isEmpty() ? DexTypeList.empty() : new DexTypeList(interfaces.toArray(DexType.EMPTY_ARRAY));
        return this.self();
    }

    public B setAbstract() {
        this.isAbstract = true;
        this.isFinal = false;
        return this.self();
    }

    public B unsetFinal() {
        this.isFinal = false;
        return this.self();
    }

    public B setInterface() {
        this.setAbstract();
        this.isInterface = true;
        return this.self();
    }

    public B setSuperType(DexType superType) {
        this.superType = superType;
        return this.self();
    }

    public B setOriginKind(ProgramResource.Kind originKind) {
        this.originKind = originKind;
        return this.self();
    }

    public B setSourceFile(DexString sourceFile) {
        this.sourceFile = sourceFile;
        return this.self();
    }

    public B setGenericSignature(GenericSignature.ClassSignature signature) {
        this.signature = signature;
        return this.self();
    }

    public B setStaticFields(List<DexEncodedField> fields) {
        this.staticFields.clear();
        this.staticFields.addAll(fields);
        return this.self();
    }

    public B setInstanceFields(List<DexEncodedField> fields) {
        this.instanceFields.clear();
        this.instanceFields.addAll(fields);
        return this.self();
    }

    public B setDirectMethods(Iterable<DexEncodedMethod> methods) {
        this.directMethods.clear();
        methods.forEach(this.directMethods::add);
        return this.self();
    }

    public B setVirtualMethods(Iterable<DexEncodedMethod> methods) {
        this.virtualMethods.clear();
        methods.forEach(this.virtualMethods::add);
        return this.self();
    }

    public B addMethod(Consumer<SyntheticMethodBuilder> fn) {
        SyntheticMethodBuilder method = new SyntheticMethodBuilder(this);
        fn.accept(method);
        this.methods.add(method);
        return this.self();
    }

    public B setUseSortedMethodBacking(boolean useSortedMethodBacking) {
        this.useSortedMethodBacking = useSortedMethodBacking;
        return this.self();
    }

    public C build() {
        int itfFlag;
        int abstractFlag = this.isAbstract ? 1024 : 0;
        int finalFlag = this.isFinal ? 16 : 0;
        int n = itfFlag = this.isInterface ? 512 : 0;
        assert (!this.isInterface || this.isAbstract);
        ClassAccessFlags accessFlags = ClassAccessFlags.fromSharedAccessFlags(abstractFlag | finalFlag | itfFlag | 1 | 0x1000);
        NestHostClassAttribute nestHost = null;
        List<NestMemberClassAttribute> nestMembers = Collections.emptyList();
        EnclosingMethodAttribute enclosingMembers = null;
        List<InnerClassAttribute> innerClasses = Collections.emptyList();
        for (SyntheticMethodBuilder builder : this.methods) {
            DexEncodedMethod method = builder.build();
            if (method.isNonPrivateVirtualMethod()) {
                this.virtualMethods.add(method);
                continue;
            }
            this.directMethods.add(method);
        }
        long checksum = 7L * (long)this.directMethods.hashCode() + 11L * (long)this.virtualMethods.hashCode() + 13L * (long)this.staticFields.hashCode() + 17L * (long)this.instanceFields.hashCode();
        C clazz = this.getClassKind().create(this.type, this.originKind, this.origin, accessFlags, this.superType, this.interfaces, this.sourceFile, nestHost, nestMembers, enclosingMembers, innerClasses, this.signature, DexAnnotationSet.empty(), this.staticFields.toArray(DexEncodedField.EMPTY_ARRAY), this.instanceFields.toArray(DexEncodedField.EMPTY_ARRAY), DexEncodedMethod.EMPTY_ARRAY, DexEncodedMethod.EMPTY_ARRAY, this.factory.getSkipNameValidationForTesting(), c -> checksum, null);
        if (this.useSortedMethodBacking) {
            ((DexClass)clazz).getMethodCollection().useSortedBacking();
        }
        ((DexClass)clazz).setDirectMethods(this.directMethods.toArray(DexEncodedMethod.EMPTY_ARRAY));
        ((DexClass)clazz).setVirtualMethods(this.virtualMethods.toArray(DexEncodedMethod.EMPTY_ARRAY));
        return clazz;
    }
}

