/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.synthesis;

import com.android.tools.r8.com.google.common.hash.HashCode;
import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.synthesis.SynthesizingContext;
import com.android.tools.r8.synthesis.SyntheticClasspathDefinition;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.synthesis.SyntheticProgramDefinition;
import com.android.tools.r8.synthesis.SyntheticReference;
import com.android.tools.r8.utils.structural.HasherWrapper;
import com.android.tools.r8.utils.structural.RepresentativeMap;

abstract class SyntheticDefinition<R extends SyntheticReference<R, D, C>, D extends SyntheticDefinition<R, D, C>, C extends DexClass> {
    private final SyntheticNaming.SyntheticKind kind;
    private final SynthesizingContext context;

    SyntheticDefinition(SyntheticNaming.SyntheticKind kind, SynthesizingContext context) {
        assert (kind != null);
        assert (context != null);
        this.kind = kind;
        this.context = context;
    }

    public boolean isClasspathDefinition() {
        return false;
    }

    public SyntheticClasspathDefinition asClasspathDefinition() {
        return null;
    }

    public boolean isProgramDefinition() {
        return false;
    }

    public SyntheticProgramDefinition asProgramDefinition() {
        return null;
    }

    abstract R toReference();

    final SyntheticNaming.SyntheticKind getKind() {
        return this.kind;
    }

    final SynthesizingContext getContext() {
        return this.context;
    }

    final String getPrefixForExternalSyntheticType() {
        return SyntheticNaming.getPrefixForExternalSyntheticType(this.getKind(), ((DexClass)this.getHolder()).getType());
    }

    public abstract C getHolder();

    final HashCode computeHash(RepresentativeMap map, boolean intermediate, ClassToFeatureSplitMap classToFeatureSplitMap, SyntheticItems syntheticItems) {
        HasherWrapper hasher = HasherWrapper.murmur3128Hasher();
        hasher.putInt(this.kind.getId());
        if (!this.getKind().isShareable()) {
            ((DexClass)this.getHolder()).getType().hash(hasher);
            return (HashCode)hasher.hash();
        }
        if (intermediate) {
            this.getContext().getSynthesizingContextType().hashWithTypeEquivalence(hasher, map);
        }
        hasher.putInt(this.context.getFeatureSplit().hashCode());
        this.internalComputeHash(hasher, map);
        return (HashCode)hasher.hash();
    }

    abstract void internalComputeHash(HasherWrapper var1, RepresentativeMap var2);

    final boolean isEquivalentTo(D other, boolean includeContext, GraphLens graphLens, ClassToFeatureSplitMap classToFeatureSplitMap) {
        return this.compareTo(other, includeContext, graphLens, classToFeatureSplitMap) == 0;
    }

    int compareTo(D other, boolean includeContext, GraphLens graphLens, ClassToFeatureSplitMap classToFeatureSplitMap) {
        int order;
        int order2 = this.kind.compareTo(((SyntheticDefinition)other).getKind());
        if (order2 != 0) {
            return order2;
        }
        DexType thisType = ((DexClass)this.getHolder()).getType();
        DexType otherType = ((DexClass)((SyntheticDefinition)other).getHolder()).getType();
        if (!this.getKind().isShareable()) {
            return thisType.compareTo(otherType);
        }
        if (includeContext && (order = this.getContext().compareTo(((SyntheticDefinition)other).getContext())) != 0) {
            return order;
        }
        if (this.getContext().getFeatureSplit() != ((SyntheticDefinition)other).getContext().getFeatureSplit()) {
            order = classToFeatureSplitMap.compareFeatureSplits(this.context.getFeatureSplit(), ((SyntheticDefinition)other).getContext().getFeatureSplit());
            assert (order != 0);
            return order;
        }
        RepresentativeMap map = null;
        if (graphLens.isNonIdentityLens()) {
            DexType thisOrigType = graphLens.getOriginalType(thisType);
            DexType otherOrigType = graphLens.getOriginalType(otherType);
            if (thisType != thisOrigType || otherType != otherOrigType) {
                map = t -> {
                    if (t == otherType || t == thisOrigType || t == otherOrigType) {
                        return thisType;
                    }
                    return t;
                };
            }
        }
        if (map == null) {
            map = t -> t == otherType ? thisType : t;
        }
        return this.internalCompareTo(other, map);
    }

    abstract int internalCompareTo(D var1, RepresentativeMap var2);

    public abstract boolean isValid();
}

