/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.synthesis;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.hash.HashCode;
import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.NestedGraphLens;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.graph.TreeFixerBase;
import com.android.tools.r8.ir.code.NumberGenerator;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.KeepInfoCollection;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.synthesis.CommittedItems;
import com.android.tools.r8.synthesis.CommittedSyntheticsCollection;
import com.android.tools.r8.synthesis.SynthesizingContext;
import com.android.tools.r8.synthesis.SyntheticDefinition;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.synthesis.SyntheticMarker;
import com.android.tools.r8.synthesis.SyntheticMethodDefinition;
import com.android.tools.r8.synthesis.SyntheticMethodReference;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.synthesis.SyntheticProgramClassDefinition;
import com.android.tools.r8.synthesis.SyntheticProgramClassReference;
import com.android.tools.r8.synthesis.SyntheticReference;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneRepresentativeHashMap;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneRepresentativeMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalManyToOneRepresentativeMap;
import com.android.tools.r8.utils.structural.RepresentativeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class SyntheticFinalization {
    private final InternalOptions options;
    private final SyntheticItems synthetics;
    private final CommittedSyntheticsCollection committed;

    SyntheticFinalization(InternalOptions options, SyntheticItems synthetics, CommittedSyntheticsCollection committed) {
        this.options = options;
        this.synthetics = synthetics;
        this.committed = committed;
    }

    public static void finalize(AppView<AppInfo> appView, ExecutorService executorService) throws ExecutionException {
        assert (!appView.appInfo().hasClassHierarchy());
        assert (!appView.appInfo().hasLiveness());
        Result result = appView.getSyntheticItems().computeFinalSynthetics(appView);
        appView.setAppInfo(new AppInfo(result.commit, result.mainDexInfo));
        if (result.lens != null) {
            appView.setAppInfo(appView.appInfo().rebuildWithMainDexInfo(appView.appInfo().getMainDexInfo().rewrittenWithLens(appView.getSyntheticItems(), result.lens)));
            appView.setGraphLens(result.lens);
        }
        appView.pruneItems(result.prunedItems, executorService);
    }

    public static void finalizeWithClassHierarchy(AppView<AppInfoWithClassHierarchy> appView, ExecutorService executorService) throws ExecutionException {
        assert (!appView.appInfo().hasLiveness());
        Result result = appView.getSyntheticItems().computeFinalSynthetics(appView);
        appView.setAppInfo(appView.appInfo().rebuildWithClassHierarchy(result.commit));
        appView.setAppInfo(appView.appInfo().rebuildWithMainDexInfo(result.mainDexInfo));
        if (result.lens != null) {
            appView.setGraphLens(result.lens);
            appView.setAppInfo(appView.appInfo().rebuildWithMainDexInfo(appView.appInfo().getMainDexInfo().rewrittenWithLens(appView.getSyntheticItems(), result.lens)));
        }
        appView.pruneItems(result.prunedItems, executorService);
    }

    public static void finalizeWithLiveness(AppView<AppInfoWithLiveness> appView, ExecutorService executorService) throws ExecutionException {
        appView.options().testing.checkDeterminism(appView);
        Result result = appView.getSyntheticItems().computeFinalSynthetics(appView);
        appView.setAppInfo(appView.appInfo().rebuildWithMainDexInfo(result.mainDexInfo));
        if (result.lens != null) {
            appView.rewriteWithLensAndApplication(result.lens, result.commit.getApplication().asDirect());
        } else assert (result.commit.getApplication() == appView.appInfo().app());
        appView.setAppInfo(appView.appInfo().rebuildWithLiveness(result.commit));
        appView.pruneItems(result.prunedItems, executorService);
    }

    private <R extends SyntheticReference<R, D, ?>, D extends SyntheticDefinition<R, D, ?>> Map<DexType, EquivalenceGroup<D>> computeEquivalences(AppView<?> appView, ImmutableMap<DexType, List<R>> references, Map<String, NumberGenerator> generators, Builder lensBuilder) {
        boolean intermediate = appView.options().intermediate;
        Map<DexType, D> definitions = this.lookupDefinitions(appView, references);
        ClassToFeatureSplitMap classToFeatureSplitMap = ((AppInfo)appView.appInfo()).hasClassHierarchy() ? ((AppInfo)appView.appInfo()).withClassHierarchy().getClassToFeatureSplitMap() : ClassToFeatureSplitMap.createEmptyClassToFeatureSplitMap();
        Collection potentialEquivalences = SyntheticFinalization.computePotentialEquivalences(definitions, intermediate, appView.dexItemFactory(), appView.graphLens(), classToFeatureSplitMap, this.synthetics);
        return this.computeActualEquivalences(potentialEquivalences, generators, appView, intermediate, classToFeatureSplitMap, lensBuilder);
    }

    private boolean isNotSyntheticType(DexType type) {
        return !this.committed.containsNonLegacyType(type);
    }

    private boolean verifyNoNestedSynthetics(DexItemFactory dexItemFactory) {
        this.committed.forEachNonLegacyItem(item -> {
            if (item.getKind().allowSyntheticContext()) {
                return;
            }
            String prefix = SyntheticNaming.getPrefixForExternalSyntheticType(item.getKind(), item.getHolder());
            assert (!prefix.contains(SyntheticNaming.getPhaseSeparator(SyntheticNaming.Phase.INTERNAL)));
            DexType context = dexItemFactory.createType(DescriptorUtils.getDescriptorFromClassBinaryName(prefix));
            assert (this.isNotSyntheticType(context));
        });
        return true;
    }

    private boolean verifyOneSyntheticPerSyntheticClass() {
        Set seen = Sets.newIdentityHashSet();
        this.committed.getNonLegacyClasses().forEach((type, references) -> {
            assert (seen.add(type));
            assert (references.size() == 1);
        });
        this.committed.getNonLegacyMethods().forEach((type, references) -> {
            assert (seen.add(type));
            assert (references.size() == 1);
        });
        return true;
    }

    private static void ensureSourceFile(DexProgramClass externalSyntheticClass, DexString syntheticSourceFileName) {
        if (externalSyntheticClass.getSourceFile() == null) {
            externalSyntheticClass.setSourceFile(syntheticSourceFileName);
        }
    }

    private static DexApplication buildLensAndProgram(AppView<?> appView, Map<DexType, EquivalenceGroup<SyntheticMethodDefinition>> syntheticMethodGroups, Map<DexType, EquivalenceGroup<SyntheticProgramClassDefinition>> syntheticClassGroups, final Builder lensBuilder, BiConsumer<DexProgramClass, SyntheticProgramClassReference> addFinalSyntheticClass, BiConsumer<DexProgramClass, SyntheticMethodReference> addFinalSyntheticMethod, Set<DexType> derivedMainDexSynthetics) {
        DexApplication application = ((AppInfo)appView.appInfo()).app();
        MainDexInfo mainDexInfo = ((AppInfo)appView.appInfo()).getMainDexInfo();
        Set pruned = Sets.newIdentityHashSet();
        TreeFixerBase treeFixer = new TreeFixerBase(appView){

            @Override
            public DexType mapClassType(DexType type) {
                return lensBuilder.typeMap.getOrDefault(type, type);
            }

            @Override
            public void recordFieldChange(DexField from, DexField to) {
                lensBuilder.move(from, to);
            }

            @Override
            public void recordMethodChange(DexMethod from, DexMethod to) {
                lensBuilder.move(from, to);
            }

            @Override
            public void recordClassChange(DexType from, DexType to) {
                lensBuilder.move(from, to);
            }
        };
        ArrayList<DexProgramClass> deduplicatedClasses = new ArrayList<DexProgramClass>();
        syntheticMethodGroups.forEach((syntheticType, syntheticGroup) -> {
            SyntheticMethodDefinition representative = (SyntheticMethodDefinition)syntheticGroup.getRepresentative();
            SynthesizingContext context = representative.getContext();
            context.registerPrefixRewriting((DexType)syntheticType, appView);
            SyntheticFinalization.addSyntheticMarker(representative.getKind(), representative.getHolder(), appView);
            if (syntheticGroup.isDerivedFromMainDexList(mainDexInfo)) {
                derivedMainDexSynthetics.add((DexType)syntheticType);
            }
            syntheticGroup.forEachNonRepresentativeMember(member -> {
                pruned.add(member.getHolder());
                deduplicatedClasses.add(member.getHolder());
            });
        });
        syntheticClassGroups.forEach((syntheticType, syntheticGroup) -> {
            SyntheticProgramClassDefinition representative = (SyntheticProgramClassDefinition)syntheticGroup.getRepresentative();
            SynthesizingContext context = representative.getContext();
            context.registerPrefixRewriting((DexType)syntheticType, appView);
            SyntheticFinalization.addSyntheticMarker(representative.getKind(), (DexProgramClass)representative.getHolder(), appView);
            if (syntheticGroup.isDerivedFromMainDexList(mainDexInfo)) {
                derivedMainDexSynthetics.add((DexType)syntheticType);
            }
            syntheticGroup.forEachNonRepresentativeMember(member -> {
                pruned.add((DexProgramClass)member.getHolder());
                deduplicatedClasses.add((DexProgramClass)member.getHolder());
            });
        });
        if (lensBuilder.isEmpty()) {
            assert (deduplicatedClasses.isEmpty());
            assert (pruned.isEmpty());
        } else {
            if (!pruned.isEmpty()) {
                ArrayList<DexProgramClass> newProgramClasses = new ArrayList<DexProgramClass>();
                for (DexProgramClass clazz : application.classes()) {
                    if (pruned.contains(clazz)) continue;
                    newProgramClasses.add(clazz);
                }
                assert (newProgramClasses.size() < application.classes().size());
                application = ((DexApplication.Builder)application.builder().replaceProgramClasses(newProgramClasses)).build();
            }
            assert (SyntheticFinalization.verifyNonRepresentativesRemovedFromApplication(application, syntheticClassGroups));
            assert (SyntheticFinalization.verifyNonRepresentativesRemovedFromApplication(application, syntheticMethodGroups));
            DexApplication.Builder<?> builder = application.builder();
            treeFixer.fixupClasses(deduplicatedClasses);
            builder.replaceProgramClasses(treeFixer.fixupClasses(application.classes()));
            application = builder.build();
        }
        DexString syntheticSourceFileName = appView.enableWholeProgramOptimizations() ? appView.dexItemFactory().createString("R8$$SyntheticClass") : appView.dexItemFactory().createString("D8$$SyntheticClass");
        DexApplication appForLookup = application;
        syntheticClassGroups.forEach((syntheticType, syntheticGroup) -> {
            DexProgramClass externalSyntheticClass = appForLookup.programDefinitionFor((DexType)syntheticType);
            assert (externalSyntheticClass != null) : "Expected definition for " + syntheticType.getTypeName();
            SyntheticFinalization.ensureSourceFile(externalSyntheticClass, syntheticSourceFileName);
            SyntheticProgramClassDefinition representative = (SyntheticProgramClassDefinition)syntheticGroup.getRepresentative();
            addFinalSyntheticClass.accept(externalSyntheticClass, new SyntheticProgramClassReference(representative.getKind(), representative.getContext(), externalSyntheticClass.type));
        });
        syntheticMethodGroups.forEach((syntheticType, syntheticGroup) -> {
            DexProgramClass externalSyntheticClass = appForLookup.programDefinitionFor((DexType)syntheticType);
            SyntheticFinalization.ensureSourceFile(externalSyntheticClass, syntheticSourceFileName);
            SyntheticMethodDefinition representative = (SyntheticMethodDefinition)syntheticGroup.getRepresentative();
            assert (externalSyntheticClass.getMethodCollection().size() == 1);
            assert (externalSyntheticClass.getMethodCollection().hasDirectMethods());
            DexEncodedMethod syntheticMethodDefinition = externalSyntheticClass.getMethodCollection().getDirectMethod(Predicates.alwaysTrue());
            addFinalSyntheticMethod.accept(externalSyntheticClass, new SyntheticMethodReference(representative.getKind(), representative.getContext(), (DexMethod)syntheticMethodDefinition.getReference()));
        });
        Iterables.concat(syntheticClassGroups.values(), syntheticMethodGroups.values()).forEach(syntheticGroup -> ((DexProgramClass)((SyntheticDefinition)syntheticGroup.getRepresentative()).getHolder()).forEachProgramMember(member -> {
            if (member.isProgramField()) {
                DexField field = (DexField)member.asProgramField().getReference();
                DexField rewrittenField = treeFixer.fixupFieldReference(field);
                lensBuilder.setRepresentative(rewrittenField, field);
            } else {
                DexMethod method = (DexMethod)member.asProgramMethod().getReference();
                DexMethod rewrittenMethod = treeFixer.fixupMethodReference(method);
                lensBuilder.setRepresentative(rewrittenMethod, method);
            }
        }));
        for (DexType key : syntheticMethodGroups.keySet()) {
            assert (application.definitionFor(key) != null);
        }
        for (DexType key : syntheticClassGroups.keySet()) {
            assert (application.definitionFor(key) != null);
        }
        return application;
    }

    private static <T extends SyntheticDefinition<?, T, ?>> boolean verifyNonRepresentativesRemovedFromApplication(DexApplication application, Map<DexType, EquivalenceGroup<T>> syntheticGroups) {
        for (EquivalenceGroup<SyntheticDefinition> equivalenceGroup : syntheticGroups.values()) {
            equivalenceGroup.forEachNonRepresentativeMember(member -> {
                assert (application.definitionFor(((DexClass)member.getHolder()).getType()) == null);
            });
        }
        return true;
    }

    private static void addSyntheticMarker(SyntheticNaming.SyntheticKind kind, DexProgramClass externalSyntheticClass, AppView<?> appView) {
        if (SyntheticFinalization.shouldAnnotateSynthetics(appView.options())) {
            SyntheticMarker.addMarkerToClass(externalSyntheticClass, kind, appView.options());
        }
    }

    private static boolean shouldAnnotateSynthetics(InternalOptions options) {
        return options.intermediate && options.isGeneratingDex();
    }

    private <T extends SyntheticDefinition<?, T, ?>> Map<DexType, EquivalenceGroup<T>> computeActualEquivalences(Collection<List<T>> potentialEquivalences, Map<String, NumberGenerator> generators, AppView<?> appView, boolean intermediate, ClassToFeatureSplitMap classToFeatureSplitMap, Builder lensBuilder) {
        HashMap<String, List> groupsPerPrefix = new HashMap<String, List>();
        IdentityHashMap equivalences = new IdentityHashMap();
        potentialEquivalences.forEach(members -> {
            List groups2 = SyntheticFinalization.groupEquivalent(appView, members, intermediate, classToFeatureSplitMap);
            for (EquivalenceGroup group : groups2) {
                if (group.hasRepresentative()) {
                    EquivalenceGroup previous = equivalences.put(((DexClass)((SyntheticDefinition)group.getRepresentative()).getHolder()).getType(), group);
                    assert (previous == null);
                    continue;
                }
                group.selectDeterministicRepresentative();
                groupsPerPrefix.computeIfAbsent(((SyntheticDefinition)group.getRepresentative()).getPrefixForExternalSyntheticType(), k -> new ArrayList()).add(group);
            }
        });
        groupsPerPrefix.forEach((externalSyntheticTypePrefix, groups2) -> {
            Comparator comparator = this::compareForFinalGroupSorting;
            ListUtils.destructiveSort(groups2, comparator);
            for (int i = 0; i < groups2.size(); ++i) {
                EquivalenceGroup group = (EquivalenceGroup)groups2.get(i);
                assert (((SyntheticDefinition)group.getRepresentative()).getPrefixForExternalSyntheticType().equals(externalSyntheticTypePrefix));
                assert (i == 0 || SyntheticFinalization.checkGroupsAreDistinct((EquivalenceGroup)groups2.get(i - 1), group, comparator));
                SyntheticNaming.SyntheticKind kind = ((SyntheticDefinition)group.getRepresentative()).getKind();
                DexType representativeType = intermediate && this.synthetics.isSyntheticInput(((DexDefinition)((SyntheticDefinition)group.getRepresentative()).getHolder()).asProgramClass()) ? ((DexClass)((SyntheticDefinition)group.getRepresentative()).getHolder()).getType() : this.createExternalType(kind, (String)externalSyntheticTypePrefix, generators, appView, candidateType -> equivalences.containsKey(candidateType) || appView.horizontallyMergedClasses().hasBeenMergedIntoDifferentType((DexType)candidateType));
                equivalences.put(representativeType, group);
            }
        });
        equivalences.forEach((representativeType, group) -> group.forEach(member -> lensBuilder.move(((DexClass)member.getHolder()).getType(), (DexType)representativeType)));
        return equivalences;
    }

    private <T extends SyntheticDefinition<?, T, ?>> int compareForFinalGroupSorting(EquivalenceGroup<T> a, EquivalenceGroup<T> b) {
        return ((DexClass)((SyntheticDefinition)a.getRepresentative()).getHolder()).getType().compareTo(((DexClass)((SyntheticDefinition)b.getRepresentative()).getHolder()).getType());
    }

    private static <T extends SyntheticDefinition<?, T, ?>> List<EquivalenceGroup<T>> groupEquivalent(AppView<?> appView, List<T> potentialEquivalence, boolean intermediate, ClassToFeatureSplitMap classToFeatureSplitMap) {
        ArrayList<EquivalenceGroup<T>> groups2 = new ArrayList<EquivalenceGroup<T>>();
        for (SyntheticDefinition synthetic : potentialEquivalence) {
            boolean mustBeRepresentative = SyntheticFinalization.isPinned(appView, synthetic);
            EquivalenceGroup equivalenceGroup = null;
            for (EquivalenceGroup equivalenceGroup2 : groups2) {
                if (!synthetic.isEquivalentTo(equivalenceGroup2.hasRepresentative() ? equivalenceGroup2.getRepresentative() : equivalenceGroup2.getFirstNonRepresentativeMember(), intermediate, appView.graphLens(), classToFeatureSplitMap)) continue;
                if (mustBeRepresentative && equivalenceGroup2.hasRepresentative()) {
                    Object representative = equivalenceGroup2.getRepresentative();
                    if (((SyntheticReference)((SyntheticDefinition)representative).toReference()).getReference().compareTo(((SyntheticReference)synthetic.toReference()).getReference()) <= 0) break;
                    equivalenceGroup2.replaceAndRemoveRepresentative(synthetic);
                    synthetic = representative;
                    break;
                }
                equivalenceGroup = equivalenceGroup2;
                break;
            }
            if (equivalenceGroup != null) {
                equivalenceGroup.add(synthetic, mustBeRepresentative);
                continue;
            }
            groups2.add(new EquivalenceGroup<SyntheticDefinition>(synthetic, mustBeRepresentative));
        }
        return groups2;
    }

    private static <D extends SyntheticDefinition<?, D, ?>> boolean isPinned(AppView<?> appView, D definition) {
        if (!appView.enableWholeProgramOptimizations()) {
            return false;
        }
        if (!((DexDefinition)definition.getHolder()).isProgramClass()) {
            return true;
        }
        DexProgramClass holder = ((DexDefinition)definition.getHolder()).asProgramClass();
        if (!appView.getSyntheticItems().isSubjectToKeepRules(holder)) {
            return false;
        }
        KeepInfoCollection keepInfo = appView.getKeepInfo();
        InternalOptions options = appView.options();
        if (keepInfo.getClassInfo(holder).isPinned(options)) {
            return true;
        }
        for (DexEncodedMember<?, ?> member : holder.members()) {
            if (!keepInfo.getMemberInfo(member, holder).isPinned(options)) continue;
            return true;
        }
        return false;
    }

    private static <T extends SyntheticDefinition<?, T, ?>> boolean checkGroupsAreDistinct(EquivalenceGroup<T> g1, EquivalenceGroup<T> g2, Comparator<EquivalenceGroup<T>> comparator) {
        int smaller = comparator.compare(g1, g2);
        assert (smaller < 0);
        int bigger = comparator.compare(g2, g1);
        assert (bigger > 0);
        return true;
    }

    private DexType createExternalType(SyntheticNaming.SyntheticKind kind, String externalSyntheticTypePrefix, Map<String, NumberGenerator> generators, AppView<?> appView, Predicate<DexType> reserved) {
        DexType externalType;
        DexItemFactory factory = appView.dexItemFactory();
        if (kind.isFixedSuffixSynthetic()) {
            return SyntheticNaming.createExternalType(kind, externalSyntheticTypePrefix, "", factory);
        }
        NumberGenerator generator = generators.computeIfAbsent(externalSyntheticTypePrefix, k -> new NumberGenerator());
        do {
            if (reserved.test(externalType = SyntheticNaming.createExternalType(kind, externalSyntheticTypePrefix, Integer.toString(generator.next()), factory))) {
                externalType = null;
                continue;
            }
            DexClass clazz = ((AppInfo)appView.appInfo()).definitionForWithoutExistenceAssert(externalType);
            if (clazz == null || !this.isNotSyntheticType(clazz.type)) continue;
            assert (this.options.testing.allowConflictingSyntheticTypes) : "Unexpected creation of an existing external synthetic type: " + clazz;
            externalType = null;
        } while (externalType == null);
        return externalType;
    }

    private static <T extends SyntheticDefinition<?, T, ?>> Collection<List<T>> computePotentialEquivalences(Map<DexType, T> definitions, boolean intermediate, DexItemFactory factory, GraphLens graphLens, ClassToFeatureSplitMap classToFeatureSplitMap, SyntheticItems syntheticItems) {
        Set<DexType> syntheticTypes;
        if (definitions.isEmpty()) {
            return Collections.emptyList();
        }
        if (graphLens.isIdentityLens()) {
            syntheticTypes = definitions.keySet();
        } else {
            syntheticTypes = SetUtils.newIdentityHashSet(definitions.size() * 2);
            definitions.keySet().forEach(t -> {
                syntheticTypes.add((DexType)t);
                syntheticTypes.add(graphLens.getOriginalType((DexType)t));
            });
        }
        RepresentativeMap map = t -> syntheticTypes.contains(t) ? factory.voidType : t;
        HashMap<HashCode, List> equivalences = new HashMap<HashCode, List>(definitions.size());
        for (SyntheticDefinition definition : definitions.values()) {
            HashCode hash = definition.computeHash(map, intermediate, classToFeatureSplitMap, syntheticItems);
            equivalences.computeIfAbsent(hash, k -> new ArrayList()).add(definition);
        }
        return equivalences.values();
    }

    private <R extends SyntheticReference<R, D, ?>, D extends SyntheticDefinition<R, D, ?>> Map<DexType, D> lookupDefinitions(AppView<?> appView, ImmutableMap<DexType, List<R>> references) {
        IdentityHashMap definitions = new IdentityHashMap(references.size());
        for (SyntheticReference reference : IterableUtils.flatten(references.values())) {
            Object definition = reference.lookupDefinition(appView::definitionFor);
            if (definition == null) {
                assert (false);
                continue;
            }
            if (((SyntheticDefinition)definition).isValid()) {
                definitions.put(reference.getHolder(), definition);
                continue;
            }
            assert (false);
        }
        return definitions;
    }

    Result computeFinalSynthetics(AppView<?> appView) {
        assert (this.verifyNoNestedSynthetics(appView.dexItemFactory()));
        assert (this.verifyOneSyntheticPerSyntheticClass());
        Builder lensBuilder = new Builder();
        ImmutableMap.Builder finalMethodsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder finalClassesBuilder = ImmutableMap.builder();
        Set<DexType> derivedMainDexTypes = Sets.newIdentityHashSet();
        HashMap<String, NumberGenerator> generators = new HashMap<String, NumberGenerator>();
        DexApplication application = SyntheticFinalization.buildLensAndProgram(appView, this.computeEquivalences(appView, this.committed.getNonLegacyMethods(), generators, lensBuilder), this.computeEquivalences(appView, this.committed.getNonLegacyClasses(), generators, lensBuilder), lensBuilder, (clazz, reference) -> finalClassesBuilder.put(clazz.getType(), ImmutableList.of(reference)), (clazz, reference) -> finalMethodsBuilder.put(clazz.getType(), ImmutableList.of(reference)), derivedMainDexTypes);
        ImmutableMap<DexType, List<SyntheticMethodReference>> finalMethods = finalMethodsBuilder.build();
        ImmutableMap<DexType, List<SyntheticProgramClassReference>> finalClasses = finalClassesBuilder.build();
        Set<DexType> prunedSynthetics = Sets.newIdentityHashSet();
        this.committed.forEachNonLegacyItem(reference -> {
            DexType type = reference.getHolder();
            if (!finalMethods.containsKey(type) && !finalClasses.containsKey(type)) {
                prunedSynthetics.add(type);
            }
        });
        SyntheticFinalizationGraphLens syntheticFinalizationGraphLens = lensBuilder.build(appView);
        ImmutableSet<DexType> finalInputSynthetics = syntheticFinalizationGraphLens != null ? SetUtils.newImmutableSet(builder -> this.committed.forEachSyntheticInput(syntheticInputType -> builder.accept(syntheticFinalizationGraphLens.lookupType((DexType)syntheticInputType)))) : this.committed.syntheticInputs;
        MainDexInfo.Builder mainDexInfoBuilder = ((AppInfo)appView.appInfo()).getMainDexInfo().builderFromCopy();
        derivedMainDexTypes.forEach(mainDexInfoBuilder::addList);
        return new Result(new CommittedItems(-1, application, new CommittedSyntheticsCollection(this.synthetics.getNaming(), finalMethods, finalClasses, finalInputSynthetics), ImmutableList.of()), syntheticFinalizationGraphLens, PrunedItems.builder().setPrunedApp(application).addRemovedClasses(prunedSynthetics).build(), mainDexInfoBuilder.build());
    }

    private static class EquivalenceGroup<T extends SyntheticDefinition<?, T, ?>> {
        private List<T> members = new ArrayList<T>();
        private T representative;

        EquivalenceGroup(T member, boolean isRepresentative) {
            this.add(member, isRepresentative);
        }

        void add(T member, boolean isRepresentative) {
            if (isRepresentative) {
                assert (!this.hasRepresentative());
                this.representative = member;
            } else {
                this.members.add(member);
            }
        }

        int compareToIncludingContext(EquivalenceGroup<T> other, GraphLens graphLens, ClassToFeatureSplitMap classToFeatureSplitMap) {
            return ((SyntheticDefinition)this.getRepresentative()).compareTo(other.getRepresentative(), true, graphLens, classToFeatureSplitMap);
        }

        public void forEach(Consumer<T> consumer) {
            consumer.accept(this.getRepresentative());
            this.members.forEach(consumer);
        }

        public void forEachNonRepresentativeMember(Consumer<T> consumer) {
            this.members.forEach(consumer);
        }

        T getFirstNonRepresentativeMember() {
            assert (!this.members.isEmpty());
            return (T)((SyntheticDefinition)this.members.get(0));
        }

        T getRepresentative() {
            assert (this.hasRepresentative());
            return this.representative;
        }

        boolean hasRepresentative() {
            return this.representative != null;
        }

        boolean isDerivedFromMainDexList(MainDexInfo mainDexInfo) {
            return ((SyntheticDefinition)this.getRepresentative()).getContext().isDerivedFromMainDexList(mainDexInfo) || Iterables.any(this.members, member -> member.getContext().isDerivedFromMainDexList(mainDexInfo));
        }

        void replaceAndRemoveRepresentative(T representative) {
            assert (this.hasRepresentative());
            this.representative = representative;
        }

        void selectDeterministicRepresentative() {
            assert (!this.hasRepresentative());
            int representativeIndex = 0;
            for (int i = 1; i < this.members.size(); ++i) {
                SyntheticDefinition next = (SyntheticDefinition)this.members.get(i);
                SyntheticDefinition representative = (SyntheticDefinition)this.members.get(representativeIndex);
                if (((SyntheticReference)next.toReference()).getReference().compareTo(((SyntheticReference)representative.toReference()).getReference()) >= 0) continue;
                representativeIndex = i;
            }
            SyntheticDefinition representative = (SyntheticDefinition)this.members.get(representativeIndex);
            this.members.set(representativeIndex, (SyntheticDefinition)ListUtils.last(this.members));
            ListUtils.removeLast(this.members);
            this.setRepresentative(representative);
        }

        void setRepresentative(T representative) {
            assert (!this.hasRepresentative());
            this.representative = representative;
        }

        public String toString() {
            if (this.hasRepresentative()) {
                return "EquivalenceGroup{ size = " + (this.members.size() + 1) + ", repr = " + this.getRepresentative() + " }";
            }
            return "EquivalenceGroup{ size = " + this.members.size() + " }";
        }
    }

    private static class Builder {
        private final BidirectionalManyToOneRepresentativeHashMap<DexField, DexField> fieldMap = BidirectionalManyToOneRepresentativeHashMap.newIdentityHashMap();
        private final MutableBidirectionalManyToOneRepresentativeMap<DexMethod, DexMethod> methodMap = BidirectionalManyToOneRepresentativeHashMap.newIdentityHashMap();
        private final Map<DexType, DexType> typeMap = new IdentityHashMap<DexType, DexType>();

        private Builder() {
        }

        boolean isEmpty() {
            if (this.typeMap.isEmpty()) {
                assert (this.fieldMap.isEmpty());
                assert (this.methodMap.isEmpty());
                return true;
            }
            return false;
        }

        void move(DexType from, DexType to) {
            DexType old = this.typeMap.put(from, to);
            assert (old == null || old == to);
        }

        void move(DexField from, DexField to) {
            DexField old = this.fieldMap.put(from, to);
            assert (old == null || old == to);
        }

        void move(DexMethod from, DexMethod to) {
            this.methodMap.put(from, to);
        }

        void setRepresentative(DexField field, DexField representative) {
            this.fieldMap.setRepresentative(field, representative);
        }

        void setRepresentative(DexMethod method, DexMethod representative) {
            this.methodMap.setRepresentative(method, representative);
        }

        SyntheticFinalizationGraphLens build(AppView<?> appView) {
            if (this.typeMap.isEmpty() && this.fieldMap.isEmpty() && this.methodMap.isEmpty()) {
                return null;
            }
            return new SyntheticFinalizationGraphLens(appView, this.fieldMap, this.methodMap, this.typeMap);
        }
    }

    public static class SyntheticFinalizationGraphLens
    extends NestedGraphLens {
        private SyntheticFinalizationGraphLens(AppView<?> appView, BidirectionalManyToOneRepresentativeMap<DexField, DexField> fieldMap, BidirectionalManyToOneRepresentativeMap<DexMethod, DexMethod> methodMap, Map<DexType, DexType> typeMap) {
            super(appView, fieldMap, methodMap, typeMap);
        }

        @Override
        public boolean isSyntheticFinalizationGraphLens() {
            return true;
        }
    }

    public static class Result {
        public final CommittedItems commit;
        public final GraphLens.NonIdentityGraphLens lens;
        public final PrunedItems prunedItems;
        public final MainDexInfo mainDexInfo;

        public Result(CommittedItems commit, SyntheticFinalizationGraphLens lens, PrunedItems prunedItems, MainDexInfo mainDexInfo) {
            this.commit = commit;
            this.lens = lens;
            this.prunedItems = prunedItems;
            this.mainDexInfo = mainDexInfo;
        }
    }
}

