/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.synthesis;

import com.android.tools.r8.FeatureSplit;
import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassResolutionResult;
import com.android.tools.r8.graph.ClasspathMethod;
import com.android.tools.r8.graph.ClasspathOrLibraryClass;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.MethodCollection;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.org.objectweb.asm.ClassWriter;
import com.android.tools.r8.synthesis.CommittedItems;
import com.android.tools.r8.synthesis.CommittedSyntheticsCollection;
import com.android.tools.r8.synthesis.SynthesizingContext;
import com.android.tools.r8.synthesis.SyntheticClasspathClassBuilder;
import com.android.tools.r8.synthesis.SyntheticClasspathClassDefinition;
import com.android.tools.r8.synthesis.SyntheticDefinition;
import com.android.tools.r8.synthesis.SyntheticDefinitionsProvider;
import com.android.tools.r8.synthesis.SyntheticFinalization;
import com.android.tools.r8.synthesis.SyntheticMarker;
import com.android.tools.r8.synthesis.SyntheticMethodBuilder;
import com.android.tools.r8.synthesis.SyntheticMethodDefinition;
import com.android.tools.r8.synthesis.SyntheticMethodReference;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.synthesis.SyntheticProgramClassBuilder;
import com.android.tools.r8.synthesis.SyntheticProgramClassDefinition;
import com.android.tools.r8.synthesis.SyntheticReference;
import com.android.tools.r8.utils.ConsumerUtils;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class SyntheticItems
implements SyntheticDefinitionsProvider {
    static final int INVALID_ID_AFTER_SYNTHETIC_FINALIZATION = -1;
    private final SyntheticNaming naming;
    private int nextSyntheticId;
    private final CommittedSyntheticsCollection committed;
    private final PendingSynthetics pending = new PendingSynthetics();

    public static SyntheticItems empty() {
        return new SyntheticItems(-1, CommittedSyntheticsCollection.empty(null));
    }

    public static CommittedItems createInitialSyntheticItems(DexApplication application) {
        return new CommittedItems(0, application, CommittedSyntheticsCollection.empty(application.dexItemFactory().getSyntheticNaming()), ImmutableList.of());
    }

    SyntheticItems(CommittedItems commit) {
        this(commit.nextSyntheticId, commit.committed);
    }

    private SyntheticItems(int nextSyntheticId, CommittedSyntheticsCollection committed) {
        this.nextSyntheticId = nextSyntheticId;
        this.committed = committed;
        this.naming = committed.getNaming();
    }

    public static void collectSyntheticInputs(AppView<?> appView) {
        SyntheticItems synthetics = appView.getSyntheticItems();
        assert (synthetics.nextSyntheticId == 0);
        assert (synthetics.committed.isEmpty());
        assert (synthetics.pending.isEmpty());
        CommittedSyntheticsCollection.Builder builder = synthetics.committed.builder();
        for (DexProgramClass clazz : ((AppInfo)appView.appInfo()).classes()) {
            DexClass contextClass;
            SyntheticMarker marker = SyntheticMarker.stripMarkerFromClass(clazz, appView);
            if (!appView.options().intermediate && marker.getContext() != null && ((contextClass = ((AppInfo)appView.appInfo()).definitionForWithoutExistenceAssert(marker.getContext().getSynthesizingContextType())) == null || contextClass.isNotProgramClass())) {
                appView.reporter().error(new StringDiagnostic("Attempt at compiling intermediate artifact without its context", clazz.getOrigin()));
            }
            if (marker.isSyntheticMethods()) {
                clazz.forEachProgramMethod(method -> builder.addNonLegacyMethod(new SyntheticMethodDefinition(marker.getKind(), marker.getContext(), (ProgramMethod)method)));
                continue;
            }
            if (!marker.isSyntheticClass()) continue;
            builder.addNonLegacyClass(new SyntheticProgramClassDefinition(marker.getKind(), marker.getContext(), clazz));
        }
        CommittedSyntheticsCollection committed = builder.collectSyntheticInputs().build();
        if (committed.isEmpty()) {
            return;
        }
        CommittedItems commit = new CommittedItems(synthetics.nextSyntheticId, ((AppInfo)appView.appInfo()).app(), committed, ImmutableList.of());
        if (((AppInfo)appView.appInfo()).hasClassHierarchy()) {
            appView.withClassHierarchy().setAppInfo(((AppInfo)appView.appInfo()).withClassHierarchy().rebuildWithClassHierarchy(commit));
        } else {
            appView.withoutClassHierarchy().setAppInfo(new AppInfo(commit, ((AppInfo)appView.appInfo()).getMainDexInfo()));
        }
    }

    private boolean isNonLegacyCommittedSynthetic(DexType type) {
        return this.committed.containsNonLegacyType(type);
    }

    private boolean isNonLegacyPendingSynthetic(DexType type) {
        return this.pending.nonLegacyDefinitions.containsKey(type);
    }

    private boolean isSyntheticLambda(DexProgramClass clazz) {
        if (!this.isNonLegacySynthetic(clazz)) {
            return false;
        }
        Iterable<SyntheticReference<?, ?, ?>> references = this.committed.getNonLegacyItems(clazz.getType());
        if (!Iterables.isEmpty(references)) {
            assert (Iterables.size(references) == 1);
            return references.iterator().next().getKind() == this.naming.LAMBDA;
        }
        SyntheticDefinition definition = (SyntheticDefinition)this.pending.nonLegacyDefinitions.get(clazz.getType());
        if (definition != null) {
            return definition.getKind() == this.naming.LAMBDA;
        }
        assert (false);
        return false;
    }

    private static <T> boolean verifyAllHaveSameFeature(List<T> items, Function<T, FeatureSplit> getter) {
        assert (!items.isEmpty());
        FeatureSplit featureSplit = getter.apply(items.get(0));
        for (int i = 1; i < items.size(); ++i) {
            assert (featureSplit == getter.apply(items.get(i)));
        }
        return true;
    }

    private void forEachSynthesizingContext(DexType type, Consumer<SynthesizingContext> consumer) {
        for (SyntheticReference<?, ?, ?> reference : this.committed.getNonLegacyItems(type)) {
            consumer.accept(reference.getContext());
        }
        SyntheticDefinition definition = (SyntheticDefinition)this.pending.nonLegacyDefinitions.get(type);
        if (definition != null) {
            consumer.accept(definition.getContext());
        }
    }

    private List<SynthesizingContext> getSynthesizingContexts(DexType type) {
        return ListUtils.newImmutableList(builder -> this.forEachSynthesizingContext(type, builder));
    }

    private SynthesizingContext getSynthesizingContext(ProgramDefinition context, AppView<?> appView) {
        return this.getSynthesizingContext(context, appView.appInfoForDesugaring().getClassToFeatureSplitMap());
    }

    private SynthesizingContext getSynthesizingContext(ProgramDefinition context, ClassToFeatureSplitMap featureSplits) {
        DexType contextType = context.getContextType();
        SyntheticDefinition existingDefinition = (SyntheticDefinition)this.pending.nonLegacyDefinitions.get(contextType);
        if (existingDefinition != null) {
            return existingDefinition.getContext();
        }
        Iterable<SyntheticReference<?, ?, ?>> existingReferences = this.committed.getNonLegacyItems(contextType);
        if (!Iterables.isEmpty(existingReferences)) {
            return IterableUtils.min(existingReferences, (existingReference, other) -> existingReference.getReference().compareTo(other.getReference())).getContext();
        }
        FeatureSplit featureSplit = featureSplits.getFeatureSplit(context, this);
        return SynthesizingContext.fromNonSyntheticInputContext(context, featureSplit);
    }

    private DexProgramClass internalLookupProgramClass(DexType type, SyntheticNaming.SyntheticKind kind, AppView<?> appView) {
        DexClass clazz = appView.definitionFor(type);
        if (clazz == null) {
            return null;
        }
        if (clazz.isProgramClass()) {
            return clazz.asProgramClass();
        }
        if (clazz.isLibraryClass() && kind.isGlobal()) {
            return null;
        }
        this.errorOnInvalidSyntheticEnsure(clazz, "program", appView);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DexProgramClass internalEnsureFixedProgramClass(SyntheticNaming.SyntheticKind kind, Consumer<SyntheticProgramClassBuilder> classConsumer, Consumer<DexProgramClass> onCreationConsumer, SynthesizingContext outerContext, AppView<?> appView) {
        Function<SynthesizingContext, DexType> contextToType = c -> SyntheticNaming.createFixedType(kind, c, appView.dexItemFactory());
        DexType type = contextToType.apply(outerContext);
        DexProgramClass clazz = this.internalLookupProgramClass(type, kind, appView);
        if (clazz != null) {
            return clazz;
        }
        DexType dexType = type;
        synchronized (dexType) {
            clazz = this.internalLookupProgramClass(type, kind, appView);
            if (clazz != null) {
                return clazz;
            }
            assert (!this.isSyntheticClass(type));
            clazz = this.internalCreateProgramClass(kind, syntheticProgramClassBuilder -> {
                syntheticProgramClassBuilder.setUseSortedMethodBacking(true);
                classConsumer.accept((SyntheticProgramClassBuilder)syntheticProgramClassBuilder);
            }, outerContext, type, contextToType, appView);
            onCreationConsumer.accept(clazz);
            return clazz;
        }
    }

    private DexProgramClass internalCreateProgramClass(SyntheticNaming.SyntheticKind kind, Consumer<SyntheticProgramClassBuilder> fn, SynthesizingContext outerContext, DexType type, Function<SynthesizingContext, DexType> contextToType, AppView<?> appView) {
        this.registerSyntheticTypeRewriting(outerContext, contextToType, appView, type);
        SyntheticProgramClassBuilder classBuilder = new SyntheticProgramClassBuilder(type, kind, outerContext, appView.dexItemFactory());
        fn.accept(classBuilder);
        DexProgramClass clazz = classBuilder.build();
        this.addPendingDefinition(new SyntheticProgramClassDefinition(kind, outerContext, clazz));
        return clazz;
    }

    private void registerSyntheticTypeRewriting(SynthesizingContext outerContext, Function<SynthesizingContext, DexType> contextToType, AppView<?> appView, DexType type) {
        DexType rewrittenContextType = appView.typeRewriter.rewrittenContextType(outerContext.getSynthesizingContextType());
        if (rewrittenContextType == null) {
            return;
        }
        SynthesizingContext synthesizingContext = SynthesizingContext.fromType(rewrittenContextType);
        DexType rewrittenType = contextToType.apply(synthesizingContext);
        appView.typeRewriter.rewriteType(type, rewrittenType);
    }

    private SynthesizingContext internalGetOuterContext(DexClass context, AppView<?> appView) {
        return context.isProgramClass() ? this.getSynthesizingContext((ProgramDefinition)context.asProgramClass(), appView) : SynthesizingContext.fromNonSyntheticInputContext(context.asClasspathOrLibraryClass());
    }

    private void errorOnInvalidSyntheticEnsure(DexClass dexClass, String kind, AppView<?> appView) {
        String classKind = dexClass.isProgramClass() ? "program" : (dexClass.isClasspathClass() ? "classpath" : "library");
        throw appView.reporter().fatalError("Cannot ensure " + dexClass.type + " as a synthetic " + kind + " class, because it is already a " + classKind + " class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DexClasspathClass internalEnsureFixedClasspathClass(SyntheticNaming.SyntheticKind kind, Consumer<SyntheticClasspathClassBuilder> classConsumer, Consumer<DexClasspathClass> onCreationConsumer, SynthesizingContext outerContext, AppView<?> appView) {
        DexType type;
        Function<SynthesizingContext, DexType> contextToType = c -> SyntheticNaming.createFixedType(kind, c, appView.dexItemFactory());
        DexType dexType = type = contextToType.apply(outerContext);
        synchronized (dexType) {
            DexClass clazz = appView.definitionFor(type);
            if (clazz != null) {
                if (!clazz.isClasspathClass()) {
                    this.errorOnInvalidSyntheticEnsure(clazz, "classpath", appView);
                }
                return clazz.asClasspathClass();
            }
            this.registerSyntheticTypeRewriting(outerContext, contextToType, appView, type);
            SyntheticClasspathClassBuilder classBuilder = new SyntheticClasspathClassBuilder(type, kind, outerContext, appView.dexItemFactory());
            classConsumer.accept(classBuilder);
            DexClasspathClass definition = (DexClasspathClass)classBuilder.build();
            this.addPendingDefinition(new SyntheticClasspathClassDefinition(kind, outerContext, definition));
            onCreationConsumer.accept(definition);
            return definition;
        }
    }

    private ClasspathMethod internalEnsureFixedClasspathMethod(DexString methodName, DexProto methodProto, SyntheticNaming.SyntheticKind kind, AppView<?> appView, Consumer<SyntheticMethodBuilder> buildMethodCallback, DexClasspathClass clazz) {
        DexMethod methodReference = appView.dexItemFactory().createMethod(clazz.getType(), methodProto, methodName);
        DexEncodedMethod methodDefinition = this.internalEnsureMethod(methodReference, clazz, kind, appView, methodBuilder -> buildMethodCallback.accept(methodBuilder.disableAndroidApiLevelCheck()), ConsumerUtils.emptyConsumer());
        return new ClasspathMethod(clazz, methodDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends DexClassAndMethod> DexEncodedMethod internalEnsureMethod(DexMethod methodReference, DexClass clazz, SyntheticNaming.SyntheticKind kind, AppView<?> appView, Consumer<SyntheticMethodBuilder> buildMethodCallback, Consumer<T> newMethodCallback) {
        MethodCollection methodCollection;
        MethodCollection methodCollection2 = methodCollection = clazz.getMethodCollection();
        synchronized (methodCollection2) {
            DexEncodedMethod methodDefinition = methodCollection.getMethod(methodReference);
            if (methodDefinition != null) {
                return methodDefinition;
            }
            SyntheticMethodBuilder builder = new SyntheticMethodBuilder(appView.dexItemFactory(), clazz.getType(), kind);
            builder.setName(methodReference.getName());
            builder.setProto(methodReference.getProto());
            buildMethodCallback.accept(builder);
            methodDefinition = builder.build();
            methodCollection.addMethod(methodDefinition);
            newMethodCallback.accept(DexClassAndMethod.create(clazz, methodDefinition));
            return methodDefinition;
        }
    }

    private ProgramMethod createMethod(SyntheticKindSelector kindSelector, ProgramDefinition context, AppView<?> appView, Consumer<SyntheticMethodBuilder> fn, Supplier<String> syntheticIdSupplier) {
        assert (this.nextSyntheticId != -1);
        SynthesizingContext outerContext = this.getSynthesizingContext(context, appView);
        SyntheticNaming.SyntheticKind kind = kindSelector.select(this.naming);
        DexType type = SyntheticNaming.createInternalType(kind, outerContext, syntheticIdSupplier.get(), appView.dexItemFactory());
        SyntheticProgramClassBuilder classBuilder = new SyntheticProgramClassBuilder(type, kind, outerContext, appView.dexItemFactory());
        DexProgramClass clazz = ((SyntheticProgramClassBuilder)classBuilder.addMethod(fn.andThen(m3 -> m3.setName("m")))).build();
        ProgramMethod method = new ProgramMethod(clazz, clazz.methods().iterator().next());
        this.addPendingDefinition(new SyntheticMethodDefinition(kind, outerContext, method));
        return method;
    }

    private void addPendingDefinition(SyntheticDefinition<?, ?, ?> definition) {
        this.pending.nonLegacyDefinitions.put(((DexClass)definition.getHolder()).getType(), definition);
    }

    private static CommittedItems commit(PrunedItems prunedItems, PendingSynthetics pending, CommittedSyntheticsCollection committed, int nextSyntheticId) {
        DexApplication amendedApplication;
        ImmutableCollection committedProgramTypes;
        DexApplication application = prunedItems.getPrunedApp();
        Set<DexType> removedClasses = prunedItems.getNoLongerSyntheticItems();
        CommittedSyntheticsCollection.Builder builder = committed.builder();
        if (pending.nonLegacyDefinitions.isEmpty()) {
            committedProgramTypes = ImmutableList.of();
            amendedApplication = application;
        } else {
            DexApplication.Builder<?> appBuilder = application.builder();
            ImmutableList.Builder committedProgramTypesBuilder = ImmutableList.builder();
            for (SyntheticDefinition definition : pending.nonLegacyDefinitions.values()) {
                if (removedClasses.contains(((DexClass)definition.getHolder()).getType())) continue;
                if (definition.isProgramDefinition()) {
                    committedProgramTypesBuilder.add(((DexClass)definition.getHolder()).getType());
                    if (definition.getKind().isMayOverridesNonProgramType()) {
                        appBuilder.addProgramClassPotentiallyOverridingNonProgramClass(definition.asProgramDefinition().getHolder());
                    } else {
                        appBuilder.addProgramClass(definition.asProgramDefinition().getHolder());
                    }
                } else if (appBuilder.isDirect()) {
                    assert (definition.isClasspathDefinition());
                    appBuilder.asDirect().addClasspathClass(definition.asClasspathDefinition().getHolder());
                }
                builder.addItem(definition);
            }
            committedProgramTypes = committedProgramTypesBuilder.build();
            amendedApplication = appBuilder.build();
        }
        return new CommittedItems(nextSyntheticId, amendedApplication, builder.build().pruneItems(prunedItems), (ImmutableList<DexType>)committedProgramTypes);
    }

    public SyntheticNaming getNaming() {
        return this.naming;
    }

    @Override
    public ClassResolutionResult definitionFor(DexType type, Function<DexType, ClassResolutionResult> baseDefinitionFor) {
        DexDefinition clazz = null;
        SyntheticNaming.SyntheticKind kind = null;
        SyntheticDefinition item = (SyntheticDefinition)this.pending.nonLegacyDefinitions.get(type);
        if (item != null) {
            clazz = (DexDefinition)item.getHolder();
            kind = item.getKind();
            assert (clazz.isProgramClass() == item.isProgramDefinition());
            assert (((DexClass)clazz).isClasspathClass() == item.isClasspathDefinition());
        }
        if (clazz != null) {
            assert (kind != null);
            assert (!baseDefinitionFor.apply(type).hasClassResolutionResult() || kind.isMayOverridesNonProgramType()) : "Pending synthetic definition also present in the active program: " + type;
            return clazz;
        }
        return baseDefinitionFor.apply(type);
    }

    public boolean isFinalized() {
        return this.nextSyntheticId == -1;
    }

    public boolean hasPendingSyntheticClasses() {
        return !this.pending.isEmpty();
    }

    public Collection<DexProgramClass> getPendingSyntheticClasses() {
        return this.pending.getAllProgramClasses();
    }

    public boolean isCommittedSynthetic(DexType type) {
        return this.committed.containsType(type);
    }

    public boolean isPendingSynthetic(DexType type) {
        return this.pending.containsType(type);
    }

    public boolean isNonLegacySynthetic(DexProgramClass clazz) {
        return this.isNonLegacySynthetic(clazz.type);
    }

    public boolean isNonLegacySynthetic(DexType type) {
        return this.isNonLegacyCommittedSynthetic(type) || this.isNonLegacyPendingSynthetic(type);
    }

    public boolean isEligibleForClassMerging(DexProgramClass clazz, HorizontalClassMerger.Mode mode) {
        assert (this.isSyntheticClass(clazz));
        return mode.isFinal() || this.isSyntheticLambda(clazz);
    }

    public boolean isSubjectToKeepRules(DexProgramClass clazz) {
        assert (this.isSyntheticClass(clazz));
        return this.isSyntheticInput(clazz);
    }

    public boolean isSyntheticClass(DexType type) {
        return this.isNonLegacySynthetic(type);
    }

    public boolean isSyntheticClass(DexProgramClass clazz) {
        return this.isSyntheticClass(clazz.type);
    }

    public boolean isSyntheticOfKind(DexType type, SyntheticKindSelector kindSelector) {
        SyntheticNaming.SyntheticKind kind = kindSelector.select(this.naming);
        return this.pending.containsTypeOfKind(type, kind) || this.committed.containsTypeOfKind(type, kind);
    }

    boolean isSyntheticInput(DexProgramClass clazz) {
        return this.committed.containsSyntheticInput(clazz.getType());
    }

    public FeatureSplit getContextualFeatureSplit(DexType type, ClassToFeatureSplitMap classToFeatureSplitMap) {
        if (this.isSyntheticOfKind(type, kinds -> kinds.ENUM_UNBOXING_SHARED_UTILITY_CLASS)) {
            return classToFeatureSplitMap.getBaseStartup();
        }
        List<SynthesizingContext> contexts = this.getSynthesizingContexts(type);
        if (contexts.isEmpty()) {
            return null;
        }
        assert (SyntheticItems.verifyAllHaveSameFeature(contexts, SynthesizingContext::getFeatureSplit));
        return contexts.get(0).getFeatureSplit();
    }

    public Collection<DexType> getSynthesizingContextTypes(DexType type) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.forEachSynthesizingContext(type, synthesizingContext -> builder.add(synthesizingContext.getSynthesizingContextType()));
        return builder.build();
    }

    public Set<DexReference> getSynthesizingContextReferences(DexProgramClass clazz, SynthesizingContextOracle oracle) {
        assert (this.isSyntheticClass(clazz));
        return oracle.getSynthesizingContexts(clazz);
    }

    public boolean isSyntheticMethodThatShouldNotBeDoubleProcessed(ProgramMethod method) {
        for (SyntheticMethodReference reference : this.committed.getNonLegacyMethods().getOrDefault(method.getHolderType(), Collections.emptyList())) {
            if (!reference.getKind().equals(this.naming.STATIC_INTERFACE_CALL)) continue;
            return true;
        }
        SyntheticDefinition definition = (SyntheticDefinition)this.pending.nonLegacyDefinitions.get(method.getHolderType());
        if (definition != null) {
            return definition.getKind().equals(this.naming.STATIC_INTERFACE_CALL);
        }
        return false;
    }

    public boolean verifySyntheticLambdaProperty(DexProgramClass clazz, Predicate<DexProgramClass> ifIsLambda, Predicate<DexProgramClass> ifNotLambda) {
        Iterable<SyntheticReference<?, ?, ?>> references = this.committed.getNonLegacyItems(clazz.getType());
        SyntheticDefinition definition = (SyntheticDefinition)this.pending.nonLegacyDefinitions.get(clazz.getType());
        if (definition != null) {
            references = Iterables.concat(references, IterableUtils.singleton(definition.toReference()));
        }
        if (Iterables.any(references, reference -> reference.getKind().equals(this.naming.LAMBDA)) ? !$assertionsDisabled && !ifIsLambda.test(clazz) : !$assertionsDisabled && !ifNotLambda.test(clazz)) {
            throw new AssertionError();
        }
        return true;
    }

    public DexProgramClass createClass(SyntheticKindSelector kindSelector, CompilationContext.UniqueContext context, AppView<?> appView) {
        return this.createClass(kindSelector, context, appView, ConsumerUtils.emptyConsumer());
    }

    public DexProgramClass createClass(SyntheticKindSelector kindSelector, CompilationContext.UniqueContext context, AppView<?> appView, Consumer<SyntheticProgramClassBuilder> fn) {
        SyntheticNaming.SyntheticKind kind = kindSelector.select(this.naming);
        SynthesizingContext outerContext = this.getSynthesizingContext((ProgramDefinition)context.getClassContext(), appView);
        Function<SynthesizingContext, DexType> contextToType = c -> SyntheticNaming.createInternalType(kind, c, context.getSyntheticSuffix(), appView.dexItemFactory());
        return this.internalCreateProgramClass(kind, fn, outerContext, contextToType.apply(outerContext), contextToType, appView);
    }

    public DexProgramClass createFixedClass(SyntheticKindSelector kindSelector, DexProgramClass context, AppView<?> appView, Consumer<SyntheticProgramClassBuilder> fn) {
        SyntheticNaming.SyntheticKind kind = kindSelector.select(this.naming);
        SynthesizingContext outerContext = this.internalGetOuterContext(context, appView);
        Function<SynthesizingContext, DexType> contextToType = c -> SyntheticNaming.createFixedType(kind, c, appView.dexItemFactory());
        return this.internalCreateProgramClass(kind, fn, outerContext, contextToType.apply(outerContext), contextToType, appView);
    }

    public DexProgramClass getExistingFixedClass(SyntheticKindSelector kindSelector, DexClass context, AppView<?> appView) {
        SyntheticNaming.SyntheticKind kind = kindSelector.select(this.naming);
        assert (kind.isFixedSuffixSynthetic());
        SynthesizingContext outerContext = this.internalGetOuterContext(context, appView);
        DexType type = SyntheticNaming.createFixedType(kind, outerContext, appView.dexItemFactory());
        DexClass clazz = appView.definitionFor(type);
        assert (clazz != null);
        assert (this.isSyntheticClass(type));
        assert (clazz.isProgramClass());
        return clazz.asProgramClass();
    }

    public DexProgramClass ensureFixedClass(SyntheticKindSelector kindSelector, DexClass context, AppView<?> appView, Consumer<SyntheticProgramClassBuilder> fn, Consumer<DexProgramClass> onCreationConsumer) {
        SyntheticNaming.SyntheticKind kind = kindSelector.select(this.naming);
        assert (kind.isFixedSuffixSynthetic());
        SynthesizingContext outerContext = this.internalGetOuterContext(context, appView);
        return this.internalEnsureFixedProgramClass(kind, fn, onCreationConsumer, outerContext, appView);
    }

    public ProgramMethod ensureFixedClassMethod(DexString name, DexProto proto, SyntheticKindSelector kindSelector, ProgramDefinition context, AppView<?> appView, Consumer<SyntheticProgramClassBuilder> buildClassCallback, Consumer<SyntheticMethodBuilder> buildMethodCallback) {
        return this.ensureFixedClassMethod(name, proto, kindSelector, context, appView, buildClassCallback, buildMethodCallback, ConsumerUtils.emptyConsumer());
    }

    public ProgramMethod ensureFixedClassMethod(DexString name, DexProto proto, SyntheticKindSelector kindSelector, ProgramDefinition context, AppView<?> appView, Consumer<SyntheticProgramClassBuilder> buildClassCallback, Consumer<SyntheticMethodBuilder> buildMethodCallback, Consumer<ProgramMethod> newMethodCallback) {
        SyntheticNaming.SyntheticKind kind = kindSelector.select(this.naming);
        DexProgramClass clazz = this.ensureFixedClass(kindSelector, context.getContextClass(), appView, buildClassCallback, ConsumerUtils.emptyConsumer());
        DexMethod methodReference = appView.dexItemFactory().createMethod(clazz.getType(), proto, name);
        DexEncodedMethod methodDefinition = this.internalEnsureMethod(methodReference, clazz, kind, appView, buildMethodCallback, newMethodCallback);
        return new ProgramMethod(clazz, methodDefinition);
    }

    public DexClasspathClass ensureFixedClasspathClassFromType(SyntheticKindSelector kindSelector, DexType contextType, AppView<?> appView, Consumer<SyntheticClasspathClassBuilder> classConsumer, Consumer<DexClasspathClass> onCreationConsumer) {
        SyntheticNaming.SyntheticKind kind = kindSelector.select(this.naming);
        SynthesizingContext outerContext = SynthesizingContext.fromType(contextType);
        return this.internalEnsureFixedClasspathClass(kind, classConsumer, onCreationConsumer, outerContext, appView);
    }

    public DexClasspathClass ensureFixedClasspathClass(SyntheticKindSelector kindSelector, ClasspathOrLibraryClass context, AppView<?> appView, Consumer<SyntheticClasspathClassBuilder> classConsumer, Consumer<DexClasspathClass> onCreationConsumer) {
        SynthesizingContext outerContext = SynthesizingContext.fromNonSyntheticInputContext(context);
        return this.internalEnsureFixedClasspathClass(kindSelector.select(this.naming), classConsumer, onCreationConsumer, outerContext, appView);
    }

    public ClasspathMethod ensureFixedClasspathMethodFromType(DexString methodName, DexProto methodProto, SyntheticKindSelector kindSelector, DexType contextType, AppView<?> appView, Consumer<SyntheticClasspathClassBuilder> classConsumer, Consumer<DexClasspathClass> onCreationConsumer, Consumer<SyntheticMethodBuilder> buildMethodCallback) {
        DexClasspathClass clazz = this.ensureFixedClasspathClassFromType(kindSelector, contextType, appView, classConsumer, onCreationConsumer);
        return this.internalEnsureFixedClasspathMethod(methodName, methodProto, kindSelector.select(this.naming), appView, buildMethodCallback, clazz);
    }

    public ClasspathMethod ensureFixedClasspathClassMethod(DexString methodName, DexProto methodProto, SyntheticKindSelector kindSelector, ClasspathOrLibraryClass context, AppView<?> appView, Consumer<SyntheticClasspathClassBuilder> buildClassCallback, Consumer<DexClasspathClass> onClassCreationCallback, Consumer<SyntheticMethodBuilder> buildMethodCallback) {
        DexClasspathClass clazz = this.ensureFixedClasspathClass(kindSelector, context, appView, buildClassCallback, onClassCreationCallback);
        return this.internalEnsureFixedClasspathMethod(methodName, methodProto, kindSelector.select(this.naming), appView, buildMethodCallback, clazz);
    }

    public DexProgramClass ensureFixedClassFromType(SyntheticKindSelector kindSelector, DexType contextType, AppView<?> appView, Consumer<SyntheticProgramClassBuilder> fn, Consumer<DexProgramClass> onCreationConsumer) {
        SyntheticNaming.SyntheticKind kind = kindSelector.select(this.naming);
        SynthesizingContext outerContext = SynthesizingContext.fromType(contextType);
        return this.internalEnsureFixedProgramClass(kind, fn, onCreationConsumer, outerContext, appView);
    }

    public ProgramMethod createMethod(SyntheticKindSelector kindSelector, CompilationContext.UniqueContext context, AppView<?> appView, Consumer<SyntheticMethodBuilder> fn) {
        return this.createMethod(kindSelector, context.getClassContext(), appView, fn, context::getSyntheticSuffix);
    }

    public CommittedItems commit(DexApplication application) {
        return this.commitPrunedItems(PrunedItems.empty(application));
    }

    public CommittedItems commitPrunedItems(PrunedItems prunedItems) {
        return SyntheticItems.commit(prunedItems, this.pending, this.committed, this.nextSyntheticId);
    }

    public CommittedItems commitRewrittenWithLens(DexApplication application, GraphLens.NonIdentityGraphLens lens) {
        assert (this.pending.verifyNotRewritten(lens));
        return SyntheticItems.commit(PrunedItems.empty(application), this.pending, this.committed.rewriteWithLens(lens), this.nextSyntheticId);
    }

    public void writeAttributeIfIntermediateSyntheticClass(ClassWriter writer, DexProgramClass clazz, AppView<?> appView) {
        if (!appView.options().intermediate || !appView.options().isGeneratingClassFiles()) {
            return;
        }
        Iterator<SyntheticReference<?, ?, ?>> it = this.committed.getNonLegacyItems(clazz.getType()).iterator();
        if (it.hasNext()) {
            SyntheticNaming.SyntheticKind kind = it.next().getKind();
            assert (!it.hasNext());
            SyntheticMarker.writeMarkerAttribute(writer, kind, appView.getSyntheticItems());
        }
    }

    SyntheticFinalization.Result computeFinalSynthetics(AppView<?> appView) {
        assert (!this.hasPendingSyntheticClasses());
        return new SyntheticFinalization(appView.options(), this, this.committed).computeFinalSynthetics(appView);
    }

    @FunctionalInterface
    public static interface SyntheticKindSelector {
        public SyntheticNaming.SyntheticKind select(SyntheticNaming var1);
    }

    public static interface SynthesizingContextOracle {
        public Set<DexReference> getSynthesizingContexts(DexProgramClass var1);
    }

    private static class PendingSynthetics {
        private final ConcurrentHashMap<DexType, SyntheticDefinition<?, ?, ?>> nonLegacyDefinitions = new ConcurrentHashMap();

        private PendingSynthetics() {
        }

        boolean isEmpty() {
            return this.nonLegacyDefinitions.isEmpty();
        }

        boolean containsType(DexType type) {
            return this.nonLegacyDefinitions.containsKey(type);
        }

        boolean containsTypeOfKind(DexType type, SyntheticNaming.SyntheticKind kind) {
            SyntheticDefinition<?, ?, ?> definition = this.nonLegacyDefinitions.get(type);
            return definition != null && definition.getKind() == kind;
        }

        boolean verifyNotRewritten(GraphLens.NonIdentityGraphLens lens) {
            assert (((ConcurrentHashMap.KeySetView)this.nonLegacyDefinitions.keySet()).equals(lens.rewriteTypes(this.nonLegacyDefinitions.keySet())));
            return true;
        }

        Collection<DexProgramClass> getAllProgramClasses() {
            ArrayList<DexProgramClass> allPending = new ArrayList<DexProgramClass>(this.nonLegacyDefinitions.size());
            for (SyntheticDefinition<?, ?, ?> item : this.nonLegacyDefinitions.values()) {
                if (!item.isProgramDefinition()) continue;
                allPending.add(item.asProgramDefinition().getHolder());
            }
            return Collections.unmodifiableList(allPending);
        }
    }
}

